/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickObject {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    public static final int USE_GEOMETRY = 256;
    public static final int USE_BOUNDS = 512;
    BranchGroup pickRoot;
    Canvas3D canvas;
    Point3d origin = new Point3d();
    Vector3d direction = new Vector3d();
    PickRay pickRay = new PickRay();
    SceneGraphPath sceneGraphPath = null;
    SceneGraphPath[] sceneGraphPathArr = null;
    int pickBy;
    static final boolean debug = false;
    private double[] distance;
    private int[] position;

    public PickObject(Canvas3D canvas3D, BranchGroup branchGroup) {
        this.pickRoot = branchGroup;
        this.canvas = canvas3D;
    }

    public PickShape generatePickRay(int n, int n2) {
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        this.canvas.getCenterEyeInImagePlate(point3d);
        this.canvas.getPixelLocationInImagePlate(n, n2, point3d2);
        if (this.canvas.getView().getProjectionPolicy() == 0) {
            point3d.x = point3d2.x;
            point3d.y = point3d2.y;
        }
        this.canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        vector3d.sub(point3d2, point3d);
        vector3d.normalize();
        this.pickRay.set(point3d, vector3d);
        return this.pickRay;
    }

    public SceneGraphPath[] pickAll(int n, int n2) {
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath[] pickAllSorted(int n, int n2) {
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPathArr = this.pickRoot.pickAllSorted(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath pickAny(int n, int n2) {
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPath = this.pickRoot.pickAny(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath pickClosest(int n, int n2) {
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPath = this.pickRoot.pickClosest(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath[] pickAll(int n, int n2, int n3) {
        if (n3 == 512) {
            return this.pickAll(n, n2);
        }
        if (n3 == 256) {
            return this.pickGeomAll(n, n2);
        }
        return null;
    }

    public SceneGraphPath[] pickAllSorted(int n, int n2, int n3) {
        if (n3 == 512) {
            return this.pickAllSorted(n, n2);
        }
        if (n3 == 256) {
            return this.pickGeomAllSorted(n, n2);
        }
        return null;
    }

    public SceneGraphPath pickAny(int n, int n2, int n3) {
        if (n3 == 512) {
            return this.pickAny(n, n2);
        }
        if (n3 == 256) {
            return this.pickGeomAny(n, n2);
        }
        return null;
    }

    public SceneGraphPath pickClosest(int n, int n2, int n3) {
        if (n3 == 512) {
            return this.pickClosest(n, n2);
        }
        if (n3 == 256) {
            return this.pickGeomClosest(n, n2);
        }
        return null;
    }

    private SceneGraphPath[] pickGeomAll(int n, int n2) {
        int n3;
        int n4 = 0;
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] blArray = new boolean[this.sceneGraphPathArr.length];
        for (n3 = 0; n3 < this.sceneGraphPathArr.length; ++n3) {
            Node node = this.sceneGraphPathArr[n3].getObject();
            if (node instanceof Shape3D) {
                blArray[n3] = ((Shape3D)node).intersect(this.sceneGraphPathArr[n3], this.pickRay);
            } else if (node instanceof Morph) {
                blArray[n3] = ((Morph)node).intersect(this.sceneGraphPathArr[n3], this.pickRay);
            }
            if (!blArray[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[n4];
        n4 = 0;
        for (n3 = 0; n3 < this.sceneGraphPathArr.length; ++n3) {
            if (!blArray[n3]) continue;
            sceneGraphPathArray[n4++] = this.sceneGraphPathArr[n3];
        }
        return sceneGraphPathArray;
    }

    private SceneGraphPath[] pickGeomAllSorted(int n, int n2) {
        int n3;
        int n4 = 0;
        double[] dArray = new double[1];
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] blArray = new boolean[this.sceneGraphPathArr.length];
        double[] dArray2 = new double[this.sceneGraphPathArr.length];
        for (n3 = 0; n3 < this.sceneGraphPathArr.length; ++n3) {
            Node node = this.sceneGraphPathArr[n3].getObject();
            if (node instanceof Shape3D) {
                blArray[n3] = ((Shape3D)node).intersect(this.sceneGraphPathArr[n3], this.pickRay, dArray);
                dArray2[n3] = dArray[0];
            } else if (node instanceof Morph) {
                blArray[n3] = ((Morph)node).intersect(this.sceneGraphPathArr[n3], this.pickRay, dArray);
                dArray2[n3] = dArray[0];
            }
            if (!blArray[n3]) continue;
            ++n4;
        }
        if (n4 == 0) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[n4];
        this.distance = new double[n4];
        n4 = 0;
        for (n3 = 0; n3 < this.sceneGraphPathArr.length; ++n3) {
            if (!blArray[n3]) continue;
            sceneGraphPathArray[n4] = this.sceneGraphPathArr[n3];
            this.distance[n4++] = dArray2[n3];
        }
        return this.sort(sceneGraphPathArray);
    }

    private SceneGraphPath pickGeomClosest(int n, int n2) {
        SceneGraphPath[] sceneGraphPathArray = this.pickGeomAllSorted(n, n2);
        if (sceneGraphPathArray == null) {
            return null;
        }
        return sceneGraphPathArray[0];
    }

    private SceneGraphPath pickGeomAny(int n, int n2) {
        this.pickRay = (PickRay)this.generatePickRay(n, n2);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        for (int i = 0; i < this.sceneGraphPathArr.length; ++i) {
            Node node = this.sceneGraphPathArr[i].getObject();
            if (!(node instanceof Shape3D ? ((Shape3D)node).intersect(this.sceneGraphPathArr[i], this.pickRay) : node instanceof Morph && ((Morph)node).intersect(this.sceneGraphPathArr[i], this.pickRay))) continue;
            return this.sceneGraphPathArr[i];
        }
        return null;
    }

    private SceneGraphPath[] sort(SceneGraphPath[] sceneGraphPathArray) {
        int n;
        if (sceneGraphPathArray == null) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray2 = new SceneGraphPath[sceneGraphPathArray.length];
        this.position = new int[sceneGraphPathArray.length];
        for (n = 0; n < sceneGraphPathArray.length; ++n) {
            this.position[n] = n;
        }
        this.quicksort(0, this.distance.length - 1);
        for (n = 0; n < this.distance.length; ++n) {
            sceneGraphPathArray2[n] = sceneGraphPathArray[this.position[n]];
        }
        return sceneGraphPathArray2;
    }

    private final void quicksort(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = this.distance[(n + n2) / 2];
        while (true) {
            if (this.distance[n3] < d) {
                ++n3;
                continue;
            }
            while (d < this.distance[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                double d2 = this.distance[n3];
                this.distance[n3] = this.distance[n4];
                this.distance[n4] = d2;
                int n5 = this.position[n3];
                this.position[n3] = this.position[n4];
                this.position[n4] = n5;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.quicksort(n, n4);
        }
        if (n < n2) {
            this.quicksort(n3, n2);
        }
    }

    public Node pickNode(SceneGraphPath sceneGraphPath, int n) {
        if (sceneGraphPath != null) {
            Node node = sceneGraphPath.getObject();
            if (node instanceof Shape3D && (n & 1) != 0) {
                return node;
            }
            if (node instanceof Morph && (n & 2) != 0) {
                return node;
            }
            for (int i = sceneGraphPath.nodeCount() - 1; i >= 0; --i) {
                node = sceneGraphPath.getNode(i);
                if (node instanceof Primitive && (n & 4) != 0) {
                    return node;
                }
                if (node instanceof Link && (n & 8) != 0) {
                    return node;
                }
                if (node instanceof Switch && (n & 0x80) != 0) {
                    return node;
                }
                if (node instanceof TransformGroup && (n & 0x20) != 0) {
                    return node;
                }
                if (node instanceof BranchGroup && (n & 0x40) != 0) {
                    return node;
                }
                if (!(node instanceof Group) || (n & 0x10) == 0) continue;
                return node;
            }
            if (node == null) {
                // empty if block
            }
        }
        return null;
    }

    public Node pickNode(SceneGraphPath sceneGraphPath, int n, int n2) {
        int n3 = 0;
        if (sceneGraphPath != null) {
            Node node = sceneGraphPath.getObject();
            if (node instanceof Shape3D && (n & 1) != 0) {
                return node;
            }
            if (node instanceof Morph && (n & 2) != 0) {
                return node;
            }
            for (int i = 0; i < sceneGraphPath.nodeCount(); ++i) {
                node = sceneGraphPath.getNode(i);
                if (!(node instanceof Group && (n & 0x10) != 0 ? ++n3 == n2 : (node instanceof BranchGroup && (n & 0x40) != 0 ? ++n3 == n2 : (node instanceof TransformGroup && (n & 0x20) != 0 ? ++n3 == n2 : (node instanceof Primitive && (n & 4) != 0 ? ++n3 == n2 : node instanceof Link && (n & 8) != 0 && ++n3 == n2))))) continue;
                return node;
            }
            if (node == null) {
                // empty if block
            }
        }
        return null;
    }
}

