/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.CommunicationPerPE;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import projections.Tools.CommunicationPerPE.ThreadedFileReader;
import projections.analysis.Analysis;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.Clickable;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommWindow
extends GenericGraphWindow
implements ItemListener,
ActionListener,
Clickable {
    private static int myRun = 0;
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] exclusiveRecv;
    private double[][] exclusiveBytesRecv;
    private int[][] hopCount;
    private double[][] avgHopCount;
    private double[][] avgPeHopCount;
    private ArrayList<Integer> histogram;
    private int[] histArray;
    private String currentArrayName;
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel blueGenePanel;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox recvExclusive;
    private Checkbox recvExclusiveBytes;
    private Checkbox hopCountCB;
    private Checkbox peHopCountCB;
    private CommWindow thisWindow;
    private SortedSet<Integer> peList;

    public CommWindow(MainWindow mainWindow) {
        super("Projections Communication - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    @Override
    public void repaint() {
        super.refreshGraph();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Set Range")) {
                this.showDialog();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ae) {
        if (ae.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox cb = (Checkbox)ae.getSource();
            if (cb == this.sentMsgs) {
                this.setDataSource("Total #Msgs Sent", this.sentMsgCount, this);
                this.setPopupText("sentMsgCount");
                this.setYAxis("Messages Sent", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.sentBytes) {
                this.setDataSource("Total Bytes Sent", this.sentByteCount, this);
                this.setPopupText("sentByteCount");
                this.setYAxis("Bytes Sent", "bytes");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.receivedMsgs) {
                this.setDataSource("Total #Msgs Received", this.receivedMsgCount, this);
                this.setPopupText("receivedMsgCount");
                this.setYAxis("Messages Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.receivedBytes) {
                this.setDataSource("Total Bytes Received", this.receivedByteCount, this);
                this.setPopupText("receivedByteCount");
                this.setYAxis("Bytes Received", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.recvExclusive) {
                this.setDataSource("#Msgs Received Externally", this.exclusiveRecv, this);
                this.setPopupText("exclusiveRecv");
                this.setYAxis("Messages Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.recvExclusiveBytes) {
                this.setDataSource("Bytes Received Externally", this.exclusiveBytesRecv, this);
                this.setPopupText("exclusiveBytesRecv");
                this.setYAxis("Bytes Received Externally", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.hopCountCB) {
                if (this.avgHopCount == null) {
                    this.avgHopCount = this.averageHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Entry Point", this.avgHopCount, this);
                this.setPopupText("avgHopCount");
                this.setYAxis("Average Message Hop Counts", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            } else if (cb == this.peHopCountCB) {
                if (this.avgPeHopCount == null) {
                    this.avgPeHopCount = this.averagePEHops(this.hopCount, this.receivedMsgCount);
                }
                this.setDataSource("Average Hop Counts by Processor", this.avgPeHopCount, this);
                this.setPopupText("avgPeHopCount");
                this.setYAxis("Average Message Hop Counts (by PE)", "");
                this.setXAxis("Processor", this.peList);
                super.refreshGraph();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void setPopupText(String input) {
        this.currentArrayName = input;
    }

    @Override
    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0 || this.currentArrayName == null) {
            return null;
        }
        Analysis a = MainWindow.runObject[myRun];
        String[] rString = new String[4];
        rString[0] = "Processor " + xVal;
        if (this.currentArrayName.equals("sentMsgCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.sentMsgCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Bytes = " + this.sentByteCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.receivedMsgCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.receivedByteCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("exclusiveRecv")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.exclusiveRecv[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("exclusiveBytesRecv")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Bytes = " + this.exclusiveBytesRecv[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("avgHopCount")) {
            rString[1] = "EPid: " + a.getEntryNameByIndex(yVal);
            rString[2] = "Count = " + this.avgHopCount[xVal][yVal];
            rString[3] = "Processor = " + this.xAxis.getIndexName(xVal);
        } else if (this.currentArrayName.equals("avgPeHopCount")) {
            rString[1] = "Count = " + this.avgPeHopCount[xVal][yVal];
            rString[2] = "Processor = " + this.xAxis.getIndexName(xVal);
            rString[3] = "";
        }
        return rString;
    }

    @Override
    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        this.parentWindow.addProcessor(xVal);
    }

    @Override
    public void toolMouseMovedResponse(MouseEvent e, int xVal, int yVal) {
    }

    @Override
    protected void createMenus() {
        super.createMenus();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.graphPanel = this.getMainPanel();
        this.checkBoxPanel = new JPanel();
        if (MainWindow.BLUEGENE) {
            this.blueGenePanel = new JPanel();
        }
        CheckboxGroup cbg = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent To", cbg, true);
        this.sentBytes = new Checkbox("Bytes Sent To", cbg, false);
        this.receivedMsgs = new Checkbox("Msgs Recv By", cbg, false);
        this.receivedBytes = new Checkbox("Bytes Recv By", cbg, false);
        this.recvExclusive = new Checkbox("External Msgs Recv By", cbg, false);
        this.recvExclusiveBytes = new Checkbox("External Bytes Recv By", cbg, false);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB = new Checkbox("Avg Hop Count (EP)", cbg, false);
            this.peHopCountCB = new Checkbox("Avg Hop Count (procs)", cbg, false);
        }
        this.sentMsgs.addItemListener(this);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes.addItemListener(this);
        this.recvExclusive.addItemListener(this);
        this.recvExclusiveBytes.addItemListener(this);
        if (MainWindow.BLUEGENE) {
            this.hopCountCB.addItemListener(this);
            this.peHopCountCB.addItemListener(this);
        }
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusive, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.recvExclusiveBytes, gbc, 5, 0, 1, 1, 1, 1);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.blueGenePanel, this.hopCountCB, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.blueGenePanel, this.peHopCountCB, gbc, 1, 0, 1, 1, 1, 1);
        }
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gbc, 0, 2, 1, 1, 0, 0);
        if (MainWindow.BLUEGENE) {
            Util.gblAdd(this.mainPanel, this.blueGenePanel, gbc, 0, 3, 1, 1, 0, 0);
        }
    }

    @Override
    public void setGraphSpecificData() {
    }

    @Override
    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range", null, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    CommWindow.this.peList = new TreeSet<Integer>(CommWindow.this.dialog.getSelectedProcessors());
                    CommWindow.this.getData(CommWindow.this.dialog.getStartTime(), CommWindow.this.dialog.getEndTime(), CommWindow.this.dialog.getSelectedProcessors());
                    return null;
                }

                public void done() {
                    CommWindow.this.setDataSource("Communications", CommWindow.this.sentMsgCount, CommWindow.this.thisWindow);
                    CommWindow.this.setPopupText("sentMsgCount");
                    CommWindow.this.setYAxis("Messages Sent", "");
                    CommWindow.this.setXAxis("Processor", CommWindow.this.peList);
                    CommWindow.this.thisWindow.setVisible(true);
                    CommWindow.this.thisWindow.repaint();
                }
            };
            worker.execute();
        }
    }

    private void getData(long startTime, long endTime, SortedSet<Integer> pes) {
        int n;
        int k;
        int min;
        this.sentMsgCount = new double[pes.size()][];
        this.sentByteCount = new double[pes.size()][];
        this.receivedMsgCount = new double[pes.size()][];
        this.receivedByteCount = new double[pes.size()][];
        this.exclusiveRecv = new double[pes.size()][];
        this.exclusiveBytesRecv = new double[pes.size()][];
        this.hopCount = MainWindow.BLUEGENE ? (Object)new int[pes.size()][] : (int[][])null;
        this.histogram = new ArrayList();
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        int pIdx = 0;
        for (Integer nextPe : pes) {
            readyReaders.add(new ThreadedFileReader(nextPe, pIdx, startTime, endTime, this.sentMsgCount, this.sentByteCount, this.receivedMsgCount, this.receivedByteCount, this.exclusiveRecv, this.exclusiveBytesRecv, this.hopCount));
            ++pIdx;
        }
        Component guiRootForProgressBar = null;
        if (this.thisWindow != null && this.thisWindow.isVisible()) {
            guiRootForProgressBar = this.thisWindow;
        } else if (MainWindow.runObject[CommWindow.myRun].guiRoot != null && MainWindow.runObject[CommWindow.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[CommWindow.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Communication Data in Parallel", readyReaders, guiRootForProgressBar, true);
        threadManager.runAll();
        for (ThreadedFileReader threadedFileReader : readyReaders) {
            this.histogram.addAll(threadedFileReader.localHistogram);
        }
        if (this.histogram.size() > 0) {
            int n2 = this.histogram.get(0);
            min = this.histogram.get(0);
        } else {
            min = 0;
            boolean bl = false;
        }
        for (k = 1; k < this.histogram.size(); ++k) {
            if (this.histogram.get(k) < min) {
                min = this.histogram.get(k);
            }
            if (this.histogram.get(k) <= n) continue;
            n = this.histogram.get(k);
        }
        this.histArray = new int[n + true];
        for (k = 0; k < Array.getLength(this.histArray); ++k) {
            this.histArray[k] = 0;
        }
        for (int k2 = 0; k2 < this.histogram.size(); ++k2) {
            int index;
            int n3 = index = this.histogram.get(k2).intValue();
            this.histArray[n3] = this.histArray[n3] + 1;
        }
    }

    static int manhattanDistance(int destPe, int srcPe) {
        int distance = 0;
        int dimDistance = 0;
        int[] destTriple = CommWindow.peToTriple(destPe);
        int[] srcTriple = CommWindow.peToTriple(srcPe);
        for (int dim = 0; dim < 3; ++dim) {
            dimDistance = destTriple[dim] < srcTriple[dim] ? srcTriple[dim] - destTriple[dim] : destTriple[dim] - srcTriple[dim];
            if ((double)dimDistance > (double)MainWindow.BLUEGENE_SIZE[dim] / 2.0) {
                dimDistance = MainWindow.BLUEGENE_SIZE[dim] - dimDistance;
            }
            distance += dimDistance;
        }
        if (distance < 0) {
            System.err.println("Internal Error: Negative Manhatten distance " + distance + " Destination PE [" + destPe + "], Source PE [" + srcPe + "]");
            System.err.println("[" + destTriple[0] + "][" + destTriple[1] + "][" + destTriple[2] + "] by [" + srcTriple[0] + "][" + srcTriple[1] + "][" + srcTriple[2] + "] on a [" + MainWindow.BLUEGENE_SIZE[0] + "][" + MainWindow.BLUEGENE_SIZE[1] + "][" + MainWindow.BLUEGENE_SIZE[2] + "] BG Torus");
            System.exit(-1);
        }
        return distance;
    }

    private static int[] peToTriple(int pe) {
        int[] returnTriple = new int[3];
        returnTriple[2] = pe / (MainWindow.BLUEGENE_SIZE[1] * MainWindow.BLUEGENE_SIZE[0]);
        returnTriple[1] = pe / MainWindow.BLUEGENE_SIZE[0] - returnTriple[2] * MainWindow.BLUEGENE_SIZE[1];
        returnTriple[0] = pe % MainWindow.BLUEGENE_SIZE[0];
        if (returnTriple[0] < 0 || returnTriple[1] < 0 || returnTriple[2] < 0) {
            System.err.println("Internal Error: Triple [" + returnTriple[0] + "][" + returnTriple[1] + "][" + returnTriple[2] + "]");
            System.exit(-1);
        }
        return returnTriple;
    }

    private double[][] averageHops(int[][] hopArray, double[][] msgReceived) {
        double[][] returnValue = new double[hopArray.length][hopArray[0].length];
        for (int i = 0; i < hopArray.length; ++i) {
            for (int j = 0; j < hopArray[i].length; ++j) {
                returnValue[i][j] = msgReceived[i][j] > 0.0 ? (double)hopArray[i][j] / msgReceived[i][j] : 0.0;
            }
        }
        return returnValue;
    }

    private double[][] averagePEHops(int[][] hopArray, double[][] msgReceived) {
        double[][] returnValue = new double[hopArray.length][1];
        double[] totalRecv = new double[hopArray.length];
        for (int pe = 0; pe < hopArray.length; ++pe) {
            for (int ep = 0; ep < hopArray[pe].length; ++ep) {
                int n = pe;
                totalRecv[n] = totalRecv[n] + msgReceived[pe][ep];
                double[] dArray = returnValue[pe];
                dArray[0] = dArray[0] + (double)hopArray[pe][ep];
            }
            if (!(totalRecv[pe] > 0.0)) continue;
            double[] dArray = returnValue[pe];
            dArray[0] = dArray[0] / totalRecv[pe];
        }
        return returnValue;
    }

    private static int[] peToTripleA(int pe) {
        int[] returnTriple = new int[3];
        int[] BG = new int[]{8, 8, 16};
        System.out.println("BG triplet = " + BG[0] + " " + BG[1] + " " + BG[2]);
        returnTriple[2] = pe / (BG[0] * BG[1]);
        returnTriple[1] = pe / BG[0] - returnTriple[2] * BG[0];
        returnTriple[0] = pe % BG[0];
        return returnTriple;
    }

    private static int manhattenDistanceA(int srcPe, int destPe) {
        int distance = 0;
        int dimDistance = 0;
        int[] BG = new int[]{8, 8, 16};
        int[] destTriple = CommWindow.peToTripleA(destPe);
        int[] srcTriple = CommWindow.peToTripleA(srcPe);
        System.out.println("Source triple = " + srcTriple[0] + " " + srcTriple[1] + " " + srcTriple[2]);
        System.out.println("Dest triple = " + destTriple[0] + " " + destTriple[1] + " " + destTriple[2]);
        for (int dim = 0; dim < 3; ++dim) {
            dimDistance = destTriple[dim] < srcTriple[dim] ? srcTriple[dim] - destTriple[dim] : destTriple[dim] - srcTriple[dim];
            if ((double)dimDistance > (double)BG[dim] / 2.0) {
                dimDistance = BG[dim] - dimDistance;
            }
            distance += dimDistance;
        }
        return distance;
    }

    public static void main(String[] args) {
        int distance = CommWindow.manhattenDistanceA(1018, 1023);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 1020);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 972);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 996);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(442, 663);
        System.out.println(distance);
        distance = CommWindow.manhattenDistanceA(1018, 324);
        System.out.println(distance);
    }
}

