/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Extrema;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import projections.analysis.Analysis;
import projections.gui.JIntTextField;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.RangeDialogExtensionPanel;
import projections.gui.Util;

class ExtremaDialogExtension
extends RangeDialogExtensionPanel {
    private int myRun = 0;
    private JPanel outlierPanel;
    private JComboBox attributeList;
    private JComboBox activityList;
    private JIntTextField thresholdField;
    private JIntTextField kField;
    private JTextArea errorText;
    private JLabel attributeLabel;
    private JLabel activityLabel;
    private JLabel thresholdPost;
    private JLabel thresholdLabel;

    public ExtremaDialogExtension(String[] attributes) {
        int threshold = MainWindow.runObject[this.myRun].getNumProcessors() <= 256 ? (int)Math.ceil(0.1 * (double)MainWindow.runObject[this.myRun].getNumProcessors()) : 20;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.outlierPanel = this;
        this.outlierPanel.setLayout(gbl);
        this.attributeList = new JComboBox<String>(attributes);
        this.attributeList.setSelectedIndex(0);
        this.attributeLabel = new JLabel("Attribute: ", 4);
        this.activityList = new JComboBox<String>(Analysis.NAMES);
        this.activityList.setSelectedIndex(0);
        this.activityLabel = new JLabel("Activity: ", 4);
        this.thresholdLabel = new JLabel("Extrema Threshold: ", 4);
        this.thresholdField = new JIntTextField(threshold, 8);
        this.thresholdPost = new JLabel("Processors", 2);
        JLabel kLabel = new JLabel("Number of Clusters: ", 4);
        this.kField = new JIntTextField(MainWindow.runObject[this.myRun].getNumProcessors(), 3);
        this.errorText = new JTextArea();
        this.errorText.setRows(3);
        this.errorText.setEditable(false);
        this.errorText.setLineWrap(true);
        this.errorText.setWrapStyleWord(true);
        this.errorText.setForeground(Color.red);
        JScrollPane scrollText = new JScrollPane(this.errorText, 20, 31);
        Util.gblAdd(this.outlierPanel, this.attributeLabel, gbc, 0, 0, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.attributeList, gbc, 1, 0, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.activityLabel, gbc, 0, 1, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.activityList, gbc, 1, 1, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.thresholdLabel, gbc, 0, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.thresholdField, gbc, 1, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.thresholdPost, gbc, 2, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, kLabel, gbc, 0, 3, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.kField, gbc, 1, 3, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, scrollText, gbc, 0, 4, 3, 3, 0, 1);
    }

    public boolean isInputValid() {
        if (this.thresholdField.getValue() < 0) {
            this.thresholdField.setForeground(Color.red);
            return false;
        }
        if (this.activityList.getSelectedIndex() == 2 && this.attributeList.getSelectedIndex() >= 1) {
            this.attributeLabel.setForeground(Color.red);
            this.activityLabel.setForeground(Color.red);
            this.errorText.setForeground(Color.red);
            this.errorText.setText("ERROR: Attribute " + this.attributeList.getSelectedItem() + " is incompatible with Activity " + this.activityList.getSelectedItem());
            return false;
        }
        this.errorText.setText("");
        this.attributeLabel.setForeground(Color.black);
        this.activityLabel.setForeground(Color.black);
        this.thresholdField.setForeground(Color.black);
        return true;
    }

    public void setInitialFields() {
    }

    public void setParentDialogBox(RangeDialog parent) {
        this.attributeList.addActionListener(parent);
        this.attributeList.addKeyListener(parent);
        this.attributeList.addFocusListener(parent);
        this.activityList.addActionListener(parent);
        this.activityList.addKeyListener(parent);
        this.activityList.addFocusListener(parent);
        this.thresholdField.addActionListener(parent);
        this.thresholdField.addKeyListener(parent);
        this.thresholdField.addFocusListener(parent);
        this.kField.addActionListener(parent);
        this.kField.addKeyListener(parent);
        this.kField.addFocusListener(parent);
    }

    public void updateFields() {
    }

    public int getThreshold() {
        return this.thresholdField.getValue();
    }

    int getCurrentAttribute() {
        return this.attributeList.getSelectedIndex();
    }

    int getCurrentActivity() {
        return this.activityList.getSelectedIndex();
    }

    int getK() {
        return this.kField.getValue();
    }
}

