/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Histogram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.gui.JIntTextField;
import projections.gui.JLongTextField;
import projections.gui.RangeDialog;
import projections.gui.RangeDialogExtensionPanel;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

class BinDialogPanel
extends RangeDialogExtensionPanel {
    private JTabbedPane tabbedPane;
    private JPanel timeBinPanel;
    private JPanel msgBinPanel;
    private JPanel idleBinPanel;
    private JLabel timeNumBinsLabel;
    private JLabel timeBinSizeLabel;
    private JLabel timeMinBinSizeLabel;
    private JLabel timeBinRangeLabel;
    private JIntTextField timeNumBinsField;
    private TimeTextField timeBinSizeField;
    private TimeTextField timeMinBinSizeField;
    private JLabel msgNumBinsLabel;
    private JLabel msgBinSizeLabel;
    private JLabel msgMinBinSizeLabel;
    private JLabel msgBinRangeLabel;
    private JIntTextField msgNumBinsField;
    private JLongTextField msgBinSizeField;
    private JLongTextField msgMinBinSizeField;
    private JLabel idleNumBinsLabel;
    private JLabel idleBinSizeLabel;
    private JLabel idleMinBinSizeLabel;
    private JLabel idleBinRangeLabel;
    private JIntTextField idleNumBinsField;
    private JLongTextField idleBinSizeField;
    private JLongTextField idleMinBinSizeField;
    private RangeDialog parent;

    public BinDialogPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.timeBinPanel = new JPanel();
        this.timeBinPanel.setLayout(gbl);
        this.timeBinPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "TIME-BASED BINS"));
        this.timeNumBinsLabel = new JLabel("# of Time Bins:", 2);
        this.timeNumBinsField = new JIntTextField(-1, 5);
        this.timeBinSizeLabel = new JLabel("Time Bin Size:", 2);
        this.timeBinSizeField = new TimeTextField(-1L, 12);
        this.timeMinBinSizeLabel = new JLabel("Starting Bin Size:", 2);
        this.timeMinBinSizeField = new TimeTextField(-1L, 12);
        this.timeBinRangeLabel = new JLabel("", 2);
        Util.gblAdd(this.timeBinPanel, this.timeNumBinsLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeNumBinsField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinSizeLabel, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinSizeField, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeMinBinSizeLabel, gbc, 0, 1, 2, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeMinBinSizeField, gbc, 1, 1, 2, 1, 1, 1);
        Util.gblAdd(this.timeBinPanel, this.timeBinRangeLabel, gbc, 0, 2, 4, 1, 1, 1);
        this.msgBinPanel = new JPanel();
        this.msgBinPanel.setLayout(gbl);
        this.msgBinPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "MESSAGE-BASED BINS"));
        this.msgNumBinsLabel = new JLabel("# of Msg Bins:", 2);
        this.msgNumBinsField = new JIntTextField(-1, 5);
        this.msgBinSizeLabel = new JLabel("Bin Size (bytes):", 2);
        this.msgBinSizeField = new JLongTextField(-1L, 12);
        this.msgMinBinSizeLabel = new JLabel("Starting Bin Size:", 2);
        this.msgMinBinSizeField = new JLongTextField(-1L, 12);
        this.msgBinRangeLabel = new JLabel("", 2);
        Util.gblAdd(this.msgBinPanel, this.msgNumBinsLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgNumBinsField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinSizeLabel, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinSizeField, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgMinBinSizeLabel, gbc, 0, 1, 2, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgMinBinSizeField, gbc, 1, 1, 2, 1, 1, 1);
        Util.gblAdd(this.msgBinPanel, this.msgBinRangeLabel, gbc, 0, 2, 4, 1, 1, 1);
        this.idleBinPanel = new JPanel();
        this.idleBinPanel.setLayout(gbl);
        this.idleBinPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "IDLE PERCENTAGE-BASED BINS"));
        this.idleNumBinsLabel = new JLabel("# of Idle % Bins:", 2);
        this.idleNumBinsField = new JIntTextField(-1, 5);
        this.idleBinSizeLabel = new JLabel("Idle % Bin Size", 2);
        this.idleBinSizeField = new JLongTextField(-1L, 12);
        this.idleMinBinSizeLabel = new JLabel("Starting Bin Size:", 2);
        this.idleMinBinSizeField = new JLongTextField(-1L, 12);
        this.idleBinRangeLabel = new JLabel("", 2);
        Util.gblAdd(this.idleBinPanel, this.idleNumBinsLabel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleNumBinsField, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleBinSizeLabel, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleBinSizeField, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleMinBinSizeLabel, gbc, 0, 1, 2, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleMinBinSizeField, gbc, 1, 1, 2, 1, 1, 1);
        Util.gblAdd(this.idleBinPanel, this.idleBinRangeLabel, gbc, 0, 2, 4, 1, 1, 1);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Time", null, this.timeBinPanel, "Time-based bins");
        this.tabbedPane.addTab("Msgs", null, this.msgBinPanel, "Message Sizes");
        this.tabbedPane.addTab("Idle %", null, this.idleBinPanel, "Idle percentage-based bins");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    public int getTimeNumBins() {
        if (this.timeNumBinsField.getValue() - 1 >= 0) {
            return this.timeNumBinsField.getValue() - 1;
        }
        return 0;
    }

    public void setTimeNumBins(int numBins) {
        this.timeNumBinsField.setValue(numBins);
        this.parent.someInputChanged();
    }

    public long getTimeBinSize() {
        return this.timeBinSizeField.getValue();
    }

    public void setTimeBinSize(long binSize) {
        this.timeBinSizeField.setValue(binSize);
        this.parent.someInputChanged();
    }

    public long getTimeMinBinSize() {
        return this.timeMinBinSizeField.getValue();
    }

    public void setTimeMinBinSize(long size) {
        this.timeMinBinSizeField.setValue(size);
        this.parent.someInputChanged();
    }

    public int getMsgNumBins() {
        if (this.msgNumBinsField.getValue() - 1 >= 0) {
            return this.msgNumBinsField.getValue() - 1;
        }
        return 0;
    }

    public void setMsgNumBins(int numBins) {
        this.msgNumBinsField.setValue(numBins);
        this.parent.someInputChanged();
    }

    public long getMsgBinSize() {
        return this.msgBinSizeField.getValue();
    }

    public void setMsgBinSize(long binSize) {
        this.msgBinSizeField.setValue(binSize);
        this.parent.someInputChanged();
    }

    public long getMsgMinBinSize() {
        return this.msgMinBinSizeField.getValue();
    }

    public void setMsgMinBinSize(long size) {
        this.msgMinBinSizeField.setValue(size);
        this.parent.someInputChanged();
    }

    public int getIdleNumBins() {
        if (this.idleNumBinsField.getValue() - 1 >= 0) {
            return this.idleNumBinsField.getValue() - 1;
        }
        return 0;
    }

    public void setIdleNumBins(int numBins) {
        this.idleNumBinsField.setValue(numBins);
        this.parent.someInputChanged();
    }

    public long getIdleBinSize() {
        return this.idleBinSizeField.getValue();
    }

    public void setIdleBinSize(long binSize) {
        this.idleBinSizeField.setValue(binSize);
        this.parent.someInputChanged();
    }

    public long getIdleMinBinSize() {
        return this.idleMinBinSizeField.getValue();
    }

    public void setIdleMinBinSize(long size) {
        this.idleMinBinSizeField.setValue(size);
        this.parent.someInputChanged();
    }

    public boolean isInputValid() {
        return true;
    }

    public void setInitialFields() {
        this.timeNumBinsField.setText("101");
        this.timeBinSizeField.setText("1000");
        this.timeMinBinSizeField.setText("0");
        this.msgNumBinsField.setText("201");
        this.msgBinSizeField.setText("100");
        this.msgMinBinSizeField.setText("0");
        this.idleNumBinsField.setText("101");
        this.idleBinSizeField.setText("1");
        this.idleMinBinSizeField.setText("0");
        this.updateFields();
    }

    public void setParentDialogBox(RangeDialog parent) {
        this.parent = parent;
        this.timeNumBinsField.addActionListener(parent);
        this.timeNumBinsField.addKeyListener(parent);
        this.timeNumBinsField.addFocusListener(parent);
        this.timeBinSizeField.addActionListener(parent);
        this.timeBinSizeField.addKeyListener(parent);
        this.timeBinSizeField.addFocusListener(parent);
        this.timeMinBinSizeField.addActionListener(parent);
        this.timeMinBinSizeField.addKeyListener(parent);
        this.timeMinBinSizeField.addFocusListener(parent);
        this.msgNumBinsField.addActionListener(parent);
        this.msgNumBinsField.addKeyListener(parent);
        this.msgNumBinsField.addFocusListener(parent);
        this.msgBinSizeField.addActionListener(parent);
        this.msgBinSizeField.addKeyListener(parent);
        this.msgBinSizeField.addFocusListener(parent);
        this.msgMinBinSizeField.addActionListener(parent);
        this.msgMinBinSizeField.addKeyListener(parent);
        this.msgMinBinSizeField.addFocusListener(parent);
        this.idleNumBinsField.addActionListener(parent);
        this.idleNumBinsField.addKeyListener(parent);
        this.idleNumBinsField.addFocusListener(parent);
        this.idleBinSizeField.addActionListener(parent);
        this.idleBinSizeField.addKeyListener(parent);
        this.idleBinSizeField.addFocusListener(parent);
        this.idleMinBinSizeField.addActionListener(parent);
        this.idleMinBinSizeField.addKeyListener(parent);
        this.idleMinBinSizeField.addFocusListener(parent);
    }

    public void updateFields() {
        this.timeBinRangeLabel.setText("Bin size ranges from : " + U.humanReadableString(this.timeMinBinSizeField.getValue()) + " to " + U.humanReadableString(this.timeMinBinSizeField.getValue() + (long)this.getTimeNumBins() * this.timeBinSizeField.getValue()));
        DecimalFormat _format = new DecimalFormat();
        this.msgBinRangeLabel.setText("Bin size ranges from : " + _format.format(this.msgMinBinSizeField.getValue()) + " bytes to " + _format.format(this.msgMinBinSizeField.getValue() + (long)this.getMsgNumBins() * this.msgBinSizeField.getValue()) + " bytes.");
        this.idleBinRangeLabel.setText("Bin size ranges from : " + _format.format(this.idleMinBinSizeField.getValue()) + "% to " + _format.format(this.idleMinBinSizeField.getValue() + (long)this.getIdleNumBins() * this.idleBinSizeField.getValue()) + "%.");
    }

    public int getSelectedType() {
        if (this.tabbedPane.getSelectedComponent() == this.timeBinPanel) {
            return 0;
        }
        if (this.tabbedPane.getSelectedComponent() == this.msgBinPanel) {
            return 1;
        }
        return 3;
    }
}

