/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Histogram;

import java.io.IOException;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private long startTime;
    private long endTime;
    private int myRun = 0;
    private int timeNumBins;
    private long timeBinSize;
    private long timeMinBinSize;
    private int msgNumBins;
    private long msgBinSize;
    private long msgMinBinSize;
    private int idleNumBins;
    private long idleBinSize;
    private long idleMinBinSize;
    private double[][][] outputCounts;
    private double[][] executionTime;

    protected ThreadedFileReader(double[][][] outputCounts, int pe, long startTime, long endTime, int timeNumBins, long timeBinSize, long timeMinBinSize, int msgNumBins, long msgBinSize, long msgMinBinSize) {
        this.pe = pe;
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeNumBins = timeNumBins;
        this.timeBinSize = timeBinSize;
        this.timeMinBinSize = timeMinBinSize;
        this.msgNumBins = msgNumBins;
        this.msgBinSize = msgBinSize;
        this.msgMinBinSize = msgMinBinSize;
        this.outputCounts = outputCounts;
    }

    protected ThreadedFileReader(double[][][] outputCounts, int pe, long startTime, long endTime, int timeNumBins, long timeBinSize, long timeMinBinSize, int msgNumBins, long msgBinSize, long msgMinBinSize, int idleNumBins, long idleBinSize, long idleMinBinSize, double[][] executionTime) {
        this.pe = pe;
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeNumBins = timeNumBins;
        this.timeBinSize = timeBinSize;
        this.timeMinBinSize = timeMinBinSize;
        this.msgNumBins = msgNumBins;
        this.msgBinSize = msgBinSize;
        this.msgMinBinSize = msgMinBinSize;
        this.idleNumBins = idleNumBins;
        this.idleBinSize = idleBinSize;
        this.idleMinBinSize = idleMinBinSize;
        this.outputCounts = outputCounts;
        this.executionTime = executionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        double[][][] myCounts = this.getCounts();
        double[][] exec_time = this.getTotalExecTime();
        Object object = this.outputCounts;
        synchronized (this.outputCounts) {
            int i;
            for (i = 0; i < this.outputCounts.length; ++i) {
                for (int j = 0; j < this.outputCounts[i].length; ++j) {
                    for (int k = 0; k < this.outputCounts[i][j].length; ++k) {
                        double[] dArray = this.outputCounts[i][j];
                        int n = k;
                        dArray[n] = dArray[n] + myCounts[i][j][k];
                    }
                }
            }
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            object = this.executionTime;
            synchronized (this.executionTime) {
                for (i = 0; i < this.executionTime[0].length; ++i) {
                    double[] dArray = this.executionTime[0];
                    int n = i;
                    dArray[n] = dArray[n] + exec_time[0][i];
                    double[] dArray2 = this.executionTime[3];
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + exec_time[3][i];
                }
                for (i = 0; i < this.executionTime[1].length; ++i) {
                    if (!(this.executionTime[1][i] < exec_time[1][i])) continue;
                    this.executionTime[1][i] = exec_time[1][i];
                }
                for (i = 0; i < this.executionTime[2].length; ++i) {
                    if (!(this.executionTime[2][i] < exec_time[2][i])) continue;
                    this.executionTime[2][i] = exec_time[2][i];
                }
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                myCounts = null;
                return;
            }
        }
    }

    private double[][][] getCounts() {
        long totalIdleTime = 0L;
        long totalStart = 0L;
        long totalStop = 0L;
        long idleStart = 0L;
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries() + 1;
        double[][][] countData = new double[4][][];
        double[] _sun_execution_time = new double[numEPs];
        for (int _i = 0; _i < numEPs; ++_i) {
            _sun_execution_time[_i] = 0.0;
        }
        countData[0] = new double[this.timeNumBins + 1][numEPs];
        countData[2] = new double[this.timeNumBins + 1][numEPs];
        countData[1] = new double[this.msgNumBins + 1][numEPs];
        countData[3] = new double[this.idleNumBins + 1][numEPs];
        int curPeCount = 0;
        ++curPeCount;
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        try {
            int nestingLevel = 0;
            boolean logEnd = false;
            LogEntryData prevBegin = null;
            LogEntryData prevIdleBegin = null;
            block15: while (true) {
                LogEntryData logdata = reader.nextEvent();
                switch (logdata.type) {
                    case 2: {
                        if (logEnd) continue block15;
                        if (++nestingLevel == 1) {
                            prevBegin = logdata;
                        }
                        if (logdata.time < this.endTime) break;
                        logEnd = true;
                        int idleTargetBin = (int)(totalIdleTime * 100L / (this.endTime - totalStart));
                        if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) < 0) continue block15;
                        if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                            idleTargetBin = this.idleNumBins;
                        }
                        double[] dArray = countData[3][idleTargetBin];
                        dArray[0] = dArray[0] + 1.0;
                        break;
                    }
                    case 3: {
                        int targetBin;
                        long executionTime;
                        long adjustedTime;
                        int idleTargetBin;
                        if (logEnd) continue block15;
                        if (--nestingLevel == 0) {
                            if (logdata.time >= this.startTime && logdata.time <= this.endTime) {
                                if (prevBegin.time <= this.startTime) {
                                    prevBegin.time = this.startTime;
                                }
                                if ((adjustedTime = (executionTime = logdata.time - prevBegin.time) - this.timeMinBinSize) >= 0L) {
                                    targetBin = (int)(adjustedTime / this.timeBinSize);
                                    if (targetBin >= this.timeNumBins) {
                                        targetBin = this.timeNumBins;
                                    }
                                    double[] dArray = countData[0][targetBin];
                                    int n = logdata.entry;
                                    dArray[n] = dArray[n] + 1.0;
                                    double[] dArray2 = countData[2][targetBin];
                                    int n2 = logdata.entry;
                                    dArray2[n2] = dArray2[n2] + (double)executionTime;
                                }
                                int n = logdata.entry;
                                _sun_execution_time[n] = _sun_execution_time[n] + (double)executionTime;
                            } else if (logdata.time >= this.endTime) {
                                if (this.startTime >= prevBegin.time) {
                                    prevBegin.time = this.startTime;
                                }
                                if ((adjustedTime = (executionTime = this.endTime - prevBegin.time) - this.timeMinBinSize) >= 0L) {
                                    targetBin = (int)(adjustedTime / this.timeBinSize);
                                    if (targetBin >= this.timeNumBins) {
                                        targetBin = this.timeNumBins;
                                    }
                                    double[] dArray = countData[0][targetBin];
                                    int n = logdata.entry;
                                    dArray[n] = dArray[n] + 1.0;
                                    double[] dArray3 = countData[2][targetBin];
                                    int n3 = logdata.entry;
                                    dArray3[n3] = dArray3[n3] + (double)executionTime;
                                }
                                int n = logdata.entry;
                                _sun_execution_time[n] = _sun_execution_time[n] + (double)executionTime;
                                logEnd = true;
                                idleTargetBin = (int)(totalIdleTime * 100L / (this.endTime - totalStart));
                                if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) >= 0) {
                                    if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                                        idleTargetBin = this.idleNumBins;
                                    }
                                    double[] dArray = countData[3][idleTargetBin];
                                    dArray[0] = dArray[0] + 1.0;
                                    break;
                                }
                            }
                            prevBegin = null;
                            break;
                        }
                        if (nestingLevel >= 0) break;
                        nestingLevel = 0;
                        prevBegin = null;
                        break;
                    }
                    case 14: {
                        if (logEnd) continue block15;
                        prevIdleBegin = logdata;
                        idleStart = prevIdleBegin.time;
                        if (logdata.time < this.endTime) break;
                        logEnd = true;
                        int idleTargetBin = (int)(totalIdleTime * 100L / (this.endTime - totalStart));
                        if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) < 0) continue block15;
                        if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                            idleTargetBin = this.idleNumBins;
                        }
                        double[] dArray = countData[3][idleTargetBin];
                        dArray[0] = dArray[0] + 1.0;
                        break;
                    }
                    case 15: {
                        int targetBin;
                        long executionTime;
                        long adjustedTime;
                        int idleTargetBin;
                        if (logEnd) continue block15;
                        if (logdata.time >= this.startTime && logdata.time <= this.endTime) {
                            if (idleStart <= this.startTime) {
                                prevIdleBegin.time = this.startTime;
                            }
                            if ((adjustedTime = (executionTime = logdata.time - prevIdleBegin.time) - this.timeMinBinSize) >= 0L) {
                                targetBin = (int)(adjustedTime / this.timeBinSize);
                                if (targetBin >= this.timeNumBins) {
                                    targetBin = this.timeNumBins;
                                }
                                double[] dArray = countData[0][targetBin];
                                int n = numEPs - 1;
                                dArray[n] = dArray[n] + 1.0;
                                double[] dArray4 = countData[2][targetBin];
                                int n4 = numEPs - 1;
                                dArray4[n4] = dArray4[n4] + (double)executionTime;
                            }
                            int n = logdata.entry;
                            _sun_execution_time[n] = _sun_execution_time[n] + (double)executionTime;
                            System.out.println("idle time is " + executionTime);
                            if (idleStart <= this.startTime) {
                                idleStart = this.startTime;
                                totalStart = this.startTime;
                            }
                            totalIdleTime += logdata.time - idleStart;
                        } else if (logdata.time >= this.endTime) {
                            if (this.startTime >= idleStart) {
                                idleStart = this.startTime;
                                totalStart = this.startTime;
                            }
                            if ((adjustedTime = (executionTime = this.endTime - idleStart) - this.timeMinBinSize) >= 0L) {
                                targetBin = (int)(adjustedTime / this.timeBinSize);
                                if (targetBin >= this.timeNumBins) {
                                    targetBin = this.timeNumBins;
                                }
                                double[] dArray = countData[0][targetBin];
                                int n = numEPs - 1;
                                dArray[n] = dArray[n] + 1.0;
                                double[] dArray5 = countData[2][targetBin];
                                int n5 = numEPs - 1;
                                dArray5[n5] = dArray5[n5] + (double)executionTime;
                            }
                            int n = logdata.entry;
                            _sun_execution_time[n] = _sun_execution_time[n] + (double)executionTime;
                            logEnd = true;
                            idleTargetBin = (int)((totalIdleTime += this.endTime - idleStart) * 100L / (this.endTime - totalStart));
                            if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) >= 0) {
                                if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                                    idleTargetBin = this.idleNumBins;
                                }
                                double[] dArray = countData[3][idleTargetBin];
                                dArray[0] = dArray[0] + 1.0;
                                break;
                            }
                        }
                        prevIdleBegin = null;
                        break;
                    }
                    case 1: {
                        long adjustedSize;
                        if (logdata.time > this.endTime || (adjustedSize = (long)logdata.msglen - this.msgMinBinSize) < 0L) continue block15;
                        int targetBin = (int)(adjustedSize / this.msgBinSize);
                        if (targetBin >= this.msgNumBins) {
                            targetBin = this.msgNumBins;
                        }
                        double[] dArray = countData[1][targetBin];
                        int n = logdata.entry;
                        dArray[n] = dArray[n] + 1.0;
                        break;
                    }
                    case 7: {
                        int idleTargetBin;
                        if (logEnd) continue block15;
                        if (logdata.time >= this.endTime) {
                            idleTargetBin = (int)(totalIdleTime * 100L / (this.endTime - totalStart));
                            if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) < 0) continue block15;
                            if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                                idleTargetBin = this.idleNumBins;
                            }
                            double[] dArray = countData[3][idleTargetBin];
                            dArray[0] = dArray[0] + 1.0;
                            break;
                        }
                        if (logdata.time <= this.startTime) {
                            idleTargetBin = (int)(0L - this.idleMinBinSize);
                            if (idleTargetBin < 0) continue block15;
                            if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                                idleTargetBin = this.idleNumBins;
                            }
                            double[] dArray = countData[3][idleTargetBin];
                            dArray[0] = dArray[0] + 1.0;
                            break;
                        }
                        idleTargetBin = (int)(totalIdleTime * 100L / (logdata.time - totalStart));
                        if ((idleTargetBin = (int)((long)idleTargetBin - this.idleMinBinSize)) < 0) continue block15;
                        if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                            idleTargetBin = this.idleNumBins;
                        }
                        double[] dArray = countData[3][idleTargetBin];
                        dArray[0] = dArray[0] + 1.0;
                        break;
                    }
                    case 6: {
                        int idleTargetBin;
                        if (logEnd) continue block15;
                        totalStart = logdata.time;
                        if (logdata.time >= this.endTime) {
                            logEnd = true;
                            idleTargetBin = (int)(0L - this.idleMinBinSize);
                            if (idleTargetBin < 0) continue block15;
                            if ((idleTargetBin = (int)((long)idleTargetBin / this.idleBinSize)) >= this.idleNumBins) {
                                idleTargetBin = this.idleNumBins;
                            }
                            double[] dArray = countData[3][idleTargetBin];
                            dArray[0] = dArray[0] + 1.0;
                            break;
                        }
                        if (logdata.time > this.startTime) break;
                        totalStart = this.startTime;
                    }
                }
            }
        }
        catch (EndOfLogSuccess nestingLevel) {
        }
        catch (Exception e) {
            System.err.println("Exception " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        return countData;
    }

    private double[][] getTotalExecTime() {
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries() + 1;
        double[][] _sun_execution_time = new double[4][numEPs];
        int curPeCount = 0;
        ++curPeCount;
        GenericLogReader reader = new GenericLogReader(this.pe, MainWindow.runObject[this.myRun].getVersion());
        try {
            int nestingLevel = 0;
            LogEntryData prevBegin = null;
            LogEntryData prevIdleBegin = null;
            block12: while (true) {
                LogEntryData logdata = reader.nextEvent();
                switch (logdata.type) {
                    case 2: {
                        if (++nestingLevel != 1) break;
                        prevBegin = logdata;
                        break;
                    }
                    case 3: {
                        long executionTime;
                        if (--nestingLevel == 0) {
                            if (logdata.time >= this.startTime && logdata.time <= this.endTime) {
                                executionTime = logdata.time - prevBegin.time;
                                double[] dArray = _sun_execution_time[0];
                                int n = logdata.entry;
                                dArray[n] = dArray[n] + (double)executionTime;
                                if (_sun_execution_time[1][logdata.entry] < (double)executionTime) {
                                    _sun_execution_time[1][logdata.entry] = executionTime;
                                }
                                if (_sun_execution_time[2][logdata.entry] > (double)executionTime) {
                                    _sun_execution_time[2][logdata.entry] = executionTime;
                                }
                                double[] dArray2 = _sun_execution_time[3];
                                int n2 = logdata.entry;
                                dArray2[n2] = dArray2[n2] + 1.0;
                            }
                            prevBegin = null;
                            break;
                        }
                        if (nestingLevel >= 0) break;
                        nestingLevel = 0;
                        prevBegin = null;
                        break;
                    }
                    case 14: {
                        prevIdleBegin = logdata;
                        break;
                    }
                    case 15: {
                        long executionTime;
                        if (prevIdleBegin == null) continue block12;
                        if (logdata.time >= this.startTime && logdata.time <= this.endTime) {
                            executionTime = logdata.time - prevIdleBegin.time;
                            double[] dArray = _sun_execution_time[0];
                            int n = numEPs - 1;
                            dArray[n] = dArray[n] + (double)executionTime;
                            if (_sun_execution_time[1][numEPs - 1] < (double)executionTime) {
                                _sun_execution_time[1][numEPs - 1] = executionTime;
                            }
                            if (_sun_execution_time[2][numEPs - 1] > (double)executionTime) {
                                _sun_execution_time[2][numEPs - 1] = executionTime;
                            }
                            double[] dArray3 = _sun_execution_time[3];
                            int n3 = numEPs - 1;
                            dArray3[n3] = dArray3[n3] + 1.0;
                            System.out.println("idle time is " + executionTime);
                        }
                        prevIdleBegin = null;
                        break;
                    }
                    case 1: {
                        if (logdata.time <= this.endTime) break;
                    }
                }
            }
        }
        catch (EndOfLogSuccess nestingLevel) {
        }
        catch (Exception e) {
            System.err.println("Exception " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        return _sun_execution_time;
    }
}

