/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.LogFileViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import projections.Tools.LogFileViewer.LogFileViewerTextArea;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;

public class LogFileViewerWindow
extends ProjectionsWindow
implements ActionListener {
    private static int myRun = 0;
    private JTabbedPane tabbedPane;
    private JButton bOpen;
    private SortedSet<Integer> validPEs;
    private long startTime;
    private long endTime;

    public LogFileViewerWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setTitle("Projections Log File Viewer - " + MainWindow.runObject[myRun].getFilename() + ".sts");
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        JLabel simpleLabel = new JLabel("<html><body><h1>Data is loading</h1></body></html>");
        this.tabbedPane.add("loading ...", simpleLabel);
        this.bOpen = new JButton("Load Different PE ...");
        this.bOpen.addActionListener(this);
        this.bOpen.setPreferredSize(new Dimension(200, 40));
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.bOpen, "South");
        this.pack();
        this.setVisible(true);
        this.showDialog();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bOpen) {
            this.showDialog();
        }
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range", null, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.validPEs = this.dialog.getSelectedProcessors();
            this.startTime = this.dialog.getStartTime();
            this.endTime = this.dialog.getEndTime();
            this.setCursor(new Cursor(3));
            this.tabbedPane.removeAll();
            for (Integer pe : this.validPEs) {
                LogFileViewerTextArea textArea = new LogFileViewerTextArea();
                textArea.setPE(pe, this.startTime, this.endTime);
                this.tabbedPane.add("PE " + pe, textArea);
            }
            this.pack();
            this.setCursor(new Cursor(0));
        }
    }
}

