/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Overview;

import java.util.TreeSet;
import projections.analysis.LogReader;
import projections.gui.MainWindow;

class ThreadedFileReader
implements Runnable {
    private int pe;
    private long intervalSize;
    private int myRun;
    private int startInterval;
    private int endInterval;
    private int[][][] mySystemUsageData;
    private int[][][][] myUserEntryData;
    private int[] entryData;
    private float[] utilizationData;
    private float[] idleData;

    protected ThreadedFileReader(int pe, long intervalSize, int myRun, int startInterval, int endInterval, int[] entryData, float[] utilizationData, float[] idleData) {
        this.pe = pe;
        this.intervalSize = intervalSize;
        this.myRun = myRun;
        this.startInterval = startInterval;
        this.endInterval = endInterval;
        this.entryData = entryData;
        this.utilizationData = utilizationData;
        this.idleData = idleData;
    }

    public void run() {
        this.LoadGraphDataForOnePe(this.intervalSize, this.startInterval, this.endInterval, true, this.pe);
    }

    private void LoadGraphDataForOnePe(long intervalSize, int intervalStart, int intervalEnd, boolean byEntryPoint, int pe) {
        int i;
        LogReader logReader = new LogReader();
        TreeSet<Integer> processorList = new TreeSet<Integer>();
        processorList.add(pe);
        if (MainWindow.runObject[this.myRun].hasLogFiles()) {
            logReader.read(intervalSize, intervalStart, intervalEnd, byEntryPoint, processorList, false, null);
            this.mySystemUsageData = logReader.getSystemUsageData();
            this.myUserEntryData = logReader.getUserEntries();
        } else {
            System.err.println("Error: No data Files found!!");
        }
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        int numIntervals = this.endInterval - this.startInterval;
        double[][] utilData = new double[numIntervals][numEPs + 2];
        for (int ep = 0; ep < numEPs; ++ep) {
            int[][] entryData = this.myUserEntryData[ep][2];
            for (int interval = 0; interval < numIntervals; ++interval) {
                double[] dArray = utilData[interval];
                int n = ep;
                dArray[n] = dArray[n] + (double)entryData[0][interval];
                double[] dArray2 = utilData[interval];
                int n2 = numEPs;
                dArray2[n2] = dArray2[n2] - (double)entryData[0][interval];
            }
        }
        int[][] sysIdleData = this.mySystemUsageData[2];
        for (int interval = 0; interval < numIntervals; ++interval) {
            if (sysIdleData[0] == null || sysIdleData[0].length <= interval) continue;
            double[] dArray = utilData[interval];
            int n = numEPs + 1;
            dArray[n] = dArray[n] + (double)sysIdleData[0][interval] * 0.01 * (double)intervalSize;
            double[] dArray3 = utilData[interval];
            int n3 = numEPs;
            dArray3[n3] = dArray3[n3] - (double)sysIdleData[0][interval] * 0.01 * (double)intervalSize;
            double[] dArray4 = utilData[interval];
            int n4 = numEPs;
            dArray4[n4] = dArray4[n4] + (double)intervalSize;
        }
        for (i = 0; i < numIntervals; ++i) {
            this.utilizationData[i] = (float)(1.0 - (utilData[i][numEPs] + utilData[i][numEPs + 1]) / (double)intervalSize);
            this.idleData[i] = (float)(utilData[i][numEPs + 1] / (double)intervalSize);
        }
        for (i = 0; i < numIntervals; ++i) {
            int maxEP = 0;
            double maxVal = utilData[i][0];
            for (int j = 0; j < numEPs + 2; ++j) {
                if (!(utilData[i][j] > maxVal)) continue;
                maxVal = utilData[i][j];
                maxEP = j;
            }
            this.entryData[i] = maxEP;
        }
        utilData = null;
        this.mySystemUsageData = null;
        this.myUserEntryData = null;
    }
}

