/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Streaming;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import projections.Tools.Streaming.ByteParser;
import projections.analysis.StsReader;
import projections.ccs.CcsProgress;
import projections.ccs.CcsThread;
import projections.misc.LogLoadException;

class MultiSeriesHandler {
    private CcsThread ccs;
    private String ccsHandler;
    private boolean saveRepliesToFile = false;
    private boolean loadRepliesFromFile = false;
    private FileOutputStream savedRepliesFileStream = null;
    private ObjectOutputStream savedRepliesObjectOutStream;
    private FileInputStream savedRepliesFileInputStream = null;
    private ObjectInputStream savedRepliesObjectInputStream;
    private String replySavedFilename = "savedCCSReplies";
    private StsReader sts;
    private XYSeries sizeDataSeries;
    private int numSizesSoFar = 0;
    private JFreeChart scrollingChart;
    private CategoryPlot scrollingPlot;
    private JFreeChart detailedChart;
    private CategoryPlot detailedPlot;
    private TreeMap<Integer, TreeMap<String, Double>> streamingData = new TreeMap();
    private ArrayList<String> categories = new ArrayList();
    private Vector<byte[]> detailedData = new Vector();
    private int updateCount = 0;
    private String chartTitle;
    private int nextXValue = 0;

    MultiSeriesHandler(String hostname, int port, String ccsHandler, String filename, boolean saveRepliesToFile, boolean loadRepliesFromFile) {
        System.out.println("StreamingDataHandler constructor");
        this.saveRepliesToFile = saveRepliesToFile;
        this.loadRepliesFromFile = loadRepliesFromFile;
        try {
            this.sts = new StsReader(filename);
        }
        catch (LogLoadException e) {
            System.out.println("Couldn't load sts file with name " + filename);
        }
        this.ccsHandler = ccsHandler;
        if (ccsHandler.equals("CkPerfSumDetail uchar")) {
            this.chartTitle = "Utilization Stacked by EP on Processor 0";
        } else if (ccsHandler.equals("CkPerfSumDetail compressed")) {
            this.chartTitle = "Utilization Stacked by EP";
        } else if (ccsHandler.equals("CkPerfSumDetail compressed PE0")) {
            this.chartTitle = "Utilization Stacked by EP on Processor 0";
        }
        this.createStackedUtilizationChart();
        this.createDetailedUtilizationChart();
        this.createMessageSizeChart();
        if (loadRepliesFromFile) {
            System.out.println("Using previously saved data instead of CCS connection\n");
            ReadDataFromFileDriver d = new ReadDataFromFileDriver();
            d.run();
        } else {
            System.out.println("Using CCS to connect\n");
            progressHandler h = new progressHandler();
            this.ccs = new CcsThread(h, hostname, port);
            this.ccs.addRequest(new dataRequest());
        }
    }

    private void createDetailedUtilizationChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.detailedChart = ChartFactory.createStackedAreaChart(this.chartTitle, "", "Percent Utilization", dataset, PlotOrientation.VERTICAL, true, true, false);
        this.detailedChart.setBackgroundPaint(Color.white);
        this.detailedPlot = (CategoryPlot)this.detailedChart.getPlot();
        CategoryAxis domainAxis = this.detailedPlot.getDomainAxis();
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        domainAxis.setAxisLineVisible(false);
        domainAxis.setTickLabelsVisible(false);
        ChartPanel chartpanel = new ChartPanel(this.detailedChart);
        JFrame window = new JFrame("Detailed Utilization Plot");
        window.setLayout(new BorderLayout());
        window.add((Component)chartpanel, "Center");
        window.pack();
        window.setLocation(720, 30);
        window.setVisible(true);
    }

    private void createStackedUtilizationChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.scrollingChart = ChartFactory.createStackedAreaChart(this.chartTitle, "", "Percent Utilization", dataset, PlotOrientation.VERTICAL, true, true, false);
        this.scrollingChart.setBackgroundPaint(Color.white);
        this.scrollingPlot = (CategoryPlot)this.scrollingChart.getPlot();
        CategoryAxis domainAxis = this.scrollingPlot.getDomainAxis();
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        domainAxis.setAxisLineVisible(false);
        domainAxis.setTickLabelsVisible(false);
        ChartPanel chartpanel = new ChartPanel(this.scrollingChart);
        JFrame window = new JFrame("Streaming Utilization Plot");
        window.setLayout(new BorderLayout());
        window.add((Component)chartpanel, "Center");
        window.pack();
        window.setLocation(20, 30);
        window.setVisible(true);
    }

    private void createMessageSizeChart() {
        this.sizeDataSeries = new XYSeries((Comparable)((Object)"CCS Reply Message Sizes"), true, false);
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        dataset.addSeries(this.sizeDataSeries);
        NumberAxis domainAxis = new NumberAxis("CCS Non-Empty Reply Message");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setAutoRange(true);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis("Size (Bytes)");
        rangeAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        XYPlot plot = new XYPlot(dataset, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart("CCS Reply Message Sizes", plot);
        ChartPanel chartpanel = new ChartPanel(chart);
        chart.setAntiAlias(true);
        chart.setBackgroundPaint(Color.white);
        chart.removeLegend();
        JFrame window = new JFrame("Message Sizes");
        window.setLayout(new BorderLayout());
        window.add((Component)chartpanel, "Center");
        window.pack();
        window.setLocation(20, 500);
        window.setVisible(true);
    }

    private void addDataPointToPlot(Double utilization, String epName, Integer nextXValue) {
        TreeMap<Object, Object> record;
        if (!this.categories.contains(epName)) {
            this.categories.add(epName);
        }
        if (this.streamingData.containsKey(nextXValue)) {
            record = this.streamingData.get(nextXValue);
            record.put(epName, utilization);
        } else {
            record = new TreeMap<String, Double>();
            record.put(epName, utilization);
            this.streamingData.put(nextXValue, record);
        }
        if (this.streamingData.size() > 100) {
            Integer firstKey = this.streamingData.firstKey();
            this.streamingData.remove(firstKey);
        }
    }

    private void updatePlots() {
        this.updateStreamingPlot();
        ++this.updateCount;
        if (this.updateCount % 20 == 0) {
            this.updateDetailedPlot();
        }
    }

    private void addKnownCategories(Integer xValue, DefaultCategoryDataset dataset) {
        dataset.addValue(0.0, (Comparable)((Object)"Other"), (Comparable)xValue);
        for (String c : this.categories) {
            if (c.equals("Other")) continue;
            dataset.addValue(0.0, (Comparable)((Object)c), (Comparable)xValue);
        }
    }

    private String getName(int ep, int numEPs) {
        String epName;
        if (ep >= 0 && ep < numEPs) {
            if (this.sts == null) {
                return "" + ep;
            }
            epName = this.sts.getEntryNameByID(ep);
            int p = epName.indexOf(40);
            if (p > 0) {
                epName = epName.substring(0, p);
            }
        } else {
            epName = "Other";
        }
        return epName;
    }

    private void updateDetailedPlot() {
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        if (this.detailedData.size() < 1) {
            return;
        }
        byte[] data = this.detailedData.lastElement();
        if (data.length <= 1) {
            return;
        }
        System.out.println("Creating detailed plot for data in " + data.length + " byte array");
        int pos = 0;
        int numBins = ByteParser.bytesToInt(data, pos);
        pos += 4;
        System.out.println("detailed plot Number of bins in message = " + numBins);
        if (numBins < 1) {
            return;
        }
        int numProcs = ByteParser.bytesToInt(data, pos);
        pos += 4;
        System.out.println("detailed plot Number of processors contributing data in message = " + numProcs);
        for (int b = 0; b < numBins && b < 250; ++b) {
            if (pos + 2 > data.length) {
                return;
            }
            if (b == 0) {
                this.addKnownCategories(new Integer(b), newDataset);
            }
            int numEntries = ByteParser.bytesToShort(data, pos);
            pos += 2;
            for (int e = 0; e < numEntries; ++e) {
                short ep = ByteParser.bytesToShort(data, pos);
                float u = ByteParser.bytesToUnsignedChar(data, pos += 2);
                ++pos;
                if (!((double)(u /= 2.5f) > 0.0)) continue;
                String epName = this.getName(ep, 1000);
                newDataset.addValue(u, (Comparable)((Object)epName), (Comparable)new Integer(b));
            }
        }
        this.detailedPlot.setDataset(newDataset);
    }

    private void updateStreamingPlot() {
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        Iterator<Integer> stepIter = this.streamingData.keySet().iterator();
        Integer xValue = new Integer(0);
        boolean firstTime = true;
        while (stepIter.hasNext()) {
            xValue = stepIter.next();
            if (firstTime) {
                this.addKnownCategories(xValue, newDataset);
            }
            TreeMap<String, Double> map = this.streamingData.get(xValue);
            for (String entryName : map.keySet()) {
                Double utilization = map.get(entryName);
                newDataset.addValue(utilization, (Comparable)((Object)entryName), (Comparable)xValue);
            }
        }
        this.scrollingPlot.setDataset(newDataset);
    }

    private void processIncomingData(byte[] data) {
        this.detailedData.add(data);
        if (data.length > 1 && this.ccsHandler.equals("CkPerfSumDetail compressed")) {
            System.out.println("\"CkPerfSumDetail compressed\" Received " + data.length + " byte data array");
            int numEPs = 1000;
            int pos = 0;
            double totalSum = 0.0;
            int numBins = ByteParser.bytesToInt(data, pos);
            pos += 4;
            System.out.println("Number of bins in message = " + numBins);
            if (numBins >= 1) {
                this.sizeDataSeries.add((double)this.numSizesSoFar++, data.length);
                int numProcs = ByteParser.bytesToInt(data, pos);
                pos += 4;
                System.out.println("Number of processors contributing data in message = " + numProcs);
                int numBinsPerPlotSample = 100;
                int binsRemaining = numBins;
                while (binsRemaining > 0) {
                    double[] sums = new double[1024];
                    double otherUtilization = 0.0;
                    for (int e = 0; e < numEPs; ++e) {
                        sums[e] = 0.0;
                    }
                    int samplesInThisBin = 0;
                    for (int b = 0; b < numBinsPerPlotSample; ++b) {
                        if (pos + 2 > data.length) continue;
                        int numEntries = ByteParser.bytesToShort(data, pos);
                        pos += 2;
                        for (int e = 0; e < numEntries; ++e) {
                            short ep = ByteParser.bytesToShort(data, pos);
                            float u = ByteParser.bytesToUnsignedChar(data, pos += 2);
                            ++pos;
                            totalSum += (double)(u /= 2.5f);
                            if (ep >= 0 && ep < sums.length) {
                                short s = ep;
                                sums[s] = sums[s] + (double)u;
                                continue;
                            }
                            otherUtilization += (double)u;
                        }
                        ++samplesInThisBin;
                        --binsRemaining;
                    }
                    boolean added = false;
                    for (int e = 0; e < numEPs; ++e) {
                        int p;
                        double utilization = sums[e] / (double)samplesInThisBin;
                        if (!(utilization > 0.0)) continue;
                        String epName = null;
                        if (this.sts != null && (p = (epName = this.sts.getEntryNameByID(e)).indexOf(40)) > 0) {
                            epName = epName.substring(0, p);
                        }
                        if (epName != null) {
                            this.addDataPointToPlot(utilization, epName, this.nextXValue);
                        } else {
                            this.addDataPointToPlot(utilization, "" + e, this.nextXValue);
                        }
                        added = true;
                    }
                    double utilization = otherUtilization / (double)samplesInThisBin;
                    if (utilization > 0.0) {
                        this.addDataPointToPlot(utilization, "Other", this.nextXValue);
                        added = true;
                    }
                    if (!added) continue;
                    ++this.nextXValue;
                    this.updatePlots();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class dataRequest
    extends CcsThread.request {
        public dataRequest() {
            super(MultiSeriesHandler.this.ccsHandler, 0);
        }

        public void handleReply(byte[] data) {
            System.out.println("handleReply(data.length=" + data.length + ")");
            if (MultiSeriesHandler.this.saveRepliesToFile) {
                if (MultiSeriesHandler.this.savedRepliesFileStream == null) {
                    try {
                        MultiSeriesHandler.this.savedRepliesFileStream = new FileOutputStream("savedCCSReplies");
                        MultiSeriesHandler.this.savedRepliesObjectOutStream = new ObjectOutputStream(MultiSeriesHandler.this.savedRepliesFileStream);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Error when trying to open output file to write CCS Replies into: " + e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        System.err.println("Error when trying to open output file to write CCS Replies into: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                try {
                    MultiSeriesHandler.this.savedRepliesObjectOutStream.writeObject(data);
                    MultiSeriesHandler.this.savedRepliesObjectOutStream.flush();
                }
                catch (IOException e) {
                    System.err.println("Error when trying to write a CCS Replies into the file: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                MultiSeriesHandler.this.processIncomingData(data);
            }
            MultiSeriesHandler.this.updatePlots();
            try {
                Thread.sleep(900L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            MultiSeriesHandler.this.ccs.addRequest(this, true);
        }
    }

    private class progressHandler
    implements CcsProgress {
        public void setText(String s) {
        }
    }

    private class ReadDataFromFileDriver
    implements Runnable {
        private ReadDataFromFileDriver() {
        }

        private void driver() {
            if (MultiSeriesHandler.this.loadRepliesFromFile) {
                try {
                    MultiSeriesHandler.this.savedRepliesFileInputStream = new FileInputStream(MultiSeriesHandler.this.replySavedFilename);
                    MultiSeriesHandler.this.savedRepliesObjectInputStream = new ObjectInputStream(MultiSeriesHandler.this.savedRepliesFileInputStream);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Error when trying to open input file to read CCS Replies: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (IOException e) {
                    System.err.println("Error when trying to open input file to read CCS Replies: " + e.getMessage());
                    e.printStackTrace();
                }
                boolean done = false;
                while (!done) {
                    try {
                        Object data = MultiSeriesHandler.this.savedRepliesObjectInputStream.readObject();
                        System.out.println("read an object from file: " + data);
                        if (data instanceof byte[]) {
                            MultiSeriesHandler.this.processIncomingData((byte[])data);
                            continue;
                        }
                        System.err.println("Read incorrect type of object from file");
                    }
                    catch (Exception e) {
                        done = true;
                    }
                }
            }
        }

        public void run() {
            this.driver();
        }
    }
}

