/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Streaming;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import projections.Tools.Streaming.ByteParser;
import projections.ccs.CcsProgress;
import projections.ccs.CcsThread;

class SingleSeriesHandler {
    private CcsThread ccs;
    private Vector<Float> averageTimes;
    private Vector<Float> allTimes;
    private XYPlot plot;
    private String server;
    private String ccsHandler;
    private static boolean REDO_DISPLAY_EACH_TIME = false;
    private XYSeries dataSeries;
    private DefaultTableXYDataset dataset;

    SingleSeriesHandler(String hostname, int port, String ccsHandler) {
        System.out.println("StreamingDataHandler constructor");
        this.averageTimes = new Vector();
        this.allTimes = new Vector();
        this.server = hostname;
        this.ccsHandler = ccsHandler;
        progressHandler h = new progressHandler();
        this.ccs = new CcsThread(h, this.server, port);
        this.createPlotInFrameJFreeChart();
        this.ccs.addRequest(new dataRequest());
    }

    private void updatePlot() {
        if (REDO_DISPLAY_EACH_TIME) {
            XYSeries newDataSeries = new XYSeries((Comparable)((Object)"Utilization For Each Sample"), true, false);
            int numInputPerDataPoint = 20;
            int numPoints = 500;
            int start = 0;
            int end = this.allTimes.size();
            if (this.allTimes.size() > numPoints * numInputPerDataPoint) {
                start = this.allTimes.size() - numPoints * numInputPerDataPoint;
            }
            int i = start;
            while (i + numInputPerDataPoint - 1 < end) {
                int count = 0;
                double sum = 0.0;
                for (int j = 0; j < numInputPerDataPoint; ++j) {
                    sum += (double)this.allTimes.elementAt(i + j).floatValue();
                    ++count;
                }
                newDataSeries.add((double)i, sum / (double)count);
                i += numInputPerDataPoint;
            }
            this.dataset.removeAllSeries();
            this.dataset.addSeries(newDataSeries);
            this.plot.setDataset(this.dataset);
        }
    }

    private void createPlotInFrameJFreeChart() {
        this.dataset = new DefaultTableXYDataset();
        if (!REDO_DISPLAY_EACH_TIME) {
            this.dataSeries = new XYSeries((Comparable)((Object)"Utilization For Each Sample"), true, false);
            this.dataSeries.setMaximumItemCount(500);
            this.dataset.addSeries(this.dataSeries);
        }
        NumberAxis domainAxis = new NumberAxis("Samples");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setAutoRange(true);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis("Utilization %");
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        this.plot = new XYPlot(this.dataset, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart("Utilization over time", this.plot);
        ChartPanel chartpanel = new ChartPanel(chart);
        JFrame window = new JFrame("Streaming Utilization Plot");
        window.setLayout(new BorderLayout());
        window.add((Component)chartpanel, "Center");
        window.pack();
        window.setVisible(true);
    }

    private class dataRequest
    extends CcsThread.request {
        public dataRequest() {
            super(SingleSeriesHandler.this.ccsHandler, 0);
        }

        public void handleReply(byte[] data) {
            float avg;
            int numData = 1;
            double sum = 0.0;
            System.out.println("SingleSeriesHandler Received " + data.length + " byte data array\n");
            int previousEntries = SingleSeriesHandler.this.allTimes.size();
            if (!SingleSeriesHandler.this.ccsHandler.equals("CkPerfSummaryCcsClientCB") && SingleSeriesHandler.this.ccsHandler.equals("CkPerfSummaryCcsClientCB uchar")) {
                numData = data.length / 1;
                for (int i = 0; i < numData; ++i) {
                    Float v = new Float(ByteParser.unsignedByteToInt(data[i]));
                    v = Float.valueOf(v.floatValue() / 2.0f);
                    sum += (double)v.floatValue();
                    if (!((double)v.floatValue() < 255.0)) continue;
                    SingleSeriesHandler.this.allTimes.add(v);
                }
            }
            if (!REDO_DISPLAY_EACH_TIME) {
                int numInputPerDataPoint = 100;
                if (SingleSeriesHandler.this.allTimes.size() - previousEntries > numInputPerDataPoint * 100) {
                    previousEntries = SingleSeriesHandler.this.allTimes.size() - numInputPerDataPoint * 100;
                }
                int i = previousEntries;
                while (i + numInputPerDataPoint - 1 < SingleSeriesHandler.this.allTimes.size()) {
                    double s = 0.0;
                    for (int j = 0; j < numInputPerDataPoint; ++j) {
                        s += (double)((Float)SingleSeriesHandler.this.allTimes.elementAt(j + i)).floatValue();
                    }
                    double avg2 = s / (double)numInputPerDataPoint;
                    SingleSeriesHandler.this.dataSeries.add((double)i, avg2);
                    i += numInputPerDataPoint;
                }
            }
            if ((double)(avg = (float)(sum / (double)numData)) >= 0.0) {
                SingleSeriesHandler.this.averageTimes.add(Float.valueOf(avg));
                System.out.println("Average of " + numData + " input values received from ccs is " + avg + ". " + SingleSeriesHandler.this.averageTimes.size() + " non-negative averages so far");
                SingleSeriesHandler.this.updatePlot();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            SingleSeriesHandler.this.ccs.addRequest(this);
        }
    }

    private class progressHandler
    implements CcsProgress {
        public void setText(String s) {
            System.out.println("CCS Message: " + s);
        }
    }
}

