/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TimeProfile;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Legend
implements MouseListener {
    private BufferedImage image;
    private Paint fgColor;
    private Paint bgColor;
    private static int myRun = 0;
    private Vector<String> names;
    private Font namesFont;
    private Font legendFont;

    Legend(String title, Vector<String> names, Vector<Paint> paints) {
        this.names = names;
        this.namesFont = new Font("SansSerif", 0, this.fontSizeNames());
        this.legendFont = new Font("SansSerif", 1, this.fontSizeLegend());
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g = this.image.createGraphics();
        this.bgColor = MainWindow.runObject[Legend.myRun].background;
        this.fgColor = MainWindow.runObject[Legend.myRun].foreground;
        g.setPaint(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setPaint(this.fgColor);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.setPaint(this.fgColor);
        g.setFont(this.legendFont);
        FontMetrics fm = g.getFontMetrics();
        int fw = fm.stringWidth(title);
        g.drawString(title, (this.getWidth() - fw) / 2, this.baselineLegend());
        g.setFont(this.namesFont);
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Paint paint = paints.get(i);
            int topPixel = this.topMargin() + i * this.lineSpacingNames();
            int textBaseline = topPixel + this.lineSpacingNames() / 2 + this.fontSizeNames() / 2;
            g.setPaint(paint);
            g.fillRect(this.getWidth() - this.rightMargin() - this.boxMarginR() - this.boxWidth(), topPixel + this.boxMarginsTB(), this.boxWidth(), this.lineSpacingNames() - this.boxMarginsTB() * 2);
            g.setPaint(this.fgColor);
            g.drawString(name, this.leftMargin(), textBaseline);
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        JFrame f = new JFrame();
        JLabel l = new JLabel(imageIcon);
        l.addMouseListener(this);
        f.getContentPane().add(l);
        f.pack();
        f.setVisible(true);
        g.dispose();
    }

    private int fontSizeLegend() {
        return 30;
    }

    private int baselineLegend() {
        return (this.topMargin() + this.fontSizeLegend()) / 2;
    }

    private int topMargin() {
        return (int)(1.5 * (double)this.fontSizeLegend());
    }

    private int fontSizeNames() {
        return 14;
    }

    private int leftMargin() {
        return 5;
    }

    private int rightMargin() {
        return 5;
    }

    private int boxMarginsTB() {
        return 3;
    }

    private int boxMarginL() {
        return 15;
    }

    private int boxMarginR() {
        return 5;
    }

    private int boxWidth() {
        return 25;
    }

    private int lineSpacingNames() {
        return this.fontSizeNames() + 10;
    }

    private int getWidth() {
        BufferedImage img = new BufferedImage(100, 100, 1);
        Graphics2D g = img.createGraphics();
        g.setFont(this.namesFont);
        FontMetrics fm = g.getFontMetrics();
        int maxw = 0;
        for (int i = 0; i < this.names.size(); ++i) {
            int w = fm.stringWidth(this.names.get(i));
            if (w <= maxw) continue;
            maxw = w;
        }
        return this.leftMargin() + maxw + this.boxMarginL() + this.boxWidth() + this.boxMarginR() + this.rightMargin();
    }

    private int getHeight() {
        return this.topMargin() + this.lineSpacingNames() * this.names.size();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JPanelToImage.saveToFileChooserSelection(this.image, "Save Legend To PNG or JPG", "TimeProfileLegend.png");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

