/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TimeProfile;

import java.util.TreeMap;
import java.util.TreeSet;
import projections.analysis.LogReader;
import projections.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadedFileReader
implements Runnable {
    private int pe;
    private long intervalSize;
    private int myRun;
    private int startInterval;
    private int endInterval;
    private int[][][] mySystemUsageData;
    private int[][][][] myUserEntryData;
    private double[][] graphData;
    private TreeMap<Double, String> phaseMarkers;

    protected ThreadedFileReader(int pe, long intervalSize, int myRun, int startInterval, int endInterval, TreeMap<Double, String> phaseMarkers, double[][] graphData) {
        this.phaseMarkers = phaseMarkers;
        this.pe = pe;
        this.intervalSize = intervalSize;
        this.myRun = myRun;
        this.startInterval = startInterval;
        this.endInterval = endInterval;
        this.graphData = graphData;
    }

    @Override
    public void run() {
        this.LoadGraphDataForOnePe(this.intervalSize, this.startInterval, this.endInterval, true, this.pe);
    }

    private void LoadGraphDataForOnePe(long intervalSize, int intervalStart, int intervalEnd, boolean byEntryPoint, int pe) {
        LogReader logReader = new LogReader();
        TreeSet<Integer> processorList = new TreeSet<Integer>();
        processorList.add(pe);
        if (MainWindow.runObject[this.myRun].hasLogFiles()) {
            logReader.read(intervalSize, intervalStart, intervalEnd, byEntryPoint, processorList, false, this.phaseMarkers);
            this.mySystemUsageData = logReader.getSystemUsageData();
            this.myUserEntryData = logReader.getUserEntries();
        } else {
            System.err.println("Error: No log data files found!");
        }
        this.accumulateIntoShared();
        this.mySystemUsageData = null;
        this.myUserEntryData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateIntoShared() {
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        int numIntervals = this.endInterval - this.startInterval + 1;
        double[][] dArray = this.graphData;
        synchronized (this.graphData) {
            for (int ep = 0; ep < numEPs; ++ep) {
                int[][] entryData = this.myUserEntryData[ep][2];
                for (int interval = 0; interval < numIntervals; ++interval) {
                    double[] dArray2 = this.graphData[interval];
                    int n = ep;
                    dArray2[n] = dArray2[n] + (double)entryData[0][interval];
                    double[] dArray3 = this.graphData[interval];
                    int n2 = numEPs;
                    dArray3[n2] = dArray3[n2] - (double)entryData[0][interval];
                }
            }
            int[][] idleData = this.mySystemUsageData[2];
            for (int interval = 0; interval < numIntervals; ++interval) {
                if (idleData[0] == null || idleData[0].length <= interval) continue;
                double[] dArray4 = this.graphData[interval];
                int n = numEPs + 1;
                dArray4[n] = dArray4[n] + (double)idleData[0][interval] * 0.01 * (double)this.intervalSize;
                double[] dArray5 = this.graphData[interval];
                int n3 = numEPs;
                dArray5[n3] = dArray5[n3] - (double)idleData[0][interval] * 0.01 * (double)this.intervalSize;
                double[] dArray6 = this.graphData[interval];
                int n4 = numEPs;
                dArray6[n4] = dArray6[n4] + (double)this.intervalSize;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

