/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TimeProfile;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import projections.Tools.TimeProfile.Legend;
import projections.Tools.TimeProfile.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.AmpiTimeProfileWindow;
import projections.gui.Clickable;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalChooserPanel;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class TimeProfileWindow
extends GenericGraphWindow
implements ActionListener,
Clickable {
    private TimeProfileWindow thisWindow;
    private MainWindow mainWindow;
    private static int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton setRanges;
    private IntervalChooserPanel intervalPanel;
    private JMenuItem mDisplayLegend;
    private JMenuItem mDisplayLegendFull;
    private JCheckBox showMarkersCheckBox;
    private JCheckBox analyzeSlopesCheckBox;
    private JCheckBox hideMouseoversCheckBox;
    private long intervalSize;
    private int startInterval;
    private int endInterval;
    private long startTime;
    private boolean displaySlopes = false;
    private TreeMap<Double, String> phaseMarkers = new TreeMap();
    private SortedSet<Integer> processorList;
    private int numEPs;
    private boolean[] stateArray;
    private boolean[] existsArray;
    private String[] entryNames;
    private double[][] graphData;
    private double[][] outputData;
    private boolean startFlag;
    private JTabbedPane tabPane = null;
    private AmpiTimeProfileWindow ampiGraphPanel = null;
    private JPanel epPanel = null;
    private boolean ampiTraceOn = false;
    private static final int special = 2;

    public TimeProfileWindow(MainWindow mainWindow) {
        super("Projections Time Profile Graph - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.mainWindow = mainWindow;
        this.numEPs = MainWindow.runObject[myRun].getNumUserEntries();
        this.stateArray = new boolean[this.numEPs + 2];
        this.existsArray = new boolean[this.numEPs + 2];
        this.entryNames = new String[this.numEPs + 2];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.entryNames[ep] = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
        }
        this.entryNames[this.numEPs] = "Overhead";
        this.entryNames[this.numEPs + 1] = "Idle";
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        if (MainWindow.runObject[myRun].getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        if (this.ampiTraceOn) {
            this.tabPane = new JTabbedPane();
            this.ampiGraphPanel = new AmpiTimeProfileWindow(mainWindow);
        }
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.thisWindow.setLocationRelativeTo(null);
        this.showDialog();
    }

    protected void createMenus() {
        super.createMenus();
        JMenu legendMenu = new JMenu("Legend");
        this.mDisplayLegend = new JMenuItem("Display Legend");
        this.mDisplayLegend.addActionListener(this);
        legendMenu.add(this.mDisplayLegend);
        this.mDisplayLegendFull = new JMenuItem("Display Legend with Full EP Names");
        this.mDisplayLegendFull.addActionListener(this);
        legendMenu.add(this.mDisplayLegendFull);
        this.menuBar.add(legendMenu);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.showMarkersCheckBox = new JCheckBox("Show Iteration/Phase Markers");
        this.showMarkersCheckBox.setSelected(false);
        this.showMarkersCheckBox.setToolTipText("Draw vertical lines at time associated with any user supplied notes containing\"***\"?");
        this.showMarkersCheckBox.addActionListener(this);
        this.analyzeSlopesCheckBox = new JCheckBox("Analyze slope");
        this.analyzeSlopesCheckBox.setToolTipText("Select a point on the graph to measure the slope");
        this.analyzeSlopesCheckBox.addActionListener(this);
        this.hideMouseoversCheckBox = new JCheckBox("Hide Mouseovers");
        this.hideMouseoversCheckBox.setSelected(false);
        this.hideMouseoversCheckBox.setToolTipText("Disable the displaying of information associated with the data under the mouse pointer.");
        this.hideMouseoversCheckBox.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.showMarkersCheckBox, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.analyzeSlopesCheckBox, gbc, 4, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.hideMouseoversCheckBox, gbc, 5, 0, 1, 1, 0, 0);
        if (this.ampiTraceOn) {
            this.epPanel = new JPanel();
            this.epPanel.setLayout(gbl);
            JPanel graphPanel = this.getMainPanel();
            Util.gblAdd(this.epPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.epPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
            JPanel ampiPanel = this.ampiGraphPanel.getAmpiMainPanel();
            this.tabPane.add("Entry Points", this.epPanel);
            this.tabPane.add("AMPI Functions", ampiPanel);
            this.mainPanel.setLayout(new GridLayout(1, 1));
            this.mainPanel.add(this.tabPane);
        } else {
            JPanel graphPanel = this.getMainPanel();
            Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
        }
    }

    public void setGraphSpecificData() {
    }

    private void generateLegend(boolean useShortenedNames) {
        Vector<SortableEPs> l = new Vector<SortableEPs>();
        double[] sums = new double[this.numEPs + 2];
        double grandTotal = 0.0;
        for (int i = 0; i < this.graphData.length; ++i) {
            for (int ep = 0; ep < this.graphData[i].length; ++ep) {
                int n = ep;
                sums[n] = sums[n] + this.graphData[i][ep];
                grandTotal += this.graphData[i][ep];
            }
        }
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (useShortenedNames) {
                l.add(new SortableEPs(sums[ep], MainWindow.runObject[myRun].getPrettyEntryNameByIndex(ep), MainWindow.runObject[myRun].getEPColorMap()[ep]));
                continue;
            }
            l.add(new SortableEPs(sums[ep], MainWindow.runObject[myRun].getEntryNameByIndex(ep), MainWindow.runObject[myRun].getEPColorMap()[ep]));
        }
        l.add(new SortableEPs(sums[this.numEPs], "Overhead", MainWindow.runObject[myRun].getOverheadColor()));
        l.add(new SortableEPs(sums[this.numEPs + 1], "Idle", MainWindow.runObject[myRun].getIdleColor()));
        Collections.sort(l);
        Vector<String> names = new Vector<String>();
        Vector<Paint> paints = new Vector<Paint>();
        for (SortableEPs s : l) {
            if (!(s.value > grandTotal * 0.005)) continue;
            names.add(s.name);
            paints.add(s.paint);
        }
        new Legend("Legend", names, paints);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.intervalPanel = new IntervalChooserPanel();
            this.dialog = MainWindow.runObject[myRun].hasLogFiles() ? new RangeDialog(this, "Select Range", this.intervalPanel, false) : new RangeDialog(this, "Select Range", this.intervalPanel, true);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.startInterval = (int)this.intervalPanel.getStartInterval();
            this.endInterval = (int)this.intervalPanel.getEndInterval();
            this.processorList = this.dialog.getSelectedProcessors();
            this.startTime = this.dialog.getStartTime();
            if (MainWindow.runObject[myRun].hasLogFiles()) {
                this.intervalSize = this.intervalPanel.getIntervalSize();
            } else {
                this.startInterval = 0;
                this.endInterval = (int)MainWindow.runObject[myRun].getSumDetailNumIntervals() - 1;
                this.intervalSize = (long)MainWindow.runObject[myRun].getSumDetailIntervalSize();
            }
            System.out.println("Props: intervalSize:" + this.intervalSize + "- startInterval:" + this.startInterval + "- endInterval:" + this.endInterval + "- startTime:" + this.startTime);
            if (this.ampiTraceOn) {
                this.ampiGraphPanel.getRangeVals(this.startInterval, this.endInterval, this.intervalSize, this.processorList);
            }
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    TimeProfileWindow.this.phaseMarkers.clear();
                    int numIntervals = TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1;
                    TimeProfileWindow.access$702(TimeProfileWindow.this, new double[numIntervals][TimeProfileWindow.this.numEPs + 2]);
                    int numProcessors = TimeProfileWindow.this.processorList.size();
                    int numUserEntries = MainWindow.runObject[myRun].getNumUserEntries();
                    if (MainWindow.runObject[myRun].hasLogFiles()) {
                        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
                        int numResultAccumulators = 8;
                        double[][][] graphDataAccumulators = new double[numResultAccumulators][numIntervals][TimeProfileWindow.this.numEPs + 2];
                        int pIdx = 0;
                        for (Integer pe : TimeProfileWindow.this.processorList) {
                            readyReaders.add(new ThreadedFileReader(pe, TimeProfileWindow.this.intervalSize, myRun, TimeProfileWindow.this.startInterval, TimeProfileWindow.this.endInterval, TimeProfileWindow.this.phaseMarkers, graphDataAccumulators[pIdx % numResultAccumulators]));
                            ++pIdx;
                        }
                        Component guiRootForProgressBar = null;
                        if (TimeProfileWindow.this.thisWindow != null && TimeProfileWindow.this.thisWindow.isVisible()) {
                            guiRootForProgressBar = TimeProfileWindow.this.thisWindow;
                        } else if (TimeProfileWindow.this.mainWindow != null && TimeProfileWindow.this.mainWindow.isVisible()) {
                            guiRootForProgressBar = TimeProfileWindow.this.mainWindow;
                        } else if (MainWindow.runObject[myRun].guiRoot != null && MainWindow.runObject[myRun].guiRoot.isVisible()) {
                            guiRootForProgressBar = MainWindow.runObject[myRun].guiRoot;
                        }
                        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Time Profile in Parallel", readyReaders, guiRootForProgressBar, true);
                        threadManager.runAll();
                        for (int a = 0; a < numResultAccumulators; ++a) {
                            for (int i = 0; i < numIntervals; ++i) {
                                for (int j = 0; j < TimeProfileWindow.this.numEPs + 2; ++j) {
                                    double[] dArray = TimeProfileWindow.this.graphData[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + graphDataAccumulators[a][i][j];
                                }
                            }
                        }
                    } else if (MainWindow.runObject[myRun].hasSumDetailFiles()) {
                        SortedSet<Integer> availablePEs = MainWindow.runObject[myRun].getValidProcessorList(2);
                        MainWindow.runObject[myRun].LoadGraphData(TimeProfileWindow.this.intervalSize, 0, numIntervals - 1, false, availablePEs);
                        int[][] sumDetailData = MainWindow.runObject[myRun].getSumDetailData();
                        for (int i = 0; i < numIntervals; ++i) {
                            for (int j = 0; j < TimeProfileWindow.this.numEPs; ++j) {
                                double[] dArray = TimeProfileWindow.this.graphData[i];
                                int n = j;
                                dArray[n] = dArray[n] + (double)sumDetailData[i][j];
                            }
                        }
                        int[][] idleTemp = MainWindow.runObject[myRun].sumAnalyzer.getSystemUsageData(TimeProfileWindow.this.startInterval, TimeProfileWindow.this.endInterval, TimeProfileWindow.this.intervalSize);
                        Component guiRootForProgressBar = null;
                        if (TimeProfileWindow.this.thisWindow != null && TimeProfileWindow.this.thisWindow.isVisible()) {
                            guiRootForProgressBar = TimeProfileWindow.this.thisWindow;
                        } else if (TimeProfileWindow.this.mainWindow != null && TimeProfileWindow.this.mainWindow.isVisible()) {
                            guiRootForProgressBar = TimeProfileWindow.this.mainWindow;
                        } else if (MainWindow.runObject[myRun].guiRoot != null && MainWindow.runObject[myRun].guiRoot.isVisible()) {
                            guiRootForProgressBar = MainWindow.runObject[myRun].guiRoot;
                        }
                    } else if (MainWindow.runObject[myRun].hasSumFiles()) {
                        int[][][] systemUsageData = new int[3][][];
                        systemUsageData[2] = new int[numProcessors][];
                        int[][][][] userEntryData = new int[numUserEntries][][][];
                        for (int n = 0; n < numUserEntries; ++n) {
                            userEntryData[n] = new int[3][][];
                            userEntryData[n][2] = new int[numProcessors][];
                        }
                        int[][] temp = MainWindow.runObject[myRun].sumAnalyzer.getSystemUsageData(TimeProfileWindow.this.startInterval, TimeProfileWindow.this.endInterval, TimeProfileWindow.this.intervalSize);
                        systemUsageData[1] = new int[TimeProfileWindow.this.processorList.size()][TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1];
                        int pIdx = 0;
                        for (Integer pe : TimeProfileWindow.this.processorList) {
                            systemUsageData[1][pIdx] = temp[pe];
                            ++pIdx;
                        }
                        for (int peIdx = 0; peIdx < numProcessors; ++peIdx) {
                            for (int ep = 0; ep < TimeProfileWindow.this.numEPs; ++ep) {
                                int[][] entryData = userEntryData[ep][2];
                                for (int interval = 0; interval < numIntervals; ++interval) {
                                    double[] dArray = TimeProfileWindow.this.graphData[interval];
                                    int n = ep;
                                    dArray[n] = dArray[n] + (double)entryData[peIdx][interval];
                                    double[] dArray2 = TimeProfileWindow.this.graphData[interval];
                                    int n2 = TimeProfileWindow.this.numEPs;
                                    dArray2[n2] = dArray2[n2] - (double)entryData[peIdx][interval];
                                }
                            }
                            int[][] idleData = systemUsageData[2];
                            for (int interval = 0; interval < numIntervals; ++interval) {
                                if (idleData[peIdx] == null || idleData[peIdx].length <= interval) continue;
                                double[] dArray = TimeProfileWindow.this.graphData[interval];
                                int n = TimeProfileWindow.this.numEPs + 1;
                                dArray[n] = dArray[n] + (double)idleData[peIdx][interval] * 0.01 * (double)TimeProfileWindow.this.intervalSize;
                                double[] dArray3 = TimeProfileWindow.this.graphData[interval];
                                int n3 = TimeProfileWindow.this.numEPs;
                                dArray3[n3] = dArray3[n3] - (double)idleData[peIdx][interval] * 0.01 * (double)TimeProfileWindow.this.intervalSize;
                                double[] dArray4 = TimeProfileWindow.this.graphData[interval];
                                int n4 = TimeProfileWindow.this.numEPs;
                                dArray4[n4] = dArray4[n4] + (double)TimeProfileWindow.this.intervalSize;
                            }
                        }
                    }
                    for (int interval = 0; interval < TimeProfileWindow.this.graphData.length; ++interval) {
                        for (int e = 0; e < TimeProfileWindow.this.graphData[interval].length; ++e) {
                            ((TimeProfileWindow)TimeProfileWindow.this).graphData[interval][e] = TimeProfileWindow.this.graphData[interval][e] * 100.0 / ((double)TimeProfileWindow.this.intervalSize * (double)numProcessors);
                        }
                    }
                    if (MainWindow.runObject[myRun].hasSumDetailFiles()) {
                        int i;
                        int[] idlePercentage = MainWindow.runObject[myRun].sumAnalyzer.getTotalIdlePercentage();
                        for (i = 0; i < numIntervals; ++i) {
                            ((TimeProfileWindow)TimeProfileWindow.this).graphData[i][((TimeProfileWindow)TimeProfileWindow.this).numEPs + 1] = idlePercentage[i];
                        }
                        for (i = 0; i < numIntervals; ++i) {
                            ((TimeProfileWindow)TimeProfileWindow.this).graphData[i][((TimeProfileWindow)TimeProfileWindow.this).numEPs] = 100.0;
                            for (int j = 0; j < TimeProfileWindow.this.numEPs; ++j) {
                                double[] dArray = TimeProfileWindow.this.graphData[i];
                                int n = TimeProfileWindow.this.numEPs;
                                dArray[n] = dArray[n] - TimeProfileWindow.this.graphData[i][j];
                            }
                            double[] dArray = TimeProfileWindow.this.graphData[i];
                            int n = TimeProfileWindow.this.numEPs;
                            dArray[n] = dArray[n] - TimeProfileWindow.this.graphData[i][TimeProfileWindow.this.numEPs + 1];
                        }
                    }
                    for (int interval = 0; interval < TimeProfileWindow.this.graphData.length; ++interval) {
                        int e;
                        boolean valid = true;
                        double sumForInterval = 0.0;
                        for (e = 0; e < TimeProfileWindow.this.graphData[interval].length; ++e) {
                            sumForInterval += TimeProfileWindow.this.graphData[interval][e];
                            if (!(TimeProfileWindow.this.graphData[interval][e] < 0.0)) continue;
                            valid = false;
                        }
                        if (sumForInterval > 105.0) {
                            valid = false;
                        }
                        if (valid) continue;
                        System.err.println("Time Profile found bad data for interval " + interval + ". The data for bad intervals will be zero-ed out. This problem is either a log file corruption issue, or a bug in Projections.");
                        for (e = 0; e < TimeProfileWindow.this.graphData[interval].length; ++e) {
                            ((TimeProfileWindow)TimeProfileWindow.this).graphData[interval][e] = 0.0;
                        }
                    }
                    if (TimeProfileWindow.this.startFlag) {
                        block20: for (int ep = 0; ep < TimeProfileWindow.this.numEPs + 2; ++ep) {
                            for (int interval = 0; interval < TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1; ++interval) {
                                if (!(TimeProfileWindow.this.graphData[interval][ep] > 0.0)) continue;
                                ((TimeProfileWindow)TimeProfileWindow.this).existsArray[ep] = true;
                                ((TimeProfileWindow)TimeProfileWindow.this).stateArray[ep] = true;
                                continue block20;
                            }
                        }
                    }
                    if (TimeProfileWindow.this.startFlag) {
                        TimeProfileWindow.this.startFlag = false;
                    }
                    return null;
                }

                public void done() {
                    TimeProfileWindow.this.setOutputGraphData();
                    if (TimeProfileWindow.this.ampiTraceOn) {
                        TimeProfileWindow.this.ampiGraphPanel.setOutputGraphData(true);
                    }
                    TimeProfileWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.execute();
        }
    }

    private void setOutputGraphData() {
        int outSize = 0;
        for (int ep = 0; ep < this.numEPs + 2; ++ep) {
            if (!this.stateArray[ep]) continue;
            ++outSize;
        }
        if (outSize > 0) {
            int numIntervals = this.endInterval - this.startInterval + 1;
            this.outputData = new double[numIntervals][outSize];
            for (int i = 0; i < numIntervals; ++i) {
                int count = 0;
                for (int ep = 0; ep < this.numEPs + 2; ++ep) {
                    if (!this.stateArray[ep]) continue;
                    this.outputData[i][count] = this.graphData[i][ep];
                }
            }
            this.setYAxis("Percentage Utilization", "%");
            String xAxisLabel = "Time (" + U.humanReadableString(this.intervalSize) + " resolution)";
            this.setXAxis(xAxisLabel, "Time", this.startTime, this.intervalSize);
            this.setDataSource("Time Profile", this.outputData, new TimeProfileColorer(outSize, numIntervals), this.thisWindow);
            this.graphCanvas.setMarkers(this.phaseMarkers);
            this.refreshGraph();
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        int count = 0;
        String epName = "";
        String epClassName = "";
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[ep] || count++ != yVal) continue;
            epName = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
            epClassName = MainWindow.runObject[myRun].getEntryChareNameByIndex(ep);
            break;
        }
        String[] rString = new String[]{"Time Interval: " + U.humanReadableString((long)(xVal + this.startInterval) * this.intervalSize) + " to " + U.humanReadableString((long)(xVal + this.startInterval + 1) * this.intervalSize), "Chare Name: " + epClassName, "Entry Method: " + epName, "Execution Time = " + U.humanReadableString((long)this.outputData[xVal][yVal])};
        if (yVal == this.outputData[xVal].length - 2) {
            rString[1] = "";
            rString[2] = "Overhead";
            rString[3] = "Time = " + U.humanReadableString((long)this.outputData[xVal][yVal]);
        } else if (yVal == this.outputData[xVal].length - 1) {
            rString[1] = "";
            rString[2] = "Idle time";
            rString[3] = "Time = " + U.humanReadableString((long)this.outputData[xVal][yVal]);
        }
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.analyzeSlopesCheckBox) {
            if (this.analyzeSlopesCheckBox.isSelected()) {
                this.displaySlopes = true;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this.displaySlopes = false;
                this.graphCanvas.setCursor(Cursor.getPredefinedCursor(0));
                this.graphCanvas.clearPolynomial();
            }
        } else if (e.getSource() == this.showMarkersCheckBox) {
            this.graphCanvas.showMarkers(this.showMarkersCheckBox.isSelected());
        } else if (e.getSource() == this.hideMouseoversCheckBox) {
            this.graphCanvas.showBubble(!this.hideMouseoversCheckBox.isSelected());
        } else if (e.getSource() == this.setRanges) {
            this.showDialog();
        } else if (e.getSource() == this.mDisplayLegend) {
            this.generateLegend(true);
        } else if (e.getSource() == this.mDisplayLegendFull) {
            this.generateLegend(false);
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Set Range")) {
                this.showDialog();
            }
        }
    }

    private void createPolynomial(int xVal, int yVal) {
        int numIntervals = this.endInterval - this.startInterval + 1;
        if (xVal < 2 || yVal < 0 || xVal >= numIntervals - 2) {
            return;
        }
        double[] nonIdle = new double[numIntervals];
        for (int i = 0; i < numIntervals; ++i) {
            nonIdle[i] = 0.0;
            for (int ep = 0; ep < this.numEPs + 1; ++ep) {
                int n = i;
                nonIdle[n] = nonIdle[n] + this.graphData[i][ep];
            }
        }
        double total = 0.0;
        for (int ep = 0; ep < this.graphData[xVal].length; ++ep) {
            total += this.graphData[xVal][ep];
        }
        double y = nonIdle[xVal];
        double slopeA = (nonIdle[xVal + 1] - nonIdle[xVal - 1]) / 2.0;
        double slopeB = (nonIdle[xVal + 2] - nonIdle[xVal - 2]) / 4.0;
        double slopeC = (slopeA + slopeB) / 2.0;
        double[] coefficients = new double[]{-1.0 * slopeC * (double)xVal + y, slopeC};
        this.graphCanvas.addPolynomial(coefficients);
    }

    public void toolMouseMovedResponse(MouseEvent e, int xVal, int yVal) {
        if (this.displaySlopes) {
            this.createPolynomial(xVal, yVal);
        }
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (this.displaySlopes) {
            JPanelToImage.saveToFileChooserSelection(this.graphCanvas, "Save Screenshot Image", "./TimeProfileScreenshot.png");
        }
    }

    static /* synthetic */ double[][] access$702(TimeProfileWindow x0, double[][] x1) {
        x0.graphData = x1;
        return x1;
    }

    public class TimeProfileColorer
    implements GenericGraphColorer {
        int myRun = 0;
        int outSize;
        int numIntervals;

        TimeProfileColorer(int outSize, int numIntervals) {
            this.outSize = outSize;
            this.numIntervals = numIntervals;
        }

        public Paint[] getColorMap() {
            Paint[] outColors = new Paint[this.outSize];
            for (int i = 0; i < this.numIntervals; ++i) {
                int count = 0;
                for (int ep = 0; ep < TimeProfileWindow.this.numEPs + 2; ++ep) {
                    if (!TimeProfileWindow.this.stateArray[ep]) continue;
                    ((TimeProfileWindow)TimeProfileWindow.this).outputData[i][count] = TimeProfileWindow.this.graphData[i][ep];
                    outColors[count++] = ep == TimeProfileWindow.this.numEPs ? MainWindow.runObject[this.myRun].getOverheadColor() : (ep == TimeProfileWindow.this.numEPs + 1 ? MainWindow.runObject[this.myRun].getIdleColor() : MainWindow.runObject[this.myRun].getEPColorMap()[ep]);
                }
            }
            return outColors;
        }
    }

    private static class SortableEPs
    implements Comparable {
        private double value;
        private String name;
        private Paint paint;

        private SortableEPs(double value, String name, Paint paint) {
            this.value = value;
            this.name = name;
            this.paint = paint;
        }

        public int compareTo(Object o) {
            SortableEPs other = (SortableEPs)o;
            if (other.value < this.value) {
                return -1;
            }
            if (other.value > this.value) {
                return 1;
            }
            return other.name.compareTo(this.name);
        }
    }
}

