/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MemoryColorRangeChooser;
import projections.Tools.Timeline.MemoryLegend;
import projections.Tools.Timeline.MessageStructures;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.RangeQueries.RangeQueryTree;
import projections.Tools.Timeline.TimelineMessage;
import projections.Tools.Timeline.TimelineRunnableFileReader;
import projections.Tools.Timeline.UserEventObject;
import projections.analysis.Analysis;
import projections.analysis.PackTime;
import projections.analysis.StsReader;
import projections.analysis.TachyonShifts;
import projections.analysis.TimedProgressThreadExecutor;
import projections.analysis.TimelineEvent;
import projections.gui.ColorManager;
import projections.gui.ColorUpdateNotifier;
import projections.gui.EntryMethodVisibility;
import projections.gui.MainWindow;
import projections.gui.OrderedUsageList;
import projections.misc.LogLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data
implements ColorUpdateNotifier,
EntryMethodVisibility {
    int myRun = 0;
    private MainHandler modificationHandler = null;
    private float scaleFactor = 1.0f;
    private double preferredViewTime = -1.0;
    private int mostRecentScaledScreenWidth;
    public LinkedList<Integer> peToLine;
    private boolean colorByObjectId;
    private boolean colorByMemoryUsage;
    private boolean colorByUserSupplied;
    private boolean colorByEntryId;
    private boolean colorByEntryIdFreq;
    private int[] entries;
    private Set<Integer> hiddenEntryPoints;
    private Set<Integer> hiddenUserEvents;
    protected Map<Integer, Query1D<EntryMethodObject>> allEntryMethodObjects = Collections.synchronizedMap(new TreeMap());
    protected Map<Integer, Query1D<UserEventObject>> allUserEventObjects = Collections.synchronizedMap(new TreeMap());
    protected TreeMap<Integer, LinkedList<Integer>> frequencyTreeMap = new TreeMap();
    protected ArrayList<Integer> frequencyVector = new ArrayList();
    float[] processorUsage;
    float[] idleUsage;
    private float[] packUsage;
    private OrderedUsageList[] entryUsageList;
    private long startTime;
    private long endTime;
    private long oldBT;
    private long oldET;
    private long minMem;
    private long maxMem;
    private long minMemColorRange;
    private long maxMemColorRange;
    MessageStructures messageStructures;
    private boolean showPacks;
    private boolean showIdle;
    private boolean showMsgs;
    private boolean showUserEvents;
    private boolean skipIdleRegions;
    private boolean skipLoadingMessages;
    private boolean skipLoadingUserEvents;
    private long minEntryDuration;
    private boolean displayTopTimes;
    private int amountTopTimes;
    private String topTimesText;
    protected Font labelFont;
    protected Font axisFont;
    protected Set<EntryMethodObject> drawMessagesForTheseObjects;
    protected Set<EntryMethodObject> drawMessagesForTheseObjectsAlt;
    protected SMPMsgGroup toPaintSMPMsgGrp;
    private boolean useCustomColors = false;
    private Color customForeground;
    private Color customBackground;
    private int numUserEventRows = 1;
    private boolean drawNestedUserEventRows = false;
    protected long minUserSupplied = 0L;
    protected long maxUserSupplied = 0L;
    Object memUsageLock = new Object();
    private float scaleChangeFactor = (float)Math.pow(2.0, 0.5);
    private int selection1 = -1;
    private int selection2 = -1;
    private int highlight = -1;
    private boolean keepViewCentered = false;
    private Set<Object> highlightedObjects;
    private boolean traceMessagesBackOnHover;
    private boolean traceCriticalPathOnHover;
    private boolean traceMessagesForwardOnHover;
    private boolean traceOIDOnHover;
    private boolean traceMessagesForwardOnClick;
    private boolean traceCriticalPathOnClick;
    private ViewType viewType;
    ColorScheme colorSchemeForUserSupplied;

    public Data(MainHandler rh) {
        this.modificationHandler = rh;
        this.showPacks = false;
        this.showMsgs = true;
        this.showIdle = true;
        this.showUserEvents = true;
        this.peToLine = new LinkedList();
        this.messageStructures = new MessageStructures(this);
        this.hiddenEntryPoints = new TreeSet<Integer>();
        this.hiddenUserEvents = new TreeSet<Integer>();
        this.viewType = ViewType.VIEW_NORMAL;
        this.oldBT = -1L;
        this.oldET = -1L;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.minMem = Integer.MAX_VALUE;
        this.maxMem = Integer.MIN_VALUE;
        this.minUserSupplied = Integer.MAX_VALUE;
        this.maxUserSupplied = Integer.MIN_VALUE;
        this.startTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.drawMessagesForTheseObjects = new HashSet<EntryMethodObject>();
        this.drawMessagesForTheseObjectsAlt = new HashSet<EntryMethodObject>();
        this.toPaintSMPMsgGrp = new SMPMsgGroup();
        this.entries = new int[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.makeFrequencyMap(this.entries);
        this.makeFreqVector();
        this.labelFont = new Font("SansSerif", 0, 10);
        this.axisFont = new Font("SansSerif", 0, 10);
        this.highlightedObjects = new HashSet<Object>();
        this.colorByMemoryUsage = false;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.customForeground = Color.white;
        this.customBackground = Color.black;
        this.skipIdleRegions = false;
        this.skipLoadingMessages = false;
        this.skipLoadingUserEvents = false;
        this.displayTopTimes = false;
        this.minEntryDuration = 0L;
        this.amountTopTimes = 0;
        this.loadGlobalPEList();
    }

    protected void addProcessor(int pe) {
        MainWindow.performanceLogger.log(Level.FINE, "Add processor " + pe);
        Integer p = pe;
        if (!this.peToLine.contains(p)) {
            int commPE;
            this.peToLine.addLast(p);
            MainWindow.performanceLogger.log(Level.FINE, "Add processor " + pe + " to peToLine size=" + this.peToLine.size());
            if (this.isSMPRun() && !this.peToLine.contains(commPE = this.getCommThdPE(p))) {
                this.peToLine.addLast(commPE);
                MainWindow.performanceLogger.log(Level.FINE, "Add processor " + commPE + " to peToLine size=" + this.peToLine.size());
            }
            this.modificationHandler.notifyProcessorListHasChanged();
            this.storeRangeToPersistantStorage();
            this.displayMustBeRedrawn();
        }
    }

    private void storeRangeToPersistantStorage() {
        MainWindow.runObject[this.myRun].persistantRangeData.update(this.startTime(), this.endTime(), this.processorListOrdered());
    }

    public void setProcessorList(SortedSet<Integer> processorList) {
        this.peToLine.clear();
        if (this.isSMPRun()) {
            TreeSet<Integer> commPEs = new TreeSet<Integer>();
            commPEs.clear();
            int prevNID = -1;
            int prevCommPE = -1;
            boolean isLastAdded = false;
            for (Integer pe : processorList) {
                if (this.isCommThd(pe)) {
                    if (!isLastAdded && prevCommPE != -1) {
                        this.peToLine.addLast(prevCommPE);
                        commPEs.add(prevCommPE);
                        isLastAdded = true;
                    }
                    if (commPEs.contains(pe)) continue;
                    this.peToLine.addLast(pe);
                    continue;
                }
                if (prevNID == -1) {
                    prevNID = this.getNodeID(pe);
                    prevCommPE = this.getCommThdPE(pe);
                    this.peToLine.addLast(pe);
                    continue;
                }
                int curNID = this.getNodeID(pe);
                if (curNID != prevNID) {
                    this.peToLine.addLast(prevCommPE);
                    commPEs.add(prevCommPE);
                    prevNID = curNID;
                    prevCommPE = this.getCommThdPE(pe);
                }
                this.peToLine.addLast(pe);
            }
            if (!isLastAdded) {
                this.peToLine.addLast(prevCommPE);
            }
        } else {
            for (Integer pe : processorList) {
                this.peToLine.addLast(pe);
            }
        }
    }

    private void loadGlobalPEList() {
        TreeSet<Integer> processorList = new TreeSet<Integer>(MainWindow.runObject[this.myRun].getValidProcessorList());
        this.setProcessorList(processorList);
    }

    private SortedSet<Integer> processorListOrdered() {
        TreeSet<Integer> processorList = new TreeSet<Integer>();
        for (Integer pe : this.peToLine) {
            processorList.add(pe);
        }
        return processorList;
    }

    protected void setFontSizes(int labelFontSize, int axisFontSize, boolean useBoldForLabel) {
        this.labelFont = useBoldForLabel ? new Font("SansSerif", 1, labelFontSize) : new Font("SansSerif", 0, labelFontSize);
        this.axisFont = new Font("SansSerif", 0, axisFontSize);
    }

    protected long startTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTLOArray(boolean useHelperThreads, Component rootWindow, boolean showProgress) {
        this.messageStructures.kill();
        Data data = this;
        synchronized (data) {
            if (this.startTime >= this.oldBT && this.endTime <= this.oldET) {
                Iterator<Map.Entry<Integer, Query1D<EntryMethodObject>>> iter = this.allEntryMethodObjects.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Integer, Query1D<EntryMethodObject>> e = iter.next();
                    Integer pe = e.getKey();
                    Query1D<EntryMethodObject> objs = e.getValue();
                    if (this.peToLine.contains(pe)) {
                        objs.removeEntriesOutsideRange(this.startTime, this.endTime);
                        continue;
                    }
                    iter.remove();
                }
                Iterator<Map.Entry<Integer, Query1D<UserEventObject>>> iter2 = this.allUserEventObjects.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry<Integer, Query1D<UserEventObject>> e = iter2.next();
                    Integer pe = e.getKey();
                    Query1D<UserEventObject> objs = e.getValue();
                    if (this.peToLine.contains(pe)) {
                        objs.removeEntriesOutsideRange(this.startTime, this.endTime);
                        continue;
                    }
                    iter2.remove();
                }
            }
            this.oldBT = this.startTime;
            this.oldET = this.endTime;
        }
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        for (Integer pe : this.peToLine) {
            if (!this.allEntryMethodObjects.containsKey(pe)) {
                readyReaders.add(new TimelineRunnableFileReader(pe, this));
                continue;
            }
            this.allEntryMethodObjects.remove(pe);
            this.allUserEventObjects.remove(pe);
            readyReaders.add(new TimelineRunnableFileReader(pe, this));
        }
        Component guiRootForProgressBar = null;
        if (rootWindow != null && rootWindow.isVisible()) {
            guiRootForProgressBar = rootWindow;
        } else if (MainWindow.runObject[this.myRun].guiRoot != null && MainWindow.runObject[this.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[this.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Timeline in Parallel", readyReaders, guiRootForProgressBar, showProgress);
        threadManager.runAll();
        if (this.memoryUsageValid()) {
            System.out.println("memory usage seen in the logs ranges from : " + this.minMem / 1024L / 1024L + "MB to " + this.maxMem / 1024L / 1024L + "MB");
        }
        Data data2 = this;
        synchronized (data2) {
            for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
                this.entries[e] = 0;
            }
            this.processorUsage = new float[this.numPEs()];
            this.entryUsageList = new OrderedUsageList[this.numPEs()];
            float[] entryUsageArray = new float[MainWindow.runObject[this.myRun].getNumUserEntries()];
            this.idleUsage = new float[this.numPEs()];
            this.packUsage = new float[this.numPEs()];
            for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
                entryUsageArray[i] = 0.0f;
            }
            for (int p = 0; p < this.numPEs(); ++p) {
                this.processorUsage[p] = 0.0f;
                this.idleUsage[p] = 0.0f;
                this.packUsage[p] = 0.0f;
            }
            EntryMethodObject[] idleArray = new EntryMethodObject[this.amountTopTimes()];
            EntryMethodObject[] entryArray = new EntryMethodObject[this.amountTopTimes()];
            long[] objEndTimes = new long[this.amountTopTimes()];
            for (Integer pe : this.allEntryMethodObjects.keySet()) {
                block13: for (EntryMethodObject obj : this.allEntryMethodObjects.get(pe)) {
                    float usage = obj.getUsage();
                    int entryIndex = obj.getEntryIndex();
                    if (entryIndex >= 0) {
                        int n = entryIndex;
                        this.entries[n] = this.entries[n] + 1;
                        int n2 = pe;
                        this.processorUsage[n2] = this.processorUsage[n2] + usage;
                        int n3 = pe;
                        this.packUsage[n3] = this.packUsage[n3] + obj.getPackUsage();
                        int n4 = entryIndex;
                        entryUsageArray[n4] = entryUsageArray[n4] + obj.getNonPackUsage();
                        if (!this.displayTopTimes()) continue;
                        for (int i = 0; i < this.amountTopTimes(); ++i) {
                            if (entryArray[i] != null && obj.getEndTime() - obj.getBeginTime() <= entryArray[i].getEndTime() - entryArray[i].getBeginTime()) continue;
                            for (int j = this.amountTopTimes() - 1; j > i; --j) {
                                entryArray[j] = entryArray[j - 1];
                            }
                            entryArray[i] = obj;
                            continue block13;
                        }
                        continue;
                    }
                    int n = pe;
                    this.idleUsage[n] = this.idleUsage[n] + usage;
                    if (!this.displayTopTimes()) continue;
                    long objEndTimeLong = obj.getEndTime();
                    if (objEndTimeLong > this.endTime()) {
                        objEndTimeLong = this.endTime();
                    }
                    for (int i = 0; i < this.amountTopTimes(); ++i) {
                        if (idleArray[i] != null && objEndTimeLong - obj.getBeginTime() <= objEndTimes[i] - idleArray[i].getBeginTime()) continue;
                        for (int j = this.amountTopTimes() - 1; j > i; --j) {
                            idleArray[j] = idleArray[j - 1];
                            objEndTimes[j] = objEndTimes[j - 1];
                        }
                        idleArray[i] = obj;
                        objEndTimes[i] = objEndTimeLong;
                        continue block13;
                    }
                }
                this.entryUsageList[pe.intValue()] = new OrderedUsageList();
                for (int i = 0; i < MainWindow.runObject[this.myRun].getNumUserEntries(); ++i) {
                    if (!(entryUsageArray[i] > 0.0f)) continue;
                    this.entryUsageList[pe].insert(entryUsageArray[i]);
                }
            }
            if (this.displayTopTimes()) {
                int i;
                this.topTimesText = "<html>";
                this.topTimesText = this.topTimesText + "The longest idle times in descending order are: <br>";
                HashSet<EntryMethodObject> longestObjectsSet = new HashSet<EntryMethodObject>();
                for (i = 0; i < this.amountTopTimes() && idleArray[i] != null && idleArray[i].getBeginTime() != objEndTimes[i]; ++i) {
                    this.topTimesText = this.topTimesText + (i + 1) + ": " + (objEndTimes[i] - idleArray[i].getBeginTime());
                    this.topTimesText = this.topTimesText + " Begin: " + idleArray[i].getBeginTime() + " End: " + objEndTimes[i] + " PE: " + idleArray[i].pe + "<br>";
                    longestObjectsSet.add(idleArray[i]);
                }
                this.topTimesText = this.topTimesText + "<br>";
                this.topTimesText = this.topTimesText + "The longest entry times in descending order are: <br>";
                for (i = 0; i < this.amountTopTimes() && entryArray[i] != null; ++i) {
                    this.topTimesText = this.topTimesText + (i + 1) + ": " + (entryArray[i].getEndTime() - entryArray[i].getBeginTime());
                    this.topTimesText = this.topTimesText + " Begin: " + entryArray[i].getBeginTime() + " End: " + entryArray[i].getEndTime();
                    this.topTimesText = this.topTimesText + " PE: " + entryArray[i].pe + " Name: " + MainWindow.runObject[this.myRun].getEntryFullNameByID(entryArray[i].getEntryID()) + "<br>";
                    longestObjectsSet.add(entryArray[i]);
                }
                this.topTimesText = this.topTimesText + "</html>";
                HashSet<Object> objsToHilite = new HashSet<Object>();
                objsToHilite.addAll(longestObjectsSet);
                this.highlightObjects(objsToHilite);
            }
            this.messageStructures.create(useHelperThreads);
            this.printNumLoadedObjects();
        }
    }

    private void printNumLoadedObjects() {
        int objCount = 0;
        for (Query1D<EntryMethodObject> query1D : this.allEntryMethodObjects.values()) {
            objCount += query1D.size();
        }
        MainWindow.performanceLogger.log(Level.INFO, "Displaying " + objCount + " entry method invocations in the timeline visualization");
        objCount = 0;
        for (Collection collection : this.allUserEventObjects.values()) {
            objCount += collection.size();
        }
        MainWindow.performanceLogger.log(Level.INFO, "Displaying " + objCount + " user events in the timeline visualization");
    }

    @Override
    public void displayMustBeRedrawn() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(true);
        }
    }

    protected void displayMustBeRepainted() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    private void toggleMessageSendLine(EntryMethodObject obj) {
        TimelineMessage created_message = obj.creationMessage();
        if (created_message != null) {
            if (this.drawMessagesForTheseObjects.contains(obj)) {
                this.drawMessagesForTheseObjects.remove(obj);
            } else {
                this.drawMessagesForTheseObjects.add(obj);
            }
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("Message was sent from outside the current time range");
        }
    }

    private void toggleMessageCalledByThisLine(EntryMethodObject obj) {
        ArrayList<TimelineMessage> tleMsg = obj.getTLmsgs();
        if (tleMsg != null) {
            for (int i = 0; i < tleMsg.size(); ++i) {
                Set<EntryMethodObject> entMethSet = this.messageStructures.getMessageToExecutingObjectsMap().get(tleMsg.get(i));
                if (entMethSet == null) continue;
                for (EntryMethodObject emo : entMethSet) {
                    if (this.drawMessagesForTheseObjectsAlt.contains(emo)) {
                        this.drawMessagesForTheseObjectsAlt.remove(emo);
                        continue;
                    }
                    this.drawMessagesForTheseObjectsAlt.add(emo);
                }
            }
            this.displayMustBeRepainted();
        }
    }

    protected boolean makeSMPMsgGroup(EntryMethodObject recvWPe) {
        TimelineMessage createdMsg = recvWPe.creationMessage();
        EntryMethodObject recvCPe = this.messageStructures.getMessageToSendingObjectsMap().get(createdMsg);
        if (!recvCPe.isCommThreadMsgRecv()) {
            return false;
        }
        createdMsg = recvCPe.creationMessage();
        if (createdMsg == null) {
            return false;
        }
        EntryMethodObject sendCPe = this.messageStructures.getMessageToSendingObjectsMap().get(createdMsg);
        if (sendCPe == null) {
            return false;
        }
        if (!this.isCommThd(sendCPe.pe)) {
            return false;
        }
        createdMsg = sendCPe.creationMessage();
        if (createdMsg == null) {
            return false;
        }
        EntryMethodObject sendWPe = this.messageStructures.getMessageToSendingObjectsMap().get(createdMsg);
        if (sendWPe == null) {
            return false;
        }
        this.toPaintSMPMsgGrp.recvWPe = recvWPe;
        this.toPaintSMPMsgGrp.recvCPe = recvCPe;
        this.toPaintSMPMsgGrp.sendCPe = sendCPe;
        this.toPaintSMPMsgGrp.sendWPe = sendWPe;
        return true;
    }

    protected void removeLines() {
        this.drawMessagesForTheseObjectsAlt.clear();
        this.drawMessagesForTheseObjects.clear();
        this.displayMustBeRepainted();
    }

    protected void addMessageSendLineAlt(Set<EntryMethodObject> s) {
        this.drawMessagesForTheseObjectsAlt.addAll(s);
    }

    protected void addMessageSendLine(Set<EntryMethodObject> s) {
        this.drawMessagesForTheseObjects.addAll(s);
    }

    protected void clearMessageSendLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
    }

    protected long endTime() {
        return this.endTime;
    }

    public Color getEntryColor(Integer id) {
        return MainWindow.runObject[this.myRun].getEntryColor(id);
    }

    protected Color getUserEventColor(Integer id) {
        return MainWindow.runObject[this.myRun].getUserEventColor(id);
    }

    public Color getBackgroundColor() {
        if (this.useCustomColors) {
            return this.customBackground;
        }
        return MainWindow.runObject[this.myRun].background;
    }

    protected int getSMPNodeSize() {
        return MainWindow.runObject[this.myRun].getSts().getNodeSize();
    }

    protected boolean isCommThd(int pe) {
        int nodesize;
        StsReader sts = MainWindow.runObject[this.myRun].getSts();
        int totalPes = sts.getProcessorCount();
        int totalNodes = sts.getSMPNodeCount();
        return pe >= totalNodes * (nodesize = sts.getNodeSize()) && pe < totalPes;
    }

    protected int getNodeID(int pe) {
        int nodesize;
        StsReader sts = MainWindow.runObject[this.myRun].getSts();
        int totalPes = sts.getProcessorCount();
        int totalNodes = sts.getSMPNodeCount();
        if (pe >= totalNodes * (nodesize = sts.getNodeSize()) && pe < totalPes) {
            return pe - totalNodes * nodesize;
        }
        return pe / nodesize;
    }

    protected boolean isSMPRun() {
        return MainWindow.runObject[this.myRun].getSts().isSMPRun();
    }

    protected int getCommThdPE(int pe) {
        int nid = this.getNodeID(pe);
        StsReader sts = MainWindow.runObject[this.myRun].getSts();
        return sts.getNodeSize() * sts.getSMPNodeCount() + nid;
    }

    protected String getPEString(int pe) {
        if (this.isSMPRun()) {
            int nid = this.getNodeID(pe);
            if (this.isCommThd(pe)) {
                return "CommP (N" + nid + ")";
            }
            return "P" + pe + " (N" + nid + ")";
        }
        return "PE " + pe;
    }

    void getData(Integer pe) {
        if (pe >= MainWindow.runObject[this.myRun].getSts().getProcessorCount()) {
            String err = "The sts file only specifies " + MainWindow.runObject[this.myRun].getSts().getProcessorCount() + " PEs, but you are trying somehow to load pe " + pe;
            throw new RuntimeException(err);
        }
        LinkedList<TimelineEvent> tl = new LinkedList<TimelineEvent>();
        RangeQueryTree<UserEventObject> userEvents = new RangeQueryTree<UserEventObject>();
        RangeQueryTree perPEObjects = new RangeQueryTree();
        try {
            if (!MainWindow.runObject[this.myRun].hasLogData()) {
                System.err.println("Error loading log files!");
                return;
            }
            MainWindow.runObject[this.myRun].logLoader.createtimeline(pe, this.startTime, this.endTime, tl, userEvents, this.minEntryDuration);
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION");
            e.printStackTrace();
            return;
        }
        if (this.skipLoadingUserEvents()) {
            userEvents.clear();
        }
        this.allUserEventObjects.put(pe, userEvents);
        this.allEntryMethodObjects.put(pe, perPEObjects);
        long minMemThisPE = Long.MAX_VALUE;
        long maxMemThisPE = 0L;
        long minUserSuppliedThisPE = Long.MAX_VALUE;
        long maxUserSuppliedThisPE = 0L;
        for (TimelineEvent tle : tl) {
            EntryMethodObject obj;
            ArrayList<TimelineMessage> msgs = null;
            if (tle.MsgsSent != null && !this.skipLoadingMessages()) {
                msgs = tle.MsgsSent;
            }
            ArrayList<PackTime> packs = null;
            if (tle.PackTimes != null && !this.skipLoadingMessages()) {
                packs = tle.PackTimes;
            }
            if (!(obj = new EntryMethodObject(this, tle, msgs, packs, pe)).isIdleEvent() && !obj.isUnaccountedTime() || !this.skipLoadingIdleRegions()) {
                perPEObjects.add(obj);
            }
            if (tle.memoryUsage != 0L) {
                if (tle.memoryUsage > maxMemThisPE) {
                    maxMemThisPE = tle.memoryUsage;
                }
                if (tle.memoryUsage < minMemThisPE) {
                    minMemThisPE = tle.memoryUsage;
                }
            }
            if (tle.UserSpecifiedData == null) continue;
            if ((long)tle.UserSpecifiedData.intValue() > maxUserSuppliedThisPE) {
                maxUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
            }
            if ((long)tle.UserSpecifiedData.intValue() >= minUserSuppliedThisPE) continue;
            minUserSuppliedThisPE = tle.UserSpecifiedData.intValue();
        }
        this.getDataSyncSaveMemUsage(minMemThisPE, maxMemThisPE, minUserSuppliedThisPE, maxUserSuppliedThisPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataSyncSaveMemUsage(long minMemThisPE, long maxMemThisPE, long minUserSuppliedThisPE, long maxUserSuppliedThisPE) {
        Object object = this.memUsageLock;
        synchronized (object) {
            if (minMemThisPE < this.minMem) {
                this.minMem = minMemThisPE;
            }
            if (maxMemThisPE > this.maxMem) {
                this.maxMem = maxMemThisPE;
            }
            if (minUserSuppliedThisPE < this.minUserSupplied) {
                this.minUserSupplied = minUserSuppliedThisPE;
            }
            if (maxUserSuppliedThisPE > this.maxUserSupplied) {
                this.maxUserSupplied = maxUserSuppliedThisPE;
            }
        }
    }

    private boolean memoryUsageValid() {
        return this.maxMem != Integer.MIN_VALUE && this.minMem != Integer.MAX_VALUE && this.maxMem != 0L;
    }

    public Color getForegroundColor() {
        if (this.useCustomColors) {
            return this.customForeground;
        }
        return MainWindow.runObject[this.myRun].foreground;
    }

    public int getNumUserEvents() {
        Iterator<Query1D<UserEventObject>> iter = this.allUserEventObjects.values().iterator();
        int num = 0;
        while (iter.hasNext()) {
            num += iter.next().size();
        }
        return num;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    private float roundScale(float scl) {
        int i = (int)(scl + 0.5f);
        if ((double)Math.abs((float)i - scl) < 0.01) {
            return i;
        }
        return scl;
    }

    protected void increaseScaleFactor() {
        this.setScaleFactor(this.roundScale(this.getScaleFactor() * this.scaleChangeFactor));
    }

    protected void decreaseScaleFactor() {
        this.setScaleFactor(this.roundScale(this.getScaleFactor() / this.scaleChangeFactor));
    }

    protected int lineWidth(int actualDisplayWidth) {
        return actualDisplayWidth - 2 * this.offset();
    }

    protected int maxLabelLen() {
        return 70;
    }

    protected int numPs() {
        return this.peToLine.size();
    }

    protected int numPEs() {
        return MainWindow.runObject[this.myRun].getNumProcessors();
    }

    protected int offset() {
        if (this.viewType == ViewType.VIEW_MINIMAL) {
            return this.maxLabelLen() / 2;
        }
        return 5 + this.maxLabelLen() / 2;
    }

    private int leftOffset() {
        return this.offset();
    }

    private int topOffset() {
        switch (this.viewType) {
            case VIEW_SUPERCOMPACT: {
                return 0;
            }
            case VIEW_MINIMAL: 
            case VIEW_COMPACT: {
                return 1;
            }
        }
        return 4;
    }

    private int bottomOffset() {
        switch (this.viewType) {
            case VIEW_SUPERCOMPACT: {
                return 0;
            }
            case VIEW_MINIMAL: 
            case VIEW_COMPACT: {
                return 1;
            }
        }
        return 4;
    }

    protected int scaledScreenWidth(int actualDisplayWidth) {
        this.mostRecentScaledScreenWidth = (int)((float)actualDisplayWidth * this.scaleFactor);
        return this.mostRecentScaledScreenWidth;
    }

    protected int screenHeight() {
        int paddingForScrollbar = 25;
        return this.singleTimelineHeight() * this.numPs() + paddingForScrollbar;
    }

    protected int barheight() {
        switch (this.viewType) {
            case VIEW_COMPACT: {
                return 12;
            }
            case VIEW_SUPERCOMPACT: {
                return 1;
            }
        }
        return 15;
    }

    public int singleTimelineHeight() {
        return this.topOffset() + this.totalUserEventRectsHeight() + this.barheight() + this.messageSendHeight() + this.bottomOffset();
    }

    protected int totalUserEventRectsHeight() {
        return this.singleUserEventRectHeight() * this.getNumUserEventRows();
    }

    protected int singleUserEventRectHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        if (this.drawNestedUserEventRows) {
            return 12;
        }
        return 7;
    }

    public void setHandler(MainHandler rh) {
        this.modificationHandler = rh;
        this.displayMustBeRedrawn();
    }

    protected void setNewRange(long beginTime, long endTime) {
        this.startTime = beginTime;
        this.endTime = endTime;
        this.setScaleFactor(1.0f);
        this.storeRangeToPersistantStorage();
    }

    public void setRange(long beginTime, long endTime) {
        this.startTime = beginTime;
        this.endTime = endTime;
        this.storeRangeToPersistantStorage();
    }

    public void setScaleFactor(float scale_) {
        this.scaleFactor = scale_;
        if ((double)this.scaleFactor < 1.0) {
            this.scaleFactor = 1.0f;
        }
        this.displayMustBeRedrawn();
    }

    protected long totalTime() {
        return this.endTime - this.startTime;
    }

    protected boolean selectionValid() {
        return this.selection1 >= 0 && this.selection2 >= 0 && this.selection1 != this.selection2;
    }

    protected boolean highlightValid() {
        return this.highlight >= 0;
    }

    protected void invalidateSelection() {
        this.selection1 = -1;
        this.selection2 = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    protected int leftSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection1;
        }
        return this.selection2;
    }

    protected int rightSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection2;
        }
        return this.selection1;
    }

    public void setSelection1(int value) {
        this.selection1 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void setSelection2(int value) {
        this.selection2 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    protected void removeHighlight() {
        this.highlight = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    protected void setHighlight(int x) {
        this.highlight = x;
        this.modificationHandler.refreshDisplay(false);
    }

    protected int getHighlight() {
        return this.highlight;
    }

    protected double getHighlightTime() {
        return this.screenToTime(this.getHighlight());
    }

    protected double leftSelectionTime() {
        return this.screenToTime(this.leftSelection());
    }

    protected double rightSelectionTime() {
        return this.screenToTime(this.rightSelection());
    }

    long screenToTime(int xPixelCoord) {
        double fractionAlongAxis = (double)(xPixelCoord - this.leftOffset()) / (double)(this.mostRecentScaledScreenWidth - 2 * this.offset());
        return Math.round((double)this.startTime + fractionAlongAxis * (double)(this.endTime - this.startTime));
    }

    protected int timeToScreenPixelRight(double time) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelLeft(double time) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixel(double time) {
        double fractionAlongTimeAxis = (time - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixel(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelLeft(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    protected int timeToScreenPixelRight(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.startTime) / (double)(this.endTime - this.startTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public void setPreferredViewTimeCenter(double time) {
        if (time > (double)this.startTime && time < (double)this.endTime) {
            this.preferredViewTime = time;
        }
    }

    protected int getNewPreferredViewCenter(int newScreenWidth) {
        double value = this.preferredViewTime;
        int coord = this.timeToScreenPixel(value, newScreenWidth);
        return coord;
    }

    protected void resetPreferredView() {
        this.preferredViewTime = -1.0;
    }

    protected boolean hasNewPreferredView() {
        return this.preferredViewTime >= 0.0 && (double)this.scaleFactor > 1.0;
    }

    protected void keepViewCentered(boolean b) {
        this.keepViewCentered = b;
    }

    protected boolean keepViewCentered() {
        return this.keepViewCentered;
    }

    protected int messageSendHeight() {
        if (this.useCompactView()) {
            return 0;
        }
        return 5;
    }

    protected int smpMessageRecvBarHeight() {
        if (this.viewType == ViewType.VIEW_NORMAL) {
            return 3;
        }
        if (this.viewType == ViewType.VIEW_COMPACT) {
            return 2;
        }
        return 0;
    }

    protected int messagePackHeight() {
        return 3;
    }

    protected void clickTraceSender(EntryMethodObject obj) {
        if (this.viewType != ViewType.VIEW_MINIMAL) {
            this.addProcessor(obj.pCreation);
            this.toggleMessageSendLine(obj);
            if (this.traceMessagesForwardOnClick) {
                this.toggleMessageCalledByThisLine(obj);
            }
        }
    }

    protected void clearObjectHighlights() {
        this.highlightedObjects.clear();
    }

    protected void highlightObjects(Set<Object> objects) {
        this.highlightedObjects.addAll(objects);
    }

    protected boolean isObjectDimmed(Object o) {
        if (this.highlightedObjects.size() == 0) {
            return false;
        }
        return !this.highlightedObjects.contains(o);
    }

    protected boolean traceMessagesBackOnHover() {
        return this.traceMessagesBackOnHover;
    }

    protected boolean traceMessagesForwardOnHover() {
        return this.traceMessagesForwardOnHover;
    }

    protected boolean traceCriticalPathOnHover() {
        return this.traceCriticalPathOnHover;
    }

    protected boolean traceOIDOnHover() {
        return this.traceOIDOnHover;
    }

    public void setTraceMessagesBackOnHover(boolean traceMessagesOnHover) {
        this.traceMessagesBackOnHover = traceMessagesOnHover;
        if (traceMessagesOnHover) {
            this.setToolTipDelayLarge();
        } else {
            this.setToolTipDelaySmall();
        }
    }

    public void setTraceMessagesForwardOnHover(boolean traceMessagesForwardOnHover) {
        this.traceMessagesForwardOnHover = traceMessagesForwardOnHover;
        if (traceMessagesForwardOnHover) {
            this.setToolTipDelayLarge();
        } else {
            this.setToolTipDelaySmall();
        }
    }

    public void setTraceMessagesForwardOnClick(boolean traceMessagesForwardOnClick) {
        this.traceMessagesForwardOnClick = traceMessagesForwardOnClick;
    }

    public void setTraceCriticalPathOnHover(boolean traceCriticalPathOnHover) {
        this.traceCriticalPathOnHover = traceCriticalPathOnHover;
        if (traceCriticalPathOnHover) {
            this.setToolTipDelayLarge();
        } else {
            this.setToolTipDelaySmall();
        }
    }

    public void setTraceCriticalPathOnClick(boolean traceCriticalPathOnClick) {
        this.traceCriticalPathOnClick = traceCriticalPathOnClick;
    }

    public void setTraceOIDOnHover(boolean showOIDOnHover) {
        this.traceOIDOnHover = showOIDOnHover;
    }

    protected void setToolTipDelaySmall() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    private void setToolTipDelayLarge() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public Color getMessageColor() {
        return this.getForegroundColor();
    }

    public Color getMessageAltColor() {
        return Color.yellow;
    }

    protected void showUserEvents(boolean b) {
        this.showUserEvents = b;
    }

    protected boolean showUserEvents() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showUserEvents;
    }

    protected void restoreHighlights() {
        this.clearObjectHighlights();
        this.displayMustBeRepainted();
    }

    protected void setColorByDefault() {
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorForEntry(int id, Color c) {
        if (c != null) {
            MainWindow.runObject[this.myRun].setEntryColor(id, c);
            this.displayMustBeRepainted();
        }
    }

    protected void setColorByMemoryUsage() {
        if (this.memoryUsageValid()) {
            new MemoryColorRangeChooser(this);
        } else {
            this.modificationHandler.displayWarning("No memory usage entries found. Use traceMemoryUsage() in the application");
        }
    }

    protected void finalizeColorByMemoryUsage() {
        this.colorByMemoryUsage = true;
        this.colorByObjectId = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSupplied(ColorScheme colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    protected void setColorByObjectID() {
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByUserSupplied = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSuppliedAndObjID(ColorScheme colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = true;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSuppliedAndEID(ColorScheme colorScheme) {
        this.colorSchemeForUserSupplied = colorScheme;
        this.colorByUserSupplied = true;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = true;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    protected void setColorByEID() {
        this.colorByUserSupplied = false;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = true;
        this.colorByEntryIdFreq = false;
        this.displayMustBeRepainted();
    }

    protected void setColorByEIDFreq() {
        this.colorByUserSupplied = false;
        this.colorByObjectId = false;
        this.colorByMemoryUsage = false;
        this.colorByEntryId = false;
        this.colorByEntryIdFreq = true;
        this.displayMustBeRepainted();
    }

    protected boolean colorByEID() {
        return this.colorByEntryId;
    }

    protected boolean colorByEIDFreq() {
        return this.colorByEntryIdFreq;
    }

    protected boolean colorByOID() {
        return this.colorByObjectId;
    }

    protected boolean colorByUserSupplied() {
        return this.colorByUserSupplied;
    }

    protected boolean colorByMemoryUsage() {
        return this.colorByMemoryUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixTachyons() {
        System.out.println("The fix tachyons feature is still experimental. It may not work well if new processors are loaded, or ranges are changed");
        TachyonShifts tachyonShifts = MainWindow.runObject[this.myRun].tachyonShifts;
        Data data = this;
        synchronized (data) {
            int numIterations = this.numPEs();
            long threshold_us = 10L;
            System.out.println("Executing at most " + numIterations + " times or until no tachyons longer than " + threshold_us + "us are found");
            for (int iteration = 0; iteration < numIterations; ++iteration) {
                long largestShift = 0L;
                long largePe = -1L;
                for (Map.Entry<Integer, Query1D<EntryMethodObject>> e : this.allEntryMethodObjects.entrySet()) {
                    Integer pe = e.getKey();
                    Query1D<EntryMethodObject> objs = e.getValue();
                    long minLatency = Integer.MAX_VALUE;
                    for (EntryMethodObject obj : objs) {
                        TimelineMessage m = obj.creationMessage();
                        if (m == null) continue;
                        long sendTime = m.Time;
                        long executeTime = obj.getBeginTime();
                        long latency = executeTime - sendTime;
                        if (minLatency <= latency) continue;
                        minLatency = latency;
                    }
                    long shift = -1L * minLatency;
                    if (shift > threshold_us) {
                        this.allEntryMethodObjects.get(pe).shiftAllEntriesBy(shift);
                        this.allUserEventObjects.get(pe).shiftAllEntriesBy(shift);
                        tachyonShifts.accumulateTachyonShifts(shift, pe);
                        largePe = pe.intValue();
                    }
                    if (shift <= largestShift) continue;
                    largestShift = shift;
                }
                System.out.println("Tachyons: iteration " + iteration + " largestShift= " + largestShift + " large PE= " + largePe);
                if (largestShift > threshold_us) continue;
                System.out.println("No tachyons go back further than " + largestShift + " us");
                break;
            }
        }
        tachyonShifts.writeTachyonShiftMap();
    }

    public long findLargestTachyon() {
        long minLatency = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Query1D<EntryMethodObject>> e : this.allEntryMethodObjects.entrySet()) {
            Integer pe = e.getKey();
            Query1D<EntryMethodObject> objs = e.getValue();
            for (EntryMethodObject obj : objs) {
                TimelineMessage m = obj.creationMessage();
                if (m == null) continue;
                long sendTime = m.Time;
                long executeTime = obj.getBeginTime();
                long latency = executeTime - sendTime;
                if (minLatency <= latency) continue;
                minLatency = latency;
            }
        }
        return -1L * minLatency;
    }

    public void setViewType(ViewType vt) {
        this.viewType = vt;
        this.displayMustBeRedrawn();
    }

    protected boolean showPacks() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showPacks;
    }

    protected boolean showMsgs() {
        if (this.useCompactView()) {
            return false;
        }
        return this.showMsgs;
    }

    protected boolean showIdle() {
        return this.showIdle;
    }

    protected void showIdle(boolean b) {
        this.showIdle = b;
    }

    protected void showPacks(boolean b) {
        this.showPacks = b;
    }

    protected void showMsgs(boolean b) {
        this.showMsgs = b;
    }

    private boolean useCompactView() {
        return this.viewType != ViewType.VIEW_NORMAL;
    }

    private int whichTimelineVerticalPosition(int PE) {
        if (this.peToLine == null) {
            throw new RuntimeException("peToLine is null");
        }
        if (!this.peToLine.contains(PE)) {
            throw new RuntimeException("peToLine does not contain pe " + PE);
        }
        return this.peToLine.indexOf(PE);
    }

    protected int whichPE(Integer verticalPosition) {
        if (verticalPosition < this.numPs() && verticalPosition >= 0) {
            return this.peToLine.get(verticalPosition);
        }
        return -1;
    }

    protected void movePEToLine(int PE, int newPos) {
        if (newPos < this.peToLine.size()) {
            Integer p = PE;
            this.peToLine.remove(p);
            this.peToLine.add(newPos, p);
        }
        this.displayMustBeRedrawn();
    }

    public void setBackgroundColor(Color c) {
        this.customBackground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setForegroundColor(Color c) {
        this.customForeground = c;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setColors(Color backgroundColor, Color foregroundColor) {
        this.setBackgroundColor(backgroundColor);
        this.setForegroundColor(foregroundColor);
    }

    protected void printUserEventInfo() {
        System.out.println("printUserEventInfo()");
        HashMap<Integer, Long> min = new HashMap<Integer, Long>();
        HashMap<Integer, Long> max = new HashMap<Integer, Long>();
        HashMap<Integer, Long> total = new HashMap<Integer, Long>();
        HashMap<Integer, Long> count = new HashMap<Integer, Long>();
        HashMap<Integer, String> name = new HashMap<Integer, String>();
        for (Integer pe : this.allUserEventObjects.keySet()) {
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.type != UserEventObject.Type.PAIR) continue;
                long BeginTime = obj.beginTime;
                long EndTime = obj.endTime;
                Integer UserEventID = obj.userEventID;
                long duration = EndTime - BeginTime;
                if (!min.containsKey(UserEventID)) {
                    min.put(UserEventID, new Long(duration));
                    max.put(UserEventID, new Long(duration));
                    total.put(UserEventID, new Long(duration));
                    count.put(UserEventID, 1L);
                    name.put(UserEventID, obj.getName());
                    continue;
                }
                if ((Long)min.get(UserEventID) > duration) {
                    min.put(UserEventID, duration);
                }
                if ((Long)max.get(UserEventID) < duration) {
                    max.put(UserEventID, duration);
                }
                total.put(UserEventID, (Long)total.get(UserEventID) + Long.valueOf(duration));
                count.put(UserEventID, (Long)count.get(UserEventID) + Long.valueOf(1L));
            }
        }
        for (Integer UserEventID : min.keySet()) {
            double avg = ((Long)total.get(UserEventID)).doubleValue() / ((Long)count.get(UserEventID)).doubleValue();
            System.out.print("User Event #" + UserEventID + "  \"" + (String)name.get(UserEventID) + "\"");
            System.out.print("    count = " + count.get(UserEventID));
            System.out.print("    min   = " + min.get(UserEventID) + " us");
            System.out.print("    max   = " + max.get(UserEventID) + " us");
            System.out.print("    avg   = " + avg + " us");
            System.out.print("    total = " + total.get(UserEventID) + " us");
            System.out.println();
        }
    }

    private int determineUserEventNestings() {
        int maxDepth = 0;
        for (Integer pe : this.allUserEventObjects.keySet()) {
            Stack<Long> activeEndTimes = new Stack<Long>();
            for (UserEventObject obj : this.allUserEventObjects.get(pe)) {
                if (obj.type != UserEventObject.Type.PAIR) continue;
                long BeginTime = obj.beginTime;
                long EndTime = obj.endTime;
                while (activeEndTimes.size() > 0 && (Long)activeEndTimes.peek() <= BeginTime) {
                    activeEndTimes.pop();
                }
                activeEndTimes.push(EndTime);
                obj.setNestedRow(activeEndTimes.size() - 1);
                if (activeEndTimes.size() <= maxDepth) continue;
                maxDepth = activeEndTimes.size();
            }
        }
        return maxDepth;
    }

    protected void showNestedUserEvents(boolean b) {
        this.drawNestedUserEventRows = b;
        if (b) {
            this.setNumUserEventRows(this.determineUserEventNestings());
        } else {
            this.setNumUserEventRows(1);
        }
        this.displayMustBeRedrawn();
    }

    public void setNumUserEventRows(int numUserEventRows) {
        this.numUserEventRows = numUserEventRows;
    }

    public int getNumUserEventRows() {
        return this.numUserEventRows;
    }

    protected RepresentedEntity representedAtPixelYOffsetInRow(int y) {
        if (y < this.topOffset()) {
            return RepresentedEntity.NOTHING;
        }
        if (y < this.topOffset() + this.totalUserEventRectsHeight()) {
            return RepresentedEntity.USER_EVENT;
        }
        if (y < this.topOffset() + this.totalUserEventRectsHeight() + this.entryMethodLocationHeight()) {
            return RepresentedEntity.ENTRY_METHOD;
        }
        return RepresentedEntity.NOTHING;
    }

    protected int entryMethodLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.totalUserEventRectsHeight();
    }

    protected int peTopPixel(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset();
    }

    protected int peBottomPixel(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * (yidx + 1) + this.topOffset() - 1;
    }

    protected int rowForPixel(int y) {
        return (y - this.topOffset()) / this.singleTimelineHeight();
    }

    Collection<Integer> processorsInPixelYRange(int y1, int y2) {
        int r1 = this.rowForPixel(y1);
        int r2 = this.rowForPixel(y2);
        ArrayList<Integer> results = new ArrayList<Integer>();
        int count = 0;
        for (Integer pe : this.peToLine) {
            if (count >= r1 && count <= r2) {
                results.add(pe);
            }
            ++count;
        }
        return results;
    }

    protected int entryMethodLocationHeight() {
        return this.barheight() + this.messageSendHeight();
    }

    protected int userEventLocationTop(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset();
    }

    protected int userEventLocationBottom(int pe) {
        return this.userEventLocationTop(pe) + this.totalUserEventRectsHeight();
    }

    protected int horizontalLineLocationTop(int i) {
        return this.singleTimelineHeight() * i + this.topOffset() + this.totalUserEventRectsHeight() + this.barheight() / 2;
    }

    protected int messageSendLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.totalUserEventRectsHeight() + this.barheight() + this.messageSendHeight();
    }

    protected int messageRecvLocationY(int pe) {
        int yidx = this.whichTimelineVerticalPosition(pe);
        return this.singleTimelineHeight() * yidx + this.topOffset() + this.totalUserEventRectsHeight();
    }

    protected void addNeighbors(Integer pe) {
        SortedSet<Integer> processorList = MainWindow.runObject[this.myRun].getValidProcessorList();
        int intpe = pe;
        for (int i = -4; i < 4; ++i) {
            int newPE = intpe + i;
            if (!processorList.contains(newPE)) continue;
            this.addProcessor(i + intpe);
        }
    }

    protected void dropPEsUnrelatedToPE(Integer pe) {
        this.dropPEsUnrelatedToObjects((Collection<EntryMethodObject>)this.allEntryMethodObjects.get(pe));
    }

    protected void dropPEsUnrelatedToObject(EntryMethodObject obj) {
        MainWindow.performanceLogger.log(Level.INFO, "dropPEsUnrelatedToObject()");
        HashSet<EntryMethodObject> set = new HashSet<EntryMethodObject>();
        set.add(obj);
        this.dropPEsUnrelatedToObjects(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPEsUnrelatedToObjects(Collection<EntryMethodObject> objs) {
        Data data = this;
        synchronized (data) {
            MainWindow.performanceLogger.log(Level.INFO, "dropPEsUnrelatedToObjects()");
            HashSet<EntryMethodObject> allRelatedEntries = new HashSet<EntryMethodObject>();
            for (EntryMethodObject obj : objs) {
                allRelatedEntries.add(obj);
                allRelatedEntries.addAll(obj.traceForwardDependencies());
                allRelatedEntries.addAll(obj.traceBackwardDependencies());
            }
            HashSet<Integer> relatedPEs = new HashSet<Integer>();
            for (EntryMethodObject o : allRelatedEntries) {
                relatedPEs.add(o.pe);
            }
            this.dropPEsNotInList(relatedPEs);
        }
    }

    private void dropPEsNotInList(Set<Integer> keepPEs) {
        HashSet<Integer> currentPEs = new HashSet<Integer>();
        currentPEs.addAll(this.peToLine);
        for (Integer p : currentPEs) {
            if (keepPEs.contains(p)) continue;
            this.peToLine.remove(p);
        }
        this.modificationHandler.notifyProcessorListHasChanged();
        this.displayMustBeRedrawn();
    }

    public Map<Integer, String> getEntryNames() {
        return MainWindow.runObject[this.myRun].getSts().getPrettyEntryNames();
    }

    public Map<Integer, String> getUserEventNames() {
        return MainWindow.runObject[this.myRun].getSts().getUserEventNameMap();
    }

    @Override
    public void makeEntryVisibleID(Integer id) {
        this.makeEntryVisibleID(id, true);
    }

    @Override
    public void makeEntryInvisibleID(Integer id) {
        this.makeEntryInvisibleID(id, true);
    }

    public void makeEntryVisibleID(Integer id, boolean redraw) {
        this.hiddenEntryPoints.remove(id);
        if (redraw) {
            this.displayMustBeRedrawn();
        }
    }

    protected void makeEntryInvisibleID(Integer id, boolean redraw) {
        this.hiddenEntryPoints.add(id);
        if (redraw) {
            this.displayMustBeRedrawn();
        }
    }

    protected void makeUserEventVisibleID(Integer id) {
        this.hiddenUserEvents.remove(id);
        this.displayMustBeRedrawn();
    }

    protected void makeUserEventInvisibleID(Integer id) {
        this.hiddenUserEvents.add(id);
        this.displayMustBeRedrawn();
    }

    protected boolean entryIsHiddenID(Integer id) {
        return this.hiddenEntryPoints.contains(id);
    }

    @Override
    public boolean entryIsVisibleID(Integer id) {
        return !this.hiddenEntryPoints.contains(id);
    }

    protected boolean userEventIsHiddenID(Integer id) {
        return this.hiddenUserEvents.contains(id);
    }

    protected void skipLoadingMessages(boolean b, boolean filterAlreadyLoaded) {
        this.skipLoadingMessages = b;
        if (this.skipLoadingMessages && filterAlreadyLoaded) {
            this.pruneOutMessages();
        }
    }

    protected void skipLoadingUserEvents(boolean b) {
        this.skipLoadingUserEvents = b;
    }

    private boolean skipLoadingUserEvents() {
        return this.skipLoadingUserEvents;
    }

    protected void displayTopTimes(boolean b) {
        this.displayTopTimes = b;
    }

    private boolean displayTopTimes() {
        return this.displayTopTimes;
    }

    private int amountTopTimes() {
        return this.amountTopTimes;
    }

    protected void amountTopTimes(int i) {
        this.amountTopTimes = i;
    }

    protected void displayTopTimesText() {
        if (this.topTimesText == null) {
            JOptionPane.showMessageDialog(null, "You must first choose to display the longest idle and entry methods in the Ranges menu.", "Error", 0);
        } else {
            JFrame frame = new JFrame("Top " + this.amountTopTimes() + " Idle and Entry Times");
            frame.setDefaultCloseOperation(2);
            JLabel lbl = new JLabel(this.topTimesText);
            JPanel pnl = new JPanel();
            pnl.add(lbl);
            JScrollPane scp = new JScrollPane(pnl, 22, 30);
            scp.getVerticalScrollBar().setUnitIncrement(16);
            frame.add(scp);
            frame.setSize(500, 400);
            frame.setVisible(true);
        }
    }

    private void pruneOutMessages() {
        MainWindow.performanceLogger.log(Level.INFO, "pruneOutMessages");
        for (Integer pe : this.allEntryMethodObjects.keySet()) {
            Query1D<EntryMethodObject> list = this.allEntryMethodObjects.get(pe);
            for (EntryMethodObject o : list) {
                o.messages = null;
            }
        }
        this.messageStructures.clearAll();
        this.clearMessageSendLines();
        this.modificationHandler.notifyProcessorListHasChanged();
        this.displayMustBeRedrawn();
    }

    private boolean skipLoadingIdleRegions() {
        return this.skipIdleRegions;
    }

    private boolean skipLoadingMessages() {
        return this.skipLoadingMessages;
    }

    protected long minMemMB() {
        return this.minMem / 1024L / 1024L;
    }

    protected long maxMemMB() {
        return this.maxMem / 1024L / 1024L;
    }

    protected long minMemBColorRange() {
        return this.minMemColorRange;
    }

    protected long maxMemBColorRange() {
        return this.maxMemColorRange;
    }

    protected void setMemColorRange(long minMemVal, long maxMemVal) {
        this.minMemColorRange = minMemVal;
        this.maxMemColorRange = maxMemVal;
    }

    protected void setFilterEntryShorterThan(long l) {
        this.minEntryDuration = l;
    }

    protected void displayLegend() {
        if (this.memoryUsageValid()) {
            new MemoryLegend(this);
        }
    }

    public void finalize() throws Throwable {
        this.entries = null;
        this.hiddenEntryPoints = null;
        this.processorUsage = null;
        this.packUsage = null;
        this.entryUsageList = null;
        this.messageStructures = null;
        this.drawMessagesForTheseObjects = null;
        this.drawMessagesForTheseObjectsAlt = null;
        super.finalize();
    }

    public void makeFrequencyMap(int[] frequencyOfEntries) {
        TreeMap mapToReturn = new TreeMap();
        for (int i = 0; i < frequencyOfEntries.length; ++i) {
            if (mapToReturn.containsKey(this.entries[i])) {
                ((LinkedList)mapToReturn.get(this.entries[i])).add(i);
                continue;
            }
            LinkedList<Integer> ll = new LinkedList<Integer>();
            ll.add(i);
            mapToReturn.put(this.entries[i], ll);
        }
        this.frequencyTreeMap = mapToReturn;
    }

    public void makeFreqVector() {
        ArrayList<Integer> vectorToReturn = new ArrayList<Integer>();
        Collection<LinkedList<Integer>> collec = this.frequencyTreeMap.values();
        for (LinkedList<Integer> tempLinkedL : collec) {
            for (int i = 0; i < tempLinkedL.size(); ++i) {
                vectorToReturn.add(0, tempLinkedL.get(i));
            }
        }
        this.frequencyVector = vectorToReturn;
    }

    protected void setFrequencyColors() {
        Analysis a = MainWindow.runObject[this.myRun];
        a.activityColors = a.colorManager.defaultColorMap();
        a.entryColors = ColorManager.entryColorsByFrequency(ColorManager.createComplementaryColorMap(this.entries.length), this.frequencyVector);
        a.userEventColors = a.activityColors[1];
        a.functionColors = a.activityColors[2];
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public void colorsHaveChanged() {
        this.displayMustBeRepainted();
    }

    @Override
    public int[] getEntriesArray() {
        return this.entries;
    }

    @Override
    public boolean hasEntryList() {
        return true;
    }

    @Override
    public boolean handleIdleOverhead() {
        return true;
    }

    public EntryMethodObject getPreviousEntry(EntryMethodObject currentObj, int currentPe) {
        Query1D<EntryMethodObject> objs = null;
        EntryMethodObject previous = null;
        for (Map.Entry<Integer, Query1D<EntryMethodObject>> e : this.allEntryMethodObjects.entrySet()) {
            EntryMethodObject obj;
            Integer pe = e.getKey();
            if (pe != currentPe) continue;
            objs = e.getValue();
            Iterator iterator = objs.iterator();
            while (iterator.hasNext() && !(obj = (EntryMethodObject)iterator.next()).equals(currentObj)) {
                previous = obj;
            }
            break block0;
        }
        return previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepresentedEntity {
        ENTRY_METHOD,
        USER_EVENT,
        NOTHING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        VIEW_NORMAL,
        VIEW_COMPACT,
        VIEW_SUPERCOMPACT,
        VIEW_MINIMAL;

    }

    public class SMPMsgGroup
    implements Comparable {
        public EntryMethodObject sendWPe;
        public EntryMethodObject sendCPe;
        public EntryMethodObject recvCPe;
        public EntryMethodObject recvWPe;

        public int compareTo(Object o) {
            SMPMsgGroup obj = (SMPMsgGroup)o;
            int swval = this.sendWPe.compareTo(obj.sendWPe);
            if (swval == 0) {
                int scval = this.sendCPe.compareTo(obj.sendCPe);
                if (scval == 0) {
                    int rcval = this.recvCPe.compareTo(obj.recvCPe);
                    if (rcval == 0) {
                        return this.recvWPe.compareTo(obj.recvWPe);
                    }
                    return rcval;
                }
                return scval;
            }
            return swval;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SMPMsgGroup)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorScheme {
        BlueGradientColors,
        RandomColors;

    }
}

