/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MainPanel;
import projections.Tools.Timeline.MessageStructures;
import projections.Tools.Timeline.MessageWindow;
import projections.Tools.Timeline.RangeQueries.Range1D;
import projections.Tools.Timeline.TimelineMessage;
import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.U;
import projections.misc.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryMethodObject
implements Comparable,
Range1D,
ActionListener,
MainPanel.SpecialMouseHandler {
    private MessageWindow msgwindow;
    private long beginTime;
    private long endTime;
    private long recvTime;
    private long cpuTime;
    private long cpuBegin;
    private long cpuEnd;
    private int entry;
    private int entryIndex;
    private int msglen;
    int EventID;
    private ObjectId tid;
    int pe;
    int pCreation;
    private ArrayList<TimelineMessage> TLmsgs;
    private static final String popupChangeColor = "Change Entry Point Color";
    private static final String popupShowDetails = "Show details";
    private static final String popupTraceSender = "Trace message to sender";
    private static final String popupTracePath = "Trace message path";
    private static final String popupDropPEsForObject = "Drop all PEs unrelated to this entry method";
    private static final String popupDropPEsForPE = "Drop all PEs unrelated to entry methods on this PE";
    private static final String loadNeighbors = "Load neighbors";
    Integer userSuppliedData;
    private long memoryUsage;
    private double usage;
    private float packusage;
    private long packtime;
    private String tleUserEventName;
    private Data data = null;
    protected ArrayList<TimelineMessage> messages;
    private ArrayList<PackTime> packs;
    private int numPapiCounts = 0;
    private long[] papiCounts;
    private boolean isFunction = false;
    private static DecimalFormat format_ = new DecimalFormat();
    private AmpiFunctionData[] funcData;
    private boolean isCommThdRecv = false;

    protected EntryMethodObject(Data data, TimelineEvent tle, ArrayList<TimelineMessage> msgs, ArrayList<PackTime> packs, int p1) {
        this.TLmsgs = tle.MsgsSent;
        this.data = data;
        this.beginTime = tle.BeginTime;
        this.endTime = tle.EndTime;
        this.cpuBegin = tle.cpuBegin;
        this.cpuEnd = tle.cpuEnd;
        this.cpuTime = this.cpuEnd - this.cpuBegin;
        this.entry = tle.EntryPoint;
        this.entryIndex = MainWindow.runObject[data.myRun].getEntryIndex(this.entry);
        this.messages = msgs;
        this.packs = packs;
        this.pe = p1;
        this.pCreation = tle.SrcPe;
        if (data.isCommThd(this.pe)) {
            int creationNode;
            int myNode = data.getNodeID(this.pe);
            this.isCommThdRecv = myNode != (creationNode = data.getNodeID(this.pCreation));
        }
        this.EventID = tle.EventID;
        this.msglen = tle.MsgLen;
        this.recvTime = tle.RecvTime;
        this.tid = tle.id != null ? new ObjectId(tle.id) : new ObjectId();
        this.userSuppliedData = tle.UserSpecifiedData;
        this.memoryUsage = tle.memoryUsage;
        this.tleUserEventName = tle.userEventName;
        this.numPapiCounts = tle.numPapiCounts;
        this.papiCounts = tle.papiCounts;
        this.isFunction = tle.isFunction;
        format_.setGroupingUsed(true);
        this.setUsage();
        this.setPackUsage();
        if (this.isFunction) {
            this.funcData = new AmpiFunctionData[tle.callStack.size()];
            tle.callStack.copyInto(this.funcData);
        } else if (tle.EntryPoint >= 0) {
            // empty if block
        }
    }

    @Override
    public String getToolTipText() {
        StringBuilder infoString = new StringBuilder(5000);
        if (this.isFunction) {
            infoString.append("<i>Function</i>: " + MainWindow.runObject[this.data.myRun].getFunctionName(this.entry) + "<br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime) + "<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime) + "<br>");
            infoString.append("<i>Msgs created</i>: " + this.messages.size() + "<br>");
            infoString.append("<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>");
            infoString.append("<hr><br><i>Function Callstack</i>:<br>");
            for (int i = 0; i < this.funcData.length; ++i) {
                AmpiFunctionData functionData = this.funcData[i];
                infoString.append("<i>[Func]</i>: " + MainWindow.runObject[this.data.myRun].getFunctionName(functionData.FunctionID) + "<br>");
                infoString.append("&nbsp&nbps&nbsp&nbps<i>line</i>:" + functionData.LineNo + " <i>file</i>: " + functionData.sourceFileName + "<br>");
            }
        } else if (this.entry >= 0) {
            infoString.append("<b>" + MainWindow.runObject[this.data.myRun].getEntryFullNameByID(this.entry, true) + "</b><br><br>");
            if (this.msglen > 0) {
                infoString.append("<i>Msg Len</i>: " + this.msglen + "<br>");
            }
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuBegin) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuEnd) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + U.humanReadableString(this.cpuTime) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Packing</i>: " + U.humanReadableString(this.packtime));
            if (this.packtime > 0L) {
                infoString.append(" (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)");
            }
            infoString.append("<br>");
            if (this.messages != null) {
                infoString.append("<i>Msgs created</i>: " + this.messages.size() + "<br>");
            } else {
                infoString.append("<i>Msgs created</i>: 0<br>");
            }
            EntryMethodObject obj = this;
            TimelineMessage created_message = obj.creationMessage();
            if (created_message != null) {
                long latency = this.beginTime - created_message.Time;
                infoString.append("<i>Msg latency is </i>: " + latency + "<br>");
            }
            infoString.append("<i>Created by </i>: " + this.data.getPEString(this.pCreation) + "<br>");
            infoString.append("<i>Id</i>: " + this.tid.id[0] + ":" + this.tid.id[1] + ":" + this.tid.id[2] + "<br>");
            if (this.tleUserEventName != null) {
                infoString.append("<i>Associated User Event</i>: " + this.tleUserEventName + "<br>");
            }
            if (this.recvTime > 0L) {
                infoString.append("<i>Recv Time</i>: " + this.recvTime + "<br>");
            }
            if (this.numPapiCounts > 0) {
                infoString.append("<i>*** PAPI counts ***</i><br>");
                for (int i = 0; i < this.numPapiCounts; ++i) {
                    infoString.append(MainWindow.runObject[this.data.myRun].getPerfCountNames()[i] + " = " + format_.format(this.papiCounts[i]) + "<br>");
                }
            }
        } else if (this.entry == -1) {
            infoString.append("<b>Idle Time</b><br><br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime) + "<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime) + "<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime) + "<br>");
        } else if (this.entry == -2) {
            infoString.append("<i>Unaccounted Time</i><br>");
            infoString.append("<i>Begin Time</i>: " + format_.format(this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuBegin) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>End Time</i>: " + format_.format(this.endTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + format_.format(this.cpuEnd) + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Total Time</i>: " + U.humanReadableString(this.endTime - this.beginTime));
            if (this.cpuTime > 0L) {
                infoString.append(" (" + this.cpuTime + ")");
            }
            infoString.append("<br>");
            infoString.append("<i>Packing</i>: " + U.humanReadableString(this.packtime));
            if (this.packtime > 0L) {
                infoString.append(" (" + 100.0f * (float)this.packtime / (float)(this.endTime - this.beginTime + 1L) + "%)");
            }
            infoString.append("<br>");
            int numMsgs = 0;
            if (this.messages != null) {
                numMsgs = this.messages.size();
            }
            infoString.append("<i>Num Msgs created</i>: " + numMsgs + "<br>");
        }
        if (this.userSuppliedData != null) {
            infoString.append("<i>User Supplied Parameter(timestep):</i> " + this.userSuppliedData + "<br>");
        }
        if (this.memoryUsage != 0L) {
            infoString.append("<i>Memory Usage:</i> " + this.memoryUsage / 1024L / 1024L + " MB<br>");
        }
        return "<html><body>" + infoString.toString() + "</html></body>";
    }

    private void drawLeftArrow(Graphics2D g, Paint c, int startY, int leftCoord, int h) {
        int[] xpts = new int[]{leftCoord + 5, leftCoord + 0, leftCoord + 5};
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setPaint(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setPaint(this.makeMoreLikeForeground(c));
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setPaint(this.makeMoreLikeBackground(c));
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    private void drawRightArrow(Graphics2D g, Paint c, int startY, int leftCoord, int h, int right) {
        int[] xpts = new int[]{leftCoord + right - 6, leftCoord + right, leftCoord + right - 6};
        int[] ypts = new int[]{startY, startY + h / 2, startY + h - 1};
        g.setPaint(c);
        g.fillPolygon(xpts, ypts, 3);
        g.setPaint(this.makeMoreLikeForeground(c));
        g.drawLine(xpts[0], ypts[0], xpts[1], ypts[1]);
        g.setPaint(this.makeMoreLikeBackground(c));
        g.drawLine(xpts[1], ypts[1], xpts[2], ypts[2]);
    }

    private Paint makeMoreLikeBackground(Paint c) {
        Color other = this.data.getBackgroundColor();
        if (c instanceof Color) {
            return this.mixColors((Color)c, other, 0.8f);
        }
        return c;
    }

    private Paint makeMoreLikeForeground(Paint c) {
        Color other = this.data.getForegroundColor();
        if (c instanceof Color) {
            return this.mixColors((Color)c, other, 0.8f);
        }
        return c;
    }

    private Color mixColors(Color a, Color b, float ratio) {
        float red = (float)((double)(ratio * (float)a.getRed()) + (1.0 - (double)ratio) * (double)b.getRed());
        float green = (float)((double)(ratio * (float)a.getGreen()) + (1.0 - (double)ratio) * (double)b.getGreen());
        float blue = (float)((double)(ratio * (float)a.getBlue()) + (1.0 - (double)ratio) * (double)b.getBlue());
        return new Color(red / 256.0f, green / 256.0f, blue / 256.0f);
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getEntryID() {
        return this.entry;
    }

    public int getEntryIndex() {
        return MainWindow.runObject[this.data.myRun].getEntryIndex(this.entry);
    }

    public ArrayList<TimelineMessage> getMessages() {
        return this.messages;
    }

    public float getNonPackUsage() {
        return (float)this.usage - this.packusage;
    }

    public int getNumMsgs() {
        if (this.messages == null) {
            return 0;
        }
        return this.messages.size();
    }

    public float getPackUsage() {
        return this.packusage;
    }

    public int getPCreation() {
        return this.pCreation;
    }

    public int getPCurrent() {
        return this.pe;
    }

    public float getUsage() {
        return (float)this.usage;
    }

    @Override
    public void mouseClicked(MouseEvent evt, JPanel parent, Data data) {
        if (this.entry >= 0) {
            if (evt.getModifiers() == 16) {
                if (data.traceMessagesBackOnHover() || data.traceMessagesForwardOnHover() || data.traceCriticalPathOnHover()) {
                    System.out.println("mouse left clicked ");
                    Set<EntryMethodObject> fwd = this.traceForwardDependencies();
                    Set<EntryMethodObject> back = this.traceBackwardDependencies();
                    Set<EntryMethodObject> criticalpath = this.traceCriticalPathDependencies();
                    HashSet<Object> fwdGeneric = new HashSet<Object>();
                    HashSet<Object> backGeneric = new HashSet<Object>();
                    HashSet<Object> criticalpathGeneric = new HashSet<Object>();
                    fwdGeneric.addAll(fwd);
                    backGeneric.addAll(back);
                    criticalpathGeneric.addAll(criticalpath);
                    data.addMessageSendLine(back);
                    data.addMessageSendLineAlt(fwd);
                    data.addMessageSendLine(criticalpath);
                    data.highlightObjects(fwdGeneric);
                    data.highlightObjects(backGeneric);
                    data.highlightObjects(criticalpathGeneric);
                    data.displayMustBeRepainted();
                } else {
                    data.clickTraceSender(this);
                }
            } else {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem(popupShowDetails);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupTraceSender);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupTracePath);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupChangeColor);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupDropPEsForObject);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(popupDropPEsForPE);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                menuItem = new JMenuItem(loadNeighbors);
                menuItem.addActionListener(this);
                popup.add(menuItem);
                popup.show(parent, evt.getX(), evt.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<EntryMethodObject> traceBackwardDependencies() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            int length = 0;
            HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
            if (this.data.traceMessagesBackOnHover()) {
                boolean done;
                EntryMethodObject obj = this;
                long max_time = 0L;
                long begin_max = 0L;
                do {
                    ++length;
                    done = true;
                    v.add(obj);
                    System.out.println("backward pe " + obj.pe + ", msg time=" + obj.beginTime + ", entry=" + obj.entry);
                    if (obj.entry == -1 || obj.pCreation > this.data.numPEs() || !((double)obj.endTime > this.data.leftSelectionTime())) continue;
                    this.data.addProcessor(obj.pCreation);
                    TimelineMessage created_message = obj.creationMessage();
                    if (created_message != null) {
                        if (obj.beginTime - created_message.Time > max_time) {
                            max_time = obj.beginTime - created_message.Time;
                            begin_max = created_message.Time;
                        }
                        if ((obj = this.data.messageStructures.getMessageToSendingObjectsMap().get(created_message)) != null) {
                            done = false;
                            continue;
                        }
                        System.out.println(" create object null");
                        continue;
                    }
                    System.out.println(" pcreation create_msg=null");
                    obj = this.data.getPreviousEntry(obj, obj.pe);
                    if (obj == null) continue;
                    done = false;
                } while (!done && length < 8);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<EntryMethodObject> traceForwardDependencies() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
            if (this.data.traceMessagesForwardOnHover()) {
                EntryMethodObject obj = this;
                ArrayList<TimelineMessage> tleMsg = this.TLmsgs;
                boolean done = false;
                v.add(obj);
                do {
                    done = true;
                    System.out.println(" forward pe " + obj.pe + ", msg time=" + obj.beginTime + ", entry=" + obj.entry + "forwarding msgs:" + tleMsg.size());
                    if (obj.entry == -1 || obj.pCreation > this.data.numPEs() || tleMsg == null || tleMsg.isEmpty()) continue;
                    for (int j = 0; j < tleMsg.size(); ++j) {
                        Iterator<EntryMethodObject> i;
                        Set<EntryMethodObject> objset;
                        TimelineMessage msgToCalledEntryMethod = tleMsg.get(j);
                        if (msgToCalledEntryMethod == null || (objset = this.data.messageStructures.getMessageToExecutingObjectsMap().get(msgToCalledEntryMethod)) == null || objset.isEmpty() || (obj = (i = objset.iterator()).next()) == null || obj == this) continue;
                        v.add(obj);
                    }
                } while (!done);
            }
            v.remove(this);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<EntryMethodObject> traceCriticalPathDependencies() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            int length = 0;
            HashSet<EntryMethodObject> v = new HashSet<EntryMethodObject>();
            if (this.data.traceCriticalPathOnHover()) {
                boolean done;
                EntryMethodObject obj = this;
                EntryMethodObject previous_obj = null;
                do {
                    ++length;
                    done = true;
                    v.add(obj);
                    System.out.println(" pe " + obj.pe + ", msg time=" + obj.beginTime + ", entry=" + obj.entry);
                    if (obj.entry == -1 || obj.pe > this.data.numPEs() || !((double)obj.endTime > this.data.leftSelectionTime())) continue;
                    previous_obj = this.data.getPreviousEntry(obj, obj.pe);
                    if (previous_obj != null && previous_obj.entry != -1) {
                        System.out.println("It has previous entry");
                        obj = previous_obj;
                        done = false;
                        continue;
                    }
                    this.data.addProcessor(obj.pCreation);
                    TimelineMessage created_message = obj.creationMessage();
                    if (created_message == null || (obj = this.data.messageStructures.getMessageToSendingObjectsMap().get(created_message)) == null) continue;
                    System.out.println("Switch to other processor");
                    done = false;
                } while (!done && length < 20);
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimelineMessage creationMessage() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            if (this.data == null) {
                return null;
            }
            if (this.pCreation < 0) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap() == null) {
                return null;
            }
            if (this.pCreation >= this.data.messageStructures.getEventIDToMessageMap().length) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap()[this.pCreation] == null) {
                return null;
            }
            return (TimelineMessage)this.data.messageStructures.getEventIDToMessageMap()[this.pCreation].get(this.EventID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimelineMessage currentMessage() {
        MessageStructures messageStructures = this.data.messageStructures;
        synchronized (messageStructures) {
            if (this.data == null) {
                return null;
            }
            if (this.pe < 0) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap() == null) {
                return null;
            }
            if (this.pe >= this.data.messageStructures.getEventIDToMessageMap().length) {
                return null;
            }
            if (this.data.messageStructures.getEventIDToMessageMap()[this.pe] == null) {
                return null;
            }
            return (TimelineMessage)this.data.messageStructures.getEventIDToMessageMap()[this.pe].get(this.EventID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseEntered(MouseEvent evt) {
        boolean needRepaint = false;
        if (this.data.traceOIDOnHover()) {
            MessageStructures messageStructures = this.data.messageStructures;
            synchronized (messageStructures) {
                Set allWithSameId = (Set)this.data.messageStructures.getOidToEntryMethodObjectsMap().get(this.tid);
                this.data.highlightObjects(allWithSameId);
                needRepaint = true;
            }
        }
        if (needRepaint) {
            this.data.displayMustBeRepainted();
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    private void OpenMessageWindow() {
        if (this.msgwindow == null) {
            this.msgwindow = new MessageWindow(this);
            Dimension d = this.msgwindow.getPreferredSize();
            this.msgwindow.setSize(480, d.width);
        }
        this.msgwindow.setVisible(true);
    }

    public boolean isIdleEvent() {
        return this.entry == -1;
    }

    public boolean isUnaccountedTime() {
        return this.entry == -2;
    }

    public boolean isDisplayed() {
        if (this.data.entryIsHiddenID(this.entry)) {
            return false;
        }
        if (this.isIdleEvent() && !this.data.showIdle()) {
            return false;
        }
        if (this.isIdleEvent() && MainWindow.IGNORE_IDLE) {
            return false;
        }
        return !this.data.entryIsHiddenID(this.getEntryID());
    }

    public void paintMe(Graphics2D g2d, int actualDisplayWidth) {
        int width;
        if (!this.isDisplayed()) {
            return;
        }
        if (this.isIdleEvent() && !this.data.showIdle()) {
            return;
        }
        if (this.isIdleEvent() && MainWindow.IGNORE_IDLE) {
            return;
        }
        if (this.data.entryIsHiddenID(this.getEntryID())) {
            return;
        }
        int leftCoord = this.data.timeToScreenPixel(this.beginTime, actualDisplayWidth);
        int rightCoord = this.data.timeToScreenPixel(this.endTime, actualDisplayWidth);
        if (this.endTime > this.data.endTime()) {
            rightCoord = this.data.timeToScreenPixelRight(this.data.endTime(), actualDisplayWidth);
        }
        if (this.beginTime < this.data.startTime()) {
            leftCoord = this.data.timeToScreenPixelLeft(this.data.startTime(), actualDisplayWidth);
        }
        if ((width = rightCoord - leftCoord + 1) < 1) {
            width = 1;
        }
        int topCoord = this.data.entryMethodLocationTop(this.pe);
        Paint c = this.determineColor();
        if (this.data.isObjectDimmed(this)) {
            c = this.isIdleEvent() ? Color.lightGray : this.makeMoreLikeBackground(c);
        }
        int rectWidth = width;
        int rectHeight = this.data.barheight();
        int verticalInset = 0;
        if (this.entryIndex == -1 && this.data.getViewType() != Data.ViewType.VIEW_SUPERCOMPACT) {
            rectHeight -= 7;
            verticalInset += 3;
        }
        int left = leftCoord + 0;
        int right = leftCoord + rectWidth - 1;
        if (this.beginTime < this.data.startTime()) {
            this.drawLeftArrow(g2d, c, topCoord + verticalInset, leftCoord, rectHeight);
            rectWidth -= 5;
            left += 5;
        }
        if (this.endTime > this.data.endTime()) {
            this.drawRightArrow(g2d, c, topCoord + verticalInset, leftCoord, rectHeight, rectWidth);
            rectWidth -= 5;
            right -= 5;
        }
        g2d.setPaint(c);
        if (rectWidth > 1 || this.entryIndex != -1) {
            g2d.fillRect(left, topCoord + verticalInset, rectWidth, rectHeight);
            if (this.isCommThdRecv) {
                g2d.setColor(this.data.getForegroundColor());
                g2d.fillRect(left, topCoord + verticalInset + rectHeight, rectWidth, this.data.smpMessageRecvBarHeight());
            }
        }
        if (rectWidth > 2 && !this.data.colorByMemoryUsage() && rectHeight > 1) {
            g2d.setPaint(this.makeMoreLikeForeground(c));
            g2d.drawLine(left, topCoord + verticalInset, right, topCoord + verticalInset);
            if (left == leftCoord) {
                g2d.drawLine(left, topCoord + verticalInset, left, topCoord + verticalInset + rectHeight - 1);
            }
            g2d.setPaint(this.makeMoreLikeBackground(c));
            g2d.drawLine(left, topCoord + verticalInset + rectHeight - 1, right, topCoord + verticalInset + rectHeight - 1);
            if (right == rectWidth - 1) {
                g2d.drawLine(right, topCoord + verticalInset, right, topCoord + verticalInset + rectHeight - 1);
            }
        }
        if (this.data.showPacks() && this.packs != null) {
            g2d.setColor(Color.pink);
            for (PackTime pt : this.packs) {
                long packBeginTime = pt.BeginTime;
                long packEndTime = pt.EndTime;
                if (packEndTime < this.data.startTime() || packBeginTime > this.data.endTime()) continue;
                int packBeginCoordX = this.data.timeToScreenPixelLeft(packBeginTime);
                int packEndCoordX = this.data.timeToScreenPixelRight(packEndTime);
                g2d.fillRect(packBeginCoordX, topCoord + verticalInset + rectHeight, packEndCoordX - packBeginCoordX + 1, this.data.messagePackHeight());
            }
        }
        if (this.data.showMsgs() && this.messages != null) {
            g2d.setColor(this.data.getForegroundColor());
            for (TimelineMessage msg : this.messages) {
                long msgtime = msg.Time;
                if (msgtime < this.data.startTime() || msgtime > this.data.endTime()) continue;
                int msgCoordX = this.data.timeToScreenPixel(msgtime);
                g2d.drawLine(msgCoordX, topCoord + verticalInset + rectHeight, msgCoordX, topCoord + verticalInset + rectHeight + this.data.messageSendHeight());
            }
        }
    }

    private Paint determineColor() {
        Color colToSave = null;
        if (this.isIdleEvent()) {
            return MainWindow.runObject[this.data.myRun].getIdleColor();
        }
        if (this.entryIndex == -2) {
            return MainWindow.runObject[this.data.myRun].getOverheadColor();
        }
        if (this.isFunction) {
            return MainWindow.runObject[this.data.myRun].getFunctionColor(this.entryIndex);
        }
        if (this.data.colorByMemoryUsage()) {
            float normalizedValue;
            colToSave = this.memoryUsage == 0L ? Color.darkGray : ((double)(normalizedValue = (float)(this.memoryUsage - this.data.minMemBColorRange()) / (float)(this.data.maxMemBColorRange() - this.data.minMemBColorRange())) < 0.0 || (double)normalizedValue > 1.0 ? Color.darkGray : Color.getHSBColor(0.6f - normalizedValue * 0.65f, 1.0f, 1.0f));
        }
        if (this.data.colorByUserSupplied() && this.data.colorSchemeForUserSupplied == Data.ColorScheme.BlueGradientColors) {
            if (this.userSuppliedData != null) {
                long value = this.userSuppliedData.longValue();
                float normalizedValue = (float)(value - this.data.minUserSupplied) / (float)(this.data.maxUserSupplied - this.data.minUserSupplied);
                colToSave = Color.getHSBColor(0.25f - normalizedValue * 0.75f, 1.0f, 1.0f);
            } else {
                colToSave = Color.darkGray;
            }
        }
        if (this.data.colorByOID() || this.data.colorByUserSupplied() || this.data.colorByEID()) {
            long color = 0L;
            if (this.data.colorByOID()) {
                int h1 = this.getTid().id[0] * 139 % 509;
                int h2 = this.getTid().id[1] * 101 % 1039;
                int h3 = this.getTid().id[2] * 67 % 1291;
                int h4 = this.getTid().id[3] * 2789 % 1721;
                color += (long)(h1 ^ h3 ^ h2 ^ h4);
            }
            if (this.data.colorByEID()) {
                color += (long)(this.entryIndex * 251 % 5113);
            }
            if (this.data.colorByUserSupplied() && this.userSuppliedData != null) {
                color += (long)(this.userSuppliedData * 359 % 4903);
            }
            if (this.data.colorByMemoryUsage() && this.memoryUsage != 0L) {
                color += this.memoryUsage * 6121L % 5953L;
            }
            float h2 = (float)((color + 512L) % 512L) / 256.0f;
            float h = (float)((color + 512L) % 512L) / 512.0f;
            float s = 1.0f;
            float b = 1.0f;
            if ((double)h2 > 1.0) {
                b = 0.6f;
            }
            colToSave = Color.getHSBColor(h, s, b);
        }
        if (colToSave == null) {
            return MainWindow.runObject[this.data.myRun].entryColors[this.entryIndex];
        }
        MainWindow.runObject[this.data.myRun].entryColors[this.entryIndex] = colToSave;
        return colToSave;
    }

    private void setPackUsage() {
        this.packtime = 0L;
        if (this.packs != null) {
            for (PackTime pt : this.packs) {
                this.packtime += pt.EndTime - pt.BeginTime;
                if (pt.BeginTime < this.data.startTime()) {
                    this.packtime -= this.data.startTime() - pt.BeginTime;
                }
                if (pt.EndTime <= this.data.endTime()) continue;
                this.packtime -= pt.EndTime - this.data.endTime();
            }
            this.packusage = this.packtime * 100L;
            this.packusage /= (float)(this.data.endTime() - this.data.startTime());
        }
    }

    private void setUsage() {
        if (this.entryIndex < -1) {
            return;
        }
        this.usage = this.endTime - this.beginTime;
        if (this.beginTime < this.data.startTime()) {
            this.usage -= (double)(this.data.startTime() - this.beginTime);
        }
        if (this.endTime > this.data.endTime()) {
            this.usage -= (double)(this.endTime - this.data.endTime());
        }
        this.usage /= (double)(this.data.endTime() - this.data.startTime());
        this.usage *= 100.0;
    }

    public int compareTo(Object o) {
        EntryMethodObject obj = (EntryMethodObject)o;
        if (this.pCreation != obj.pCreation) {
            return MiscUtil.sign(this.pCreation - obj.pCreation);
        }
        if (this.pe != obj.pe) {
            return MiscUtil.sign(this.pe - obj.pe);
        }
        return MiscUtil.sign(this.EventID - obj.EventID);
    }

    public ObjectId getTid() {
        return this.tid;
    }

    public boolean isCommThreadMsgRecv() {
        return this.isCommThdRecv;
    }

    @Override
    public void shiftTimesBy(long s) {
        this.beginTime += s;
        this.endTime += s;
        this.recvTime += s;
        this.cpuBegin += s;
        this.cpuEnd += s;
        if (this.messages != null) {
            for (TimelineMessage msg : this.messages) {
                msg.shiftTimesBy(s);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals(popupChangeColor)) {
                Color old = MainWindow.runObject[this.data.myRun].getEntryColor(this.entry);
                Color c = JColorChooser.showDialog(null, "Choose new color", old);
                if (c != null) {
                    MainWindow.runObject[this.data.myRun].setEntryColor(this.entry, c);
                    this.data.displayMustBeRepainted();
                }
            } else if (arg.equals(popupShowDetails)) {
                this.OpenMessageWindow();
            } else if (arg.equals(popupTraceSender)) {
                this.data.clickTraceSender(this);
            } else if (arg.equals(popupTracePath)) {
                this.data.clickTraceSender(this);
            } else if (arg.equals(popupDropPEsForObject)) {
                this.data.dropPEsUnrelatedToObject(this);
            } else if (arg.equals(popupDropPEsForPE)) {
                this.data.dropPEsUnrelatedToPE(this.pe);
            } else if (arg.equals(loadNeighbors)) {
                this.data.addNeighbors(this.pe);
            }
        }
    }

    public ArrayList<TimelineMessage> getTLmsgs() {
        return this.TLmsgs;
    }

    @Override
    public long lowerBound() {
        return this.beginTime;
    }

    @Override
    public long upperBound() {
        return this.endTime;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }
}

