/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Level;
import javax.swing.JPanel;
import projections.Tools.Timeline.Data;
import projections.gui.MainWindow;

class LabelPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Data data;
    private int clickedOnPE;
    private Point mouseLast;

    protected LabelPanel(Data data) {
        this.setOpaque(true);
        this.data = data;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.clickedOnPE = -1;
    }

    private int preferredWidth() {
        if (this.data.getViewType() == Data.ViewType.VIEW_MINIMAL) {
            return 60;
        }
        return 90;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth(), this.data.screenHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        long startTime2;
        long startTime = System.nanoTime();
        Data data = this.data;
        synchronized (data) {
            startTime2 = System.nanoTime();
            g.setFont(this.data.labelFont);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.data.getBackgroundColor());
            Rectangle clip = g.getClipBounds();
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            int upperRowToPaint = this.data.rowForPixel(clip.y);
            int lowerRowToPaint = this.data.rowForPixel(clip.y + clip.height - 1);
            block7: for (int verticalPosition = upperRowToPaint; verticalPosition <= lowerRowToPaint; ++verticalPosition) {
                int pe = this.data.whichPE(verticalPosition);
                if (pe <= -1) continue;
                switch (this.data.getViewType()) {
                    case VIEW_SUPERCOMPACT: {
                        continue block7;
                    }
                    case VIEW_MINIMAL: 
                    case VIEW_COMPACT: {
                        String peString;
                        if (this.clickedOnPE == pe) continue block7;
                        if (this.clickedOnPE >= 0 && verticalPosition == this.mouseLast.y / this.data.singleTimelineHeight()) {
                            g.setColor(Color.red);
                            peString = this.data.getPEString(this.clickedOnPE);
                            int stringWidth = fm.stringWidth(peString);
                            g.drawString(peString, this.preferredWidth() - stringWidth, fm.getHeight() / 2 + this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                            continue block7;
                        }
                        g.setColor(this.data.getForegroundColor());
                        peString = this.data.getPEString(pe);
                        int stringWidth = fm.stringWidth(peString);
                        g.drawString(peString, this.preferredWidth() - stringWidth, fm.getHeight() / 2 + this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        continue block7;
                    }
                    default: {
                        String peString;
                        if (this.clickedOnPE == pe) continue block7;
                        if (this.clickedOnPE >= 0 && verticalPosition == this.mouseLast.y / this.data.singleTimelineHeight()) {
                            g.setColor(Color.red);
                            peString = this.data.getPEString(this.clickedOnPE);
                            g.drawString(peString, 10, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                            String percentString = "(" + (int)(100.0f - this.data.idleUsage[this.clickedOnPE]) + ", " + (int)this.data.processorUsage[this.clickedOnPE] + ")";
                            g.drawString(percentString, 15, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight() + fm.getHeight() + 2);
                            continue block7;
                        }
                        g.setColor(this.data.getForegroundColor());
                        peString = this.data.getPEString(pe);
                        g.drawString(peString, 10, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight());
                        String percentString = "(?,?)";
                        if (this.data.idleUsage.length > pe && this.data.processorUsage.length > pe) {
                            percentString = "(" + (int)(100.0f - this.data.idleUsage[pe]) + ", " + (int)this.data.processorUsage[pe] + ")";
                        }
                        g.drawString(percentString, 15, this.data.singleTimelineHeight() / 2 + verticalPosition * this.data.singleTimelineHeight() + fm.getHeight() + 2);
                    }
                }
            }
        }
        long endTime = System.nanoTime();
        long duration1 = startTime2 - startTime;
        long duration2 = endTime - startTime2;
        MainWindow.performanceLogger.log(Level.INFO, "Time to paint Label Panel: " + duration2 / 1000000L + " ms. Time waiting to synchronize: " + duration1 / 1000000L + " ms");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseLast = e.getPoint();
        int whichLine = this.mouseLast.y / this.data.singleTimelineHeight();
        this.clickedOnPE = this.data.whichPE(whichLine);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        int whichLine = e.getPoint().y / this.data.singleTimelineHeight();
        this.data.movePEToLine(this.clickedOnPE, whichLine);
        this.clickedOnPE = -1;
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseLast = e.getPoint();
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }
}

