/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.Tools.Timeline.Data;

class MemoryColorRangeChooser
extends JFrame
implements ActionListener {
    private Data data;
    private JTextField minField;
    private JTextField maxField;

    MemoryColorRangeChooser(Data _data) {
        this.data = _data;
        this.createLayout();
    }

    private void createLayout() {
        this.setTitle("Specify a range for use in coloring the entry methods:");
        JPanel rangeChooserPanel = new JPanel();
        rangeChooserPanel.setLayout(new FlowLayout());
        JLabel minLabel = new JLabel("Minimum MB:");
        JLabel maxLabel = new JLabel("Maximum MB:");
        this.minField = new JTextField(7);
        this.maxField = new JTextField(7);
        this.minField.setText("" + this.data.minMemMB());
        this.maxField.setText("" + this.data.maxMemMB());
        JButton okButton = new JButton("Continue");
        okButton.addActionListener(this);
        rangeChooserPanel.add(minLabel);
        rangeChooserPanel.add(this.minField);
        rangeChooserPanel.add(maxLabel);
        rangeChooserPanel.add(this.maxField);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)rangeChooserPanel, "Center");
        p.add((Component)okButton, "South");
        this.setContentPane(p);
        this.pack();
        this.setVisible(true);
        this.setLocation(400, 400);
    }

    public void actionPerformed(ActionEvent e) {
        long userMin = Long.parseLong(this.minField.getText());
        long userMax = Long.parseLong(this.maxField.getText());
        this.data.setMemColorRange(userMin * 1024L * 1024L, userMax * 1024L * 1024L);
        this.data.finalizeColorByMemoryUsage();
        this.dispose();
    }
}

