/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import projections.Tools.Timeline.Data;
import projections.gui.JPanelToImage;

class MemoryLegend
implements MouseListener {
    private BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);

    MemoryLegend(Data data) {
        Graphics2D g = this.image.createGraphics();
        FontMetrics fm = g.getFontMetrics();
        g.setColor(data.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int i = this.barLeftMargin(); i < this.getWidth() - this.barRightMargin(); ++i) {
            float normalizedValue = (float)(i - this.barLeftMargin()) / (float)(this.getWidth() - this.barRightMargin() - this.barLeftMargin());
            Color c = Color.getHSBColor(0.6f - normalizedValue * 0.65f, 1.0f, 1.0f);
            g.setColor(c);
            g.fillRect(i, this.barTopMargin(), 1, this.getHeight() - this.barTopMargin() - this.barBottomMargin());
        }
        g.setColor(data.getForegroundColor());
        Font numberFont = new Font("SansSerif", 0, 15);
        g.setFont(numberFont);
        int numLabels = 4;
        int pxBetweenLabels = (this.getWidth() - this.barRightMargin() - this.barLeftMargin()) / (numLabels - 1);
        float memUsageBetweenLabels = (data.maxMemBColorRange() - data.minMemBColorRange()) / (long)(numLabels - 1);
        for (int j = 0; j < numLabels; ++j) {
            float memUsageB = (float)data.minMemBColorRange() + (float)j * memUsageBetweenLabels;
            int memUsageMB = (int)(memUsageB / 1024.0f / 1024.0f);
            String s = "" + memUsageMB + " MB";
            int x = this.barLeftMargin() + j * pxBetweenLabels;
            int xtext = x - fm.stringWidth(s) / 2;
            g.drawString(s, xtext, this.bottomLabelBaseline());
            g.fillRect(x - 1, this.getHeight() - this.barBottomMargin(), 3, 7);
        }
        Font legendFont = new Font("SansSerif", 0, 30);
        g.setColor(data.getForegroundColor());
        g.setFont(legendFont);
        g.drawString("Legend:", 10, this.getHeight() / 2 + legendFont.getSize() / 2);
        ImageIcon imageIcon = new ImageIcon(this.image);
        JFrame f = new JFrame();
        JLabel l = new JLabel(imageIcon);
        l.addMouseListener(this);
        f.getContentPane().add(l);
        f.pack();
        f.setVisible(true);
        g.dispose();
    }

    private int barTopMargin() {
        return 20;
    }

    private int barBottomMargin() {
        return 40;
    }

    private int barLeftMargin() {
        return 175;
    }

    private int barRightMargin() {
        return 75;
    }

    private int bottomLabelBaseline() {
        return this.getHeight() - 10;
    }

    private int getWidth() {
        return 600;
    }

    private int getHeight() {
        return 100;
    }

    public void mouseClicked(MouseEvent e) {
        JPanelToImage.saveToFileChooserSelection(this.image, "Save Legend To PNG or JPG", "TimelineLegend.png");
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

