/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.ThreadMessageStructures;
import projections.Tools.Timeline.TimelineMessage;
import projections.analysis.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageStructures {
    private Data data;
    private Map<Integer, TimelineMessage>[] eventIDToMessageMap;
    private Map<Integer, EntryMethodObject>[] eventIDToEntryMethodMap;
    private Map<TimelineMessage, Set<EntryMethodObject>> messageToExecutingObjectsMap;
    private Map<TimelineMessage, EntryMethodObject> messageToSendingObjectsMap;
    private Map<ObjectId, List<EntryMethodObject>> oidToEntryMethodObjectsMap;
    private ThreadMessageStructures secondaryWorkers;

    protected MessageStructures(Data data) {
        this.data = data;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MessageStructures messageStructures = this;
        synchronized (messageStructures) {
            int i;
            int pe = this.data.numPEs();
            this.eventIDToMessageMap = new HashMap[pe];
            for (i = 0; i < pe; ++i) {
                this.eventIDToMessageMap[i] = new HashMap<Integer, TimelineMessage>();
            }
            this.eventIDToEntryMethodMap = new HashMap[pe];
            for (i = 0; i < pe; ++i) {
                this.eventIDToEntryMethodMap[i] = new HashMap<Integer, EntryMethodObject>();
            }
            this.messageToSendingObjectsMap = new HashMap<TimelineMessage, EntryMethodObject>();
            this.messageToExecutingObjectsMap = new HashMap<TimelineMessage, Set<EntryMethodObject>>();
            this.oidToEntryMethodObjectsMap = new TreeMap<ObjectId, List<EntryMethodObject>>();
        }
    }

    protected void create(boolean useSeparateThread) {
        this.init();
        this.secondaryWorkers = new ThreadMessageStructures(this);
        if (useSeparateThread) {
            this.secondaryWorkers.setPriority(1);
            this.secondaryWorkers.start();
        } else {
            this.generate(null);
        }
    }

    public void setEventIDToMessageMap(Map[] eventIDToMessageMap) {
        this.eventIDToMessageMap = eventIDToMessageMap;
    }

    public Map[] getEventIDToMessageMap() {
        return this.eventIDToMessageMap;
    }

    public Map<TimelineMessage, EntryMethodObject> getMessageToSendingObjectsMap() {
        return this.messageToSendingObjectsMap;
    }

    public void setOidToEntryMethodObjectsMap(Map oidToEntryMethodObjectsMap) {
        this.oidToEntryMethodObjectsMap = oidToEntryMethodObjectsMap;
    }

    public Map getOidToEntryMethodObjectsMap() {
        return this.oidToEntryMethodObjectsMap;
    }

    public void setEventIDToEntryMethodMap(Map[] eventIDToEntryMethodMap) {
        this.eventIDToEntryMethodMap = eventIDToEntryMethodMap;
    }

    public Map[] getEventIDToEntryMethodMap() {
        return this.eventIDToEntryMethodMap;
    }

    public void setMessageToExecutingObjectsMap(Map<TimelineMessage, Set<EntryMethodObject>> messageToExecutingObjectsMap) {
        this.messageToExecutingObjectsMap = messageToExecutingObjectsMap;
    }

    public Map<TimelineMessage, Set<EntryMethodObject>> getMessageToExecutingObjectsMap() {
        return this.messageToExecutingObjectsMap;
    }

    public void setMessageToSendingObjectsMap(Map<TimelineMessage, EntryMethodObject> messageToSendingObjectsMap) {
        this.messageToSendingObjectsMap = messageToSendingObjectsMap;
    }

    protected void kill() {
        if (this.secondaryWorkers != null) {
            this.secondaryWorkers.stopThread();
            this.secondaryWorkers = null;
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(ThreadMessageStructures structures) {
        Query1D<EntryMethodObject> objs;
        Object pe;
        Iterator<Integer> pe_iter = this.data.allEntryMethodObjects.keySet().iterator();
        while (pe_iter.hasNext()) {
            if (structures != null) {
                ThreadMessageStructures threadMessageStructures = structures;
                synchronized (threadMessageStructures) {
                    if (structures.stop) {
                        return;
                    }
                }
            }
            pe = pe_iter.next();
            for (EntryMethodObject obj : this.data.allEntryMethodObjects.get(pe)) {
                if (obj.messages == null) continue;
                for (TimelineMessage timelineMessage : obj.messages) {
                    this.getEventIDToMessageMap()[(Integer)pe].put(timelineMessage.EventID, timelineMessage);
                }
            }
        }
        pe_iter = this.data.allEntryMethodObjects.keySet().iterator();
        while (pe_iter.hasNext()) {
            if (structures != null) {
                pe = structures;
                synchronized (pe) {
                    if (structures.stop) {
                        return;
                    }
                }
            }
            pe = pe_iter.next();
            objs = this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                this.getEventIDToEntryMethodMap()[(Integer)pe].put(obj.EventID, obj);
            }
        }
        pe_iter = this.data.allEntryMethodObjects.keySet().iterator();
        while (pe_iter.hasNext()) {
            if (structures != null) {
                pe = structures;
                synchronized (pe) {
                    if (structures.stop) {
                        return;
                    }
                }
            }
            pe = pe_iter.next();
            objs = this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                if (obj.messages == null) continue;
                for (TimelineMessage msg : obj.messages) {
                    this.getMessageToSendingObjectsMap().put(msg, obj);
                }
            }
        }
        pe_iter = this.data.allEntryMethodObjects.keySet().iterator();
        while (pe_iter.hasNext()) {
            if (structures != null) {
                pe = structures;
                synchronized (pe) {
                    if (structures.stop) {
                        return;
                    }
                }
            }
            pe = pe_iter.next();
            objs = this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                TimelineMessage timelineMessage = obj.creationMessage();
                if (timelineMessage == null) continue;
                if (this.getMessageToExecutingObjectsMap().containsKey(timelineMessage)) {
                    Set<EntryMethodObject> o = this.getMessageToExecutingObjectsMap().get(timelineMessage);
                    TreeSet ts = (TreeSet)o;
                    ts.add(obj);
                    continue;
                }
                TreeSet<EntryMethodObject> ts = new TreeSet<EntryMethodObject>();
                ts.add(obj);
                this.getMessageToExecutingObjectsMap().put(timelineMessage, ts);
            }
        }
        pe_iter = this.data.allEntryMethodObjects.keySet().iterator();
        while (pe_iter.hasNext()) {
            if (structures != null) {
                pe = structures;
                synchronized (pe) {
                    if (structures.stop) {
                        return;
                    }
                }
            }
            pe = pe_iter.next();
            objs = this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                TreeSet s;
                if (obj == null) continue;
                ObjectId objectId = obj.getTid();
                if (this.getOidToEntryMethodObjectsMap().containsKey(objectId)) {
                    s = (TreeSet)this.getOidToEntryMethodObjectsMap().get(objectId);
                    s.add(obj);
                    continue;
                }
                s = new TreeSet();
                s.add(obj);
                this.getOidToEntryMethodObjectsMap().put(objectId, s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        MessageStructures messageStructures = this;
        synchronized (messageStructures) {
            int i;
            int pe = this.eventIDToMessageMap.length;
            for (i = 0; i < pe; ++i) {
                this.eventIDToMessageMap[i].clear();
            }
            for (i = 0; i < pe; ++i) {
                this.eventIDToEntryMethodMap[i].clear();
            }
            this.messageToSendingObjectsMap.clear();
            this.messageToExecutingObjectsMap.clear();
            this.oidToEntryMethodObjectsMap.clear();
        }
    }
}

