/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline.RangeQueries;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.RangeQueries.Range1D;
import projections.Tools.Timeline.RangeQueries.RangeQueryArrayList;
import projections.Tools.Timeline.RangeQueries.RangeQueryTree;

public class UnitTest {
    Random random;

    public static void main(String[] args) {
        UnitTest t = new UnitTest();
        boolean success = true;
        int count = 0;
        while (success && count++ < 50) {
            success = t.doTest(count);
        }
        if (success) {
            System.out.println("Unit Test Passed for projections.Tools.Timeline.RangeQueryDatabase");
        } else {
            System.out.println("Unit Test Failed for projections.Tools.Timeline.RangeQueryDatabase");
        }
    }

    public boolean doTest(int seed) {
        System.out.println("==================================== seed=" + seed);
        this.random = new Random(seed);
        RangeQueryTree.MAX_ENTRIES_PER_NODE = (int)(2.0 + this.random.nextDouble() * 500.0);
        RangeQueryArrayList db = new RangeQueryArrayList();
        RangeQueryTree db2 = new RangeQueryTree();
        return this.testQuery1D(db) && this.testQuery1D(db2);
    }

    public boolean testQuery1D(Query1D db) {
        int size;
        int i;
        long expectedCount;
        long ub;
        int j;
        int i2;
        System.out.println("Starting test for " + db);
        db.add(new TestRange1DObject(10L, 20L));
        db.add(new TestRange1DObject(30L, 40L));
        db.add(new TestRange1DObject(50L, 60L));
        db.add(new TestRange1DObject(70L, 80L));
        db.add(new TestRange1DObject(90L, 100L));
        db.add(new TestRange1DObject(110L, 120L));
        if (db.size() != 6) {
            return false;
        }
        int count = 0;
        for (Object o : db) {
            ++count;
        }
        if (count != 6) {
            return false;
        }
        System.out.println("Test 10 passed for " + db);
        db.clear();
        db.add(new TestRange1DObject(10L, 20L));
        db.add(new TestRange1DObject(30L, 40L));
        db.add(new TestRange1DObject(50L, 60L));
        db.add(new TestRange1DObject(70L, 80L));
        db.add(new TestRange1DObject(90L, 100L));
        db.add(new TestRange1DObject(110L, 120L));
        if (db instanceof RangeQueryTree && !((RangeQueryTree)db).root.verifyTreeCorrectness()) {
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        if (db.size() != 6) {
            return false;
        }
        Iterator iter = db.iterator(35L, 95L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 4) {
            return false;
        }
        System.out.println("Test 20 passed for " + db);
        db.clear();
        db.add(new TestRange1DObject(110L, 120L));
        db.add(new TestRange1DObject(90L, 100L));
        db.add(new TestRange1DObject(70L, 80L));
        db.add(new TestRange1DObject(50L, 60L));
        db.add(new TestRange1DObject(30L, 40L));
        db.add(new TestRange1DObject(10L, 20L));
        count = 0;
        iter = db.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 6) {
            return false;
        }
        System.out.println("Test 30 passed for " + db);
        count = 0;
        iter = db.iterator(35L, 95L);
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 4) {
            return false;
        }
        System.out.println("Test 40 passed for " + db);
        db.clear();
        db.add(new TestRange1DObject(70L, 80L));
        db.add(new TestRange1DObject(110L, 120L));
        db.add(new TestRange1DObject(90L, 100L));
        db.add(new TestRange1DObject(10L, 20L));
        db.add(new TestRange1DObject(50L, 60L));
        db.add(new TestRange1DObject(30L, 40L));
        iter = db.iterator(10L, 20L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 1) {
            return false;
        }
        System.out.println("Test 50 passed for " + db);
        iter = db.iterator(15L, 16L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 1) {
            return false;
        }
        System.out.println("Test 60 passed for " + db);
        db.clear();
        int n = 10000;
        for (i2 = 0; i2 < n; ++i2) {
            long lb = (long)(this.random.nextDouble() * 94.0);
            db.add(new TestRange1DObject(lb, lb + 5L));
            if (!(db instanceof RangeQueryTree) || ((RangeQueryTree)db).root.verifyTreeCorrectness()) continue;
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        iter = db.iterator(1000L, 2000L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 0) {
            return false;
        }
        iter = db.iterator(-1000L, -1L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != 0) {
            return false;
        }
        iter = db.iterator(0L, 100L);
        count = 0;
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        if (count != n) {
            return false;
        }
        db.clear();
        for (i2 = 0; i2 < 100; ++i2) {
            TestRange1DObject o = new TestRange1DObject(i2, i2);
            db.add(o);
            if (db.contains(o)) continue;
            System.err.println("Failure: data structure does not contain newly added entry: " + o);
            return false;
        }
        for (j = 0; j < 1000; ++j) {
            long lb = (long)(this.random.nextDouble() * 40.0);
            ub = (long)((double)lb + this.random.nextDouble() * 40.0);
            expectedCount = ub - lb + 1L;
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        for (j = 0; j < 1000; ++j) {
            long lb;
            ub = lb = (long)(this.random.nextDouble() * 40.0);
            expectedCount = 1L;
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        for (j = 0; j < 1000; ++j) {
            long lb = (long)(this.random.nextDouble() * 40.0);
            ub = lb + 1L;
            expectedCount = 2L;
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        for (i2 = 0; i2 < 100; ++i2) {
            db.add(new TestRange1DObject(i2, i2));
        }
        for (j = 0; j < 1000; ++j) {
            long lb = (long)(this.random.nextDouble() * 40.0);
            ub = (long)((double)lb + this.random.nextDouble() * 40.0);
            expectedCount = 2L * (ub - lb + 1L);
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        for (j = 0; j < 1000; ++j) {
            long lb;
            ub = lb = (long)(this.random.nextDouble() * 40.0);
            expectedCount = 2L;
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        for (j = 0; j < 1000; ++j) {
            long lb = (long)(this.random.nextDouble() * 40.0);
            ub = lb + 1L;
            expectedCount = 4L;
            iter = db.iterator(lb, ub);
            count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            if ((long)count == expectedCount) continue;
            return false;
        }
        if (db instanceof RangeQueryTree && !((RangeQueryTree)db).root.verifyTreeCorrectness()) {
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        for (Object o : db) {
            if (o != null) continue;
            System.err.println("Failure: db contains a null value");
            return false;
        }
        db.clear();
        for (int i3 = 0; i3 < 100; ++i3) {
            db.add(new TestRange1DObject(i3, i3));
        }
        if (db instanceof RangeQueryTree && !((RangeQueryTree)db).root.verifyTreeCorrectness()) {
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        for (i = size = db.size(); i > 0; --i) {
            iter = db.iterator();
            Object o = iter.next();
            if (db instanceof RangeQueryTree && !((RangeQueryTree)db).root.verifyTreeCorrectness()) {
                System.out.println("Verifying tree correctness FAILED");
                return false;
            }
            if (o == null) {
                System.err.println("Failure iterator returned a NULL object: db.size()=" + db.size() + " o=" + o + " i=" + i);
                return false;
            }
            if (!db.remove(o) || db.size() != i - 1) {
                System.err.println("Failure: db.size()=" + db.size() + " (should be " + (i - 1) + ") o=" + o + " i=" + i);
                if (db.contains(o)) {
                    System.err.println("Failure: data structure still contains removed entry: " + o);
                    if (db instanceof RangeQueryTree) {
                        ((RangeQueryTree)db).printTree();
                    }
                    return false;
                }
                return false;
            }
            if (!(db instanceof RangeQueryTree) || ((RangeQueryTree)db).root.verifyTreeCorrectness()) continue;
            System.out.println("Verifying tree correctness FAILED");
            return false;
        }
        System.out.println("Test 60 passed for " + db);
        db.clear();
        n = 1000;
        for (i = 0; i < n; ++i) {
            long lb = (long)(Math.pow(this.random.nextDouble() * 5.0 - 3.0, 3.0) * 100.0);
            db.add(new TestRange1DObject(lb, lb + 5L));
            count = 0;
            for (Object e : db) {
                ++count;
            }
            if (count != i + 1 || count != db.size() || db.size() != i + 1) {
                System.out.println("FAILURE: There should be " + (i + 1) + " entries in the structure, but iterator produced " + count + " and data structure thinks it is " + db.size());
                return false;
            }
            if (!(db instanceof RangeQueryTree) || ((RangeQueryTree)db).root.verifyTreeCorrectness()) continue;
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        System.out.println("Test 70 passed for " + db);
        db.clear();
        n = (int)(this.random.nextDouble() * 5000.0);
        int m = (int)(this.random.nextDouble() * (double)n);
        int l = (int)(this.random.nextDouble() * (double)n);
        LinkedList<TestRange1DObject> toRemove = new LinkedList<TestRange1DObject>();
        for (int i4 = 0; i4 < n; ++i4) {
            long lb = (long)(Math.pow(this.random.nextDouble() * 5.0 - 3.0, 3.0) * 100.0 + 3000.0);
            db.add(new TestRange1DObject(lb, lb + 5L));
        }
        if (db.removeAll(new LinkedList())) {
            System.out.println("FAILURE: removeAll() should have returned false for " + db);
        }
        count = 0;
        for (Object e : db) {
            TestRange1DObject o = (TestRange1DObject)e;
            if (toRemove.size() >= m || ++count <= l) continue;
            toRemove.add(o);
        }
        boolean result = db.removeAll(toRemove);
        if (!result && toRemove.size() > 0) {
            System.out.println("FAILURE: removeAll() should have returned true for " + db);
            if (db instanceof RangeQueryTree) {
                ((RangeQueryTree)db).printTree();
            }
            return false;
        }
        for (TestRange1DObject o : toRemove) {
            if (!db.contains(o)) continue;
            System.err.println("Failure: data structure still contains removed (via removeAll) entry: " + o);
            return false;
        }
        count = 0;
        for (Object e : db) {
            ++count;
        }
        if (db instanceof RangeQueryTree && !((RangeQueryTree)db).root.verifyTreeCorrectness()) {
            System.out.println("Verifying tree correctness FAILED. The bad tree is thus:");
            ((RangeQueryTree)db).printTree();
            return false;
        }
        if (count != n - toRemove.size() || count != db.size() || db.size() != n - toRemove.size()) {
            System.out.println("FAILURE: There should be " + (n - toRemove.size()) + " entries in the structure, but iterator produced " + count + " and data structure thinks it is " + db.size());
            if (db instanceof RangeQueryTree) {
                ((RangeQueryTree)db).printTree();
            }
            return false;
        }
        System.out.println("Test 80 passed for " + db);
        System.out.println("\n\n");
        return true;
    }

    public class TestRange1DObject
    implements Range1D {
        long lb;
        long ub;

        public long lowerBound() {
            return this.lb;
        }

        public long upperBound() {
            return this.ub;
        }

        public TestRange1DObject(long l, long u) {
            this.lb = l;
            this.ub = u;
        }

        public String toString() {
            return "(" + this.lb + "," + this.ub + ") ";
        }

        public void shiftTimesBy(long s) {
            this.lb += s;
            this.ub += s;
        }
    }
}

