/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import projections.gui.JIntTextField;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.RangeDialogExtensionPanel;
import projections.gui.TimeTextField;

class TimlineRangeDialogExtension
extends RangeDialogExtensionPanel
implements ItemListener,
ActionListener {
    protected JCheckBox dialogEnableEntryFiltering;
    protected TimeTextField dialogMinEntryFiltering;
    protected JCheckBox dialogEnableMsgFiltering;
    protected JCheckBox dialogEnableUserEventFiltering;
    protected JCheckBox dialogEnableTopTimes;
    protected JIntTextField dialogAmountTopTimes;
    protected JButton dialogAdjustRanges;
    protected RangeDialog parent;
    private int myRun = 0;

    public TimlineRangeDialogExtension() {
        TimlineRangeDialogExtension p = this;
        p.setLayout(new BoxLayout(p, 3));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 2));
        this.dialogEnableEntryFiltering = new JCheckBox();
        p1.add(this.dialogEnableEntryFiltering);
        p1.add(new JLabel("Filter out entries shorter than"));
        this.dialogMinEntryFiltering = new TimeTextField("30us", 7);
        this.dialogMinEntryFiltering.setEditable(false);
        p1.add(this.dialogMinEntryFiltering);
        p1.add(Box.createHorizontalStrut(200));
        p1.add(Box.createHorizontalGlue());
        this.dialogEnableEntryFiltering.addItemListener(this);
        this.dialogEnableMsgFiltering = new JCheckBox("Filter out messages");
        this.dialogEnableUserEventFiltering = new JCheckBox("Filter out user events");
        this.dialogAdjustRanges = new JButton("Adjust ranges to show useful information");
        this.dialogAdjustRanges.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 2));
        this.dialogEnableTopTimes = new JCheckBox();
        p2.add(this.dialogEnableTopTimes);
        p2.add(new JLabel("Highlight the top "));
        this.dialogAmountTopTimes = new JIntTextField(10, 5);
        this.dialogAmountTopTimes.setEditable(false);
        p2.add(this.dialogAmountTopTimes);
        p2.add(new JLabel(" longest idle and entry times"));
        p2.add(Box.createHorizontalStrut(200));
        p2.add(Box.createHorizontalGlue());
        this.dialogEnableTopTimes.addItemListener(this);
        p.add(p1);
        p.add(new LeftAlignedPanel(this.dialogEnableMsgFiltering));
        p.add(new LeftAlignedPanel(this.dialogEnableUserEventFiltering));
        p.add(p2);
        p.add(new LeftAlignedPanel(this.dialogAdjustRanges));
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.dialogEnableEntryFiltering) {
            this.dialogMinEntryFiltering.setEditable(this.dialogEnableEntryFiltering.isSelected());
        }
        if (evt.getSource() == this.dialogEnableTopTimes) {
            this.dialogAmountTopTimes.setEditable(this.dialogEnableTopTimes.isSelected());
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.dialogAdjustRanges) {
            long adjustedTime = MainWindow.runObject[this.myRun].findEarliestBeginEventTime(this.parent.getSelectedProcessors(), MainWindow.runObject[this.myRun].getValidProcessorList());
            if (this.parent.getStartTime() < adjustedTime) {
                this.parent.setStartTime(adjustedTime);
            }
            adjustedTime = MainWindow.runObject[this.myRun].findLatestEndEventTime(this.parent.getSelectedProcessors(), MainWindow.runObject[this.myRun].getValidProcessorList());
            if (this.parent.getEndTime() > adjustedTime) {
                this.parent.setEndTime(adjustedTime);
            }
        }
    }

    public void setParentDialogBox(RangeDialog parent) {
        this.parent = parent;
    }

    public boolean isInputValid() {
        return true;
    }

    public void setInitialFields() {
    }

    public void updateFields() {
    }

    private class LeftAlignedPanel
    extends JPanel {
        private LeftAlignedPanel(JComponent c) {
            this.setLayout(new BoxLayout(this, 2));
            this.add(c);
            this.add(Box.createHorizontalGlue());
        }
    }
}

