/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MainPanel;
import projections.Tools.Timeline.RangeQueries.Range1D;
import projections.gui.MainWindow;
import projections.misc.MiscUtil;

public class UserEventObject
implements Comparable,
Range1D,
ActionListener,
MainPanel.SpecialMouseHandler {
    private static int myRun = 0;
    public static final int SINGLE = 1;
    public static final int PAIR = 2;
    protected Type type;
    public long beginTime;
    public long endTime;
    public int userEventID;
    public int charmEventID;
    private int pe;
    private String note = null;
    private static final String popupChangeColor = "Change Color";
    private int nestedRow;
    Data dataForLastClick;

    public UserEventObject(int pe, long t, int e, int event, Type type) {
        this.type = type;
        this.beginTime = this.endTime = t;
        this.userEventID = e;
        this.charmEventID = event;
        this.pe = pe;
    }

    public UserEventObject(int pe, long t, String note) {
        this.beginTime = this.endTime = t;
        this.pe = pe;
        this.note = note;
        this.userEventID = -1;
    }

    public UserEventObject(int pe, long t, int e, int event, Type type, String note) {
        this.type = type;
        this.beginTime = this.endTime = t;
        this.userEventID = e;
        this.charmEventID = event;
        this.pe = pe;
        this.note = note;
    }

    public String getName() {
        String name = "";
        boolean addNewline = false;
        String userEventName = MainWindow.runObject[myRun].getUserEventName(this.userEventID);
        if (userEventName != null) {
            name = name + userEventName;
            addNewline = true;
        }
        if (this.note != null) {
            if (addNewline) {
                name = name + "\n";
            }
            name = name + this.note;
        }
        return name;
    }

    protected Color getColor(Data data) {
        Color c = MainWindow.runObject[myRun].getUserEventColor(this.userEventID);
        if (c != null) {
            return c;
        }
        return data.getForegroundColor();
    }

    protected void paintMe(Graphics2D g, int actualDisplayWidth, Data data) {
        int width;
        if (data.userEventIsHiddenID(this.userEventID)) {
            return;
        }
        int leftCoord = data.timeToScreenPixel(this.beginTime, actualDisplayWidth);
        int rightCoord = data.timeToScreenPixel(this.endTime, actualDisplayWidth);
        if (this.endTime > data.endTime()) {
            rightCoord = data.timeToScreenPixelRight(data.endTime(), actualDisplayWidth);
        }
        if (this.beginTime < data.startTime()) {
            leftCoord = data.timeToScreenPixelLeft(data.startTime(), actualDisplayWidth);
        }
        if ((width = rightCoord - leftCoord + 1) < 1) {
            width = 1;
        }
        int topCoord = data.userEventLocationBottom(this.pe) - (1 + this.nestedRow) * data.singleUserEventRectHeight();
        int height = data.singleUserEventRectHeight();
        int bottomCoord = topCoord + height - 1;
        Color c = this.getColor(data);
        g.setColor(c);
        g.fillRect(leftCoord, topCoord, width, height);
        if (width > 1) {
            g.setColor(c.brighter());
            g.drawLine(leftCoord, topCoord, leftCoord, bottomCoord);
            g.setColor(c.darker());
            g.drawLine(rightCoord, topCoord, rightCoord, bottomCoord);
        }
        if (this.getName() != null) {
            int leftpad = 3;
            int rightpad = 3;
            int toppad = 1;
            int bottompad = 1;
            int fontsize = height - toppad - bottompad;
            g.setFont(data.labelFont);
            FontMetrics fm = g.getFontMetrics();
            int stringWidth = fm.stringWidth(this.getName());
            if (fontsize >= 9 && stringWidth < width - leftpad - rightpad) {
                g.setColor(Color.black);
                g.drawString(this.getName(), leftCoord + leftpad, topCoord + toppad + fontsize);
            }
        }
    }

    public String getToolTipText() {
        if (this.note == null) {
            return "<html><body><p><i>User Traced Event:</i> <b>" + this.getName() + "</b></p><p><i>Duration:</i> " + (this.endTime - this.beginTime) + " us</p><p><i>event:</i> " + this.userEventID + "</p><p><i>occurred on PE:</i> " + this.pe + "</p></html></body>";
        }
        if (this.endTime - this.beginTime <= 0L) {
            return "<html><body><p><i>User Supplied Note:</i></p><p></p>" + this.note + "</html></body>";
        }
        return "<html><body><p><i>User Supplied Note:</i></p><p></p>" + this.note + "<p><i>Duration</i>: " + (this.endTime - this.beginTime) + "us</p></html></body>";
    }

    public void shiftTimesBy(long shift) {
        this.beginTime += shift;
        this.endTime += shift;
    }

    public int compareTo(Object o) {
        UserEventObject ueo = (UserEventObject)o;
        if (this.pe != ueo.pe) {
            return this.pe - ueo.pe;
        }
        if (this.beginTime != ueo.beginTime) {
            return MiscUtil.sign(this.beginTime - ueo.beginTime);
        }
        if (this.endTime != ueo.endTime) {
            return MiscUtil.sign(ueo.endTime - this.endTime);
        }
        if (this != ueo) {
            return MiscUtil.sign(this.userEventID - ueo.userEventID);
        }
        System.err.println("ERROR: compareTo not working correctly for class UserEventObject");
        return 0;
    }

    public void setNestedRow(int row) {
        this.nestedRow = row;
    }

    public void mouseClicked(MouseEvent evt, JPanel parent, Data data) {
        this.dataForLastClick = data;
        if (evt.getModifiers() != 16) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(popupChangeColor);
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.show(parent, evt.getX(), evt.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Color c;
        String arg;
        if (e.getSource() instanceof JMenuItem && (arg = ((JMenuItem)e.getSource()).getText()).equals(popupChangeColor) && (c = JColorChooser.showDialog(null, "Choose color for " + this.getName(), this.getColor(this.dataForLastClick))) != null) {
            MainWindow.runObject[myRun].setUserEventColor(this.userEventID, c);
            this.dataForLastClick.displayMustBeRepainted();
        }
    }

    public long lowerBound() {
        return this.beginTime;
    }

    public long upperBound() {
        return this.endTime;
    }

    public void mouseMoved(MouseEvent evt) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SINGLE,
        PAIR;

    }
}

