/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.UserEventObject;
import projections.gui.FormattedNumber;
import projections.gui.count.TableSorter;

class UserEventWindow
extends JFrame {
    private Color BACKGROUND = Color.black;
    private Color FOREGROUND = Color.white;
    Data data;
    private static DecimalFormat format_;
    private JCheckBox checkbox_;
    private Object[][] events_ = null;
    private Integer[] pes;
    private JTabbedPane tabbedPane_ = new JTabbedPane();
    private TableSorter[] sorter_ = null;
    private DefaultTableCellRenderer rightJustify_ = new DefaultTableCellRenderer();

    public void setData(Data data) {
        this.data = data;
        if (data.numPs() <= 100) {
            this.events_ = new Object[data.numPs()][];
            this.pes = new Integer[data.numPs()];
            int pindex = 0;
            for (Map.Entry<Integer, Query1D<UserEventObject>> e : data.allUserEventObjects.entrySet()) {
                Integer pe = e.getKey();
                Query1D<UserEventObject> userEventsForPe = e.getValue();
                this.events_[pindex] = userEventsForPe.toArray();
                this.pes[pindex] = pe;
                ++pindex;
            }
            super.getContentPane().removeAll();
            this.tabbedPane_.removeAll();
            if (this.events_.length > 1) {
                super.getContentPane().add(this.tabbedPane_);
            }
            this.sorter_ = new TableSorter[this.events_.length];
            for (int i = 0; i < this.events_.length; ++i) {
                UserEventTable userEvents = new UserEventTable(i);
                this.sorter_[i] = new TableSorter(userEvents);
                JTable table = new JTable(this.sorter_[i]);
                this.sorter_[i].addMouseListenerToHeaderInTable(table);
                table.setBackground(this.BACKGROUND);
                table.setForeground(this.FOREGROUND);
                TableColumn column = null;
                column = table.getColumnModel().getColumn(0);
                column.setPreferredWidth(150);
                column.setCellRenderer(new NameRenderer(i));
                for (int j = 1; j < userEvents.getColumnCount(); ++j) {
                    column = table.getColumnModel().getColumn(j);
                    column.setPreferredWidth(75);
                    column.setCellRenderer(this.rightJustify_);
                }
                if (this.events_.length == 1) {
                    super.getContentPane().add(new JScrollPane(table));
                    continue;
                }
                this.tabbedPane_.addTab(this.pes[i].toString(), new JScrollPane(table));
            }
        } else {
            super.getContentPane().removeAll();
            super.getContentPane().add(new JLabel("<html><body><h1>ERROR: Can only load display when at most 100 PEs are loaded</h1></body></html>"));
        }
        super.getContentPane().invalidate();
        super.getContentPane().doLayout();
    }

    protected UserEventWindow(JCheckBox c) {
        super("User Event Window");
        format_ = new DecimalFormat();
        format_.setGroupingUsed(true);
        this.rightJustify_.setHorizontalAlignment(4);
        this.checkbox_ = c;
        this.setSize(480, 400);
        this.tabbedPane_ = new JTabbedPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabbedPane_, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                UserEventWindow.this.setVisible(false);
                UserEventWindow.this.checkbox_.setSelected(false);
            }
        });
    }

    private class UserEventTable
    extends AbstractTableModel {
        private int index_;

        protected UserEventTable(int i) {
            this.index_ = i;
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            if (UserEventWindow.this.events_ != null && UserEventWindow.this.events_[this.index_] != null) {
                return UserEventWindow.this.events_[this.index_].length;
            }
            return 0;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "User Event";
                }
                case 1: {
                    return "Begin Time";
                }
                case 2: {
                    return "End Time";
                }
                case 3: {
                    return "Delta Time";
                }
            }
            return "ERROR";
        }

        public Object getValueAt(int row, int col) {
            if (UserEventWindow.this.events_ != null && UserEventWindow.this.events_[this.index_] != null) {
                switch (col) {
                    case 0: {
                        return ((UserEventObject)UserEventWindow.this.events_[this.index_][row]).getName();
                    }
                    case 1: {
                        return new FormattedNumber(((UserEventObject)((UserEventWindow)UserEventWindow.this).events_[this.index_][row]).beginTime, format_);
                    }
                    case 2: {
                        return new FormattedNumber(((UserEventObject)((UserEventWindow)UserEventWindow.this).events_[this.index_][row]).endTime, format_);
                    }
                    case 3: {
                        return new FormattedNumber(((UserEventObject)((UserEventWindow)UserEventWindow.this).events_[this.index_][row]).endTime - ((UserEventObject)((UserEventWindow)UserEventWindow.this).events_[this.index_][row]).beginTime, format_);
                    }
                }
                return "ERROR";
            }
            return "ERROR";
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return FormattedNumber.class;
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private int index_;

        protected NameRenderer(int index) {
            this.index_ = index;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setEnabled(table == null || table.isEnabled());
            this.setForeground(((UserEventObject)UserEventWindow.this.events_[this.index_][UserEventWindow.this.sorter_[this.index_].mapRow(row)]).getColor(UserEventWindow.this.data));
            this.setBackground(UserEventWindow.this.BACKGROUND);
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }
}

