/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.RangeQueries.Query1D;

class UserSuppliedAnalyzer
extends JFrame {
    private Data data;

    UserSuppliedAnalyzer(Data data) {
        this.data = data;
        this.createLayout();
    }

    private void createLayout() {
        this.setTitle("Analysis of user supplied values(timesteps)");
        TreeMap<Integer, Long> parameterMinTime = new TreeMap<Integer, Long>();
        TreeMap<Integer, Long> parameterMaxTime = new TreeMap<Integer, Long>();
        for (Query1D<EntryMethodObject> objs : this.data.allEntryMethodObjects.values()) {
            for (EntryMethodObject obj : objs) {
                Integer param = obj.userSuppliedData;
                long start = obj.getBeginTime();
                long end = obj.getEndTime();
                if (param == null) continue;
                if (parameterMinTime.containsKey(param)) {
                    Long oldval = (Long)parameterMinTime.get(param);
                    if (start < oldval) {
                        parameterMinTime.put(param, start);
                    }
                    if (end <= (oldval = (Long)parameterMaxTime.get(param))) continue;
                    parameterMaxTime.put(param, end);
                    continue;
                }
                parameterMinTime.put(param, start);
                parameterMaxTime.put(param, end);
            }
        }
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(new String("User Supplied Value(timestep)"));
        columnNames.add(new String("Earliest Begin Time"));
        columnNames.add(new String("Latest End Time"));
        columnNames.add(new String("Duration"));
        columnNames.add(new String("Last Begin to This Begin"));
        columnNames.add(new String("Last End to This End"));
        Vector data = new Vector();
        Iterator i = parameterMinTime.keySet().iterator();
        Long prevMin = null;
        Long prevMax = null;
        while (i.hasNext()) {
            Integer param = (Integer)i.next();
            Long min = (Long)parameterMinTime.get(param);
            Long max = (Long)parameterMaxTime.get(param);
            Vector<Object> row = new Vector<Object>();
            row.add(param);
            row.add(min);
            row.add(max);
            row.add(max - min);
            if (prevMin == null) {
                row.add("");
            } else {
                row.add(min - prevMin);
            }
            if (prevMax == null) {
                row.add("");
            } else {
                row.add(max - prevMax);
            }
            prevMin = min;
            prevMax = max;
            data.add(row);
        }
        if (parameterMinTime.size() == 0) {
            JLabel msg = new JLabel("<html><body>No User Supplied Values Found in the currently loaded timeline.<br> Try selecting a different time range, or add calls to <br><font color=blue><tt>traceUserSuppliedData(int value)</tt></font> to the program.</body></html>");
            JOptionPane.showMessageDialog(this, msg, "Warning", 2);
            Vector<String> row = new Vector<String>();
            row.add(new String("No data found"));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            row.add(new String(""));
            data.add(row);
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, columnNames);
        JTable table = new JTable(tableModel);
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        this.setContentPane(scroller);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }
}

