/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TimelineRendered;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.TreeSet;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MainPanel;
import projections.gui.JPanelToImage;

class ThreadedFileReader
implements MainHandler,
Runnable {
    protected int PE;
    private Color background;
    private Color foreground;
    private long startTime;
    private long endTime;
    private BufferedImage image;
    private int width;

    protected ThreadedFileReader(int pe, long startTime, long endTime, Color backgroundColor, Color foregroundColor, int width) {
        this.PE = pe;
        this.startTime = startTime;
        this.endTime = endTime;
        this.background = backgroundColor;
        this.foreground = foregroundColor;
        this.width = width;
    }

    public void run() {
        TreeSet<Integer> validPEs = new TreeSet<Integer>();
        validPEs.add(this.PE);
        Data data = new Data(null);
        data.setProcessorList(validPEs);
        data.setRange(this.startTime, this.endTime);
        data.setViewType(Data.ViewType.VIEW_COMPACT);
        if (this.background != null && this.foreground != null) {
            data.setColors(this.background, this.foreground);
        }
        data.setHandler(this);
        MainPanel displayPanel = new MainPanel(data, this);
        System.out.println("Calling loadTimelineObjects");
        displayPanel.loadTimelineObjects(false, null, false);
        displayPanel.setSize(this.width, data.singleTimelineHeight());
        displayPanel.revalidate();
        displayPanel.doLayout();
        this.image = JPanelToImage.generateImage(displayPanel);
        System.out.println("Created image for PE " + this.PE);
        displayPanel = null;
        data = null;
        long oneGB = 0x40000000L;
        if (Runtime.getRuntime().freeMemory() < oneGB) {
            System.out.println("Calling garbage collector");
            Runtime.getRuntime().gc();
        }
    }

    public void displayWarning(String message2) {
    }

    public void notifyProcessorListHasChanged() {
    }

    public void refreshDisplay(boolean doRevalidate) {
    }

    public void setData(Data data) {
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

