/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TopologyDisplay;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.IllegalFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class TextIO {
    public static final char EOF = '\uffff';
    public static final char EOLN = '\n';
    private static String inputFileName;
    private static String outputFileName;
    private static JFileChooser fileDialog;
    private static final BufferedReader standardInput;
    private static final PrintWriter standardOutput;
    private static BufferedReader in;
    private static PrintWriter out;
    private static boolean readingStandardInput;
    private static boolean writingStandardOutput;
    private static int inputErrorCount;
    private static int outputErrorCount;
    private static Matcher integerMatcher;
    private static Matcher floatMatcher;
    private static final Pattern integerRegex;
    private static final Pattern floatRegex;
    private static String buffer;
    private static int pos;

    public static void readStandardInput() {
        if (readingStandardInput) {
            return;
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextIO.emptyBuffer();
        in = standardInput;
        inputFileName = null;
        readingStandardInput = true;
        inputErrorCount = 0;
    }

    public static void readStream(InputStream inputStream) {
        if (inputStream == null) {
            TextIO.readStandardInput();
        } else {
            TextIO.readStream(new InputStreamReader(inputStream));
        }
    }

    public static void readStream(Reader inputStream) {
        if (inputStream == null) {
            TextIO.readStandardInput();
        } else {
            in = inputStream instanceof BufferedReader ? (BufferedReader)inputStream : new BufferedReader(inputStream);
            TextIO.emptyBuffer();
            inputFileName = null;
            readingStandardInput = false;
            inputErrorCount = 0;
        }
    }

    public static void readFile(String fileName) {
        if (fileName == null) {
            TextIO.readStandardInput();
        } else {
            BufferedReader newin;
            try {
                newin = new BufferedReader(new FileReader(fileName));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't open file \"" + fileName + "\" for input.\n" + "(Error :" + e + ")");
            }
            if (!readingStandardInput) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TextIO.emptyBuffer();
            in = newin;
            readingStandardInput = false;
            inputErrorCount = 0;
            inputFileName = fileName;
        }
    }

    public static boolean readUserSelectedFile() {
        BufferedReader newin;
        if (fileDialog == null) {
            fileDialog = new JFileChooser();
        }
        fileDialog.setDialogTitle("Select File for Input");
        int option = fileDialog.showOpenDialog(null);
        if (option != 0) {
            return false;
        }
        File selectedFile = fileDialog.getSelectedFile();
        try {
            newin = new BufferedReader(new FileReader(selectedFile));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't open file \"" + selectedFile.getName() + "\" for input.\n" + "(Error :" + e + ")");
        }
        if (!readingStandardInput) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TextIO.emptyBuffer();
        in = newin;
        inputFileName = selectedFile.getName();
        readingStandardInput = false;
        inputErrorCount = 0;
        return true;
    }

    public static void writeStandardOutput() {
        if (writingStandardOutput) {
            return;
        }
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        outputFileName = null;
        outputErrorCount = 0;
        out = standardOutput;
        writingStandardOutput = true;
    }

    public static void writeStream(OutputStream outputStream) {
        if (outputStream == null) {
            TextIO.writeStandardOutput();
        } else {
            TextIO.writeStream(new PrintWriter(outputStream));
        }
    }

    public static void writeStream(PrintWriter outputStream) {
        if (outputStream == null) {
            TextIO.writeStandardOutput();
        } else {
            out = outputStream;
            outputFileName = null;
            outputErrorCount = 0;
            writingStandardOutput = false;
        }
    }

    public static void writeFile(String fileName) {
        if (fileName == null) {
            TextIO.writeStandardOutput();
        } else {
            PrintWriter newout;
            try {
                newout = new PrintWriter(new FileWriter(fileName));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can't open file \"" + fileName + "\" for output.\n" + "(Error :" + e + ")");
            }
            if (!writingStandardOutput) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            out = newout;
            writingStandardOutput = false;
            outputFileName = fileName;
            outputErrorCount = 0;
        }
    }

    public static boolean writeUserSelectedFile() {
        PrintWriter newout;
        int response;
        File selectedFile;
        if (fileDialog == null) {
            fileDialog = new JFileChooser();
        }
        fileDialog.setDialogTitle("Select File for Output");
        do {
            int option;
            if ((option = fileDialog.showSaveDialog(null)) == 0) continue;
            return false;
        } while ((selectedFile = fileDialog.getSelectedFile()).exists() && (response = JOptionPane.showConfirmDialog(null, "The file \"" + selectedFile.getName() + "\" already exists.  Do you want to replace it?", "Replace existing file?", 0, 2)) != 0);
        try {
            newout = new PrintWriter(new FileWriter(selectedFile));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't open file \"" + selectedFile.getName() + "\" for output.\n" + "(Error :" + e + ")");
        }
        if (!writingStandardOutput) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        out = newout;
        writingStandardOutput = false;
        outputFileName = selectedFile.getName();
        outputErrorCount = 0;
        return true;
    }

    public static String getInputFileName() {
        return inputFileName;
    }

    public static String getOutputFileName() {
        return outputFileName;
    }

    public static void put(Object x) {
        out.print(x);
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static void put(Object x, int minChars) {
        if (minChars <= 0) {
            out.print(x);
        } else {
            out.printf("%" + minChars + "s", x);
        }
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static void putln(Object x) {
        out.println(x);
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static void putln(Object x, int minChars) {
        TextIO.put(x, minChars);
        out.println();
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static void putln() {
        out.println();
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static void putf(String format, Object ... items) {
        if (format == null) {
            throw new IllegalArgumentException("Null format string in TextIO.putf() method.");
        }
        try {
            out.printf(format, items);
        }
        catch (IllegalFormatException e) {
            throw new IllegalArgumentException("Illegal format string in TextIO.putf() method.");
        }
        out.flush();
        if (out.checkError()) {
            TextIO.outputError("Error while writing output.");
        }
    }

    public static boolean eoln() {
        return TextIO.peek() == '\n';
    }

    public static boolean eof() {
        return TextIO.peek() == '\uffff';
    }

    public static char getAnyChar() {
        return TextIO.readChar();
    }

    public static char peek() {
        return TextIO.lookChar();
    }

    public static void skipBlanks() {
        char ch = TextIO.lookChar();
        while (ch != '\uffff' && ch != '\n' && Character.isWhitespace(ch)) {
            TextIO.readChar();
            ch = TextIO.lookChar();
        }
    }

    private static void skipWhitespace() {
        char ch = TextIO.lookChar();
        while (ch != '\uffff' && Character.isWhitespace(ch)) {
            TextIO.readChar();
            if (ch == '\n' && readingStandardInput && writingStandardOutput) {
                out.print("? ");
                out.flush();
            }
            ch = TextIO.lookChar();
        }
    }

    public static byte getlnByte() {
        byte x = TextIO.getByte();
        TextIO.emptyBuffer();
        return x;
    }

    public static short getlnShort() {
        short x = TextIO.getShort();
        TextIO.emptyBuffer();
        return x;
    }

    public static int getlnInt() {
        int x = TextIO.getInt();
        TextIO.emptyBuffer();
        return x;
    }

    public static long getlnLong() {
        long x = TextIO.getLong();
        TextIO.emptyBuffer();
        return x;
    }

    public static float getlnFloat() {
        float x = TextIO.getFloat();
        TextIO.emptyBuffer();
        return x;
    }

    public static double getlnDouble() {
        double x = TextIO.getDouble();
        TextIO.emptyBuffer();
        return x;
    }

    public static char getlnChar() {
        char x = TextIO.getChar();
        TextIO.emptyBuffer();
        return x;
    }

    public static boolean getlnBoolean() {
        boolean x = TextIO.getBoolean();
        TextIO.emptyBuffer();
        return x;
    }

    public static String getlnWord() {
        String x = TextIO.getWord();
        TextIO.emptyBuffer();
        return x;
    }

    public static String getlnString() {
        return TextIO.getln();
    }

    public static String getln() {
        StringBuffer s = new StringBuffer(100);
        char ch = TextIO.readChar();
        while (ch != '\n') {
            s.append(ch);
            ch = TextIO.readChar();
        }
        return s.toString();
    }

    public static byte getByte() {
        return (byte)TextIO.readInteger(-128L, 127L);
    }

    public static short getShort() {
        return (short)TextIO.readInteger(-32768L, 32767L);
    }

    public static int getInt() {
        return (int)TextIO.readInteger(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static long getLong() {
        return TextIO.readInteger(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static char getChar() {
        TextIO.skipWhitespace();
        return TextIO.readChar();
    }

    public static float getFloat() {
        float x = 0.0f;
        while (true) {
            String str;
            if ((str = TextIO.readRealString()) == null) {
                TextIO.errorMessage("Floating point number not found.", "Real number in the range -3.4028235E38 to 3.4028235E38");
                continue;
            }
            try {
                x = Float.parseFloat(str);
            }
            catch (NumberFormatException e) {
                TextIO.errorMessage("Illegal floating point input, " + str + ".", "Real number in the range -3.4028235E38 to 3.4028235E38");
                continue;
            }
            if (!Float.isInfinite(x)) break;
            TextIO.errorMessage("Floating point input outside of legal range, " + str + ".", "Real number in the range -3.4028235E38 to 3.4028235E38");
        }
        inputErrorCount = 0;
        return x;
    }

    public static double getDouble() {
        double x = 0.0;
        while (true) {
            String str;
            if ((str = TextIO.readRealString()) == null) {
                TextIO.errorMessage("Floating point number not found.", "Real number in the range -1.7976931348623157E308 to 1.7976931348623157E308");
                continue;
            }
            try {
                x = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                TextIO.errorMessage("Illegal floating point input, " + str + ".", "Real number in the range -1.7976931348623157E308 to 1.7976931348623157E308");
                continue;
            }
            if (!Double.isInfinite(x)) break;
            TextIO.errorMessage("Floating point input outside of legal range, " + str + ".", "Real number in the range -1.7976931348623157E308 to 1.7976931348623157E308");
        }
        inputErrorCount = 0;
        return x;
    }

    public static String getWord() {
        TextIO.skipWhitespace();
        StringBuffer str = new StringBuffer(50);
        char ch = TextIO.lookChar();
        while (ch == '\uffff' || !Character.isWhitespace(ch)) {
            str.append(TextIO.readChar());
            ch = TextIO.lookChar();
        }
        return str.toString();
    }

    public static boolean getBoolean() {
        boolean ans = false;
        while (true) {
            String s;
            if ((s = TextIO.getWord()).equalsIgnoreCase("true") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y") || s.equals("1")) {
                ans = true;
                break;
            }
            if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("n") || s.equals("0")) {
                ans = false;
                break;
            }
            TextIO.errorMessage("Illegal boolean input value.", "one of:  true, false, t, f, yes, no, y, n, 0, or 1");
        }
        inputErrorCount = 0;
        return ans;
    }

    private static String readRealString() {
        TextIO.skipWhitespace();
        if (TextIO.lookChar() == '\uffff') {
            return null;
        }
        if (floatMatcher == null) {
            floatMatcher = floatRegex.matcher(buffer);
        }
        floatMatcher.region(pos, buffer.length());
        if (floatMatcher.lookingAt()) {
            String str = floatMatcher.group();
            pos = floatMatcher.end();
            return str;
        }
        return null;
    }

    private static String readIntegerString() {
        TextIO.skipWhitespace();
        if (TextIO.lookChar() == '\uffff') {
            return null;
        }
        if (integerMatcher == null) {
            integerMatcher = integerRegex.matcher(buffer);
        }
        integerMatcher.region(pos, buffer.length());
        if (integerMatcher.lookingAt()) {
            String str = integerMatcher.group();
            pos = integerMatcher.end();
            return str;
        }
        return null;
    }

    private static long readInteger(long min, long max) {
        long x = 0L;
        while (true) {
            String s;
            if ((s = TextIO.readIntegerString()) == null) {
                TextIO.errorMessage("Integer value not found in input.", "Integer in the range " + min + " to " + max);
                continue;
            }
            String str = s.toString();
            try {
                x = Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                TextIO.errorMessage("Illegal integer input, " + str + ".", "Integer in the range " + min + " to " + max);
                continue;
            }
            if (x >= min && x <= max) break;
            TextIO.errorMessage("Integer input outside of legal range, " + str + ".", "Integer in the range " + min + " to " + max);
        }
        inputErrorCount = 0;
        return x;
    }

    private static void errorMessage(String message2, String expecting) {
        if (readingStandardInput && writingStandardOutput) {
            out.println();
            out.print("  *** Error in input: " + message2 + "\n");
            out.print("  *** Expecting: " + expecting + "\n");
            out.print("  *** Discarding Input: ");
            if (TextIO.lookChar() == '\n') {
                out.print("(end-of-line)\n\n");
            } else {
                while (TextIO.lookChar() != '\n') {
                    out.print(TextIO.readChar());
                }
                out.print("\n\n");
            }
            out.print("Please re-enter: ");
            out.flush();
            TextIO.readChar();
            if (++inputErrorCount >= 10) {
                throw new IllegalArgumentException("Too many input consecutive input errors on standard input.");
            }
        } else {
            if (inputFileName != null) {
                throw new IllegalArgumentException("Error while reading from file \"" + inputFileName + "\":\n" + message2 + "\nExpecting " + expecting);
            }
            throw new IllegalArgumentException("Error while reading from inptu stream:\n" + message2 + "\nExpecting " + expecting);
        }
    }

    private static char lookChar() {
        if (buffer == null || pos > buffer.length()) {
            TextIO.fillBuffer();
        }
        if (buffer == null) {
            return '\uffff';
        }
        if (pos == buffer.length()) {
            return '\n';
        }
        return buffer.charAt(pos);
    }

    private static char readChar() {
        char ch = TextIO.lookChar();
        if (buffer == null) {
            if (readingStandardInput) {
                throw new IllegalArgumentException("Attempt to read past end-of-file in standard input???");
            }
            throw new IllegalArgumentException("Attempt to read past end-of-file in file \"" + inputFileName + "\".");
        }
        ++pos;
        return ch;
    }

    private static void fillBuffer() {
        try {
            buffer = in.readLine();
        }
        catch (Exception e) {
            if (readingStandardInput) {
                throw new IllegalArgumentException("Error while reading standard input???");
            }
            if (inputFileName != null) {
                throw new IllegalArgumentException("Error while attempting to read from file \"" + inputFileName + "\".");
            }
            throw new IllegalArgumentException("Errow while attempting to read form an input stream.");
        }
        pos = 0;
        floatMatcher = null;
        integerMatcher = null;
    }

    private static void emptyBuffer() {
        buffer = null;
    }

    private static void outputError(String message2) {
        if (writingStandardOutput) {
            System.err.println("Error occurred in TextIO while writing to standard output!!");
            if (++outputErrorCount >= 10) {
                outputErrorCount = 0;
                throw new IllegalArgumentException("Too many errors while writing to standard output.");
            }
        } else {
            if (outputFileName != null) {
                throw new IllegalArgumentException("Error occurred while writing to file \"" + outputFileName + "\":\n   " + message2);
            }
            throw new IllegalArgumentException("Error occurred while writing to output stream:\n   " + message2);
        }
    }

    static {
        standardInput = new BufferedReader(new InputStreamReader(System.in));
        standardOutput = new PrintWriter(System.out);
        in = standardInput;
        out = standardOutput;
        readingStandardInput = true;
        writingStandardOutput = true;
        integerRegex = Pattern.compile("(\\+|-)?[0-9]+");
        floatRegex = Pattern.compile("(\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?");
        buffer = null;
        pos = 0;
    }
}

