/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TopologyDisplay;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.LineArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import projections.Tools.TopologyDisplay.OffScreenCanvas3D;
import projections.Tools.TopologyDisplay.TextIO;
import projections.Tools.TopologyDisplay.TopologyFileFilter;
import projections.Tools.TopologyDisplay.Util;
import projections.gui.MainWindow;
import projections.gui.OffScreenCanvas3DToImage;
import projections.gui.ProjectionsWindow;

public class TopologyDisplayWindow
extends ProjectionsWindow
implements ItemListener,
KeyListener {
    static final float pointRadius = 0.13f;
    static final float coneRadius = 0.12f;
    static final float coneHeight = 0.3f;
    static final float rotationStepRadian = (float)Math.PI / 180;
    private Appearance redAppearance;
    private Appearance greenAppearance;
    private Appearance blueAppearance;
    private SimpleUniverse universe;
    private BranchGroup scene;
    private TransformGroup objTrans;
    private TransformGroup objRotate;
    private BranchGroup boxGroup;
    private BranchGroup centerGroup;
    private BranchGroup coordinatesGroup;
    private BranchGroup wrapperGraph;
    private BoundingSphere backgroundBounds;
    private DirectionalLight light;
    private int maxX;
    private int minX;
    private int maxY;
    private int minY;
    private int maxZ;
    private int minZ;
    static final float axisExt = 1.0f;
    private Vector3f centerOfCube;
    static int screenshotCount = 0;
    private MainWindow parentWindow;
    private Canvas3D canvas;
    private OffScreenCanvas3D offScreenCanvas;
    private JMenuItem inputFileItem;
    private JMenuItem quitItem;
    private JCheckBoxMenuItem showBoxItem;
    private JCheckBoxMenuItem showCoordItem;
    private JCheckBoxMenuItem showCenterItem;
    private JMenuItem screenshotItem;

    public void initUI() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this.inputFileItem = new JMenuItem("Open File");
        this.inputFileItem.addActionListener(this);
        fileMenu.add(this.inputFileItem);
        this.quitItem = new JMenuItem("Quit");
        this.quitItem.addActionListener(this);
        fileMenu.add(this.quitItem);
        JMenu optionsMenu = new JMenu("Options");
        menuBar.add(optionsMenu);
        this.showBoxItem = new JCheckBoxMenuItem("Show Box");
        this.showBoxItem.setSelected(true);
        this.showBoxItem.addItemListener(this);
        optionsMenu.add(this.showBoxItem);
        this.showCoordItem = new JCheckBoxMenuItem("Show Coordinates");
        this.showCoordItem.addItemListener(this);
        optionsMenu.add(this.showCoordItem);
        this.showCenterItem = new JCheckBoxMenuItem("Show Center Point");
        this.showCenterItem.addItemListener(this);
        optionsMenu.add(this.showCenterItem);
        JMenu screenshotMenu = new JMenu("Screenshot");
        menuBar.add(screenshotMenu);
        this.screenshotItem = new JMenuItem("Take Screenshot");
        this.screenshotItem.addActionListener(this);
        screenshotMenu.add(this.screenshotItem);
        this.setJMenuBar(menuBar);
    }

    public void initCommonAppearance() {
        this.redAppearance = new Appearance();
        Color3f redColor = new Color3f(1.0f, 0.0f, 0.0f);
        ColoringAttributes redCA = new ColoringAttributes(redColor, 1);
        this.redAppearance.setColoringAttributes(redCA);
        this.greenAppearance = new Appearance();
        Color3f greenColor = new Color3f(0.0f, 1.0f, 0.0f);
        ColoringAttributes greenCA = new ColoringAttributes(greenColor, 1);
        this.greenAppearance.setColoringAttributes(greenCA);
        this.blueAppearance = new Appearance();
        Color3f blueColor = new Color3f(0.0f, 0.0f, 1.0f);
        ColoringAttributes blueCA = new ColoringAttributes(blueColor, 1);
        this.blueAppearance.setColoringAttributes(blueCA);
    }

    public TopologyDisplayWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setTitle("Projections 3D Topology");
        this.setSize(500, 500);
        this.parentWindow = parentWindow;
        this.maxX = 0;
        this.minX = 0;
        this.maxY = 0;
        this.minY = 0;
        this.maxZ = 0;
        this.minZ = 0;
        this.initCommonAppearance();
        this.initUI();
        this.setLayout(new BorderLayout());
        this.canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.add("Center", this.canvas);
        this.universe = new SimpleUniverse(this.canvas);
        this.scene = new BranchGroup();
        this.wrapperGraph = new BranchGroup();
        this.objTrans = new TransformGroup();
        this.objRotate = new TransformGroup();
        this.boxGroup = new BranchGroup();
        this.centerGroup = new BranchGroup();
        this.coordinatesGroup = new BranchGroup();
        this.backgroundBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.offScreenCanvas = new OffScreenCanvas3D(SimpleUniverse.getPreferredConfiguration(), true);
        Screen3D sOn = this.canvas.getScreen3D();
        Screen3D sOff = this.offScreenCanvas.getScreen3D();
        sOff.setSize(sOn.getSize());
        sOff.setPhysicalScreenWidth(sOn.getPhysicalScreenWidth());
        sOff.setPhysicalScreenHeight(sOn.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas);
        this.setCapabilities();
        this.addMouseRotator(this.scene, this.objTrans);
        this.addMouseTranslation(this.scene, this.objTrans);
        this.addMouseZoom(this.scene, this.objTrans);
        this.canvas.addKeyListener(this);
        this.scene.addChild(this.wrapperGraph);
        this.scene.compile();
        this.universe.addBranchGraph(this.scene);
        this.showDialog();
    }

    private void setViewPlatform() {
        ViewingPlatform vp = this.universe.getViewingPlatform();
        TransformGroup viewTransformGroup = vp.getMultiTransformGroup().getTransformGroup(0);
        Transform3D viewTransform3D = new Transform3D();
        viewTransformGroup.getTransform(viewTransform3D);
        float cameraZ = (float)this.maxZ * 1.2f;
        viewTransform3D.setTranslation(new Vector3f(0.0f, 0.0f, cameraZ));
        viewTransformGroup.setTransform(viewTransform3D);
        double backClipDistance = (cameraZ + (float)Math.abs(this.minZ)) * 5.0f;
        if (backClipDistance < 1.0) {
            backClipDistance = 20.0;
        }
        this.universe.getViewer().getView().setBackClipDistance(backClipDistance);
    }

    protected void showDialog() {
        this.setVisible(true);
    }

    private void setCapabilities() {
        this.scene.setCapability(13);
        this.scene.setCapability(12);
        this.scene.setCapability(14);
        this.wrapperGraph.setCapability(17);
        this.objTrans.setCapability(13);
        this.objTrans.setCapability(12);
        this.objTrans.setCapability(14);
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objRotate.setCapability(13);
        this.objRotate.setCapability(12);
        this.objRotate.setCapability(14);
        this.objRotate.setCapability(18);
        this.objRotate.setCapability(17);
        this.boxGroup.setCapability(17);
        this.centerGroup.setCapability(17);
        this.coordinatesGroup.setCapability(17);
    }

    private void ClearScreen() {
        this.maxX = 0;
        this.minX = 0;
        this.maxY = 0;
        this.minY = 0;
        this.maxZ = 0;
        this.minZ = 0;
        this.scene.removeChild(this.wrapperGraph);
        this.wrapperGraph.removeAllChildren();
        this.objTrans.removeAllChildren();
        this.objRotate.removeAllChildren();
        this.boxGroup.removeAllChildren();
        this.centerGroup.removeAllChildren();
        this.coordinatesGroup.removeAllChildren();
    }

    private void RefreshScreen(String filePath) {
        this.initSceneGraph();
        this.AddAllPoints(filePath);
        this.createAxes();
        this.initBoxGroup();
        this.initCenterPoint();
        this.initCenterGroup();
        this.addLight();
        if (this.showBoxItem.isSelected()) {
            this.objRotate.addChild(this.boxGroup);
        }
        Transform3D centerTrans = new Transform3D();
        centerTrans.setTranslation(this.centerOfCube);
        this.objRotate.setTransform(centerTrans);
        this.objTrans.addChild(this.objRotate);
        this.wrapperGraph = new BranchGroup();
        this.wrapperGraph.setCapability(17);
        this.wrapperGraph.addChild(this.objTrans);
        this.scene.addChild(this.wrapperGraph);
        this.setViewPlatform();
    }

    private void addLight() {
        TransformGroup transformGroup = new TransformGroup();
        Color3f lightColor = new Color3f(1.0f, 1.0f, 1.0f);
        Vector3f lightDir = new Vector3f(0.0f, 0.0f, -1.0f);
        this.light = new DirectionalLight(lightColor, lightDir);
        Transform3D transform = new Transform3D();
        float cameraZ = (float)this.maxZ * 1.5f;
        if (cameraZ < 0.0f) {
            cameraZ = 10.0f;
        }
        Vector3f lightLocation = new Vector3f(0.0f, 0.0f, cameraZ);
        Point3d lightPoint = new Point3d(0.0, 0.0, cameraZ);
        transform.setTranslation(lightLocation);
        transformGroup.setTransform(transform);
        transformGroup.addChild(this.light);
        this.objRotate.addChild(transformGroup);
        double boundRadius = 3.0 * (double)(cameraZ + (float)Math.abs(this.minZ));
        BoundingSphere bounds = new BoundingSphere(lightPoint, boundRadius);
        this.light.setInfluencingBounds(bounds);
    }

    private void initCenterPoint() {
        float x = (float)this.maxX - (float)(this.maxX - this.minX) / 2.0f;
        float y = (float)this.maxY - (float)(this.maxY - this.minY) / 2.0f;
        float z = (float)this.maxZ - (float)(this.maxZ - this.minZ) / 2.0f;
        this.centerOfCube = new Vector3f(-x, -y, -z);
    }

    private void initCenterGroup() {
        Vector3f posCenter = Util.neg(this.centerOfCube);
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform = new Transform3D();
        transform.setTranslation(posCenter);
        transformGroup.setTransform(transform);
        Sphere point = new Sphere(0.32999998f);
        point.setAppearance(this.redAppearance);
        transformGroup.addChild(point);
        this.centerGroup.addChild(transformGroup);
    }

    private void initSceneGraph() {
        Background back = new Background();
        back.setCapability(17);
        back.setColor(1.0f, 1.0f, 1.0f);
        back.setApplicationBounds(this.backgroundBounds);
        this.objRotate.addChild(back);
    }

    private void AddAllPoints(String filePath) {
        TextIO.readFile(filePath);
        TextIO.getln();
        TextIO.getln();
        TextIO.getln();
        TextIO.getln();
        if (MainWindow.BLUEGENE) {
            while (!TextIO.eof()) {
                TextIO.getInt();
                TextIO.getChar();
                int x = TextIO.getInt();
                int y = TextIO.getInt();
                int z = TextIO.getInt();
                this.AddPoint(x, y, z);
                TextIO.getln();
                TextIO.skipBlanks();
            }
        } else {
            while (!TextIO.eof()) {
                TextIO.getInt();
                TextIO.getChar();
                TextIO.getInt();
                TextIO.getChar();
                TextIO.getInt();
                TextIO.getChar();
                TextIO.getInt();
                TextIO.getChar();
                int x = TextIO.getInt();
                int y = TextIO.getInt();
                int z = TextIO.getInt();
                this.AddPoint(x, y, z);
                TextIO.getln();
                TextIO.skipBlanks();
            }
        }
        this.objRotate.addChild(this.coordinatesGroup);
    }

    private void AddPoint(int x, int y, int z) {
        if (x > this.maxX) {
            this.maxX = x;
        } else if (x < this.minX) {
            this.minX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        } else if (y < this.minY) {
            this.minY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        } else if (z < this.minZ) {
            this.minZ = z;
        }
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform = new Transform3D();
        transform.setTranslation(new Vector3f(x, y, z));
        transformGroup.setTransform(transform);
        Sphere point = new Sphere(0.13f);
        transformGroup.addChild(point);
        this.coordinatesGroup.addChild(transformGroup);
    }

    private void createAxes() {
        LineArray axisXLines = new LineArray(2, 5);
        axisXLines.setColor(0, new Color3f(1.0f, 0.0f, 0.0f));
        axisXLines.setColor(1, new Color3f(1.0f, 0.0f, 0.0f));
        this.objRotate.addChild(new Shape3D(axisXLines));
        axisXLines.setCoordinate(0, new Point3f((float)this.minX - 1.0f, 0.0f, 0.0f));
        axisXLines.setCoordinate(1, new Point3f((float)this.maxX + 1.0f, 0.0f, 0.0f));
        Cone xAxisCone = new Cone(0.12f, 0.3f);
        xAxisCone.setAppearance(this.redAppearance);
        TransformGroup xTransformGroup = new TransformGroup();
        Transform3D xTransform = new Transform3D();
        xTransform.setRotation(new AxisAngle4f(new Vector3f(0.0f, 0.0f, 1.0f), -1.5707964f));
        xTransform.setTranslation(new Vector3f((float)this.maxX + 1.0f, 0.0f, 0.0f));
        xTransformGroup.setTransform(xTransform);
        xTransformGroup.addChild(xAxisCone);
        this.objRotate.addChild(xTransformGroup);
        LineArray axisYLines = new LineArray(2, 5);
        axisYLines.setColor(0, new Color3f(0.0f, 1.0f, 0.0f));
        axisYLines.setColor(1, new Color3f(0.0f, 1.0f, 0.0f));
        this.objRotate.addChild(new Shape3D(axisYLines));
        axisYLines.setCoordinate(0, new Point3f(0.0f, (float)this.minY - 1.0f, 0.0f));
        axisYLines.setCoordinate(1, new Point3f(0.0f, (float)this.maxY + 1.0f, 0.0f));
        Cone yAxisCone = new Cone(0.12f, 0.3f);
        yAxisCone.setAppearance(this.greenAppearance);
        TransformGroup yTransformGroup = new TransformGroup();
        Transform3D yTransform = new Transform3D();
        yTransform.setTranslation(new Vector3f(0.0f, (float)this.maxY + 1.0f, 0.0f));
        yTransformGroup.setTransform(yTransform);
        yTransformGroup.addChild(yAxisCone);
        this.objRotate.addChild(yTransformGroup);
        LineArray axisZLines = new LineArray(10, 5);
        axisZLines.setColor(0, new Color3f(0.0f, 0.0f, 1.0f));
        axisZLines.setColor(1, new Color3f(0.0f, 0.0f, 1.0f));
        this.objRotate.addChild(new Shape3D(axisZLines));
        axisZLines.setCoordinate(0, new Point3f(0.0f, 0.0f, (float)this.minZ - 1.0f));
        axisZLines.setCoordinate(1, new Point3f(0.0f, 0.0f, (float)this.maxZ + 1.0f));
        Cone zAxisCone = new Cone(0.12f, 0.3f);
        zAxisCone.setAppearance(this.blueAppearance);
        TransformGroup zTransformGroup = new TransformGroup();
        Transform3D zTransform = new Transform3D();
        zTransform.setRotation(new AxisAngle4f(new Vector3f(1.0f, 0.0f, 0.0f), 1.5707964f));
        zTransform.setTranslation(new Vector3f(0.0f, 0.0f, (float)this.maxZ + 1.0f));
        zTransformGroup.setTransform(zTransform);
        zTransformGroup.addChild(zAxisCone);
        this.objRotate.addChild(zTransformGroup);
    }

    private void initBoxGroup() {
        LineArray lines;
        Color lineColor = Color.BLACK;
        Color3f xyWallColor = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f yzWallColor = new Color3f(0.4f, 0.4f, 0.4f);
        Color3f xzWallColor = new Color3f(0.6f, 0.6f, 0.6f);
        Appearance xyAppearance = new Appearance();
        xyAppearance.setColoringAttributes(new ColoringAttributes(xyWallColor, 1));
        xyAppearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.3f));
        Appearance yzAppearance = new Appearance();
        yzAppearance.setColoringAttributes(new ColoringAttributes(yzWallColor, 1));
        yzAppearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.3f));
        Appearance xzAppearance = new Appearance();
        xzAppearance.setColoringAttributes(new ColoringAttributes(xzWallColor, 1));
        xzAppearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.3f));
        QuadArray polygonXY = new QuadArray(4, 1);
        polygonXY.setCoordinate(0, new Point3f(this.minX, this.minY, this.minZ));
        polygonXY.setCoordinate(1, new Point3f(this.maxX, this.minY, this.minZ));
        polygonXY.setCoordinate(2, new Point3f(this.maxX, this.maxY, this.minZ));
        polygonXY.setCoordinate(3, new Point3f(this.minX, this.maxY, this.minZ));
        this.boxGroup.addChild(new Shape3D(polygonXY, xyAppearance));
        QuadArray polygonXZ = new QuadArray(4, 1);
        polygonXZ.setCoordinate(0, new Point3f(this.maxX, this.minY, this.maxZ));
        polygonXZ.setCoordinate(1, new Point3f(this.maxX, this.minY, this.minZ));
        polygonXZ.setCoordinate(2, new Point3f(this.minX, this.minY, this.minZ));
        polygonXZ.setCoordinate(3, new Point3f(this.minX, this.minY, this.maxZ));
        this.boxGroup.addChild(new Shape3D(polygonXZ, xzAppearance));
        QuadArray polygonYZ = new QuadArray(4, 1);
        polygonYZ.setCoordinate(0, new Point3f(this.minX, this.minY, this.maxZ));
        polygonYZ.setCoordinate(1, new Point3f(this.minX, this.minY, this.minZ));
        polygonYZ.setCoordinate(2, new Point3f(this.minX, this.maxY, this.minZ));
        polygonYZ.setCoordinate(3, new Point3f(this.minX, this.maxY, this.maxZ));
        this.boxGroup.addChild(new Shape3D(polygonYZ, yzAppearance));
        for (int x = this.minX; x <= this.maxX; ++x) {
            lines = new LineArray(4, 5);
            lines.setColor(0, new Color3f(lineColor));
            lines.setColor(1, new Color3f(lineColor));
            lines.setColor(2, new Color3f(lineColor));
            lines.setColor(3, new Color3f(lineColor));
            this.boxGroup.addChild(new Shape3D(lines));
            lines.setCoordinate(0, new Point3f(x, this.minY, this.minZ));
            lines.setCoordinate(1, new Point3f(x, this.minY, this.maxZ));
            lines.setCoordinate(2, new Point3f(x, this.minY, this.minZ));
            lines.setCoordinate(3, new Point3f(x, this.maxY, this.minZ));
        }
        for (int y = this.minY; y <= this.maxY; ++y) {
            lines = new LineArray(4, 5);
            lines.setColor(0, new Color3f(lineColor));
            lines.setColor(1, new Color3f(lineColor));
            lines.setColor(2, new Color3f(lineColor));
            lines.setColor(3, new Color3f(lineColor));
            this.boxGroup.addChild(new Shape3D(lines));
            lines.setCoordinate(0, new Point3f(this.minX, y, this.minZ));
            lines.setCoordinate(1, new Point3f(this.minX, y, this.maxZ));
            lines.setCoordinate(2, new Point3f(this.minX, y, this.minZ));
            lines.setCoordinate(3, new Point3f(this.maxX, y, this.minZ));
        }
        for (int z = this.minZ; z <= this.maxZ; ++z) {
            lines = new LineArray(4, 5);
            lines.setColor(0, new Color3f(lineColor));
            lines.setColor(1, new Color3f(lineColor));
            lines.setColor(2, new Color3f(lineColor));
            lines.setColor(3, new Color3f(lineColor));
            this.boxGroup.addChild(new Shape3D(lines));
            lines.setCoordinate(0, new Point3f(this.minX, this.minY, z));
            lines.setCoordinate(1, new Point3f(this.minX, this.maxY, z));
            lines.setCoordinate(2, new Point3f(this.minX, this.minY, z));
            lines.setCoordinate(3, new Point3f(this.maxX, this.minY, z));
        }
    }

    private void addMouseRotator(BranchGroup scene, TransformGroup objGroup) {
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objGroup);
        myMouseRotate.setSchedulingBounds(this.backgroundBounds);
        scene.addChild(myMouseRotate);
    }

    private void addMouseTranslation(BranchGroup scene, TransformGroup objGroup) {
        MouseTranslate translateBehavior = new MouseTranslate();
        translateBehavior.setTransformGroup(objGroup);
        translateBehavior.setSchedulingBounds(this.backgroundBounds);
        scene.addChild(translateBehavior);
    }

    private void addMouseZoom(BranchGroup scene, TransformGroup objGroup) {
        MouseZoom zoomBehavior = new MouseZoom();
        zoomBehavior.setTransformGroup(objGroup);
        zoomBehavior.setSchedulingBounds(this.backgroundBounds);
        scene.addChild(zoomBehavior);
    }

    public void keyPressed(KeyEvent e) {
        float rotateX = 0.0f;
        float rotateY = 0.0f;
        float rotateZ = 0.0f;
        Transform3D oldTransform = new Transform3D();
        this.objTrans.getTransform(oldTransform);
        switch (e.getKeyCode()) {
            case 37: {
                rotateY = (float)(-Math.PI) / 180;
                break;
            }
            case 39: {
                rotateY = (float)Math.PI / 180;
                break;
            }
            case 38: {
                rotateX = (float)(-Math.PI) / 180;
                break;
            }
            case 40: {
                rotateX = (float)Math.PI / 180;
                break;
            }
            case 78: {
                rotateZ = (float)Math.PI / 180;
                break;
            }
            case 77: {
                rotateZ = (float)(-Math.PI) / 180;
            }
        }
        Transform3D xRotation = new Transform3D();
        xRotation.rotX(rotateX);
        Transform3D yRotation = new Transform3D();
        yRotation.rotY(rotateY);
        Transform3D zRotation = new Transform3D();
        zRotation.rotZ(rotateZ);
        oldTransform.mul(xRotation);
        oldTransform.mul(yRotation);
        oldTransform.mul(zRotation);
        this.objTrans.setTransform(oldTransform);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent ae) {
        JMenuItem source = (JMenuItem)ae.getSource();
        if (source == this.inputFileItem) {
            JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
            fc.setFileFilter(new TopologyFileFilter());
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String absFilePath = file.getAbsolutePath();
                this.ClearScreen();
                this.RefreshScreen(absFilePath);
            }
        } else if (source == this.quitItem) {
            this.close();
        } else if (source == this.screenshotItem) {
            String fileName = String.format("./TopologyScreenshot%03d.png", ++screenshotCount);
            Point loc = this.canvas.getLocationOnScreen();
            this.offScreenCanvas.setOffScreenLocation(loc);
            OffScreenCanvas3DToImage.saveToFileChooserSelection(this.offScreenCanvas, "Save Topology Image", fileName, this.canvas.getSize().width, this.canvas.getSize().height);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
        if (source == this.showBoxItem) {
            if (e.getStateChange() == 1) {
                this.objRotate.addChild(this.boxGroup);
            } else {
                this.objRotate.removeChild(this.boxGroup);
            }
        } else if (source != this.showCoordItem && source == this.showCenterItem) {
            if (e.getStateChange() == 1) {
                this.objRotate.addChild(this.centerGroup);
            } else {
                this.objRotate.removeChild(this.centerGroup);
            }
        }
    }
}

