/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Hashtable;
import java.util.Stack;

public class CallStackManager
extends Hashtable {
    private static final long serialVersionUID = 1L;
    private Stack activeStack;

    public void push(Object data, int id1, int id2, int id3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(id1, id2, id3));
        if (this.activeStack == null) {
            this.activeStack = new Stack();
            this.put(this.tripleToKey(id1, id2, id3), this.activeStack);
        }
        this.activeStack.push(data);
    }

    public Object pop(int id1, int id2, int id3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(id1, id2, id3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return this.activeStack.pop();
    }

    public Object read(int id1, int id2, int id3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(id1, id2, id3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return this.activeStack.peek();
    }

    protected Stack getStack(int id1, int id2, int id3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(id1, id2, id3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return (Stack)this.activeStack.clone();
    }

    private Object tripleToKey(int id1, int id2, int id3) {
        String newkey = "[0]" + String.valueOf(id1) + "[1]" + String.valueOf(id2) + "[2]" + String.valueOf(id3);
        return newkey;
    }

    public static void main(String[] args) {
        CallStackManager cs = new CallStackManager();
        cs.push("Hello", 3, 4, 5);
        cs.push("There", 3, 4, 5);
        cs.push("You", 3, 4, 5);
        Stack stack1 = cs.getStack(3, 4, 5);
        cs.pop(3, 4, 5);
        Stack stack2 = cs.getStack(3, 4, 5);
        cs.push("Dummy", 3, 4, 5);
        System.out.println("Stack1 top = " + (String)stack1.pop());
        System.out.println("Stack2 top = " + (String)stack2.pop());
        System.out.println("Current top = " + (String)cs.getStack(3, 4, 5).pop());
    }
}

