/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.InputMismatchException;
import java.util.zip.GZIPInputStream;
import projections.analysis.Analysis;
import projections.analysis.AsciiLineParser;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.analysis.StsReader;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    private static int myRun = 0;
    private int bufferSize = 262144;
    private double version;
    private BufferedReader reader;
    private long lastRecordedTime = 0L;
    private LogEntryData lastBeginEvent = null;
    private boolean endComputationOccurred;
    long shiftAmount = 0L;

    public GenericLogReader(int peNum, double Nversion) {
        super(MainWindow.runObject[myRun].getLog(peNum), String.valueOf(Nversion));
        this.sourceFile = MainWindow.runObject[myRun].getLog(peNum);
        this.shiftAmount = MainWindow.runObject[GenericLogReader.myRun].tachyonShifts.getShiftAmount(peNum);
        this.lastBeginEvent = new LogEntryData();
        this.lastBeginEvent.setValid(false);
        this.endComputationOccurred = false;
        this.reader = this.createBufferedReader(this.sourceFile);
        this.version = Nversion;
        try {
            this.reader.readLine();
        }
        catch (IOException e) {
            System.err.println("Error reading file");
        }
    }

    private BufferedReader createBufferedReader(File file) {
        BufferedReader r = null;
        String filename = file.getAbsolutePath();
        String s3 = filename.substring(filename.length() - 3);
        try {
            if (s3.compareTo(".gz") == 0) {
                FileInputStream fis = new FileInputStream(file);
                GZIPInputStream gis = new GZIPInputStream(fis);
                r = new BufferedReader(new InputStreamReader(gis), this.bufferSize);
            } else {
                FileReader fr = new FileReader(file);
                r = new BufferedReader(fr, this.bufferSize);
            }
        }
        catch (IOException e2) {
            System.err.println("Error reading file " + filename);
            return null;
        }
        return r;
    }

    protected boolean checkAvailable() {
        return this.sourceFile.canRead();
    }

    private String interpretNote(String input) {
        Analysis a = MainWindow.runObject[myRun];
        String modified = input;
        if (modified.contains("<EP")) {
            int numEntries = a.getEntryCount();
            for (int i = 0; i < numEntries; ++i) {
                String name = a.getEntryFullNameByID(i);
                modified = modified.replace("<EP " + i + ">", name);
            }
        }
        return modified;
    }

    public LogEntryData nextEvent() throws InputMismatchException, IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        StsReader stsinfo = MainWindow.runObject[myRun].getSts();
        String line = this.reader.readLine();
        if (line == null) {
            throw new EndOfLogSuccess();
        }
        AsciiLineParser sc = new AsciiLineParser(line);
        if (this.endComputationOccurred) {
            throw new EndOfLogSuccess();
        }
        if (line == null) {
            this.endComputationOccurred = true;
            data.type = 7;
            data.time = this.lastRecordedTime;
            System.err.println("[" + this.sourceFile.getAbsolutePath() + "] WARNING: Partial or Corrupted Projections log. Faked END_COMPUTATION entry added for last recorded time of " + data.time);
            return data;
        }
        data.type = (int)sc.nextLong();
        switch (data.type) {
            case 14: {
                this.lastBeginEvent.time = data.time = sc.nextLong() + this.shiftAmount;
                this.lastBeginEvent.pe = data.pe = (int)sc.nextLong();
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 15: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.pe = (int)sc.nextLong();
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.pe = (int)sc.nextLong();
                break;
            }
            case 26: {
                data.userSupplied = new Integer((int)sc.nextLong());
                break;
            }
            case 28: {
                data.time = sc.nextLong() + this.shiftAmount;
                int strLen = (int)sc.nextLong();
                data.note = this.interpretNote(sc.nextString(strLen));
                break;
            }
            case 29: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.endTime = sc.nextLong();
                data.entry = data.userEventID = (int)sc.nextLong();
                int brStrLen = (int)sc.nextLong();
                data.note = this.interpretNote(sc.nextString(brStrLen));
                break;
            }
            case 27: {
                data.memoryUsage = sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                break;
            }
            case 1: {
                data.mtype = (int)sc.nextLong();
                data.entry = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                data.msglen = this.version >= 2.0 ? (int)sc.nextLong() : -1;
                if (!(this.version >= 5.0)) break;
                data.sendTime = sc.nextLong() + this.shiftAmount;
                break;
            }
            case 20: {
                data.mtype = (int)sc.nextLong();
                data.entry = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                data.msglen = this.version >= 2.0 ? (int)sc.nextLong() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = sc.nextLong() + this.shiftAmount;
                }
                data.numPEs = (int)sc.nextLong();
                break;
            }
            case 21: {
                data.mtype = (int)sc.nextLong();
                data.entry = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                data.msglen = this.version >= 2.0 ? (int)sc.nextLong() : -1;
                if (this.version >= 5.0) {
                    data.sendTime = sc.nextLong() + this.shiftAmount;
                }
                data.numPEs = (int)sc.nextLong();
                data.destPEs = new int[data.numPEs];
                for (int i = 0; i < data.numPEs; ++i) {
                    data.destPEs[i] = (int)sc.nextLong();
                }
                break;
            }
            case 2: {
                this.lastBeginEvent.mtype = data.mtype = (int)sc.nextLong();
                this.lastBeginEvent.entry = data.entry = (int)sc.nextLong();
                this.lastBeginEvent.time = data.time = sc.nextLong() + this.shiftAmount;
                this.lastBeginEvent.event = data.event = (int)sc.nextLong();
                this.lastBeginEvent.pe = data.pe = (int)sc.nextLong();
                if (this.version >= 2.0) {
                    this.lastBeginEvent.msglen = data.msglen = (int)sc.nextLong();
                } else {
                    data.msglen = -1;
                    this.lastBeginEvent.msglen = -1;
                }
                if (this.version >= 4.0) {
                    this.lastBeginEvent.recvTime = data.recvTime = sc.nextLong() + this.shiftAmount;
                    this.lastBeginEvent.id[0] = data.id[0] = (int)sc.nextLong();
                    this.lastBeginEvent.id[1] = data.id[1] = (int)sc.nextLong();
                    this.lastBeginEvent.id[2] = data.id[2] = (int)sc.nextLong();
                }
                if (this.version >= 7.0) {
                    this.lastBeginEvent.id[3] = data.id[3] = (int)sc.nextLong();
                }
                if (this.version >= 6.5) {
                    this.lastBeginEvent.cpuStartTime = data.cpuStartTime = sc.nextLong() + this.shiftAmount;
                }
                if (this.version >= 6.6) {
                    this.lastBeginEvent.numPerfCounts = data.numPerfCounts = stsinfo.getNumPerfCounts();
                    this.lastBeginEvent.perfCounts = new long[data.numPerfCounts];
                    data.perfCounts = new long[data.numPerfCounts];
                    for (int i = 0; i < data.numPerfCounts; ++i) {
                        this.lastBeginEvent.perfCounts[i] = data.perfCounts[i] = sc.nextLong();
                    }
                }
                this.lastBeginEvent.setValid(true);
                break;
            }
            case 3: {
                data.mtype = (int)sc.nextLong();
                data.entry = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                data.msglen = this.version >= 2.0 ? (int)sc.nextLong() : -1;
                if (this.version >= 6.5) {
                    data.cpuEndTime = sc.nextLong() + this.shiftAmount;
                }
                if (!(this.version >= 6.6)) break;
                data.numPerfCounts = stsinfo.getNumPerfCounts();
                data.perfCounts = new long[data.numPerfCounts];
                for (int i = 0; i < data.numPerfCounts; ++i) {
                    data.perfCounts[i] = sc.nextLong();
                }
                break;
            }
            case 11: {
                data.time = sc.nextLong() + this.shiftAmount;
                this.lastBeginEvent.setValid(false);
                break;
            }
            case 12: {
                data.time = sc.nextLong() + this.shiftAmount;
                break;
            }
            case 22: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.entry = (int)sc.nextLong();
                data.lineNo = (int)sc.nextLong();
                data.funcName = "";
                break;
            }
            case 23: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.entry = (int)sc.nextLong();
                break;
            }
            case 10: {
                data.mtype = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                data.msglen = (int)sc.nextLong();
                break;
            }
            case 4: 
            case 5: {
                data.mtype = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                break;
            }
            case 8: 
            case 9: {
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                break;
            }
            case 6: {
                data.time = sc.nextLong() + this.shiftAmount;
                break;
            }
            case 7: {
                data.time = sc.nextLong() + this.shiftAmount;
                this.endComputationOccurred = true;
                break;
            }
            case 13: {
                data.entry = data.userEventID = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                break;
            }
            case 100: {
                data.entry = data.userEventID = (int)sc.nextLong();
                data.time = sc.nextLong() + this.shiftAmount;
                data.event = (int)sc.nextLong();
                data.pe = (int)sc.nextLong();
                break;
            }
            default: {
                data.type = -1;
            }
        }
        this.lastRecordedTime = data.time;
        return data;
    }

    public LogEntryData nextEventOnOrAfter(long timestamp) throws IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
            while (data.type == -1) {
                data = this.nextEvent();
            }
        } while (data.time < timestamp);
        return data;
    }

    public LogEntryData nextEventOfType(int eventType) throws IOException, EndOfLogSuccess {
        LogEntryData data = new LogEntryData();
        do {
            data = this.nextEvent();
        } while (data.type != eventType);
        return data;
    }

    public LogEntryData getLastBE() {
        if (this.lastBeginEvent.isValid()) {
            return this.lastBeginEvent;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

