/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import projections.analysis.IntervalUtils;
import projections.analysis.SumDetailReader;
import projections.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalData {
    private int myRun = 0;
    private static final int TYPE_TIME = 0;
    private static final int TYPE_NUM_MSGS = 1;
    private static SumDetailReader[] summaryDetails;
    private Vector[][][] rawData;
    private int[][][] systemUsageData = null;
    private int[][][][] systemMsgsData = null;
    private int[][][][] userEntryData = null;
    private int numEPs = 0;
    private int numPEs = MainWindow.runObject[this.myRun].getNumProcessors();
    private int numIntervals = 0;
    private double intervalSize = 0.0;
    private int[][] sumDetailData = null;

    public IntervalData() {
        this.numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (MainWindow.runObject[this.myRun].hasSumDetailData()) {
            summaryDetails = new SumDetailReader[this.numPEs];
            this.rawData = new Vector[2][this.numPEs][];
            SortedSet<Integer> availablePEs = MainWindow.runObject[this.myRun].getValidProcessorList(2);
            for (Integer pe : availablePEs) {
                try {
                    IntervalData.summaryDetails[pe.intValue()] = new SumDetailReader(MainWindow.runObject[this.myRun].getSumDetailLog(pe), MainWindow.runObject[this.myRun].getVersion());
                    summaryDetails[pe].readStaticData();
                    summaryDetails[pe].read();
                    for (int type = 0; type < 2; ++type) {
                        this.rawData[type][pe.intValue()] = summaryDetails[pe].getData(type);
                    }
                    if (this.numIntervals < summaryDetails[pe].getNumIntervals()) {
                        this.numIntervals = summaryDetails[pe].getNumIntervals();
                    }
                    this.intervalSize = summaryDetails[pe].getIntervalSize();
                }
                catch (IOException e) {
                    System.err.println("Warning: Failed to read summary detail file for processor " + pe);
                    e.printStackTrace();
                }
            }
            System.out.println("IntervalData - hasSumDetailData + numIntervals: " + this.numIntervals + " intervalSize: " + this.intervalSize);
        }
    }

    public void loadSumDetailIntervalData(long intervalSize, int intervalStart, int intervalEnd, SortedSet<Integer> processorList) {
        int numIntervals = intervalEnd - intervalStart + 1;
        this.sumDetailData = new int[numIntervals][this.numEPs];
        for (Integer curPe : processorList) {
            double[][] tempData = this.getData(curPe, 0);
            for (int i = 0; i < numIntervals; ++i) {
                for (int e = 0; e < this.numEPs; ++e) {
                    int[] nArray = this.sumDetailData[i];
                    int n = e;
                    nArray[n] = (int)((double)nArray[n] + tempData[e][i]);
                }
            }
        }
    }

    public void loadIntervalData(long intervalSize, int intervalStart, int intervalEnd, boolean byEntryPoint, SortedSet<Integer> processorList) {
        int numIntervals = intervalEnd - intervalStart + 1;
        this.systemUsageData = new int[3][processorList.size()][numIntervals];
        this.systemMsgsData = new int[5][3][processorList.size()][numIntervals];
        if (byEntryPoint) {
            this.userEntryData = new int[this.numEPs][3][processorList.size()][numIntervals];
        }
        double[][] tempData = null;
        int processorCount = 0;
        for (Integer curPe : processorList) {
            int ep;
            int i;
            tempData = this.getData(curPe, 0, intervalSize, intervalStart, intervalEnd - intervalStart + 1);
            for (i = 0; i < numIntervals; ++i) {
                for (ep = 0; ep < this.numEPs; ++ep) {
                    if (byEntryPoint) {
                        this.userEntryData[ep][2][processorCount][i] = (int)tempData[ep][i];
                    }
                    int[] nArray = this.systemUsageData[1][processorCount];
                    int n = i;
                    nArray[n] = nArray[n] + (int)tempData[ep][i];
                }
                this.systemUsageData[1][processorCount][i] = (int)IntervalUtils.timeToUtil(this.systemUsageData[1][processorCount][i], (double)intervalSize);
            }
            tempData = this.getData(curPe, 1, intervalSize, intervalStart, intervalEnd - intervalStart + 1);
            for (i = 0; i < numIntervals; ++i) {
                for (ep = 0; ep < this.numEPs; ++ep) {
                    int[] nArray = this.systemMsgsData[1][2][processorCount];
                    int n = i;
                    nArray[n] = nArray[n] + (int)tempData[ep][i];
                }
            }
            ++processorCount;
        }
    }

    public int[][] sumDetailData() {
        return this.sumDetailData;
    }

    public int[][][] getSystemUsageData() {
        return this.systemUsageData;
    }

    public int[][][][] getSystemMsgs() {
        return this.systemMsgsData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntryData;
    }

    private double[][] getData(int pe, int type) {
        double[][] returnData = new double[this.numEPs][this.numIntervals];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            Iterator blockIterator = this.rawData[type][pe][ep].iterator();
            int curInterval = 0;
            while (blockIterator.hasNext()) {
                SumDetailReader.RLEBlock nextBlock = (SumDetailReader.RLEBlock)blockIterator.next();
                for (int offset = 0; offset < nextBlock.count; ++offset) {
                    returnData[ep][curInterval + offset] = nextBlock.value;
                }
                curInterval += nextBlock.count;
            }
        }
        return returnData;
    }

    private double[][] getData(int pe, int type, long destIntervalSize, int destIntervalStart, int numDestIntervals) {
        double[][] tempData = this.getData(pe, type);
        double[][] returnData = null;
        if ((double)destIntervalSize == this.intervalSize) {
            if (destIntervalStart == 0 && numDestIntervals == this.numIntervals) {
                return tempData;
            }
            returnData = new double[this.numEPs][numDestIntervals];
            for (int ep = 0; ep < tempData.length; ++ep) {
                for (int interval = destIntervalStart; interval < destIntervalStart + numDestIntervals; ++interval) {
                    returnData[ep][interval - destIntervalStart] = tempData[ep][interval];
                }
            }
            return returnData;
        }
        returnData = new double[this.numEPs][numDestIntervals];
        boolean discrete = false;
        if (type == 1) {
            discrete = true;
        }
        for (int ep = 0; ep < tempData.length; ++ep) {
            for (int srcInt = 0; srcInt < tempData[ep].length; ++srcInt) {
                IntervalUtils.fillIntervals(returnData[ep], destIntervalSize, destIntervalStart, (long)((double)srcInt * this.intervalSize), (long)((double)(srcInt + 1) * this.intervalSize - 1.0), tempData[ep][srcInt], discrete);
            }
        }
        return returnData;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }
}

