/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Random;

public class KMeansClustering {
    public static void kMeans(double[][] in_data, int numClusters, int[] clusterMap, double[] distanceFromClusterMean) {
        int k;
        int p;
        double[][] data = KMeansClustering.normalize(in_data);
        int numProcs = data.length;
        int numMetrics = data[0].length;
        double[][] centroids = new double[numClusters][numMetrics];
        double[][] newCentroidVectors = new double[numClusters][numMetrics];
        int[] clusterCounts = new int[numClusters];
        boolean[] clusterChange = new boolean[numClusters];
        for (p = 0; p < numProcs; ++p) {
            clusterMap[p] = -1;
        }
        KMeansClustering.setCentroidRandom(centroids, numClusters, data);
        for (k = 0; k < numClusters; ++k) {
            clusterChange[k] = true;
        }
        while (!KMeansClustering.isConverged(clusterChange)) {
            for (k = 0; k < numClusters; ++k) {
                clusterChange[k] = false;
                clusterCounts[k] = 0;
                for (int metric = 0; metric < numMetrics; ++metric) {
                    newCentroidVectors[k][metric] = 0.0;
                }
            }
            for (p = 0; p < numProcs; ++p) {
                double minDist = Double.MAX_VALUE;
                int currentK = -1;
                for (int k2 = 0; k2 < numClusters; ++k2) {
                    double tempDist = 0.0;
                    for (int metric = 0; metric < numMetrics; ++metric) {
                        tempDist += Math.pow(data[p][metric] - centroids[k2][metric], 2.0);
                    }
                    if (!((tempDist = Math.sqrt(tempDist)) < minDist)) continue;
                    minDist = tempDist;
                    currentK = k2;
                }
                int n = currentK;
                clusterCounts[n] = clusterCounts[n] + 1;
                if (currentK != clusterMap[p]) {
                    clusterChange[currentK] = true;
                }
                clusterMap[p] = currentK;
                distanceFromClusterMean[p] = minDist;
                for (int metric = 0; metric < numMetrics; ++metric) {
                    double[] dArray = newCentroidVectors[currentK];
                    int n2 = metric;
                    dArray[n2] = dArray[n2] + data[p][metric];
                }
            }
            for (k = 0; k < numClusters; ++k) {
                for (int metric = 0; metric < numMetrics; ++metric) {
                    if (clusterCounts[k] <= 0) continue;
                    centroids[k][metric] = newCentroidVectors[k][metric] / (double)clusterCounts[k];
                }
            }
        }
        KMeansClustering.outputResults(clusterMap, numClusters, distanceFromClusterMean, false);
    }

    private static boolean isConverged(boolean[] clusterChange) {
        for (int k = 0; k < clusterChange.length; ++k) {
            if (!clusterChange[k]) continue;
            return false;
        }
        return true;
    }

    private static void setCentroidRandom(double[][] centroid, int numClusters, double[][] data) {
        int numProcs = data.length;
        int[] pickedCentroids = new int[numClusters];
        for (int k = 0; k < numClusters; ++k) {
            pickedCentroids[k] = -1;
        }
        Random rand = new Random(11337L);
        int numPicked = 0;
        while (numPicked < numClusters) {
            int randomNum = rand.nextInt(numProcs);
            boolean duplicate = false;
            for (int k = 0; k <= numPicked; ++k) {
                if (pickedCentroids[k] != randomNum) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            pickedCentroids[numPicked] = randomNum;
            System.out.println("Centroid " + randomNum + " picked");
            for (int act = 0; act < centroid[numPicked].length; ++act) {
                centroid[numPicked][act] = data[randomNum][act];
            }
            ++numPicked;
        }
    }

    private static double[][] normalize(double[][] data) {
        double[][] normalized = new double[data.length][data[0].length];
        for (int metric = 0; metric < data[0].length; ++metric) {
            int p;
            double min = Double.MAX_VALUE;
            for (p = 0; p < data.length; ++p) {
                if (!(data[p][metric] < min)) continue;
                min = data[p][metric];
            }
            for (p = 0; p < data.length; ++p) {
                normalized[p][metric] = data[p][metric] - min;
            }
        }
        return normalized;
    }

    private static void outputResults(int[] clusterMap, int numClusters, double[] distanceFromClusterMean, boolean outputDetails) {
        int k;
        int numPoints = distanceFromClusterMean.length;
        int numNonEmpty = 0;
        double quality = 0.0;
        double[] clusterMax = new double[numPoints];
        int[] clusterCounts = new int[numClusters];
        boolean[] clusterHasStuff = new boolean[numClusters];
        for (k = 0; k < numClusters; ++k) {
            clusterCounts[k] = 0;
            clusterHasStuff[k] = false;
        }
        for (int p = 0; p < numPoints; ++p) {
            int k2 = clusterMap[p];
            clusterHasStuff[k2] = true;
            int n = k2;
            clusterCounts[n] = clusterCounts[n] + 1;
            if (!(distanceFromClusterMean[p] > clusterMax[k2])) continue;
            clusterMax[k2] = distanceFromClusterMean[p];
        }
        for (k = 0; k < numClusters; ++k) {
            if (!clusterHasStuff[k]) continue;
            quality += clusterMax[k];
            ++numNonEmpty;
        }
        System.out.println("Cluster Results:");
        System.out.println("----------------");
        System.out.println("Chosen Num Clusters: " + numClusters);
        System.out.println("Num Non Empty: " + numNonEmpty);
        System.out.print("Cluster Counts: ");
        for (k = 0; k < numClusters; ++k) {
            if (!clusterHasStuff[k]) continue;
            System.out.print("[" + k + "] " + clusterCounts[k] + ", ");
        }
        System.out.println();
        System.out.println("Average Cluster Quality: " + quality / (double)numNonEmpty);
        System.out.println("================================");
        if (outputDetails) {
            for (k = 0; k < numClusters; ++k) {
                System.out.println("[" + k + "]:");
                for (int p = 0; p < clusterMap.length; ++p) {
                    if (clusterMap[p] != k) continue;
                    System.out.println(p);
                }
            }
        }
    }

    public static void main(String[] args) {
        int numClusters = 5;
        double[][] data = new double[][]{{0.0, 5.0}, {1.0, 1.0}, {1.0, 2.0}, {1.0, 4.0}, {2.0, 1.0}, {2.0, 7.0}, {3.0, 6.0}, {3.0, 8.0}, {4.0, 9.0}, {5.0, 2.0}, {5.0, 7.0}, {6.0, 1.0}, {7.0, 2.0}, {9.0, 4.0}, {9.0, 5.0}};
        int[] clusterMap = new int[data.length];
        double[] distanceFromClusterMean = new double[data.length];
        KMeansClustering.kMeans(data, numClusters, clusterMap, distanceFromClusterMean);
        KMeansClustering.outputResults(clusterMap, numClusters, distanceFromClusterMean, true);
    }
}

