/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Color;
import java.util.Vector;
import projections.gui.ColorManager;
import projections.gui.U;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;
import projections.misc.ProjectionsStatistics;

public class MultiRunDataAnalyzer {
    private MultiRunData data;
    private double[][][] dataTable;
    private double[][][] extraTable;
    private static final int NUM_EXTR_ENTRIES = 1;
    private static final int EXTR_OVERHEAD = 0;
    private static final String[] extraNames = new String[]{"Idle Time and System Overhead"};
    private double[] runTimeSum;
    private double[] epTimeMean;
    private double[] epTimeVariance;
    private Vector[][] categories;
    private String[] catNames;
    private static final int NUM_CATEGORIES = 4;
    private static final int CAT_EP_NO_CHANGE = 0;
    private static final int CAT_EP_INSIGNIFICANT = 1;
    private static final int CAT_EP_CHANGE = 2;
    private static final int CAT_OVERHEAD_IDLE = 3;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;
    private ProjectionsStatistics timeStats = new ProjectionsStatistics();
    private double[][] outputData;

    public MultiRunDataAnalyzer(MultiRunData data) {
        this.data = data;
        this.numEPs = data.getNumEPs();
        this.numRuns = data.getNumRuns();
        this.epNames = data.getEPNames();
        this.runNames = data.getRunNames();
        this.dataTable = data.getData();
        this.computeDerivedInformation();
        this.computeExtraInformation();
        this.computeExtraDerivedInformation();
        this.constructCategories();
    }

    private void computeDerivedInformation() {
        this.runTimeSum = new double[this.numRuns];
        for (int run = 0; run < this.numRuns; ++run) {
            this.timeStats.reset();
            this.timeStats.accumulate(this.dataTable[0][run]);
            this.runTimeSum[run] = this.timeStats.getSum();
        }
        this.epTimeMean = new double[this.numEPs];
        this.epTimeVariance = new double[this.numEPs];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.timeStats.reset();
            for (int run = 0; run < this.numRuns; ++run) {
                this.timeStats.accumulate(this.dataTable[0][run][ep]);
            }
            this.epTimeMean[ep] = this.timeStats.getMean();
            this.epTimeVariance[ep] = this.timeStats.getVariance(this.epTimeMean[ep]);
        }
    }

    private void computeExtraInformation() {
        this.extraTable = new double[4][this.numRuns][1];
        double[] runWallTimes = this.data.getRunWallTimes();
        for (int run = 0; run < this.numRuns; ++run) {
            this.extraTable[0][run][0] = runWallTimes[run] - this.runTimeSum[run];
        }
    }

    private void computeExtraDerivedInformation() {
    }

    private void constructCategories() {
        this.categories = new Vector[4][4];
        this.catNames = new String[4];
        for (int cat = 0; cat < 4; ++cat) {
            this.catNames[cat] = this.getCategoryName(cat);
        }
        for (int type = 0; type < 4; ++type) {
            for (int category = 0; category < 4; ++category) {
                this.categories[type][category] = new Vector();
            }
            this.categorize(type);
        }
    }

    private String getCategoryName(int categoryID) {
        switch (categoryID) {
            case 0: {
                return "EPs with little change";
            }
            case 1: {
                return "Insignificant EPs";
            }
            case 2: {
                return "EPs with change";
            }
            case 3: {
                return "Idle time and System Overhead";
            }
        }
        return "unknown category";
    }

    private void categorize(int dataType) {
        for (int ep = 0; ep < this.numEPs; ++ep) {
            int insigCount = 0;
            for (int run = 0; run < this.numRuns; ++run) {
                if (!(this.dataTable[dataType][run][ep] < 0.01 * this.runTimeSum[run])) continue;
                ++insigCount;
            }
            if (insigCount > this.numRuns / 2) {
                this.categories[dataType][1].add(new Integer(ep));
                continue;
            }
            int consecutiveIncrements = 0;
            int consecutiveDecrements = 0;
            boolean lastIncremented = true;
            double avgChange = 0.0;
            double prevValue = this.dataTable[dataType][0][ep];
            if (this.dataTable[dataType][1][ep] > prevValue) {
                consecutiveIncrements = 1;
                avgChange += this.dataTable[dataType][1][ep] - prevValue;
                lastIncremented = true;
            } else if (this.dataTable[dataType][1][ep] < prevValue) {
                consecutiveDecrements = 1;
                avgChange += prevValue - this.dataTable[dataType][1][ep];
                lastIncremented = false;
            }
            prevValue = this.dataTable[dataType][1][ep];
            for (int run = 2; run < this.numRuns; ++run) {
                double change;
                if (this.dataTable[dataType][run][ep] > prevValue) {
                    change = this.dataTable[dataType][run][ep] - prevValue;
                    if (lastIncremented) {
                        avgChange = avgChange * (double)consecutiveIncrements + change;
                        avgChange /= (double)(++consecutiveIncrements);
                    } else {
                        consecutiveIncrements = 1;
                        avgChange = change;
                    }
                    lastIncremented = true;
                } else if (this.dataTable[dataType][run][ep] < prevValue) {
                    change = prevValue - this.dataTable[dataType][run][ep];
                    if (!lastIncremented) {
                        avgChange = avgChange * (double)consecutiveDecrements + change;
                        avgChange /= (double)(++consecutiveDecrements);
                    } else {
                        consecutiveDecrements = 1;
                        avgChange = change;
                    }
                    lastIncremented = false;
                }
                prevValue = this.dataTable[dataType][run][ep];
            }
            if (this.numRuns == 1) {
                this.categories[dataType][0].add(new Integer(ep));
                continue;
            }
            if (((double)consecutiveIncrements > (double)(this.numRuns - 1) * 0.5 || (double)consecutiveDecrements > (double)(this.numRuns - 1) * 0.5) && avgChange > this.dataTable[dataType][0][ep] * 0.1) {
                this.categories[dataType][2].add(new Integer(ep));
                continue;
            }
            this.categories[dataType][0].add(new Integer(ep));
        }
        for (int entry = 0; entry < 1; ++entry) {
            switch (entry) {
                case 0: {
                    this.categories[dataType][3].add(new Integer(this.numEPs + 0));
                }
            }
        }
    }

    public int getNumRows(int dataType, int categoryIndex) {
        return this.categories[dataType][categoryIndex].size();
    }

    public int getNumColumns() {
        return this.numRuns + 1;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Entry Point Name";
        }
        return this.runNames[col - 1];
    }

    public Object getTableValueAt(int dataType, int categoryIndex, int row, int col) {
        int epIndex = (Integer)this.categories[dataType][categoryIndex].elementAt(row);
        if (col == 0) {
            if (epIndex >= this.numEPs) {
                return extraNames[this.numEPs - epIndex];
            }
            return this.epNames[epIndex];
        }
        if (epIndex >= this.numEPs) {
            return new Double(this.extraTable[dataType][col - 1][this.numEPs - epIndex]);
        }
        return new Double(this.dataTable[dataType][col - 1][epIndex]);
    }

    public String[] getCategoryNames() {
        return this.catNames;
    }

    public MultiRunDataSource getDataSource(int dataType) {
        int numYvalues = this.numEPs - this.categories[dataType][1].size() + 1 + 1;
        this.outputData = new double[this.numRuns][numYvalues];
        String titleString = "";
        switch (dataType) {
            case 0: {
                titleString = "Time taken";
                break;
            }
            case 1: {
                titleString = "Number of times called";
                break;
            }
            case 2: {
                titleString = "Messages sent per processor";
                break;
            }
            case 3: {
                titleString = "Amount of data sent";
            }
        }
        this.computeOutputArray(this.outputData, dataType);
        Color[] colorMap = this.computeColorMap(numYvalues, dataType);
        return new MultiRunDataSource(this, this.outputData, dataType, colorMap, titleString);
    }

    public MultiRunXAxis getMRXAxisData() {
        return new MultiRunXAxis(this.runNames);
    }

    public MultiRunYAxis getMRYAxisData(int dataType) {
        String title = "";
        int outAxisType = 1;
        switch (dataType) {
            case 0: {
                title = "Time summed across processors (us)";
                outAxisType = 1;
                break;
            }
            case 1: {
                title = "Number of times entry point was called";
                outAxisType = 2;
                break;
            }
            case 2: {
                title = "Number of messages sent per processor";
                outAxisType = 2;
                break;
            }
            case 3: {
                title = "Total amount of data sent (bytes)";
                outAxisType = 2;
            }
        }
        ProjectionsStatistics stats = new ProjectionsStatistics();
        for (int run = 0; run < this.numRuns; ++run) {
            stats.accumulate(this.outputData[run]);
        }
        return new MultiRunYAxis(outAxisType, title, stats.getMax());
    }

    public String[] getPopup(int xVal, int yVal, int dataType) {
        String[] returnStrings = new String[4];
        returnStrings[0] = this.runNames[xVal];
        int numNoChange = this.categories[dataType][0].size();
        int numChanged = this.categories[dataType][2].size();
        int category = 0;
        if (yVal < numNoChange) {
            category = 0;
            int catIdx = yVal;
            int epIdx = (Integer)this.categories[dataType][category].elementAt(catIdx);
            returnStrings[2] = "Entry Point: " + this.epNames[epIdx];
        } else if (yVal < numNoChange + 1) {
            category = 1;
            returnStrings[2] = "Bunch of EPs";
        } else if (yVal < numNoChange + 1 + numChanged) {
            category = 2;
            int catIdx = yVal - 1 - numNoChange;
            int epIdx = (Integer)this.categories[dataType][category].elementAt(catIdx);
            returnStrings[2] = "Entry Point: " + this.epNames[epIdx];
        } else {
            category = 3;
            returnStrings[2] = "";
        }
        returnStrings[1] = this.catNames[category];
        switch (dataType) {
            case 0: {
                returnStrings[3] = "Exec Time: " + U.humanReadableString((long)this.outputData[xVal][yVal]);
                break;
            }
            case 1: {
                returnStrings[3] = "Times called: " + (long)this.outputData[xVal][yVal];
                break;
            }
            case 2: {
                returnStrings[3] = "Msgs Sent: " + (long)this.outputData[xVal][yVal];
                break;
            }
            case 3: {
                returnStrings[3] = "Msg Volume: " + (long)this.outputData[xVal][yVal];
            }
        }
        return returnStrings;
    }

    private void computeOutputArray(double[][] data, int dataType) {
        int epIdx;
        int catIdx;
        int entry = 0;
        int numNoChange = this.categories[dataType][0].size();
        for (int catIdx2 = 0; catIdx2 < numNoChange; ++catIdx2) {
            int epIdx2 = (Integer)this.categories[dataType][0].elementAt(catIdx2);
            for (int run = 0; run < this.numRuns; ++run) {
                data[run][entry] = this.dataTable[dataType][run][epIdx2];
            }
            ++entry;
        }
        int numInsignificant = this.categories[dataType][1].size();
        for (int run = 0; run < this.numRuns; ++run) {
            for (catIdx = 0; catIdx < numInsignificant; ++catIdx) {
                epIdx = (Integer)this.categories[dataType][1].elementAt(catIdx);
                double[] dArray = data[run];
                int n = entry;
                dArray[n] = dArray[n] + this.dataTable[dataType][run][epIdx];
            }
        }
        ++entry;
        int numChanged = this.categories[dataType][2].size();
        for (catIdx = 0; catIdx < numChanged; ++catIdx) {
            epIdx = (Integer)this.categories[dataType][2].elementAt(catIdx);
            for (int run = 0; run < this.numRuns; ++run) {
                data[run][entry] = this.dataTable[dataType][run][epIdx];
            }
            ++entry;
        }
        int numOverhead = this.categories[dataType][3].size();
        for (int catIdx3 = 0; catIdx3 < numOverhead; ++catIdx3) {
            int entryIdx = this.numEPs - (Integer)this.categories[dataType][3].elementAt(catIdx3);
            for (int run = 0; run < this.numRuns; ++run) {
                data[run][entry] = this.extraTable[dataType][run][entryIdx];
            }
            ++entry;
        }
    }

    private Color[] computeColorMap(int numColors, int dataType) {
        Color[] colorMap = new Color[numColors];
        int numNoChange = this.categories[dataType][0].size();
        int numChanged = this.categories[dataType][2].size();
        colorMap = ColorManager.createColorMap(numColors);
        colorMap[numNoChange] = Color.gray;
        int numOverhead = this.categories[dataType][3].size();
        int offset = numNoChange + 1 + numChanged;
        for (int catIdx = 0; catIdx < numOverhead; ++catIdx) {
            switch (catIdx) {
                case 0: {
                    colorMap[offset + catIdx] = Color.white;
                }
            }
        }
        return colorMap;
    }
}

