/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import projections.misc.FileUtils;
import projections.misc.LogLoadException;

public class ProjectionsConfigurationReader {
    private String projrcFileName;
    private boolean dirty;
    FileUtils fileNameHandler;
    public Long RC_GLOBAL_END_TIME = new Long(-1L);
    public Long RC_POSE_REAL_TIME = new Long(-1L);
    public Long RC_POSE_VIRT_TIME = new Long(-1L);
    public Boolean RC_OUTLIER_FILTERED = false;

    public ProjectionsConfigurationReader(FileUtils fileNameHandler) {
        this.fileNameHandler = fileNameHandler;
        this.projrcFileName = fileNameHandler.getProjRCName();
        this.dirty = false;
        try {
            this.readfile();
        }
        catch (LogLoadException e) {
            System.err.println(e.toString());
            System.exit(-1);
        }
    }

    private void readfile() throws LogLoadException {
        try {
            String Line;
            BufferedReader InFile = new BufferedReader(new InputStreamReader(new FileInputStream(this.projrcFileName)));
            while ((Line = InFile.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(Line);
                String s1 = "";
                try {
                    s1 = st.nextToken();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                String tempStr = "";
                if (!s1.startsWith("RC_")) {
                    System.err.println("Warning: Key [" + s1 + "] does not " + "start with RC_ and is rejected.");
                    continue;
                }
                try {
                    Field rcField = this.getClass().getField(s1);
                    try {
                        tempStr = st.nextToken();
                    }
                    catch (NoSuchElementException e) {
                        tempStr = "";
                    }
                    if (Class.forName("java.lang.String").equals(rcField.getType())) {
                        rcField.set(this, tempStr);
                        continue;
                    }
                    rcField.set(this, rcField.getType().getMethod("valueOf", Class.forName("java.lang.String")).invoke(null, tempStr));
                }
                catch (NoSuchFieldException e) {
                    System.err.println("Warning: Key [" + s1 + "] is " + "not supported on this version " + "of Projections!");
                }
                catch (Exception e) {
                    System.err.println("Internal Error: Encountered when attempting to assign value [" + tempStr + "] to configuration key [" + s1 + "] Please report to " + "developers!");
                    System.err.println(e.toString());
                    System.exit(-1);
                }
            }
            InFile.close();
        }
        catch (FileNotFoundException InFile) {
        }
        catch (IOException e) {
            throw new LogLoadException(this.projrcFileName);
        }
    }

    public void writeFile() throws LogLoadException {
        String filedata = "";
        try {
            Field[] rcFields = this.getClass().getFields();
            for (int field = 0; field < rcFields.length; ++field) {
                String fieldname = rcFields[field].getName();
                if (!fieldname.startsWith("RC_")) continue;
                filedata = filedata + "" + fieldname + " " + rcFields[field].get(this).toString() + "\n";
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Internal Error: Cannot write configuration (.projrc) file. Please report to developers!");
            System.err.println(e.toString());
            System.exit(-1);
        }
        catch (IllegalAccessException e) {
            System.err.println("Internal Error: Cannot write configuration (.projrc) file. Please report to developers!");
            System.err.println(e.toString());
            System.exit(-1);
        }
        if (this.dirty && filedata.length() > 0) {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(this.projrcFileName));
                try {
                    writer.print(filedata);
                }
                catch (Exception e) {
                    System.err.println("Internal Error: Cannot write configuration (.projrc) file. Please report to developers!");
                    System.err.println(e.toString());
                    System.exit(-1);
                }
                writer.close();
            }
            catch (FileNotFoundException e) {
                throw new LogLoadException(this.projrcFileName);
            }
            catch (IOException e) {
                throw new LogLoadException(this.projrcFileName);
            }
        }
    }

    public void setValue(String key, Object value) {
        if (!key.startsWith("RC_")) {
            System.err.println("Internal Error: Request to set configuration option [" + key + "] not supported! Please report to " + "developers!");
            System.exit(-1);
        } else {
            try {
                Field rcField = this.getClass().getField(key);
                rcField.set(this, value);
                this.dirty = true;
            }
            catch (NoSuchFieldException e) {
                System.err.println("Internal Error: Request to set configuration option [" + key + "] not supported! Please report to " + "developers!");
                System.err.println(e.toString());
                System.exit(-1);
            }
            catch (SecurityException e) {
                System.err.println("Internal Error: Request to set configuration option [" + key + "] not supported! Please report to " + "developers!");
                System.err.println(e.toString());
                System.exit(-1);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Internal Error: Request to set configuration option [" + key + "] not supported! Please report to " + "developers!");
                System.err.println(e.toString());
                System.exit(-1);
            }
            catch (IllegalAccessException e) {
                System.err.println("Internal Error: Request to set configuration option [" + key + "] not supported! Please report to " + "developers!");
                System.err.println(e.toString());
                System.exit(-1);
            }
        }
    }

    public void close() {
        try {
            this.writeFile();
        }
        catch (LogLoadException e) {
            System.err.println(e.toString());
            System.exit(-1);
        }
    }
}

