/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import projections.gui.U;

public class RangeHistory {
    public static final int MAX_ENTRIES = 10;
    private String filename;
    private int numEntries;
    private Vector rangeSet;
    private Vector rangeName;
    private Vector rangeProcs;
    private Vector historyStringVector;

    public RangeHistory(String logDirectory) {
        this.filename = logDirectory + "ranges.hst";
        if (!new File(this.filename).exists()) {
            this.rangeSet = new Vector();
            this.rangeName = new Vector();
            this.rangeProcs = new Vector();
            this.historyStringVector = new Vector();
        } else {
            try {
                this.loadRanges();
                this.historyStringVector = new Vector();
                for (int i = 0; i < this.rangeSet.size() / 2; ++i) {
                    String temp;
                    String historyString = U.humanReadableString((Long)this.rangeSet.elementAt(i * 2)) + " to " + U.humanReadableString((Long)this.rangeSet.elementAt(i * 2 + 1));
                    if (this.rangeProcs != null && this.rangeProcs.size() != 0 && this.rangeProcs.size() > i) {
                        temp = (String)this.rangeProcs.elementAt(i);
                        historyString = temp.length() > 10 ? historyString + " Procs:" + temp.substring(0, 10) + "..." : historyString + " Procs:" + temp;
                    }
                    if (this.rangeName != null && this.rangeName.size() != 0 && !this.rangeName.elementAt(i).equals(null) && !this.rangeName.elementAt(i).equals("cancel")) {
                        temp = (String)this.rangeName.elementAt(i);
                        historyString = temp.length() > 10 ? historyString + " (" + temp.substring(0, 10) + "...)" : historyString + " (" + this.rangeName.elementAt(i) + ")";
                    }
                    this.historyStringVector.add(historyString);
                }
            }
            catch (IOException e) {
                System.err.println("Error: " + e.toString());
            }
        }
    }

    private void loadRanges() throws IOException {
        String line;
        this.rangeSet = new Vector();
        this.rangeName = new Vector();
        this.rangeProcs = new Vector();
        BufferedReader reader = new BufferedReader(new FileReader(this.filename));
        this.numEntries = 0;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String s1 = st.nextToken();
            if (s1.equals("ENTRY")) {
                if (this.numEntries >= 10) {
                    throw new IOException("Range history overflow!");
                }
                this.rangeSet.add(Long.valueOf(st.nextToken()));
                this.rangeSet.add(Long.valueOf(st.nextToken()));
                ++this.numEntries;
                continue;
            }
            if (s1.equals("NAMEENTRY")) {
                if (st.hasMoreTokens()) {
                    this.rangeName.add(st.nextToken());
                    continue;
                }
                this.rangeName.add("cancel");
                continue;
            }
            if (!s1.equals("PROCENTRY")) continue;
            String procs = "";
            while (st.hasMoreTokens()) {
                procs = procs + st.nextToken();
            }
            this.rangeProcs.add(procs);
        }
        reader.close();
    }

    public void save() throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new FileWriter(this.filename), true);
        for (int i = 0; i < this.numEntries; ++i) {
            writer.print("ENTRY ");
            writer.print((Long)this.rangeSet.elementAt(i * 2));
            writer.print(" ");
            writer.println((Long)this.rangeSet.elementAt(i * 2 + 1));
            writer.print("NAMEENTRY ");
            if (this.rangeName.size() > i) {
                writer.println(this.rangeName.elementAt(i));
            } else {
                writer.println("cancel");
            }
            writer.print("PROCENTRY ");
            if (this.rangeProcs.size() <= i) continue;
            writer.println(this.rangeProcs.elementAt(i));
        }
    }

    public void add(long start, long end, String name, String procs) {
        if (this.numEntries == 10) {
            this.rangeSet.remove(19);
            this.rangeSet.remove(18);
            if (this.rangeName.size() == 10) {
                this.rangeName.remove(9);
            }
            if (this.rangeProcs.size() == 10) {
                this.rangeProcs.remove(9);
            }
            --this.numEntries;
        }
        if (this.rangeName == null) {
            this.rangeName = new Vector();
        }
        this.rangeName.add(0, new String(name));
        this.rangeSet.add(0, new Long(end));
        this.rangeSet.add(0, new Long(start));
        this.rangeProcs.add(0, new String(procs));
        ++this.numEntries;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Attempt to remove invalid index " + index + ". Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        this.rangeSet.remove(index * 2);
        this.rangeSet.remove(index * 2);
        if (this.rangeName != null && this.rangeName.size() != 0) {
            this.rangeName.remove(index);
        }
        if (this.rangeProcs != null && this.rangeProcs.size() > index) {
            this.rangeProcs.remove(index);
        }
        --this.numEntries;
    }

    public Vector getHistoryStrings() {
        return this.historyStringVector;
    }

    public String getProcRange(int index) {
        if (this.rangeProcs == null || this.rangeProcs.size() <= index || index < 0) {
            return null;
        }
        return (String)this.rangeProcs.elementAt(index);
    }

    public long getStartValue(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + index + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(index * 2);
    }

    public long getEndValue(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + index + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(index * 2 + 1);
    }
}

