/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import projections.analysis.ProjDefs;
import projections.misc.LogLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StsReader
extends ProjDefs {
    private boolean hasPAPI = false;
    private double version;
    private String Machine;
    private int NumPe;
    private int TotalChares;
    private int EntryCount;
    private int TotalMsgs;
    private String[] ClassNames;
    private long[] MsgTable;
    private int NumNodes = 0;
    private int NodeSize = 1;
    private int NumCommThdPerNode = 0;
    private int entryIndex = 0;
    private Map<Integer, String> entryNames = new TreeMap<Integer, String>();
    public Map<Integer, String> entryChareNames = new TreeMap<Integer, String>();
    private Map<Integer, Integer> entryFlatToID = new TreeMap<Integer, Integer>();
    private Map<Integer, Integer> entryIDToFlat = new TreeMap<Integer, Integer>();
    private Hashtable<Integer, Integer> userEventIndices = new Hashtable();
    private int userEventIndex = 0;
    private TreeMap<Integer, String> userEvents = new TreeMap();
    private String[] userEventNames;
    private int functionEventIndex = 0;
    private Hashtable<Integer, Integer> functionEventIndices = new Hashtable();
    private Hashtable<Integer, String> functionEvents = new Hashtable();
    private String[] functionEventNames;
    private int numPapiEvents;
    private String[] papiEventNames;

    public StsReader(String FileName) throws LogLoadException {
        try {
            String Line;
            BufferedReader InFile = new BufferedReader(new InputStreamReader(new FileInputStream(FileName)));
            while ((Line = InFile.readLine()) != null) {
                int ID;
                StringTokenizer st = new StringTokenizer(Line);
                String s1 = st.nextToken();
                if (s1.equals("VERSION")) {
                    this.version = Double.parseDouble(st.nextToken());
                    continue;
                }
                if (s1.equals("MACHINE")) {
                    this.Machine = st.nextToken();
                    continue;
                }
                if (s1.equals("PROCESSORS")) {
                    this.NumPe = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (s1.equals("SMPMODE")) {
                    this.NodeSize = Integer.parseInt(st.nextToken());
                    this.NumNodes = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (s1.equals("TOTAL_CHARES")) {
                    this.TotalChares = Integer.parseInt(st.nextToken());
                    this.ClassNames = new String[this.TotalChares];
                    continue;
                }
                if (s1.equals("TOTAL_EPS")) {
                    this.EntryCount = Integer.parseInt(st.nextToken());
                    continue;
                }
                if (s1.equals("TOTAL_MSGS")) {
                    this.TotalMsgs = Integer.parseInt(st.nextToken());
                    this.MsgTable = new long[this.TotalMsgs];
                    continue;
                }
                if (s1.equals("CHARE") || Line.equals("BOC")) {
                    String name;
                    ID = Integer.parseInt(st.nextToken());
                    this.ClassNames[ID] = name = st.nextToken();
                    continue;
                }
                if (s1.equals("ENTRY")) {
                    st.nextToken();
                    ID = Integer.parseInt(st.nextToken());
                    StringBuffer nameBuf = new StringBuffer(st.nextToken());
                    String Name = nameBuf.toString();
                    if (-1 != Name.indexOf(40) && -1 == Name.indexOf(41)) {
                        String tmp;
                        do {
                            tmp = st.nextToken();
                            nameBuf.append(" ");
                            nameBuf.append(tmp);
                        } while (!tmp.endsWith(")"));
                    }
                    Name = nameBuf.toString();
                    int ChareID = Integer.parseInt(st.nextToken());
                    st.nextToken();
                    this.entryFlatToID.put(this.entryIndex, ID);
                    this.entryIDToFlat.put(ID, this.entryIndex);
                    ++this.entryIndex;
                    this.getEntryNames().put(ID, Name);
                    this.getEntryChareNames().put(ID, this.ClassNames[ChareID]);
                    continue;
                }
                if (s1.equals("MESSAGE")) {
                    ID = Integer.parseInt(st.nextToken());
                    int Size = Integer.parseInt(st.nextToken());
                    this.MsgTable[ID] = Size;
                    continue;
                }
                if (s1.equals("FUNCTION")) {
                    Integer key = new Integer(st.nextToken());
                    if (!this.functionEvents.containsKey(key)) {
                        String functionEventName = "";
                        while (st.hasMoreTokens()) {
                            functionEventName = functionEventName + st.nextToken() + " ";
                        }
                        this.functionEvents.put(key, functionEventName);
                        this.functionEventNames[this.functionEventIndex] = functionEventName;
                        this.functionEventIndices.put(key, new Integer(this.functionEventIndex));
                    }
                    ++this.functionEventIndex;
                    continue;
                }
                if (s1.equals("EVENT")) {
                    Integer key = new Integer(st.nextToken());
                    if (this.userEvents.containsKey(key)) continue;
                    String eventName = "";
                    while (st.hasMoreTokens()) {
                        eventName = eventName + st.nextToken() + " ";
                    }
                    this.userEvents.put(key, eventName);
                    this.userEventNames[this.userEventIndex] = eventName;
                    this.userEventIndices.put(key, new Integer(this.userEventIndex++));
                    continue;
                }
                if (s1.equals("TOTAL_EVENTS")) {
                    this.userEventNames = new String[Integer.parseInt(st.nextToken())];
                    continue;
                }
                if (s1.equals("TOTAL_FUNCTIONS")) {
                    this.functionEventNames = new String[Integer.parseInt(st.nextToken())];
                    continue;
                }
                if (s1.equals("TOTAL_PAPI_EVENTS")) {
                    this.hasPAPI = true;
                    this.numPapiEvents = Integer.parseInt(st.nextToken());
                    this.papiEventNames = new String[this.numPapiEvents];
                    continue;
                }
                if (s1.equals("PAPI_EVENT")) {
                    this.hasPAPI = true;
                    this.papiEventNames[Integer.parseInt((String)st.nextToken())] = st.nextToken();
                    continue;
                }
                if (!s1.equals("END")) continue;
                break;
            }
            InFile.close();
            if (this.NumNodes == 0) {
                this.NumNodes = this.NumPe;
            } else {
                int workPes = this.NumNodes * this.NodeSize;
                this.NumCommThdPerNode = (this.NumPe - workPes) / this.NumNodes;
                if ((this.NodeSize + this.NumCommThdPerNode) * this.NumNodes != this.NumPe) {
                    System.err.println("ERROR: node size and number of nodes doesn't match!");
                    throw new LogLoadException(FileName);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new LogLoadException(FileName);
        }
        catch (IOException e) {
            throw new LogLoadException(FileName);
        }
    }

    public double getVersion() {
        return this.version;
    }

    public int getEntryCount() {
        return this.EntryCount;
    }

    public int getProcessorCount() {
        return this.NumPe;
    }

    public String getMachineName() {
        return this.Machine;
    }

    public String getEntryNameByID(int ID) {
        return this.getEntryNames().get(ID);
    }

    public String getEntryNameByIndex(int index) {
        if (this.entryFlatToID.containsKey(index)) {
            return this.getEntryNames().get(this.entryFlatToID.get(index));
        }
        return "Unknown";
    }

    public int getEntryIDByName(String epName) {
        for (Integer id : this.entryNames.keySet()) {
            if (!this.entryNames.get(id).equals(epName)) continue;
            return id;
        }
        return -1;
    }

    private String getEntryChareNameByID(int ID) {
        return this.getEntryChareNames().get(ID);
    }

    public String getEntryChareNameByIndex(int index) {
        return this.getEntryChareNames().get(this.entryFlatToID.get(index));
    }

    public String getEntryFullNameByID(int ID) {
        return this.getEntryChareNameByID(ID) + "::" + this.getEntryNameByID(ID);
    }

    public String getEntryFullNameByIndex(int index) {
        return this.getEntryChareNameByIndex(index) + "::" + this.getEntryNameByIndex(index);
    }

    public Integer getEntryIndex(Integer ID) {
        if (ID < 0) {
            return ID;
        }
        return this.entryIDToFlat.get(ID);
    }

    public int getNumUserDefinedEvents() {
        return this.userEvents.size();
    }

    public Integer getUserEventIndex(int eventID) {
        Integer key = new Integer(eventID);
        if (this.userEventIndices.containsKey(key)) {
            return this.userEventIndices.get(key);
        }
        return null;
    }

    public String getUserEventName(int eventID) {
        Integer key = new Integer(eventID);
        return this.userEvents.get(key);
    }

    public String[] getUserEventNames() {
        return this.userEventNames;
    }

    public Map<Integer, String> getUserEventNameMap() {
        return this.userEvents;
    }

    public int getNumFunctionEvents() {
        if (this.functionEvents.size() == 0) {
            return 0;
        }
        return this.functionEvents.size() + 1;
    }

    public int getFunctionEventIndex(int eventID) {
        Integer key = new Integer(eventID);
        return this.functionEventIndices.get(key);
    }

    public String getFunctionEventDescriptor(int eventID) {
        Integer key = new Integer(eventID);
        return this.functionEvents.get(key);
    }

    public String[] getFunctionEventDescriptors() {
        return this.functionEventNames;
    }

    public int getNumPerfCounts() {
        if (this.hasPAPI) {
            return this.numPapiEvents;
        }
        return 0;
    }

    public String[] getPerfCountNames() {
        if (this.hasPAPI) {
            return this.papiEventNames;
        }
        return null;
    }

    public Map<Integer, String> getEntryNames() {
        return this.entryNames;
    }

    public Map<Integer, String> getEntryChareNames() {
        return this.entryChareNames;
    }

    public Map<Integer, String> getPrettyEntryNames() {
        Map<Integer, String> entryNames = this.getEntryNames();
        Map<Integer, String> entryChareNames = this.getEntryChareNames();
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        for (Integer id : entryNames.keySet()) {
            result.put(id, entryNames.get(id) + "::" + entryChareNames.get(id));
        }
        return result;
    }

    public int getNodeSize() {
        return this.NodeSize;
    }

    public int getSMPNodeCount() {
        return this.NumNodes;
    }

    public int getNumCommThdPerNode() {
        return this.NumCommThdPerNode;
    }

    public boolean isSMPRun() {
        return this.NumNodes < this.NumPe;
    }
}

