/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.ProgressMonitor;
import projections.analysis.AccumulatedSummaryReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.misc.SummaryFormatException;

public class SumAnalyzer
extends ProjDefs {
    private int myRun = 0;
    private static final int ACC_MODE = 0;
    private static final int NORMAL_MODE = 1;
    private StreamTokenizer tokenizer;
    private long[][] ChareTime;
    private int[][] NumEntryMsgs;
    private int[][] MaxEntryTime;
    private int PhaseCount;
    private long IntervalSize;
    private int IntervalCount;
    private long TotalTime;
    private long[][][] PhaseChareTime;
    private int[][][] PhaseNumEntryMsgs;
    private int[][] ProcessorUtilization;
    private int[][] IdlePercentage;
    private int mode = 1;
    private int nPe;
    private AccumulatedSummaryReader accumulatedReader;

    public SumAnalyzer() throws IOException, SummaryFormatException {
        long myIntervalSize;
        double interval;
        int myCount;
        BufferedReader b;
        FileReader file;
        int p;
        int numEntry = 0;
        double versionNum = 0.0;
        this.IntervalCount = 0;
        this.TotalTime = 0L;
        this.nPe = 1;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Determining max intervals", "", 0, this.nPe);
        for (p = 0; p < this.nPe; ++p) {
            if (!progressBar.isCanceled()) {
                progressBar.setNote(p + " of " + this.nPe);
                progressBar.setProgress(p);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper number of summary intervals!");
                System.exit(-1);
            }
            file = new FileReader(MainWindow.runObject[this.myRun].getSumName(p));
            b = new BufferedReader(file);
            this.tokenizer = new StreamTokenizer(b);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            versionNum = this.nextNumber("Version Number");
            this.nextNumber("processor number");
            this.nPe = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            myCount = (int)this.nextNumber("count");
            this.checkNextString("ep");
            this.nextNumber("ep");
            this.checkNextString("interval");
            interval = this.nextScientific("intervalsize");
            myIntervalSize = (long)Math.floor(interval * 1000000.0);
            double factor = 1.0;
            if (myIntervalSize != this.IntervalSize) {
                if (this.IntervalSize == 0L) {
                    this.IntervalSize = myIntervalSize;
                } else {
                    factor = (double)myIntervalSize / ((double)this.IntervalSize * 1.0);
                    if (myIntervalSize < this.IntervalSize) {
                        this.IntervalSize = myIntervalSize;
                    }
                }
            }
            if (factor < 1.0) {
                this.IntervalCount = (int)((double)this.IntervalCount / factor);
            }
            if ((double)this.IntervalCount < (double)myCount * factor) {
                this.IntervalCount = (int)((double)myCount * factor);
            }
            this.tokenizer = null;
            file.close();
        }
        progressBar.close();
        progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Reading summary data", "", 0, this.nPe);
        for (p = 0; p < this.nPe; ++p) {
            int f;
            int tokenType;
            if (progressBar.isCanceled()) {
                progressBar.close();
                return;
            }
            progressBar.setNote(p + " of " + this.nPe);
            progressBar.setProgress(p);
            file = new FileReader(MainWindow.runObject[this.myRun].getSumName(p));
            b = new BufferedReader(file);
            this.tokenizer = new StreamTokenizer(b);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            versionNum = this.nextNumber("Version Number");
            this.nextNumber("processor number");
            this.nPe = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            myCount = (int)this.nextNumber("count");
            this.checkNextString("ep");
            numEntry = (int)this.nextNumber("number of entry methods");
            this.checkNextString("interval");
            interval = this.nextScientific("processor usage sample interval");
            myIntervalSize = (long)Math.floor(interval * 1000000.0);
            if (this.TotalTime < (long)myCount * myIntervalSize) {
                this.TotalTime = (long)myCount * myIntervalSize;
            }
            int factor = (int)(myIntervalSize / this.IntervalSize);
            if (versionNum > 2.0) {
                this.checkNextString("phases");
                this.PhaseCount = (int)this.nextNumber("phases");
            } else {
                this.PhaseCount = 0;
            }
            if (10 != this.tokenizer.nextToken()) {
                throw new SummaryFormatException("extra garbage at end of line 1");
            }
            if (p == 0) {
                this.ProcessorUtilization = new int[this.nPe][];
                this.IdlePercentage = new int[this.nPe][];
                this.ChareTime = new long[this.nPe][numEntry];
                this.NumEntryMsgs = new int[this.nPe][numEntry];
                this.MaxEntryTime = new int[this.nPe][numEntry];
            }
            this.ProcessorUtilization[p] = new int[this.IntervalCount];
            this.IdlePercentage[p] = new int[this.IntervalCount];
            int nUsageRead = 0;
            int val = 0;
            int extraCount = 0;
            while ((tokenType = this.tokenizer.nextToken()) != 10) {
                if (tokenType == -2) {
                    val = (int)this.tokenizer.nval;
                    for (int f2 = 0; f2 < factor; ++f2) {
                        this.ProcessorUtilization[p][nUsageRead++] = val;
                    }
                    tokenType = this.tokenizer.nextToken();
                    if (tokenType == 43) {
                        tokenType = this.tokenizer.nextToken();
                        if (tokenType != -2) {
                            System.out.println("Unrecorgnized syntax at end of line 2");
                        }
                        if ((extraCount = (int)this.tokenizer.nval) > myCount) {
                            System.err.println("[" + p + "] Token read = [" + val + "+" + extraCount + "] is impossible as the " + "count is larger than the " + "total count of " + myCount);
                            System.exit(-1);
                        }
                        for (int i = 1; i < extraCount; ++i) {
                            for (f = 0; f < factor; ++f) {
                                this.ProcessorUtilization[p][nUsageRead++] = val;
                            }
                        }
                    } else {
                        this.tokenizer.pushBack();
                    }
                }
                if (nUsageRead <= myCount * factor) continue;
                System.err.println("[" + p + "] Corrupted data: " + "Number of datapoints read exceeds " + "file recorded value of " + myCount + "adjusted by factor " + factor);
                System.err.print("The violating token is [" + val);
                if (extraCount > 1) {
                    System.err.println("+" + extraCount + "]");
                } else {
                    System.err.println("]");
                }
                System.exit(-1);
            }
            if (myCount * factor != nUsageRead) {
                System.err.println("numIntervals for Utilization do not agree: " + myCount * factor + " v.s. " + nUsageRead + "!");
            }
            int CurrentUserEntry = 0;
            tokenType = this.tokenizer.nextToken();
            if (-3 != tokenType) {
                this.tokenizer.pushBack();
            }
            while (-2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry) {
                this.ChareTime[p][CurrentUserEntry++] = (int)this.tokenizer.nval;
            }
            if (10 != tokenType) {
                throw new SummaryFormatException("extra garbage at end of line 3");
            }
            tokenType = this.tokenizer.nextToken();
            if (-3 != tokenType) {
                this.tokenizer.pushBack();
            }
            for (CurrentUserEntry = 0; -2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry; ++CurrentUserEntry) {
                this.NumEntryMsgs[p][CurrentUserEntry] = (int)this.tokenizer.nval;
            }
            if (10 != tokenType) {
                throw new SummaryFormatException("extra garbage at end of line 4");
            }
            if (versionNum > 3.0) {
                tokenType = this.tokenizer.nextToken();
                if (-3 != tokenType) {
                    this.tokenizer.pushBack();
                }
                for (CurrentUserEntry = 0; -2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry; ++CurrentUserEntry) {
                    this.MaxEntryTime[p][CurrentUserEntry] = (int)this.tokenizer.nval;
                }
                if (10 != tokenType) {
                    throw new SummaryFormatException("extra garbage at end of line 5");
                }
            }
            if (versionNum > 3.0) {
                tokenType = this.tokenizer.nextToken();
                if (-3 != tokenType) {
                    this.tokenizer.pushBack();
                }
                int NumberofPairs = (int)this.nextNumber("Number of Marked Events");
                for (int g = 0; g < NumberofPairs; ++g) {
                    this.nextNumber("Number of Marked Events");
                    this.nextNumber("Number of Marked Events");
                }
                tokenType = this.tokenizer.nextToken();
                if (10 != tokenType) {
                    throw new SummaryFormatException("extra garbage at end of line 6");
                }
                if (this.PhaseCount > 1) {
                    if (p == 0) {
                        this.PhaseChareTime = new long[this.PhaseCount][this.nPe][numEntry];
                        this.PhaseNumEntryMsgs = new int[this.PhaseCount][this.nPe][numEntry];
                    }
                    for (int m = 0; m < this.PhaseCount; ++m) {
                        this.tokenizer.nextToken();
                        this.tokenizer.nextToken();
                        for (CurrentUserEntry = 0; -2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry; ++CurrentUserEntry) {
                            this.PhaseNumEntryMsgs[m][p][CurrentUserEntry] = (int)this.tokenizer.nval;
                        }
                        if (10 != tokenType) {
                            throw new SummaryFormatException("extra garbage at end of line 3");
                        }
                        this.tokenizer.nextToken();
                        this.tokenizer.nextToken();
                        for (CurrentUserEntry = 0; -2 == (tokenType = this.tokenizer.nextToken()) && numEntry > CurrentUserEntry; ++CurrentUserEntry) {
                            this.PhaseChareTime[m][p][CurrentUserEntry] = (int)this.tokenizer.nval;
                        }
                        if (10 == tokenType) continue;
                        throw new SummaryFormatException("extra garbage at end of line 4");
                    }
                }
            }
            if (versionNum > 7.0) {
                tokenType = this.tokenizer.nextToken();
                if (-3 != tokenType) {
                    this.tokenizer.pushBack();
                }
                int nIdleRead = 0;
                val = 0;
                extraCount = 0;
                while ((tokenType = this.tokenizer.nextToken()) != 10) {
                    if (tokenType == -2) {
                        val = (int)this.tokenizer.nval;
                        for (f = 0; f < factor; ++f) {
                            this.IdlePercentage[p][nIdleRead++] = val;
                        }
                        tokenType = this.tokenizer.nextToken();
                        if (tokenType == 43) {
                            tokenType = this.tokenizer.nextToken();
                            if (tokenType != -2) {
                                System.out.println("Unrecorgnized syntax at end of line 2");
                            }
                            if ((extraCount = (int)this.tokenizer.nval) > myCount) {
                                System.err.println("[" + p + "] Token read = [" + val + "+" + extraCount + "] is impossible as the " + "count is larger than " + "the total count of " + myCount);
                                System.exit(-1);
                            }
                            for (int i = 1; i < extraCount; ++i) {
                                for (int f3 = 0; f3 < factor; ++f3) {
                                    this.IdlePercentage[p][nIdleRead++] = val;
                                }
                            }
                        } else {
                            this.tokenizer.pushBack();
                        }
                    }
                    if (nIdleRead <= myCount * factor) continue;
                    System.err.println("[" + p + "] Corrupted data: " + "Number of datapoints read " + "exceeds " + "file recorded value of " + myCount + "adjusted by factor " + factor);
                    System.err.print("The violating token is [" + val);
                    if (extraCount > 1) {
                        System.err.println("+" + extraCount + "]");
                    } else {
                        System.err.println("]");
                    }
                    System.exit(-1);
                }
                if (myCount * factor != nIdleRead) {
                    System.err.println("numIntervals for Idle do not agree: " + myCount * factor + " v.s. " + nIdleRead + "!");
                }
            }
            this.tokenizer = null;
            file.close();
        }
        progressBar.close();
        MainWindow.runObject[this.myRun].setTotalTime(this.TotalTime);
    }

    private void checkNextString(String expected) throws IOException, SummaryFormatException {
        String ret = this.nextString(expected);
        if (!expected.equals(ret)) {
            throw new SummaryFormatException("Expected " + expected + " got " + ret);
        }
    }

    public long getIntervalSize() {
        return this.IntervalSize;
    }

    public long[][] getChareTime() {
        return this.ChareTime;
    }

    public long[][] getPhaseChareTime(int Phase) {
        return this.PhaseChareTime[Phase];
    }

    public int getPhaseCount() {
        return this.PhaseCount;
    }

    public int[][] getSystemUsageData(int intervalStart, int intervalEnd, long outIntervalSize) {
        int p;
        int numProcessors = this.ProcessorUtilization.length;
        int intervalRange = intervalEnd - intervalStart + 1;
        int[][] ret = new int[numProcessors][intervalRange];
        if (outIntervalSize == this.IntervalSize) {
            for (int p2 = 0; p2 < numProcessors; ++p2) {
                for (int i = intervalStart; i < intervalEnd && i < this.ProcessorUtilization[p2].length; ++i) {
                    ret[p2][i - intervalStart] = this.ProcessorUtilization[p2][i];
                }
            }
            return ret;
        }
        int sourceStartInterval = (int)((long)intervalStart * outIntervalSize / this.IntervalSize);
        double[][] tempData = new double[numProcessors][intervalRange];
        for (p = 0; p < numProcessors; ++p) {
            for (int interval = sourceStartInterval; interval < this.ProcessorUtilization[p].length && interval < sourceStartInterval + intervalRange; ++interval) {
                if (this.ProcessorUtilization[p][interval] <= 0) continue;
                IntervalUtils.fillIntervals(tempData[p], outIntervalSize, intervalStart, (long)interval * this.IntervalSize, (long)(interval + 1) * this.IntervalSize, IntervalUtils.utilToTime(this.ProcessorUtilization[p][interval], (double)this.IntervalSize), false);
            }
        }
        for (p = 0; p < tempData.length; ++p) {
            for (int i = 0; i < tempData[p].length; ++i) {
                tempData[p][i] = IntervalUtils.timeToUtil(tempData[p][i], (double)outIntervalSize);
                ret[p][i] = (int)tempData[p][i];
            }
        }
        return ret;
    }

    public double[][] getSummaryAverageData() {
        if (this.mode == 1) {
            int numProcessors = this.ProcessorUtilization.length;
            double[][] ret = new double[this.IntervalCount][2];
            for (int p = 0; p < numProcessors; ++p) {
                for (int interval = 0; interval < this.IntervalCount; ++interval) {
                    double[] dArray = ret[interval];
                    dArray[0] = dArray[0] + (double)this.ProcessorUtilization[p][interval];
                    double[] dArray2 = ret[interval];
                    dArray2[1] = dArray2[1] + (double)this.IdlePercentage[p][interval];
                }
            }
            for (int interval = 0; interval < this.IntervalCount; ++interval) {
                double[] dArray = ret[interval];
                dArray[0] = dArray[0] / ((double)numProcessors * 1.0);
                double[] dArray3 = ret[interval];
                dArray3[1] = dArray3[1] / ((double)numProcessors * 1.0);
            }
            return ret;
        }
        if (this.mode == 0) {
            try {
                this.accumulatedReader.loadIntervalData(0L, this.IntervalCount - 1);
            }
            catch (IOException e) {
                System.err.println("Exception caught!");
                System.exit(-1);
            }
            double[] temp = this.accumulatedReader.getUtilData();
            double[][] ret = new double[temp.length][1];
            for (int interval = 0; interval < temp.length; ++interval) {
                ret[interval][0] = temp[interval];
            }
            return ret;
        }
        return null;
    }

    public long getTotalTime() {
        return this.TotalTime;
    }

    private double nextNumber(String description) throws IOException, SummaryFormatException {
        if (-2 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read " + description);
        }
        return this.tokenizer.nval;
    }

    private double nextScientific(String description) throws IOException, SummaryFormatException {
        int exponent;
        double mantissa = this.nextNumber(description + " mantissa");
        String expString = this.nextString(description + " exponent");
        char expChar = expString.charAt(0);
        if (expChar != 'e' && expChar != 'd' && expChar != 'E' && expChar != 'D') {
            throw new SummaryFormatException("Couldn't find exponent in " + expString);
        }
        if ((expString = expString.substring(1)).equals("")) {
            this.tokenizer.nextToken();
            exponent = (int)this.nextNumber("exponent");
        } else {
            try {
                exponent = Integer.parseInt(expString);
            }
            catch (NumberFormatException e) {
                throw new SummaryFormatException("Couldn't parse exponent " + expString);
            }
        }
        return mantissa * Math.pow(10.0, exponent);
    }

    private String nextString(String description) throws IOException, SummaryFormatException {
        if (-3 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read string " + description);
        }
        return this.tokenizer.sval;
    }

    public int[] getTotalIdlePercentage() {
        int[] totalIdlePercentage = new int[this.IntervalCount];
        for (int i = 0; i < this.nPe; ++i) {
            for (int j = 0; j < this.IntervalCount; ++j) {
                totalIdlePercentage[j] = this.IdlePercentage[i][j];
            }
        }
        return totalIdlePercentage;
    }
}

