/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import projections.analysis.AmpiFunctionData;
import projections.analysis.CallStackManager;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.misc.LogEntryData;

public class UsageCalc
extends ProjDefs {
    private int myRun = 0;
    private long beginTime;
    private long endTime;
    private long startTime;
    private int pnum;
    private int dataLen;
    private long packtime;
    private long packstarttime;
    private long unpacktime;
    private long unpackstarttime;
    private int numUserEntries;
    private double version;
    private int countflag = 0;
    private int curEntry = -1;
    private boolean deltaEncoded = false;

    private void intervalCalc(float[][] data, int type, int entry, long time) {
        if (type != 1) {
            if (time <= this.beginTime + 1L) {
                time = this.beginTime;
                this.countflag = 0;
            } else if (this.countflag != 2) {
                this.countflag = 1;
            }
            if (time > this.endTime) {
                time = this.endTime;
                this.countflag = 2;
            } else if (this.countflag != 0) {
                this.countflag = 1;
            }
        } else if (this.countflag != 1) {
            time = 0L;
        }
        switch (type) {
            case 2: {
                this.packtime = 0L;
                this.unpacktime = 0L;
                this.curEntry = MainWindow.runObject[this.myRun].getEntryIndex(entry);
                this.startTime = time;
                break;
            }
            case 3: {
                if (this.curEntry == -1) break;
                this.curEntry = MainWindow.runObject[this.myRun].getEntryIndex(entry);
                if (this.curEntry == -1) break;
                float[] fArray = data[0];
                int n = this.curEntry;
                fArray[n] = fArray[n] + (float)(time - this.startTime - this.packtime - this.unpacktime);
                break;
            }
            case 1: {
                if (this.curEntry == -1) break;
                float[] fArray = data[1];
                int n = this.curEntry;
                fArray[n] = fArray[n] + (float)time;
                break;
            }
            case 21: {
                break;
            }
            case 14: {
                this.startTime = time;
                break;
            }
            case 15: {
                float[] fArray = data[0];
                int n = this.numUserEntries + 2;
                fArray[n] = fArray[n] + (float)(time - this.startTime);
                break;
            }
            case 16: {
                this.packstarttime = time;
                break;
            }
            case 17: {
                this.packtime += time - this.packstarttime;
                float[] fArray = data[0];
                int n = this.numUserEntries;
                fArray[n] = fArray[n] + (float)(time - this.packstarttime);
                break;
            }
            case 18: {
                this.unpackstarttime = time;
                break;
            }
            case 19: {
                this.unpacktime += time - this.unpackstarttime;
                float[] fArray = data[0];
                int n = this.numUserEntries + 1;
                fArray[n] = fArray[n] + (float)(time - this.unpackstarttime);
                break;
            }
        }
    }

    public float[] ampiUsage(int procnum, long begintime, long endtime, double v) {
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        long[] accTime = new long[numFunc + 1];
        float[] data = new float[numFunc + 1];
        for (int i = 0; i < numFunc; ++i) {
            accTime[i] = 0L;
        }
        GenericLogReader reader = new GenericLogReader(procnum, v);
        AmpiFunctionData curFunc = null;
        long time = 0L;
        boolean isProcessing = false;
        CallStackManager funcStack = new CallStackManager();
        try {
            LogEntryData LE;
            do {
                LE = reader.nextEvent();
                time = LE.time;
            } while (LE.type != 2 || LE.entry == -1 || LE.time < begintime);
            while (time < endtime) {
                switch (LE.type) {
                    case 2: {
                        if (isProcessing) break;
                        isProcessing = true;
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.setLastBeginTime(time);
                        break;
                    }
                    case 3: {
                        if (!isProcessing) break;
                        isProcessing = false;
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.incrAccExecTimeNow(time);
                        break;
                    }
                    case 22: {
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc != null) {
                            curFunc.incrAccExecTimeNow(time);
                        }
                        LogEntry entry = new LogEntry(LE);
                        AmpiFunctionData thisFunc = entry.ampiData;
                        thisFunc.setLastBeginTime(time);
                        funcStack.push(thisFunc, LE.id[0], LE.id[1], LE.id[2]);
                        break;
                    }
                    case 23: {
                        AmpiFunctionData lastFunc = (AmpiFunctionData)funcStack.pop(LE.id[0], LE.id[1], LE.id[2]);
                        lastFunc.incrAccExecTimeNow(time);
                        int n = LE.entry;
                        accTime[n] = accTime[n] + lastFunc.getAccExecTime();
                        curFunc = (AmpiFunctionData)funcStack.read(LE.id[0], LE.id[1], LE.id[2]);
                        if (curFunc == null) break;
                        curFunc.setLastBeginTime(time);
                        break;
                    }
                }
                LE = reader.nextEvent();
                time = LE.time;
            }
        }
        catch (EndOfLogSuccess entry) {
        }
        catch (IOException e) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pnum);
        }
        float accumulated = 0.0f;
        for (int j = 1; j < numFunc; ++j) {
            data[j] = (float)(100.0 * (double)accTime[j]) / (float)(endtime - begintime);
            accumulated += data[j];
        }
        if (accumulated > 100.0f) {
            System.out.println("ERROR: accTime > 100%");
            return null;
        }
        data[numFunc] = 100.0f - accumulated;
        return data;
    }

    public float[][] usage(int procnum, long begintime, long endtime, double v) {
        this.version = v;
        this.beginTime = begintime;
        this.endTime = endtime;
        this.pnum = procnum;
        this.numUserEntries = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.dataLen = this.numUserEntries + 4;
        float[][] data = new float[2][this.dataLen];
        for (int i = 0; i < this.dataLen; ++i) {
            data[0][i] = 0.0f;
            data[1][i] = 0.0f;
        }
        GenericLogReader reader = new GenericLogReader(procnum, this.version);
        LogEntryData logEntry = new LogEntryData();
        this.curEntry = -1;
        this.startTime = 0L;
        long time = 0L;
        boolean isProcessing = false;
        LogEntryData lastBeginData = null;
        long prevTime = 0L;
        try {
            block19: while (time < this.endTime) {
                logEntry = reader.nextEvent();
                time = logEntry.time;
                switch (logEntry.type) {
                    case 14: 
                    case 15: {
                        if (isProcessing) {
                            this.intervalCalc(data, 3, lastBeginData.entry, logEntry.time);
                            isProcessing = false;
                            lastBeginData = null;
                        }
                        this.intervalCalc(data, logEntry.type, 0, time);
                        continue block19;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        this.intervalCalc(data, logEntry.type, 0, time);
                        continue block19;
                    }
                    case 2: {
                        if (isProcessing) {
                            this.intervalCalc(data, 3, lastBeginData.entry, logEntry.time);
                        }
                        this.intervalCalc(data, logEntry.type, logEntry.entry, time);
                        isProcessing = true;
                        lastBeginData = logEntry;
                        continue block19;
                    }
                    case 3: {
                        if (!isProcessing) continue block19;
                        this.intervalCalc(data, logEntry.type, logEntry.entry, time);
                        isProcessing = false;
                        continue block19;
                    }
                    case 11: {
                        continue block19;
                    }
                    case 12: {
                        continue block19;
                    }
                    case 10: {
                        continue block19;
                    }
                    case 1: {
                        this.intervalCalc(data, logEntry.type, 0, logEntry.sendTime);
                        continue block19;
                    }
                    case 21: {
                        continue block19;
                    }
                    case 13: 
                    case 100: {
                        continue block19;
                    }
                    case 4: 
                    case 5: {
                        continue block19;
                    }
                    case 8: 
                    case 9: {
                        continue block19;
                    }
                    case 7: {
                        continue block19;
                    }
                }
                if (!this.deltaEncoded) continue;
                System.out.println("Warning: Unknown Event! This can mess up delta encoding!");
            }
        }
        catch (EndOfLogSuccess endOfLogSuccess) {
        }
        catch (IOException e) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        for (int j = 0; j < this.dataLen; ++j) {
            data[0][j] = data[0][j] - data[1][j];
            data[0][j] = (float)(100.0 * (double)data[0][j]) / (float)(this.endTime - this.beginTime);
            data[1][j] = (float)(100.0 * (double)data[1][j]) / (float)(this.endTime - this.beginTime);
        }
        return data;
    }
}

