/*
 * Decompiled with CFR 0.152.
 */
package projections.ccs;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Stack;
import projections.ccs.CcsProgress;
import projections.ccs.CcsServer;

public class CcsThread
implements Runnable {
    private boolean isBad;
    private Stack requests = new Stack();
    private volatile boolean keepGoing;
    private CcsServer ccs;
    private CcsProgress status;
    private Thread myThread;
    private String hostName;
    private int port;

    public CcsThread(CcsProgress status_, String hostName_, int port_) {
        this.status = status_;
        this.hostName = hostName_;
        this.port = port_;
        this.isBad = false;
        this.keepGoing = true;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void addRequest(request req) {
        this.addRequest(req, false);
    }

    public void addRequest(request req, boolean flushOld) {
        if (flushOld) {
            while (!this.requests.empty()) {
                this.requests.pop();
            }
        }
        this.requests.push(req);
    }

    public void finish() {
        this.keepGoing = false;
    }

    public boolean isInvalid() {
        return this.isBad;
    }

    private void ioError(Exception e, String what) {
        this.isBad = true;
        this.keepGoing = false;
        this.status.setText(what + " (" + this.hostName + ":" + this.port + ")");
        System.out.println("ERROR> " + what);
        System.out.println("Traceback: " + e);
        e.printStackTrace();
    }

    public void run() {
        System.out.println("Connecting to " + this.hostName + ":" + this.port + "...\n");
        this.status.setText("Connecting to " + this.hostName + ":" + this.port + "...");
        try {
            this.ccs = new CcsServer(this.hostName, this.port);
        }
        catch (UnknownHostException e) {
            this.ioError(e, "Bad host name");
        }
        catch (IOException e) {
            this.ioError(e, "Could not connect");
        }
        if (!this.keepGoing) {
            return;
        }
        this.status.setText("Connected to " + this.hostName + " (" + this.ccs.getNumPes() + " processors)");
        while (this.keepGoing) {
            byte[] reply;
            while (this.requests.empty() && this.keepGoing) {
                try {
                    int sleepMs = 30;
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException sleepMs) {}
            }
            if (!this.keepGoing) break;
            request curReq = (request)this.requests.pop();
            this.status.setText("Sending request " + curReq.getHandler());
            try {
                this.ccs.sendRequest(curReq.getHandler(), curReq.getPE(), curReq.getData());
            }
            catch (IOException e) {
                this.ioError(e, "Error sending request");
                break;
            }
            try {
                reply = this.ccs.recvResponse();
            }
            catch (IOException e) {
                this.ioError(e, "Error receiving response");
                break;
            }
            curReq.handleReply(reply);
            this.status.setText("");
        }
    }

    public static class request
    extends message {
        int onPE;
        String handler;

        public request(String handler_, byte[] data_) {
            super(data_);
            this.handler = handler_;
        }

        public request(String handler_, int nBytes) {
            super(nBytes);
            this.handler = handler_;
        }

        public void setPE(int pe) {
            this.onPE = pe;
        }

        public int getPE() {
            return this.onPE;
        }

        public String getHandler() {
            return this.handler;
        }

        public void handleReply(byte[] data) {
            if (data.length != 0) {
                System.out.println("Overload handleReply to actually use these " + data.length + " bytes of reply!");
            }
        }
    }

    public static class message {
        private byte[] data;

        public message(byte[] data_) {
            this.data = data_;
        }

        public message(int nBytes) {
            this.data = new byte[nBytes];
        }

        public byte[] getData() {
            return this.data;
        }

        protected void setData(byte[] data_) {
            this.data = data_;
        }
    }
}

