/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.JPanel;
import projections.gui.AnimationWindow;
import projections.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnimationDisplayPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private int myRun = 0;
    private float MAXHUE = 0.65f;
    private int numPs = -1;
    private int numIs = -1;
    private int pwidth;
    private int pheight;
    private int numrows;
    private int numcols;
    private int pold = -1;
    private int phoffset;
    private int pvoffset;
    private int hoffset;
    private int voffset;
    private float psize = 0.75f;
    private float fontOffset = 0.9f;
    private FontMetrics fm = null;
    private Font font = null;
    private SortedSet<Integer> chosenPEs;
    private int curI = -1;
    private int curP = -1;
    private long Isize = 0L;
    private int[][] data;
    private Image offscreen;
    private Color[] colors;
    private int w;
    private int h;
    private AnimationWindow animationWindow;

    protected AnimationDisplayPanel(AnimationWindow animationWindow) {
        this.animationWindow = animationWindow;
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
                if (AnimationDisplayPanel.this.w > 0 && AnimationDisplayPanel.this.h > 0) {
                    AnimationDisplayPanel.this.offscreen = AnimationDisplayPanel.this.createImage(AnimationDisplayPanel.this.w, AnimationDisplayPanel.this.h);
                    AnimationDisplayPanel.this.numcols = (int)Math.sqrt(AnimationDisplayPanel.this.numPs) - (int)(Math.sqrt(AnimationDisplayPanel.this.numPs) % 5.0);
                    if (AnimationDisplayPanel.this.numcols == 0) {
                        AnimationDisplayPanel.this.numcols = Math.min(AnimationDisplayPanel.this.numPs, 10);
                    }
                    AnimationDisplayPanel.this.numrows = (int)Math.ceil((double)AnimationDisplayPanel.this.numPs / (double)AnimationDisplayPanel.this.numcols);
                    AnimationDisplayPanel.this.pwidth = Math.min(AnimationDisplayPanel.this.w / AnimationDisplayPanel.this.numcols, AnimationDisplayPanel.this.h / AnimationDisplayPanel.this.numrows);
                    AnimationDisplayPanel.this.pheight = AnimationDisplayPanel.this.pwidth;
                    AnimationDisplayPanel.this.hoffset = (AnimationDisplayPanel.this.w - AnimationDisplayPanel.this.numcols * AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.voffset = (AnimationDisplayPanel.this.h - AnimationDisplayPanel.this.numrows * AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.phoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.pvoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.clearScreen();
                }
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.colors = new Color[101];
        for (int i = 0; i <= 100; ++i) {
            this.colors[i] = Color.getHSBColor((float)((double)(100 - i) / 100.0) * this.MAXHUE, 1.0f, 1.0f);
        }
        this.setParameters();
    }

    private void clearScreen() {
        if (this.offscreen == null) {
            return;
        }
        Graphics og = this.offscreen.getGraphics();
        if (og != null) {
            og.clearRect(0, 0, this.w, this.h);
        }
        this.repaint();
    }

    public int getCurI() {
        return this.curI;
    }

    public int getNumI() {
        return this.numIs;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    private void makeNextImage(Graphics g, int I) {
        int tothoffset = this.phoffset + this.hoffset;
        int totvoffset = this.pvoffset + this.voffset;
        int pw = (int)((float)this.pwidth * this.psize);
        int ph = (int)((float)this.pheight * this.psize);
        g.translate(tothoffset, totvoffset);
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            g.setFont(this.font);
            this.fm = g.getFontMetrics(this.font);
        }
        int p = 0;
        int curPE = 0;
        Iterator iter = this.chosenPEs.iterator();
        block0: for (int r = 0; r < this.numrows; ++r) {
            for (int c = 0; c < this.numcols; ++c) {
                int usage = this.data[p++][I];
                curPE = (Integer)iter.next();
                if (usage >= 0 && usage <= 100) {
                    g.setColor(this.colors[usage]);
                    g.fillRect(c * this.pwidth, r * this.pheight, pw, ph);
                    if ((float)this.fm.stringWidth(String.valueOf(this.numPs)) <= this.fontOffset * (float)pw && (float)this.fm.getHeight() <= this.fontOffset * (float)ph) {
                        g.setColor(Color.black);
                        g.drawString(String.valueOf(curPE), c * this.pwidth + (pw - this.fm.stringWidth(String.valueOf(curPE))) / 2, r * this.pheight + (ph + this.fm.getHeight()) / 2);
                    }
                }
                if (p >= this.numPs) continue block0;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.pold = -1;
        this.animationWindow.setStatusInfo(-1, -1, -1);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (this.pwidth <= 0 || this.pheight <= 0) {
            return;
        }
        int row = (evt.getY() - this.voffset) / this.pheight;
        int col = (evt.getX() - this.hoffset) / this.pwidth;
        this.curP = row * this.numcols + col;
        if (this.curP >= this.numPs || this.curP < 0 || row < 0 || col < 0 || row >= this.numrows || col >= this.numcols) {
            this.curP = -1;
        }
        if (this.curP != this.pold) {
            this.pold = this.curP;
            int pe = 0;
            Iterator iter = this.animationWindow.selectedPEs.iterator();
            for (int count = 0; count <= this.curP; ++count) {
                pe = (Integer)iter.next();
            }
            if (this.curP >= 0 && this.curI != -1) {
                this.animationWindow.setStatusInfo(pe, this.curI, this.data[this.curP][this.curI]);
            } else {
                this.animationWindow.setStatusInfo(-1, -1, -1);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void paint(Graphics g) {
        if (this.offscreen == null) {
            return;
        }
        if (this.curI != -1) {
            this.makeNextImage(this.offscreen.getGraphics(), this.curI);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public void setCurI(int i) {
        this.curI = i % this.numIs;
        if (this.curI < 0) {
            this.curI += this.numIs;
        }
        if (this.curP >= 0 && this.curP < this.numPs) {
            this.animationWindow.setStatusInfo(this.curP, this.curI, this.data[this.curP][this.curI]);
        }
        this.repaint();
    }

    protected void setParameters() {
        SortedSet<Integer> selectedPEs = this.animationWindow.selectedPEs;
        this.chosenPEs = selectedPEs;
        this.numPs = selectedPEs.size();
        this.Isize = this.animationWindow.intervalSize;
        this.data = this.getAnimationData(this.Isize, this.animationWindow.startTime, this.animationWindow.endTime, selectedPEs);
        this.numIs = this.data[0].length;
        if (this.numIs > 0) {
            this.curI = 0;
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.w > 0 && this.h > 0) {
            this.numcols = (int)Math.sqrt(this.numPs) - (int)(Math.sqrt(this.numPs) % 5.0);
            if (this.numcols == 0) {
                this.numcols = Math.min(this.numPs, 10);
            }
            this.numrows = (int)Math.ceil((double)this.numPs / (double)this.numcols);
            this.pheight = this.pwidth = Math.min(this.w / this.numcols, this.h / this.numrows);
            this.hoffset = (this.w - this.numcols * this.pwidth) / 2;
            this.voffset = (this.h - this.numrows * this.pheight) / 2;
            this.phoffset = (int)((1.0f - this.psize) * (float)this.pwidth) / 2;
            this.pvoffset = (int)((1.0f - this.psize) * (float)this.pheight) / 2;
            this.animationWindow.setTitleInfo(this.curI);
            this.clearScreen();
        }
    }

    private int[][] getAnimationData(long intervalSize, long startTime, long endTime, SortedSet<Integer> desiredPEs) {
        if (intervalSize >= endTime - startTime) {
            intervalSize = endTime - startTime;
        }
        int startI = (int)(startTime / intervalSize);
        int endI = (int)(endTime / intervalSize);
        int numPs = desiredPEs.size();
        MainWindow.runObject[this.myRun].LoadGraphData(intervalSize, startI, endI - 1, false, desiredPEs);
        int[][] animationdata = new int[numPs][endI - startI];
        for (int p = 0; p < numPs; ++p) {
            for (int t = 0; t < endI - startI; ++t) {
                animationdata[p][t] = MainWindow.runObject[this.myRun].getSystemUsageData(1)[p][t];
            }
        }
        return animationdata;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

