/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

class BackGroundImagePanel
extends JPanel {
    private Image bgimage = null;
    private boolean tile;

    protected BackGroundImagePanel(Image bgimage, boolean tile) {
        this.bgimage = bgimage;
        this.tile = tile;
    }

    protected BackGroundImagePanel(Image bgimage) {
        this(bgimage, true);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bgimage != null) {
            this.wallPaper(this, g, this.bgimage);
        }
    }

    private void wallPaper(Component component, Graphics g, Image image) {
        Dimension compsize = component.getSize();
        this.waitForImage(component, image);
        int patchW = image.getWidth(component);
        int patchH = image.getHeight(component);
        if (this.tile) {
            for (int r = 0; r < compsize.width; r += patchW) {
                for (int c = 0; c < compsize.height; c += patchH) {
                    g.drawImage(image, r, c, component);
                }
            }
        } else {
            double pnlAspect = (double)compsize.height * 1.0 / (double)compsize.width;
            double imgAspect = (double)patchH * 1.0 / (double)patchW;
            if (pnlAspect > imgAspect) {
                Image scaledImg = image.getScaledInstance(compsize.width, -1, 4);
                this.waitForImage(component, scaledImg);
                int scaledImgH = scaledImg.getHeight(component);
                int heightOffset = (compsize.height - scaledImgH) / 2;
                g.drawImage(scaledImg, 0, heightOffset, component);
            } else {
                Image scaledImg = image.getScaledInstance(-1, compsize.height, 4);
                this.waitForImage(component, scaledImg);
                int scaledImgW = scaledImg.getWidth(component);
                int widthOffset = (compsize.width - scaledImgW) / 2;
                g.drawImage(scaledImg, widthOffset, 0, component);
            }
        }
    }

    private void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

