/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import projections.gui.MainWindow;

class CallTableTextArea
extends JPanel
implements AdjustmentListener {
    private int myRun = 0;
    private JScrollBar VSB;
    private String[][] text;
    private FontMetrics fm;
    private int lineheight;
    private int titleheight;
    private Image offscreen;
    private int linenumwidth;
    private int timewidth;
    private Color sourceEntryColor;
    private Color destEntryColor;
    private Color statsColor;

    public CallTableTextArea() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                CallTableTextArea.this.setBounds();
            }
        });
        this.setLayout(null);
        this.setBackground(Color.black);
        this.VSB = new JScrollBar(1, 0, 1, 0, 1);
        this.VSB.setVisible(false);
        this.VSB.setBackground(Color.lightGray);
        this.VSB.addAdjustmentListener(this);
        this.add(this.VSB);
        this.sourceEntryColor = Color.green;
        this.destEntryColor = Color.yellow;
        this.statsColor = Color.white;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.setBounds();
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.fm == null) {
            this.setBounds();
        }
        if (this.text == null) {
            return;
        }
        Graphics og = g;
        if (this.offscreen != null) {
            g = this.offscreen.getGraphics();
        }
        int vsb = this.VSB.getValue();
        g.translate(0, -vsb);
        int w = this.getSize().width - 20;
        int h = this.getSize().height - this.titleheight;
        int minline = (vsb - this.lineheight) / this.lineheight;
        int maxline = (vsb - this.lineheight + h) / this.lineheight + 1;
        if (minline < 0) {
            minline = 0;
        }
        if (maxline < minline) {
            maxline = minline;
        }
        if (maxline > this.text.length - 1) {
            maxline = this.text.length - 1;
        }
        g.setColor(Color.white);
        for (int i = minline; i <= maxline; ++i) {
            String s = this.text[i][0];
            if (s != "") {
                char[] str = s.toCharArray();
                if (str[0] != ' ') {
                    g.setColor(this.sourceEntryColor);
                } else if (str[8] != ' ') {
                    g.setColor(this.destEntryColor);
                } else {
                    g.setColor(this.statsColor);
                }
            } else {
                g.setColor(Color.white);
            }
            int xpos = 10;
            int ypos = i * this.lineheight + this.titleheight;
            g.drawString(s, xpos, ypos);
        }
        og.drawImage(this.offscreen, 0, 0, w, h + this.titleheight, 0, 0, w, h + this.titleheight, null);
    }

    private void setBounds() {
        Graphics g;
        if (this.fm == null && (g = this.getGraphics()) != null) {
            this.fm = g.getFontMetrics(g.getFont());
            this.lineheight = this.fm.getHeight() + 2;
        }
        if (this.fm == null || this.text == null) {
            return;
        }
        int numlines = this.text.length;
        int totalheight = this.lineheight * (numlines + 1);
        this.titleheight = this.lineheight + 20;
        this.linenumwidth = this.fm.stringWidth("" + numlines);
        if (this.linenumwidth < this.fm.stringWidth("LINE")) {
            this.linenumwidth = this.fm.stringWidth("LINE");
        }
        this.timewidth = this.fm.stringWidth("" + MainWindow.runObject[this.myRun].getTotalTime());
        if (this.timewidth < this.fm.stringWidth("TIME")) {
            this.timewidth = this.fm.stringWidth("TIME");
        }
        int w = this.getSize().width - 20;
        int h = this.getSize().height - this.titleheight;
        this.VSB.setBounds(w, this.titleheight, 20, h);
        if (totalheight > h) {
            this.VSB.setMaximum(totalheight);
            this.VSB.setVisibleAmount(h);
            this.VSB.setBlockIncrement(h);
            this.VSB.setUnitIncrement(this.lineheight);
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        try {
            this.offscreen = this.createImage(w, h + this.titleheight);
        }
        catch (OutOfMemoryError e) {
            System.out.println("NOT ENOUGH MEMORY!");
        }
        this.repaint();
    }

    public void setText(String[][] s) {
        this.text = s;
        if (s == null) {
            this.text = new String[1][2];
            this.text[0][0] = "";
            this.text[0][1] = "THIS LOG FILE IS EMPTY";
        }
        this.setBounds();
    }

    public void update(Graphics g) {
        int w = this.getSize().width - 20;
        int h = this.getSize().height;
        if (this.offscreen != null) {
            Graphics og = this.offscreen.getGraphics();
            og.clearRect(0, 0, w, h);
        }
        this.paint(g);
    }

    public void setSourceEntryColor(Color c) {
        this.sourceEntryColor = c;
        this.repaint();
    }

    public void setDestEntryColor(Color c) {
        this.destEntryColor = c;
        this.repaint();
    }

    public void setStatsColor(Color c) {
        this.statsColor = c;
        this.repaint();
    }

    public Color getSourceEntryColor() {
        return this.sourceEntryColor;
    }

    public Color getDestEntryColor() {
        return this.destEntryColor;
    }

    public Color getStatsColor() {
        return this.statsColor;
    }

    public void setTextAreaBackgroundColor() {
        this.setBounds();
    }
}

