/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import projections.analysis.CallTable;
import projections.gui.CallTableTextArea;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

class CallTableWindow
extends ProjectionsWindow
implements ActionListener {
    private CallTableWindow thisWindow = this;
    private int myRun = 0;
    private CallTableTextArea textArea;
    private JLabel lTitle;
    private JPanel titlePanel;
    private JPanel mainPanel;
    private JPanel buttonPanel1;
    private JPanel buttonPanel2;
    private JPanel controlPanel;
    private JButton setRanges;
    private ButtonGroup bg1;
    private JRadioButton epDetailOn;
    private JRadioButton epDetailOff;
    private ButtonGroup bg2;
    private JRadioButton statsOn;
    private JRadioButton statsOff;
    private SortedSet<Integer> validPEs;
    private long startTime;
    private long endTime;
    private CallTable ct;
    private boolean epDetailToggle;
    private boolean statsToggle;
    private JButton bSourceEntryColor;
    private JButton bDestEntryColor;
    private JButton bStatsColor;
    private JButton bBackgroundColor;

    protected CallTableWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setBackground(Color.black);
        this.setTitle("Projections Call Table - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.mainPanel = new JPanel();
        this.epDetailToggle = false;
        this.statsToggle = false;
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.setRanges) {
                this.showDialog();
            } else if (b == this.bSourceEntryColor) {
                JColorChooser colorChooser = new JColorChooser();
                Color c = JColorChooser.showDialog(this.bSourceEntryColor, "Choose Source Entry Point Color", this.textArea.getSourceEntryColor());
                if (c != null) {
                    this.textArea.setSourceEntryColor(c);
                }
            } else if (b == this.bDestEntryColor) {
                JColorChooser colorChooser = new JColorChooser();
                Color c = JColorChooser.showDialog(this.bDestEntryColor, "Choose Destination Entry Point Color", this.textArea.getDestEntryColor());
                if (c != null) {
                    this.textArea.setDestEntryColor(c);
                }
            } else if (b == this.bStatsColor) {
                JColorChooser colorChooser = new JColorChooser();
                Color c = JColorChooser.showDialog(this.bStatsColor, "Choose Statistics Color", this.textArea.getStatsColor());
                if (c != null) {
                    this.textArea.setStatsColor(c);
                }
            } else if (b == this.bBackgroundColor) {
                JColorChooser colorChooser = new JColorChooser();
                Color c = JColorChooser.showDialog(this.bBackgroundColor, "Choose Background Color", this.getBackground());
                if (c != null) {
                    this.setBackground(c);
                    this.titlePanel.setBackground(c);
                    if (c.equals(Color.white)) {
                        this.lTitle.setForeground(Color.black);
                    }
                    if (c.equals(Color.black)) {
                        this.lTitle.setForeground(Color.white);
                    }
                    this.textArea.setBackground(c);
                    this.textArea.setTextAreaBackgroundColor();
                }
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            } else if (arg.equals("Change Colors")) {
                this.changeColors();
            }
        } else if (e.getSource() instanceof JRadioButton) {
            this.setCursor(new Cursor(3));
            if (e.getSource() == this.statsOff) {
                this.statsToggle = false;
                this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
            } else if (e.getSource() == this.statsOn) {
                this.statsToggle = true;
                this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
            } else if (e.getSource() == this.epDetailOff) {
                this.epDetailToggle = false;
                this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
            } else if (e.getSource() == this.epDetailOn) {
                this.epDetailToggle = true;
                this.textArea.setText(this.ct.getCallTableText(this.epDetailToggle, this.statsToggle));
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void changeColors() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.bSourceEntryColor = new JButton("Change Source Entry Point Color");
        this.bSourceEntryColor.addActionListener(this);
        this.bDestEntryColor = new JButton("Change Destination Entry Point Color");
        this.bDestEntryColor.addActionListener(this);
        this.bStatsColor = new JButton("Change Statistics Color");
        this.bStatsColor.addActionListener(this);
        this.bBackgroundColor = new JButton("Change Background Color");
        this.bBackgroundColor.addActionListener(this);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(gbl);
        colorPanel.add(this.bSourceEntryColor);
        colorPanel.add(this.bDestEntryColor);
        colorPanel.add(this.bStatsColor);
        colorPanel.add(this.bBackgroundColor);
        Util.gblAdd(colorPanel, this.bSourceEntryColor, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(colorPanel, this.bDestEntryColor, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(colorPanel, this.bStatsColor, gbc, 0, 3, 1, 1, 1, 1);
        Util.gblAdd(colorPanel, this.bBackgroundColor, gbc, 0, 4, 1, 1, 1, 1);
        JFrame colorFrame = new JFrame("Call Table - Change Colors");
        colorFrame.setDefaultCloseOperation(2);
        colorFrame.add(colorPanel);
        colorFrame.pack();
        colorFrame.setVisible(true);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range", null, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.validPEs = this.dialog.getSelectedProcessors();
            this.startTime = this.dialog.getStartTime();
            this.endTime = this.dialog.getEndTime();
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    CallTableWindow.this.ct = new CallTable(CallTableWindow.this.startTime, CallTableWindow.this.endTime, CallTableWindow.this.validPEs);
                    CallTableWindow.this.ct.GatherData(CallTableWindow.this.thisWindow);
                    CallTableWindow.this.textArea.setText(CallTableWindow.this.ct.getCallTableText(CallTableWindow.this.epDetailToggle, CallTableWindow.this.statsToggle));
                    return null;
                }

                public void done() {
                }
            };
            worker.execute();
        }
    }

    private void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, this));
        this.setJMenuBar(mbar);
    }

    private void CreateLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.textArea = new CallTableTextArea();
        this.titlePanel = new JPanel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new JLabel("CALL TABLE", 0);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        this.bg1 = new ButtonGroup();
        this.epDetailOff = new JRadioButton("EP Detail Off", true);
        this.epDetailOff.addActionListener(this);
        this.epDetailOn = new JRadioButton("EP Detail On", false);
        this.epDetailOn.addActionListener(this);
        this.bg1.add(this.epDetailOff);
        this.bg1.add(this.epDetailOn);
        this.buttonPanel1 = new JPanel();
        Util.gblAdd(this.buttonPanel1, this.epDetailOff, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.buttonPanel1, this.epDetailOn, gbc, 1, 0, 1, 1, 1, 1);
        this.bg2 = new ButtonGroup();
        this.statsOff = new JRadioButton("Statistics Off", true);
        this.statsOff.addActionListener(this);
        this.bg2.add(this.statsOff);
        this.statsOn = new JRadioButton("Statistics On", false);
        this.statsOn.addActionListener(this);
        this.bg2.add(this.statsOn);
        this.buttonPanel2 = new JPanel();
        Util.gblAdd(this.buttonPanel2, this.statsOff, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.buttonPanel2, this.statsOn, gbc, 1, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.titlePanel, gbc, 0, 1, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.textArea, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.buttonPanel1, gbc, 0, 3, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.buttonPanel2, gbc, 0, 4, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 5, 1, 0, 0, 0);
    }
}

