/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.SortedSet;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import projections.gui.ChooseEntriesWindow;
import projections.gui.ColorUpdateNotifier;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphDefaultColors;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;
import projections.gui.PopUpAble;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisDiscrete;
import projections.gui.graph.XAxisDiscreteOrdered;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;
import projections.gui.graph.YAxisFixed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericGraphWindow
extends ProjectionsWindow
implements PopUpAble,
ColorUpdateNotifier {
    private static int myRun = 0;
    private GraphPanel graphPanel;
    protected Graph graphCanvas;
    private DataSource dataSource;
    protected XAxis xAxis;
    private YAxis yAxis;
    protected JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem mSaveScreenshot;
    private JMenuItem mWhiteBG;
    private JMenuItem mBlackBG;
    protected JMenuItem mChooseColors;
    private JMenuItem mSaveColors;
    private JMenuItem mLoadColors;
    private GenericGraphColorer colorer;
    GenericGraphWindow gw;

    protected abstract void setGraphSpecificData();

    public GenericGraphWindow(String title, MainWindow mainWindow) {
        super(title, mainWindow);
        this.menuBar.add(this.fileMenu);
        this.gw = this;
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Set Range", "Close"}, this);
        JMenu mColors = new JMenu("Color Scheme");
        this.mWhiteBG = new JMenuItem("White background");
        this.mBlackBG = new JMenuItem("Black background");
        this.mChooseColors = new JMenuItem("Choose Entry Colors");
        this.mSaveColors = new JMenuItem("Save Colors To File");
        this.mLoadColors = new JMenuItem("Load Colors From File");
        this.mWhiteBG.addActionListener(new MenuHandler());
        this.mBlackBG.addActionListener(new MenuHandler());
        this.mChooseColors.addActionListener(new MenuHandler());
        this.mSaveColors.addActionListener(new MenuHandler());
        this.mLoadColors.addActionListener(new MenuHandler());
        mColors.add(this.mWhiteBG);
        mColors.add(this.mBlackBG);
        mColors.addSeparator();
        mColors.add(this.mChooseColors);
        mColors.addSeparator();
        mColors.add(this.mSaveColors);
        mColors.add(this.mLoadColors);
        this.menuBar.add(mColors);
        JMenu saveMenu = new JMenu("Save To Image");
        this.mSaveScreenshot = new JMenuItem("Save Plot as JPG or PNG");
        this.mSaveScreenshot.addActionListener(new MenuHandler());
        saveMenu.add(this.mSaveScreenshot);
        this.menuBar.add(saveMenu);
        this.setJMenuBar(this.menuBar);
    }

    @Override
    public abstract String[] getPopup(int var1, int var2);

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        this.graphCanvas = new Graph();
        this.graphPanel = new GraphPanel(this.graphCanvas);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.graphPanel);
        return mainPanel;
    }

    protected void setXAxis(String title, String units) {
        this.xAxis = new XAxisFixed(title, units);
    }

    protected void setXAxis(String title, SortedSet<Integer> discreteList) {
        this.xAxis = new XAxisDiscreteOrdered(title, discreteList);
    }

    protected void setXAxis(String title, LinkedList discreteList) {
        this.xAxis = new XAxisDiscrete(title, discreteList);
    }

    protected void setXAxis(String title, String units, double startValue, double multiplier) {
        this.xAxis = new XAxisFixed(title, units);
        ((XAxisFixed)this.xAxis).setLimits(startValue, multiplier);
    }

    protected void setYAxis(String title, String units) {
        this.yAxis = this.dataSource != null ? new YAxisAuto(title, units, this.dataSource) : new YAxisFixed(title, units, 0.0);
    }

    protected void setDataSource(String title, double[][] data, GenericGraphColorer colorer, GenericGraphWindow parent) {
        this.dataSource = new DataSource2D(title, data, parent);
        this.colorer = colorer;
        this.dataSource.setColors(colorer.getColorMap());
        if (this.yAxis != null) {
            this.yAxis = new YAxisAuto(this.yAxis.getTitle(), this.yAxis.getUnits(), this.dataSource);
        }
    }

    protected void setDataSource(String title, double[][] data, GenericGraphWindow parent) {
        this.setDataSource(title, data, new GenericGraphDefaultColors(), parent);
    }

    protected void refreshGraph() {
        if (this.graphCanvas != null) {
            this.dataSource.setColors(this.colorer.getColorMap());
            this.graphCanvas.setData(this.dataSource, this.xAxis, this.yAxis);
            this.graphCanvas.repaint();
        }
    }

    @Override
    public void colorsHaveChanged() {
        this.refreshGraph();
    }

    public class MenuHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GenericGraphWindow.this.mWhiteBG) {
                MainWindow.runObject[myRun].background = Color.white;
                MainWindow.runObject[myRun].foreground = Color.black;
                GenericGraphWindow.this.graphCanvas.repaint();
            } else if (e.getSource() == GenericGraphWindow.this.mBlackBG) {
                MainWindow.runObject[myRun].background = Color.black;
                MainWindow.runObject[myRun].foreground = Color.white;
                GenericGraphWindow.this.graphCanvas.repaint();
            } else if (e.getSource() == GenericGraphWindow.this.mSaveScreenshot) {
                JPanelToImage.saveToFileChooserSelection(GenericGraphWindow.this.graphCanvas, "Save Plot To File", "./ProjectionsPlot.png");
            } else if (e.getSource() == GenericGraphWindow.this.mChooseColors) {
                new ChooseEntriesWindow(GenericGraphWindow.this.gw);
            } else if (e.getSource() == GenericGraphWindow.this.mLoadColors) {
                try {
                    MainWindow.runObject[myRun].loadColors();
                    GenericGraphWindow.this.gw.colorsHaveChanged();
                    JOptionPane.showMessageDialog(null, "The colors have successfully been loaded.", "Colors Loaded", 1);
                }
                catch (Exception error) {
                    JOptionPane.showMessageDialog(null, error.getMessage() + "\nPlease set your colors and save them.", "Error", 0);
                    GenericGraphWindow.this.refreshGraph();
                }
            } else if (e.getSource() == GenericGraphWindow.this.mSaveColors) {
                MainWindow.runObject[myRun].saveColors();
            }
        }
    }
}

