/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.Util;

class MainRunStatusPanel
extends JPanel
implements ChangeListener {
    private JTextField statusField;
    private JLabel statusLabel;
    private int tabIndex = 0;

    public MainRunStatusPanel() {
        this.createLayout();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof MainSummaryGraphPanel) {
            MainSummaryGraphPanel pane = (MainSummaryGraphPanel)e.getSource();
            if (pane.isEmpty()) {
                this.setField(0, "Not Applicable");
            } else {
                int index = pane.getSelectedIndex();
                if (index != -1) {
                    this.setField(index, pane.getTitleAt(index));
                }
            }
        }
    }

    private void createLayout() {
        this.setBackground(Color.black);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.setLayout(gbl);
        this.statusField = new JTextField("Tab Index " + this.tabIndex + ": " + "Not Applicable");
        this.statusField.setEditable(false);
        this.statusLabel = new JLabel("Active Run: ");
        this.statusLabel.setForeground(Color.yellow);
        Util.gblAdd(this, this.statusLabel, gbc, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0);
        Util.gblAdd(this, this.statusField, gbc, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0);
    }

    private void setField(int index, String text) {
        this.statusField.setText("Tab Index " + index + ": " + text);
    }
}

