/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import projections.Tools.Timeline.TimelineWindow;
import projections.analysis.Analysis;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjMain;
import projections.gui.BackGroundImagePanel;
import projections.gui.InvalidFileDialog;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.ProjectionsWindow;
import projections.gui.ScalePanel;
import projections.gui.ScreenInfo;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ScalePanel.StatusDisplay {
    private static final int NUM_RUNS = 1;
    private int myRun = 0;
    protected static final int NUM_WINDOWS = 18;
    private LinkedList<ProjectionsWindow> openToolWindows;
    public static double CUR_VERSION;
    public static boolean IGNORE_IDLE;
    public static boolean BLUEGENE;
    public static int[] BLUEGENE_SIZE;
    protected static boolean PRINT_USAGE;
    private static PrintWriter dataDump;
    private MainWindow mainWindow = this;
    public static Analysis[] runObject;
    private MainTitlePanel titlePanel;
    private BackGroundImagePanel background;
    private MainMenuManager menuManager;
    private MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    private SummaryDataSource sumDataSource;
    private SummaryXAxis sumXAxis;
    private SummaryYAxis sumYAxis;
    private GraphPanel graphPanel;
    private Label status;
    private Image bgimage;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    public static Logger performanceLogger;

    public MainWindow() {
        CUR_VERSION = ProjMain.CUR_VERSION;
        IGNORE_IDLE = ProjMain.IGNORE_IDLE;
        BLUEGENE = ProjMain.BLUEGENE;
        BLUEGENE_SIZE = ProjMain.BLUEGENE_SIZE;
        PRINT_USAGE = ProjMain.PRINT_USAGE;
        performanceLogger.setLevel(Level.OFF);
        ScreenInfo.init();
        int numProcs = Runtime.getRuntime().availableProcessors();
        performanceLogger.log(Level.INFO, "Number of processors available to the Java Virtual Machine: " + numProcs);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjMain.shutdown(0);
            }
        });
        this.setBackground(Color.lightGray);
        runObject = new Analysis[1];
        MainWindow.runObject[0] = new Analysis();
        this.openToolWindows = new LinkedList();
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    private void createLayout() {
        try {
            URL imageURL = this.getClass().getResource("/projections/images/bgimage.jpg");
            this.bgimage = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.background = new BackGroundImagePanel(this.bgimage, true);
        }
        catch (Exception E) {
            System.out.println("Error loading background image.  Continuing.");
            this.background = new BackGroundImagePanel(null);
        }
        this.setContentPane(this.background);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.background.setLayout(this.gbl);
        this.titlePanel = new MainTitlePanel();
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this, this.runStatusPanel);
        Util.gblAdd(this.background, this.titlePanel, this.gbc, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.background, this.runStatusPanel, this.gbc, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.background, this.summaryGraphPanel, this.gbc, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.background.setPreferredSize(new Dimension(ScreenInfo.screenWidth, ScreenInfo.screenHeight));
        this.pack();
    }

    protected void changeBackground() {
        Color returnColor = JColorChooser.showDialog(this, "Background Color", MainWindow.runObject[this.myRun].background);
        if (returnColor != null) {
            MainWindow.runObject[this.myRun].background = returnColor;
            this.repaintAllWindows();
        }
    }

    protected void changeForeground() {
        Color returnColor = JColorChooser.showDialog(this, "Foreground Color", MainWindow.runObject[this.myRun].foreground);
        if (returnColor != null) {
            MainWindow.runObject[this.myRun].foreground = returnColor;
            this.repaintAllWindows();
        }
    }

    private void repaintAllWindows() {
        for (ProjectionsWindow w : this.openToolWindows) {
            if (w instanceof TimelineWindow) {
                ((TimelineWindow)w).refreshDisplay(false);
                continue;
            }
            w.repaint();
        }
        this.repaint();
    }

    protected void showOpenFileDialog() {
        JFileChooser d = new JFileChooser(System.getProperty("user.dir"));
        d.setFileFilter(new MainFileFilter());
        int returnval = d.showOpenDialog(this);
        if (returnval == 0) {
            this.setTitle("Projections -" + d.getSelectedFile());
            this.openFile(d.getSelectedFile().getAbsolutePath());
        }
    }

    public void openFile(String filename) {
        final String newfile = filename;
        this.sumDataSource = null;
        this.sumXAxis = null;
        this.sumYAxis = null;
        this.graphPanel = null;
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                try {
                    runObject[MainWindow.this.myRun].initAnalysis(newfile, MainWindow.this.mainWindow);
                }
                catch (IOException e) {
                    InvalidFileDialog ifd = new InvalidFileDialog((Frame)MainWindow.this.mainWindow, e);
                    ifd.setVisible(true);
                }
                catch (StringIndexOutOfBoundsException e) {
                    e.printStackTrace();
                    InvalidFileDialog ifd = new InvalidFileDialog((Frame)MainWindow.this.mainWindow, e);
                    ifd.setVisible(true);
                }
                catch (OutOfMemoryError e) {
                    e.printStackTrace();
                    System.err.println("ERROR: PROJECTIONS RUNNING OUT oF MEMORY");
                    System.err.println("POSSIBLE SOLUTION: Set more memory for projections OR use \"projections64\"");
                    System.exit(1);
                }
                return null;
            }

            public void done() {
                MainWindow.this.setTitle("Projections - " + newfile);
                if (runObject[MainWindow.this.myRun].hasSummaryData()) {
                    double[][] newdata;
                    double[][] data = runObject[MainWindow.this.myRun].getSummaryAverageData();
                    long originalSize = runObject[MainWindow.this.myRun].getSummaryIntervalSize();
                    if (ProjMain.SUM_OVERRIDE && (ProjMain.SUM_END_INT <= ProjMain.SUM_START_INT || (long)data.length * originalSize < (long)ProjMain.SUM_END_INT * ProjMain.SUM_INT_SIZE)) {
                        System.out.println("Warning: Specified Summary parameters of [" + ProjMain.SUM_START_INT + "," + ProjMain.SUM_END_INT + "," + ProjMain.SUM_INT_SIZE + "] " + "is inconsistent. " + "Real Summary Data " + "has [" + 0 + "," + data.length + "," + originalSize + "]. " + "Reverting to default " + "main summary display.");
                        ProjMain.SUM_OVERRIDE = false;
                    }
                    long bestSize = 0L;
                    bestSize = ProjMain.SUM_OVERRIDE ? ProjMain.SUM_INT_SIZE : (long)IntervalUtils.getBestIntervalSize(originalSize, data.length);
                    if (bestSize != originalSize) {
                        int i;
                        double[] timeData = new double[data.length];
                        double[] idleData = new double[data.length];
                        for (int i2 = 0; i2 < data.length; ++i2) {
                            timeData[i2] = data[i2][0];
                            idleData[i2] = data[i2][1];
                        }
                        IntervalUtils.utilToTime(timeData, (double)originalSize);
                        IntervalUtils.utilToTime(idleData, (double)originalSize);
                        double[] tempTimeData = IntervalUtils.rebin(timeData, (double)originalSize, bestSize);
                        IntervalUtils.timeToUtil(tempTimeData, (double)bestSize);
                        double[] tempIdleData = IntervalUtils.rebin(idleData, (double)originalSize, bestSize);
                        IntervalUtils.timeToUtil(tempIdleData, (double)bestSize);
                        newdata = new double[tempTimeData.length][2];
                        for (i = 0; i < tempTimeData.length; ++i) {
                            newdata[i][0] = tempTimeData[i];
                            newdata[i][1] = tempIdleData[i];
                        }
                        if (ProjMain.SUM_OVERRIDE) {
                            newdata = new double[ProjMain.SUM_END_INT - ProjMain.SUM_START_INT + 1][2];
                            for (i = 0; i < newdata.length; ++i) {
                                newdata[i][0] = tempTimeData[i + ProjMain.SUM_START_INT];
                                newdata[i][1] = tempIdleData[i + ProjMain.SUM_START_INT];
                            }
                        }
                    } else {
                        newdata = data;
                        if (ProjMain.SUM_OVERRIDE) {
                            newdata = new double[ProjMain.SUM_END_INT - ProjMain.SUM_START_INT + 1][2];
                            for (int i = 0; i < newdata.length; ++i) {
                                newdata[i][0] = data[i + ProjMain.SUM_START_INT][0];
                                newdata[i][1] = data[i + ProjMain.SUM_START_INT][1];
                            }
                        }
                    }
                    try {
                        dataDump = new PrintWriter(new FileWriter(runObject[MainWindow.this.myRun].getLogDirectory() + File.separator + "SummaryDump.out"));
                        dataDump.println("--- Summary Graph ---");
                        for (int i = 0; i < newdata.length; ++i) {
                            if (ProjMain.SUM_OVERRIDE) {
                                dataDump.print(i + ProjMain.SUM_START_INT + " ");
                            } else {
                                dataDump.print(i + " ");
                            }
                            dataDump.println(newdata[i][0]);
                        }
                        dataDump.flush();
                    }
                    catch (IOException e) {
                        System.err.println("WARNING: Failed to handle dump file SummaryDump.out. Reason: ");
                        System.err.println(e);
                    }
                    if (ProjMain.SUM_OVERRIDE) {
                        MainWindow.this.sumXAxis = new SummaryXAxis(ProjMain.SUM_START_INT, ProjMain.SUM_INT_SIZE);
                        MainWindow.this.sumDataSource = new SummaryDataSource(newdata, ProjMain.SUM_START_INT);
                    } else {
                        MainWindow.this.sumXAxis = new SummaryXAxis(0, bestSize);
                        MainWindow.this.sumDataSource = new SummaryDataSource(newdata, 0);
                    }
                    MainWindow.this.sumYAxis = new SummaryYAxis();
                    MainWindow.this.graphPanel = new GraphPanel(new Graph(MainWindow.this.sumDataSource, MainWindow.this.sumXAxis, MainWindow.this.sumYAxis));
                    MainWindow.this.summaryGraphPanel.add("data", MainWindow.this.graphPanel, "run data");
                }
                if (runObject[MainWindow.this.myRun].hasLogData()) {
                    MainWindow.this.menuManager.fileOpened();
                } else if (runObject[MainWindow.this.myRun].hasSummaryData()) {
                    if (runObject[MainWindow.this.myRun].hasSumDetailData()) {
                        MainWindow.this.menuManager.summaryOnly(1);
                    } else {
                        MainWindow.this.menuManager.summaryOnly(0);
                    }
                }
            }
        };
        worker.execute();
    }

    protected void closeChildWindow(ProjectionsWindow child) {
        System.out.println("Removing window from openToolWindows");
        this.openToolWindows.remove(child);
    }

    public void shutdown() {
        runObject[this.myRun].closeRC();
    }

    protected void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        runObject[this.myRun].closeRC();
        this.setTitle("Projections");
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    public void addProcessor(int pe) {
        for (ProjectionsWindow w : this.openToolWindows) {
            w.addProcessor(pe);
        }
    }

    protected void closeCurrent() {
        this.closeAll();
    }

    protected void openTool(ProjectionsWindow w) {
        this.openToolWindows.add(w);
    }

    static {
        dataDump = null;
        performanceLogger = Logger.getLogger("ProjectionsPerformance");
    }
}

