/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.MainWindow;
import projections.gui.MultiRunControlPanel;
import projections.gui.MultiRunTables;
import projections.gui.ProjectionsFileChooser;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;

class MultiRunWindow
extends ProjectionsWindow
implements ActionListener,
ItemListener {
    private MultiRunWindow thisWindow = this;
    private MultiRunControlPanel controlPanel;
    private MultiRunTables tablesPanel;
    private JDialog tablesWindow;
    private GraphPanel graphPanel;
    private Graph graphCanvas;
    private ProjectionsFileChooser fc;
    private MultiRunData data;
    private MultiRunDataAnalyzer analyzer;
    private JPanel mainPanel;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private int selectedDataType;

    protected MultiRunWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setBackground(Color.lightGray);
        this.showDialog();
    }

    public void showDialog() {
        this.fc = new ProjectionsFileChooser(this, "Multirun Analysis", 1);
        this.fc.showDialog();
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        this.parentWindow.closeChildWindow(this);
    }

    protected void dialogCallback() {
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                try {
                    MultiRunWindow.this.data = new MultiRunData(((MultiRunWindow)MultiRunWindow.this).fc.userSelect_returnVal, MultiRunWindow.this.thisWindow);
                    MultiRunWindow.this.analyzer = new MultiRunDataAnalyzer(MultiRunWindow.this.data);
                    MultiRunWindow.this.selectedDataType = 0;
                    MultiRunWindow.this.thisWindow.createDisplayPanels();
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
                return null;
            }

            public void done() {
                MultiRunWindow.this.thisWindow.createLayout();
                MultiRunWindow.this.thisWindow.pack();
                MultiRunWindow.this.thisWindow.setTitle("Multiple Run Analysis");
                MultiRunWindow.this.thisWindow.setVisible(true);
            }
        };
        worker.execute();
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(Color.gray);
        this.controlPanel = new MultiRunControlPanel(this, this.selectedDataType);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.mainPanel.setLayout(this.gbl);
        this.gbc.fill = 1;
        Util.gblAdd(this.mainPanel, this.graphPanel, this.gbc, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(this.mainPanel, this.controlPanel, this.gbc, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
        this.setContentPane(this.mainPanel);
    }

    private void createDisplayPanels() {
        MultiRunDataSource dataSource = this.analyzer.getDataSource(this.selectedDataType);
        MultiRunXAxis xAxis = this.analyzer.getMRXAxisData();
        MultiRunYAxis yAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
        this.graphCanvas = new Graph(dataSource, xAxis, yAxis);
        this.graphPanel = new GraphPanel(this.graphCanvas);
        this.tablesPanel = new MultiRunTables(this.selectedDataType, this.analyzer);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JRadioButton && e.getStateChange() == 1) {
            this.selectedDataType = this.controlPanel.getSelectedIdx(e.getItemSelectable());
            MultiRunDataSource dataSource = this.analyzer.getDataSource(this.selectedDataType);
            MultiRunXAxis xAxis = this.analyzer.getMRXAxisData();
            MultiRunYAxis yAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
            this.graphCanvas.setData(dataSource, xAxis, yAxis);
            this.tablesPanel.setType(this.selectedDataType);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (button.getText().equals("Close Window")) {
                this.close();
            } else if (button.getText().equals("Display Tables")) {
                if (this.tablesWindow == null) {
                    this.tablesWindow = new JDialog(this);
                    this.tablesWindow.getContentPane().add(this.tablesPanel);
                    this.tablesWindow.setSize(new Dimension(500, 300));
                    this.tablesWindow.setVisible(true);
                } else {
                    this.tablesWindow.setVisible(true);
                }
            }
        }
    }
}

