/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import projections.Tools.Timeline.ImageFilter;
import projections.Tools.TopologyDisplay.OffScreenCanvas3D;

public class OffScreenCanvas3DToImage {
    public static BufferedImage generateImage(OffScreenCanvas3D canvasToRender, int width, int height) {
        return canvasToRender.generateImage(width, height);
    }

    private static void saveImage(String filename, String format, RenderedImage image) {
        try {
            ImageIO.write(image, format, new File(filename));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public static void saveToFileChooserSelection(OffScreenCanvas3D canvasToRender, String dialogTitle, String fileName, int width, int height) {
        BufferedImage image = OffScreenCanvas3DToImage.generateImage(canvasToRender, width, height);
        OffScreenCanvas3DToImage.saveToFileChooserSelection(image, dialogTitle, fileName);
    }

    public static void saveToFileChooserSelection(final BufferedImage image, final String dialogTitle, final String fileName) {
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                try {
                    ImageIcon icon = image.getWidth() < image.getHeight() ? new ImageIcon(image.getScaledInstance(-1, 200, 4)) : new ImageIcon(image.getScaledInstance(200, -1, 4));
                    JLabel miniPicture = new JLabel(icon);
                    JPanel previewPanel = new JPanel();
                    previewPanel.setLayout(new BorderLayout());
                    previewPanel.add((Component)new JLabel("Preview:"), "North");
                    previewPanel.add((Component)miniPicture, "Center");
                    JFileChooser fc = new JFileChooser();
                    ImageFilter imageFilter = new ImageFilter();
                    fc.setFileFilter(imageFilter);
                    fc.setSelectedFile(new File(fileName));
                    fc.setAccessory(previewPanel);
                    fc.setDialogTitle(dialogTitle);
                    int returnVal = fc.showSaveDialog(null);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        if (imageFilter.isJPEG(file)) {
                            OffScreenCanvas3DToImage.saveImage(file.getCanonicalPath(), "jpg", image);
                        }
                        if (imageFilter.isPNG(file)) {
                            OffScreenCanvas3DToImage.saveImage(file.getCanonicalPath(), "png", image);
                        }
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, null, "Error occurred while saving file:" + e.getLocalizedMessage(), 0);
                }
                return null;
            }

            public void done() {
            }
        };
        worker.execute();
    }
}

