/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import projections.gui.GrepFileFilter;
import projections.gui.MultiRunWindow;
import projections.gui.ProjectionsFileMgr;

class ProjectionsFileChooser {
    private Frame owner_ = null;
    private String title_ = null;
    private JFileChooser fChoose_ = null;
    private JDialog dialog_ = null;
    private JList list_ = null;
    private int listSize_ = 0;
    ProjectionsFileMgr fileMgr_ = null;
    protected static final int MULTIPLE_FILES = 1;
    private static final int SINGLE_FILE = 2;
    protected String[] userSelect_returnVal;
    private int[] userSelect_selected;

    protected ProjectionsFileChooser(Frame owner, String title, int type) {
        if (type != 1 && type != 2) {
            System.err.println("ProjectionFileChooser must init with:\n  ProjectionFileChooser.MULTIPLE_FILES or\n  ProjectionFileChooser.SINGLE_FILE");
            System.exit(-1);
        }
        this.owner_ = owner;
        this.title_ = title;
        this.fChoose_ = this.initFileChooser(this.title_ + ": File(s) Open");
        this.dialog_ = this.initFileDialog(this.title_ + ": Choose Files");
    }

    protected int showDialog() {
        int returnVal = this.fChoose_.showDialog(null, "Open/Search");
        try {
            if (returnVal == 0) {
                Vector files = this.filterFiles(this.fChoose_.getSelectedFiles(), this.fChoose_.getFileFilter());
                this.userSubselect(files);
            }
        }
        catch (Exception exc) {
            System.err.println(exc.toString());
            System.exit(-1);
        }
        return returnVal;
    }

    private JFileChooser initFileChooser(String title) {
        JFileChooser fc = new JFileChooser(title);
        String currDirStr = null;
        try {
            currDirStr = System.getProperty("PWD");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (currDirStr != null) {
            fc.setCurrentDirectory(new File(currDirStr));
        }
        JTextArea instructions = new JTextArea("INSTRUCTIONS:\n* Use the list to the left to choose\n  either directories (to search) or sts files.\n* If a single sts file is chosen, the\n  run will be analyzed.\n* If directories are chosen, the chosen\n  dirs and all subdirs will be searched\n  for any sts files, which can be further\n  subselected.\n* So, if several multi-run simulations are\n  stored in several directories, just choose\n  the parent directory and all the\n  simulations will be found.\n* NOTE: Use shift/control keys to select!");
        instructions.setEditable(false);
        fc.setAccessory(instructions);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(2);
        fc.addChoosableFileFilter(new GrepFileFilter("sts", "STS Files (*sts*)"));
        return fc;
    }

    private JDialog initFileDialog(String title) {
        JDialog d = new JDialog(this.owner_, false);
        d.getContentPane().setLayout(new BorderLayout());
        d.setDefaultCloseOperation(0);
        d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectionsFileChooser.this.dialog_.setVisible(false);
            }
        });
        d.setTitle(title);
        d.setSize(600, 480);
        JTextArea instructions = new JTextArea("All of the files below have been found\nto match the file open filter in all of\nthe subdirectories searched.  Highlighted\nfiles will be opened by Projections, so\nfurther subselect only the files that are\ndesired.  NOTE: Can use control/shift keys\nto subselect.\n");
        instructions.setEditable(false);
        d.getContentPane().add((Component)instructions, "North");
        JButton button1 = new JButton("Select All");
        button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int[] selectAll = new int[ProjectionsFileChooser.this.listSize_];
                for (int i = 0; i < selectAll.length; ++i) {
                    selectAll[i] = i;
                }
                ProjectionsFileChooser.this.list_.setSelectedIndices(selectAll);
            }
        });
        JButton button2 = new JButton("OK");
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ProjectionsFileChooser.access$302(ProjectionsFileChooser.this, ProjectionsFileChooser.this.list_.getSelectedIndices());
                ProjectionsFileChooser.this.userSelect_returnVal = new String[ProjectionsFileChooser.this.userSelect_selected.length];
                for (int j = 0; j < ProjectionsFileChooser.this.userSelect_selected.length; ++j) {
                    ProjectionsFileChooser.this.userSelect_returnVal[j] = (String)ProjectionsFileChooser.this.list_.getModel().getElementAt(ProjectionsFileChooser.this.userSelect_selected[j]);
                }
                try {
                    ProjectionsFileChooser.this.fileMgr_ = new ProjectionsFileMgr(ProjectionsFileChooser.this.userSelect_returnVal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ProjectionsFileChooser.this.dialog_.setVisible(false);
                ((MultiRunWindow)ProjectionsFileChooser.this.owner_).dialogCallback();
            }
        });
        JPanel panel = new JPanel();
        panel.add(button1);
        panel.add(button2);
        d.getContentPane().add((Component)panel, "South");
        return d;
    }

    private Vector filterFiles(File[] files, FileFilter filter) {
        Vector fileVector = new Vector();
        Vector<File> fileList = new Vector<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            fileList.addElement(files[i]);
        }
        this.recurseFilterFiles(fileList, fileVector, filter);
        return fileVector;
    }

    private void recurseFilterFiles(Vector fileList, Vector fileVector, FileFilter filter) {
        for (int i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.elementAt(i);
            if (file.isDirectory()) {
                String[] dirFileStr = file.list();
                Vector<File> newFileList = new Vector<File>();
                for (int j = 0; j < dirFileStr.length; ++j) {
                    newFileList.addElement(new File(file, dirFileStr[j]));
                }
                this.recurseFilterFiles(newFileList, fileVector, filter);
                continue;
            }
            if (!filter.accept(file)) continue;
            fileVector.addElement(file);
        }
    }

    private String[] userSubselect(Vector files) {
        String[] filesStr = new String[files.size()];
        int[] selectAll = new int[files.size()];
        for (int i = 0; i < filesStr.length; ++i) {
            File file = (File)files.elementAt(i);
            try {
                filesStr[i] = file.getCanonicalPath();
            }
            catch (IOException e) {
                System.out.println("exception in USersubselect");
                filesStr[i] = "IOException index " + i;
            }
            selectAll[i] = i;
        }
        this.list_ = new JList<String>(filesStr);
        this.listSize_ = filesStr.length;
        this.list_.setSelectedIndices(selectAll);
        this.dialog_.getContentPane().add((Component)new JScrollPane(this.list_), "Center");
        this.dialog_.setVisible(true);
        return this.userSelect_returnVal;
    }

    static /* synthetic */ int[] access$302(ProjectionsFileChooser x0, int[] x1) {
        x0.userSelect_selected = x1;
        return x1;
    }
}

