/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import projections.gui.U;

public class TimeTextField
extends JTextField {
    public TimeTextField(long defval, int size) {
        this(U.humanReadableString(defval), size);
    }

    public TimeTextField(String defval, int size) {
        super(defval, size);
        this.setInputVerifier(new TimeFieldVerifier());
    }

    public long getValue() {
        return U.fromT(this.getText());
    }

    public void setValue(long time) {
        this.setText(String.valueOf(time));
    }

    public void setText(String text) {
        super.setText(U.humanReadableString(U.fromT(text)));
    }

    private class TimeFieldVerifier
    extends InputVerifier {
        private TimeFieldVerifier() {
        }

        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String time = tf.getText();
            for (int i = 0; i < time.length(); ++i) {
                char ch = time.charAt(i);
                if ('0' <= ch && ch <= '9' || ch == 's' || ch == 'm' || ch == 'u' || ch == '.' || ch == ' ' || Character.isISOControl(ch)) continue;
                return false;
            }
            return true;
        }
    }
}

