/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import projections.gui.Clickable;
import projections.gui.PopUpAble;
import projections.gui.ResponsiveToMouse;
import projections.gui.graph.DataSource;

public class DataSource2D
extends DataSource {
    private String title;
    private double[][] data;
    private int xValues;
    private ResponsiveToMouse parent;

    protected DataSource2D(String title_, double[][] data_) {
        this.title = title_;
        this.data = data_;
        this.xValues = this.data.length;
        this.parent = null;
    }

    public DataSource2D(String title_, double[][] data_, ResponsiveToMouse parent_) {
        this.title = title_;
        this.data = data_;
        this.parent = parent_;
        this.xValues = this.data.length;
    }

    public String[] getPopup(int xVal, int yVal) {
        int NUM_EXTRA_LINES = 4;
        if (this.parent != null && this.parent instanceof PopUpAble) {
            int i;
            String[] tempText = ((PopUpAble)this.parent).getPopup(xVal, yVal);
            int offset = tempText.length;
            int longestLength = 0;
            String[] text = new String[offset + NUM_EXTRA_LINES];
            if (offset == 0) {
                return tempText;
            }
            for (i = 0; i < offset; ++i) {
                if (tempText[i].length() > longestLength) {
                    longestLength = tempText[i].length();
                }
                text[i] = tempText[i];
            }
            text[offset] = new String();
            for (i = 0; i < longestLength; ++i) {
                int n = offset;
                text[n] = text[n] + "-";
            }
            int count = 0;
            double total = 0.0;
            for (int i2 = 0; i2 < this.data[xVal].length; ++i2) {
                if (!(this.data[xVal][i2] > 0.0)) continue;
                ++count;
                total += this.data[xVal][i2];
            }
            text[offset + 1] = "Number: " + count;
            if (count > 0) {
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(1);
                text[offset + 2] = "Average: " + df.format(total / (double)count);
            } else {
                text[offset + 2] = "No Average";
            }
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            text[offset + 3] = "Total: " + df.format(total);
            return text;
        }
        return null;
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (this.parent != null && this.parent instanceof Clickable) {
            ((Clickable)this.parent).toolClickResponse(e, xVal, yVal);
        }
    }

    public void toolMouseMovedResponse(MouseEvent e, int xVal, int yVal) {
        if (this.parent != null && this.parent instanceof Clickable) {
            ((Clickable)this.parent).toolMouseMovedResponse(e, xVal, yVal);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getIndexCount() {
        return this.xValues;
    }

    public int getValueCount() {
        return this.data[0].length;
    }

    public void getValues(int index, double[] values) {
        for (int j = 0; j < this.data[index].length; ++j) {
            values[j] = this.data[index][j];
        }
    }
}

