/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.Paint;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.graph.DataSource;

public class MultiRunDataSource
extends DataSource {
    private double[][] dataValues;
    private int dataType;
    private Color[] colorMap = null;
    private String title;
    private MultiRunDataAnalyzer parent;

    public MultiRunDataSource(MultiRunDataAnalyzer parent, double[][] Ndata, int dataType, Color[] NcolorMap, String Ntitle) {
        this.parent = parent;
        this.dataValues = Ndata;
        this.dataType = dataType;
        this.colorMap = NcolorMap;
        this.title = Ntitle;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return "";
    }

    public int getIndexCount() {
        if (this.dataValues != null) {
            return this.dataValues.length;
        }
        return 0;
    }

    public int getValueCount() {
        if (this.dataValues != null) {
            return this.dataValues[0].length;
        }
        return 0;
    }

    public Paint getColor(int valNo) {
        if (this.colorMap == null) {
            return super.getColor(valNo);
        }
        return this.colorMap[valNo];
    }

    public Paint[] getColorMap() {
        if (this.colorMap == null) {
            Paint[] newMap = new Color[this.getValueCount()];
            for (int i = 0; i < newMap.length; ++i) {
                newMap[i] = super.getColor(i);
            }
            return newMap;
        }
        return this.colorMap;
    }

    public void getValues(int index, double[] values) {
        for (int j = 0; j < this.getValueCount(); ++j) {
            values[j] = this.dataValues[index][j];
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPopup(xVal, yVal, this.dataType);
    }

    public void setColors(Color[] NcolorMap) {
        this.colorMap = NcolorMap;
    }
}

